# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/saasplatform/saasservicemgmt/v1beta1/deployments_service_pb"
require "google/cloud/saas_platform/saas_service_mgmt/v1beta1/saas_deployments/rest/service_stub"
require "google/cloud/location/rest"

module Google
  module Cloud
    module SaasPlatform
      module SaasServiceMgmt
        module V1beta1
          module SaasDeployments
            module Rest
              ##
              # REST client for the SaasDeployments service.
              #
              # Manages the deployment of SaaS services.
              #
              class Client
                # @private
                API_VERSION = ""

                # @private
                DEFAULT_ENDPOINT_TEMPLATE = "saasservicemgmt.$UNIVERSE_DOMAIN$"

                include Paths

                # @private
                attr_reader :saas_deployments_stub

                ##
                # Configure the SaasDeployments Client class.
                #
                # See {::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client::Configuration}
                # for a description of the configuration fields.
                #
                # @example
                #
                #   # Modify the configuration for all SaasDeployments clients
                #   ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.configure do |config|
                #     config.timeout = 10.0
                #   end
                #
                # @yield [config] Configure the Client client.
                # @yieldparam config [Client::Configuration]
                #
                # @return [Client::Configuration]
                #
                def self.configure
                  @configure ||= begin
                    namespace = ["Google", "Cloud", "SaasPlatform", "SaasServiceMgmt", "V1beta1"]
                    parent_config = while namespace.any?
                                      parent_name = namespace.join "::"
                                      parent_const = const_get parent_name
                                      break parent_const.configure if parent_const.respond_to? :configure
                                      namespace.pop
                                    end
                    default_config = Client::Configuration.new parent_config

                    default_config.rpcs.list_saas.timeout = 80.0
                    default_config.rpcs.list_saas.retry_policy = {
                      initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                    }

                    default_config.rpcs.get_saas.timeout = 30.0
                    default_config.rpcs.get_saas.retry_policy = {
                      initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                    }

                    default_config.rpcs.create_saas.timeout = 30.0

                    default_config.rpcs.update_saas.timeout = 30.0

                    default_config.rpcs.delete_saas.timeout = 30.0
                    default_config.rpcs.delete_saas.retry_policy = {
                      initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                    }

                    default_config.rpcs.list_tenants.timeout = 80.0
                    default_config.rpcs.list_tenants.retry_policy = {
                      initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                    }

                    default_config.rpcs.get_tenant.timeout = 30.0
                    default_config.rpcs.get_tenant.retry_policy = {
                      initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                    }

                    default_config.rpcs.create_tenant.timeout = 30.0

                    default_config.rpcs.update_tenant.timeout = 30.0

                    default_config.rpcs.delete_tenant.timeout = 30.0
                    default_config.rpcs.delete_tenant.retry_policy = {
                      initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                    }

                    default_config.rpcs.list_unit_kinds.timeout = 80.0
                    default_config.rpcs.list_unit_kinds.retry_policy = {
                      initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                    }

                    default_config.rpcs.get_unit_kind.timeout = 30.0
                    default_config.rpcs.get_unit_kind.retry_policy = {
                      initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                    }

                    default_config.rpcs.create_unit_kind.timeout = 30.0

                    default_config.rpcs.update_unit_kind.timeout = 80.0

                    default_config.rpcs.delete_unit_kind.timeout = 80.0
                    default_config.rpcs.delete_unit_kind.retry_policy = {
                      initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                    }

                    default_config.rpcs.list_units.timeout = 80.0
                    default_config.rpcs.list_units.retry_policy = {
                      initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                    }

                    default_config.rpcs.get_unit.timeout = 30.0
                    default_config.rpcs.get_unit.retry_policy = {
                      initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                    }

                    default_config.rpcs.create_unit.timeout = 30.0

                    default_config.rpcs.update_unit.timeout = 30.0

                    default_config.rpcs.delete_unit.timeout = 30.0
                    default_config.rpcs.delete_unit.retry_policy = {
                      initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                    }

                    default_config.rpcs.list_unit_operations.timeout = 80.0
                    default_config.rpcs.list_unit_operations.retry_policy = {
                      initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                    }

                    default_config.rpcs.get_unit_operation.timeout = 30.0
                    default_config.rpcs.get_unit_operation.retry_policy = {
                      initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                    }

                    default_config.rpcs.create_unit_operation.timeout = 30.0

                    default_config.rpcs.update_unit_operation.timeout = 30.0

                    default_config.rpcs.delete_unit_operation.timeout = 30.0
                    default_config.rpcs.delete_unit_operation.retry_policy = {
                      initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                    }

                    default_config.rpcs.list_releases.timeout = 80.0
                    default_config.rpcs.list_releases.retry_policy = {
                      initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                    }

                    default_config.rpcs.get_release.timeout = 30.0
                    default_config.rpcs.get_release.retry_policy = {
                      initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                    }

                    default_config.rpcs.create_release.timeout = 30.0

                    default_config.rpcs.update_release.timeout = 30.0

                    default_config.rpcs.delete_release.timeout = 30.0
                    default_config.rpcs.delete_release.retry_policy = {
                      initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                    }

                    default_config
                  end
                  yield @configure if block_given?
                  @configure
                end

                ##
                # Configure the SaasDeployments Client instance.
                #
                # The configuration is set to the derived mode, meaning that values can be changed,
                # but structural changes (adding new fields, etc.) are not allowed. Structural changes
                # should be made on {Client.configure}.
                #
                # See {::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client::Configuration}
                # for a description of the configuration fields.
                #
                # @yield [config] Configure the Client client.
                # @yieldparam config [Client::Configuration]
                #
                # @return [Client::Configuration]
                #
                def configure
                  yield @config if block_given?
                  @config
                end

                ##
                # The effective universe domain
                #
                # @return [String]
                #
                def universe_domain
                  @saas_deployments_stub.universe_domain
                end

                ##
                # Create a new SaasDeployments REST client object.
                #
                # @example
                #
                #   # Create a client using the default configuration
                #   client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new
                #
                #   # Create a client using a custom configuration
                #   client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new do |config|
                #     config.timeout = 10.0
                #   end
                #
                # @yield [config] Configure the SaasDeployments client.
                # @yieldparam config [Client::Configuration]
                #
                def initialize
                  # Create the configuration object
                  @config = Configuration.new Client.configure

                  # Yield the configuration if needed
                  yield @config if block_given?

                  # Create credentials
                  credentials = @config.credentials
                  # Use self-signed JWT if the endpoint is unchanged from default,
                  # but only if the default endpoint does not have a region prefix.
                  enable_self_signed_jwt = @config.endpoint.nil? ||
                                           (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                           !@config.endpoint.split(".").first.include?("-"))
                  credentials ||= Credentials.default scope: @config.scope,
                                                      enable_self_signed_jwt: enable_self_signed_jwt
                  if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                    credentials = Credentials.new credentials, scope: @config.scope
                  end

                  @quota_project_id = @config.quota_project
                  @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                  @saas_deployments_stub = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::ServiceStub.new(
                    endpoint: @config.endpoint,
                    endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                    universe_domain: @config.universe_domain,
                    credentials: credentials,
                    logger: @config.logger
                  )

                  @saas_deployments_stub.logger(stub: true)&.info do |entry|
                    entry.set_system_name
                    entry.set_service
                    entry.message = "Created client for #{entry.service}"
                    entry.set_credentials_fields credentials
                    entry.set "customEndpoint", @config.endpoint if @config.endpoint
                    entry.set "defaultTimeout", @config.timeout if @config.timeout
                    entry.set "quotaProject", @quota_project_id if @quota_project_id
                  end

                  @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                    config.credentials = credentials
                    config.quota_project = @quota_project_id
                    config.endpoint = @saas_deployments_stub.endpoint
                    config.universe_domain = @saas_deployments_stub.universe_domain
                    config.bindings_override = @config.bindings_override
                    config.logger = @saas_deployments_stub.logger if config.respond_to? :logger=
                  end
                end

                ##
                # Get the associated client for mix-in of the Locations.
                #
                # @return [Google::Cloud::Location::Locations::Rest::Client]
                #
                attr_reader :location_client

                ##
                # The logger used for request/response debug logging.
                #
                # @return [Logger]
                #
                def logger
                  @saas_deployments_stub.logger
                end

                # Service calls

                ##
                # Retrieve a collection of saas.
                #
                # @overload list_saas(request, options = nil)
                #   Pass arguments to `list_saas` via a request object, either of type
                #   {::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListSaasRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListSaasRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload list_saas(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
                #   Pass arguments to `list_saas` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param parent [::String]
                #     Required. The parent of the saas.
                #   @param page_size [::Integer]
                #     The maximum number of saas to send per page.
                #   @param page_token [::String]
                #     The page token: If the next_page_token from a previous response
                #     is provided, this request will send the subsequent page.
                #   @param filter [::String]
                #     Filter the list as specified in https://google.aip.dev/160.
                #   @param order_by [::String]
                #     Order results as specified in https://google.aip.dev/132.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Saas>]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Saas>]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/saas_platform/saas_service_mgmt/v1beta1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListSaasRequest.new
                #
                #   # Call the list_saas method.
                #   result = client.list_saas request
                #
                #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
                #   # over elements, and API calls will be issued to fetch pages as needed.
                #   result.each do |item|
                #     # Each element is of type ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Saas.
                #     p item
                #   end
                #
                def list_saas request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListSaasRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.list_saas.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.list_saas.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.list_saas.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @saas_deployments_stub.list_saas request, options do |result, operation|
                    result = ::Gapic::Rest::PagedEnumerable.new @saas_deployments_stub, :list_saas, "saas", request, result, options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Retrieve a single saas.
                #
                # @overload get_saas(request, options = nil)
                #   Pass arguments to `get_saas` via a request object, either of type
                #   {::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetSaasRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetSaasRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload get_saas(name: nil)
                #   Pass arguments to `get_saas` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The resource name of the resource within a service.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Saas]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Saas]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/saas_platform/saas_service_mgmt/v1beta1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetSaasRequest.new
                #
                #   # Call the get_saas method.
                #   result = client.get_saas request
                #
                #   # The returned object is of type Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Saas.
                #   p result
                #
                def get_saas request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetSaasRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.get_saas.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.get_saas.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.get_saas.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @saas_deployments_stub.get_saas request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Create a new saas.
                #
                # @overload create_saas(request, options = nil)
                #   Pass arguments to `create_saas` via a request object, either of type
                #   {::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateSaasRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateSaasRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload create_saas(parent: nil, saas_id: nil, saas: nil, validate_only: nil, request_id: nil)
                #   Pass arguments to `create_saas` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param parent [::String]
                #     Required. The parent of the saas.
                #   @param saas_id [::String]
                #     Required. The ID value for the new saas.
                #   @param saas [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Saas, ::Hash]
                #     Required. The desired state for the saas.
                #   @param validate_only [::Boolean]
                #     If "validate_only" is set to true, the service will try to validate
                #     that this request would succeed, but will not actually make changes.
                #   @param request_id [::String]
                #     An optional request ID to identify requests. Specify a unique request ID
                #     so that if you must retry your request, the server will know to ignore
                #     the request if it has already been completed. The server will guarantee
                #     that for at least 60 minutes since the first request.
                #
                #     For example, consider a situation where you make an initial request and the
                #     request times out. If you make the request again with the same request
                #     ID, the server can check if original operation with the same request ID
                #     was received, and if so, will ignore the second request. This prevents
                #     clients from accidentally creating duplicate commitments.
                #
                #     The request ID must be a valid UUID with the exception that zero UUID is
                #     not supported (00000000-0000-0000-0000-000000000000).
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Saas]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Saas]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/saas_platform/saas_service_mgmt/v1beta1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateSaasRequest.new
                #
                #   # Call the create_saas method.
                #   result = client.create_saas request
                #
                #   # The returned object is of type Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Saas.
                #   p result
                #
                def create_saas request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateSaasRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.create_saas.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.create_saas.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.create_saas.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @saas_deployments_stub.create_saas request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Update a single saas.
                #
                # @overload update_saas(request, options = nil)
                #   Pass arguments to `update_saas` via a request object, either of type
                #   {::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateSaasRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateSaasRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload update_saas(saas: nil, validate_only: nil, request_id: nil, update_mask: nil)
                #   Pass arguments to `update_saas` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param saas [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Saas, ::Hash]
                #     Required. The desired state for the saas.
                #   @param validate_only [::Boolean]
                #     If "validate_only" is set to true, the service will try to validate
                #     that this request would succeed, but will not actually make changes.
                #   @param request_id [::String]
                #     An optional request ID to identify requests. Specify a unique request ID
                #     so that if you must retry your request, the server will know to ignore
                #     the request if it has already been completed. The server will guarantee
                #     that for at least 60 minutes since the first request.
                #
                #     For example, consider a situation where you make an initial request and the
                #     request times out. If you make the request again with the same request
                #     ID, the server can check if original operation with the same request ID
                #     was received, and if so, will ignore the second request. This prevents
                #     clients from accidentally creating duplicate commitments.
                #
                #     The request ID must be a valid UUID with the exception that zero UUID is
                #     not supported (00000000-0000-0000-0000-000000000000).
                #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
                #     Field mask is used to specify the fields to be overwritten in the
                #     Saas resource by the update.
                #
                #     The fields specified in the update_mask are relative to the resource, not
                #     the full request. A field will be overwritten if it is in the mask.
                #
                #     If the user does not provide a mask then all fields in the
                #     Saas will be overwritten.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Saas]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Saas]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/saas_platform/saas_service_mgmt/v1beta1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateSaasRequest.new
                #
                #   # Call the update_saas method.
                #   result = client.update_saas request
                #
                #   # The returned object is of type Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Saas.
                #   p result
                #
                def update_saas request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateSaasRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.update_saas.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.update_saas.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.update_saas.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @saas_deployments_stub.update_saas request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Delete a single saas.
                #
                # @overload delete_saas(request, options = nil)
                #   Pass arguments to `delete_saas` via a request object, either of type
                #   {::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteSaasRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteSaasRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload delete_saas(name: nil, etag: nil, validate_only: nil, request_id: nil)
                #   Pass arguments to `delete_saas` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The resource name of the resource within a service.
                #   @param etag [::String]
                #     The etag known to the client for the expected state of the saas. This is
                #     used with state-changing methods to prevent accidental overwrites when
                #     multiple user agents might be acting in parallel on the same resource.
                #
                #     An etag wildcard provide optimistic concurrency based on the expected
                #     existence of the saas. The Any wildcard (`*`) requires that the resource
                #     must already exists, and the Not Any wildcard (`!*`) requires that it must
                #     not.
                #   @param validate_only [::Boolean]
                #     If "validate_only" is set to true, the service will try to validate
                #     that this request would succeed, but will not actually make changes.
                #   @param request_id [::String]
                #     An optional request ID to identify requests. Specify a unique request ID
                #     so that if you must retry your request, the server will know to ignore
                #     the request if it has already been completed. The server will guarantee
                #     that for at least 60 minutes since the first request.
                #
                #     For example, consider a situation where you make an initial request and the
                #     request times out. If you make the request again with the same request
                #     ID, the server can check if original operation with the same request ID
                #     was received, and if so, will ignore the second request. This prevents
                #     clients from accidentally creating duplicate commitments.
                #
                #     The request ID must be a valid UUID with the exception that zero UUID is
                #     not supported (00000000-0000-0000-0000-000000000000).
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Protobuf::Empty]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Protobuf::Empty]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/saas_platform/saas_service_mgmt/v1beta1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteSaasRequest.new
                #
                #   # Call the delete_saas method.
                #   result = client.delete_saas request
                #
                #   # The returned object is of type Google::Protobuf::Empty.
                #   p result
                #
                def delete_saas request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteSaasRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.delete_saas.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.delete_saas.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.delete_saas.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @saas_deployments_stub.delete_saas request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Retrieve a collection of tenants.
                #
                # @overload list_tenants(request, options = nil)
                #   Pass arguments to `list_tenants` via a request object, either of type
                #   {::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListTenantsRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListTenantsRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload list_tenants(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
                #   Pass arguments to `list_tenants` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param parent [::String]
                #     Required. The parent of the tenant.
                #   @param page_size [::Integer]
                #     The maximum number of tenants to send per page.
                #   @param page_token [::String]
                #     The page token: If the next_page_token from a previous response
                #     is provided, this request will send the subsequent page.
                #   @param filter [::String]
                #     Filter the list as specified in https://google.aip.dev/160.
                #   @param order_by [::String]
                #     Order results as specified in https://google.aip.dev/132.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Tenant>]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Tenant>]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/saas_platform/saas_service_mgmt/v1beta1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListTenantsRequest.new
                #
                #   # Call the list_tenants method.
                #   result = client.list_tenants request
                #
                #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
                #   # over elements, and API calls will be issued to fetch pages as needed.
                #   result.each do |item|
                #     # Each element is of type ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Tenant.
                #     p item
                #   end
                #
                def list_tenants request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListTenantsRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.list_tenants.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.list_tenants.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.list_tenants.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @saas_deployments_stub.list_tenants request, options do |result, operation|
                    result = ::Gapic::Rest::PagedEnumerable.new @saas_deployments_stub, :list_tenants, "tenants", request, result, options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Retrieve a single tenant.
                #
                # @overload get_tenant(request, options = nil)
                #   Pass arguments to `get_tenant` via a request object, either of type
                #   {::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetTenantRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetTenantRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload get_tenant(name: nil)
                #   Pass arguments to `get_tenant` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The resource name of the resource within a service.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Tenant]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Tenant]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/saas_platform/saas_service_mgmt/v1beta1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetTenantRequest.new
                #
                #   # Call the get_tenant method.
                #   result = client.get_tenant request
                #
                #   # The returned object is of type Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Tenant.
                #   p result
                #
                def get_tenant request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetTenantRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.get_tenant.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.get_tenant.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.get_tenant.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @saas_deployments_stub.get_tenant request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Create a new tenant.
                #
                # @overload create_tenant(request, options = nil)
                #   Pass arguments to `create_tenant` via a request object, either of type
                #   {::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateTenantRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateTenantRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload create_tenant(parent: nil, tenant_id: nil, tenant: nil, validate_only: nil, request_id: nil)
                #   Pass arguments to `create_tenant` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param parent [::String]
                #     Required. The parent of the tenant.
                #   @param tenant_id [::String]
                #     Required. The ID value for the new tenant.
                #   @param tenant [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Tenant, ::Hash]
                #     Required. The desired state for the tenant.
                #   @param validate_only [::Boolean]
                #     If "validate_only" is set to true, the service will try to validate
                #     that this request would succeed, but will not actually make changes.
                #   @param request_id [::String]
                #     An optional request ID to identify requests. Specify a unique request ID
                #     so that if you must retry your request, the server will know to ignore
                #     the request if it has already been completed. The server will guarantee
                #     that for at least 60 minutes since the first request.
                #
                #     For example, consider a situation where you make an initial request and the
                #     request times out. If you make the request again with the same request
                #     ID, the server can check if original operation with the same request ID
                #     was received, and if so, will ignore the second request. This prevents
                #     clients from accidentally creating duplicate commitments.
                #
                #     The request ID must be a valid UUID with the exception that zero UUID is
                #     not supported (00000000-0000-0000-0000-000000000000).
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Tenant]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Tenant]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/saas_platform/saas_service_mgmt/v1beta1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateTenantRequest.new
                #
                #   # Call the create_tenant method.
                #   result = client.create_tenant request
                #
                #   # The returned object is of type Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Tenant.
                #   p result
                #
                def create_tenant request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateTenantRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.create_tenant.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.create_tenant.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.create_tenant.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @saas_deployments_stub.create_tenant request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Update a single tenant.
                #
                # @overload update_tenant(request, options = nil)
                #   Pass arguments to `update_tenant` via a request object, either of type
                #   {::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateTenantRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateTenantRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload update_tenant(tenant: nil, validate_only: nil, request_id: nil, update_mask: nil)
                #   Pass arguments to `update_tenant` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param tenant [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Tenant, ::Hash]
                #     Required. The desired state for the tenant.
                #   @param validate_only [::Boolean]
                #     If "validate_only" is set to true, the service will try to validate
                #     that this request would succeed, but will not actually make changes.
                #   @param request_id [::String]
                #     An optional request ID to identify requests. Specify a unique request ID
                #     so that if you must retry your request, the server will know to ignore
                #     the request if it has already been completed. The server will guarantee
                #     that for at least 60 minutes since the first request.
                #
                #     For example, consider a situation where you make an initial request and the
                #     request times out. If you make the request again with the same request
                #     ID, the server can check if original operation with the same request ID
                #     was received, and if so, will ignore the second request. This prevents
                #     clients from accidentally creating duplicate commitments.
                #
                #     The request ID must be a valid UUID with the exception that zero UUID is
                #     not supported (00000000-0000-0000-0000-000000000000).
                #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
                #     Field mask is used to specify the fields to be overwritten in the
                #     Tenant resource by the update.
                #
                #     The fields specified in the update_mask are relative to the resource, not
                #     the full request. A field will be overwritten if it is in the mask.
                #
                #     If the user does not provide a mask then all fields in the
                #     Tenant will be overwritten.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Tenant]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Tenant]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/saas_platform/saas_service_mgmt/v1beta1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateTenantRequest.new
                #
                #   # Call the update_tenant method.
                #   result = client.update_tenant request
                #
                #   # The returned object is of type Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Tenant.
                #   p result
                #
                def update_tenant request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateTenantRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.update_tenant.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.update_tenant.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.update_tenant.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @saas_deployments_stub.update_tenant request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Delete a single tenant.
                #
                # @overload delete_tenant(request, options = nil)
                #   Pass arguments to `delete_tenant` via a request object, either of type
                #   {::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteTenantRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteTenantRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload delete_tenant(name: nil, etag: nil, validate_only: nil, request_id: nil)
                #   Pass arguments to `delete_tenant` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The resource name of the resource within a service.
                #   @param etag [::String]
                #     The etag known to the client for the expected state of the tenant. This is
                #     used with state-changing methods to prevent accidental overwrites when
                #     multiple user agents might be acting in parallel on the same resource.
                #
                #     An etag wildcard provide optimistic concurrency based on the expected
                #     existence of the tenant. The Any wildcard (`*`) requires that the resource
                #     must already exists, and the Not Any wildcard (`!*`) requires that it must
                #     not.
                #   @param validate_only [::Boolean]
                #     If "validate_only" is set to true, the service will try to validate
                #     that this request would succeed, but will not actually make changes.
                #   @param request_id [::String]
                #     An optional request ID to identify requests. Specify a unique request ID
                #     so that if you must retry your request, the server will know to ignore
                #     the request if it has already been completed. The server will guarantee
                #     that for at least 60 minutes since the first request.
                #
                #     For example, consider a situation where you make an initial request and the
                #     request times out. If you make the request again with the same request
                #     ID, the server can check if original operation with the same request ID
                #     was received, and if so, will ignore the second request. This prevents
                #     clients from accidentally creating duplicate commitments.
                #
                #     The request ID must be a valid UUID with the exception that zero UUID is
                #     not supported (00000000-0000-0000-0000-000000000000).
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Protobuf::Empty]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Protobuf::Empty]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/saas_platform/saas_service_mgmt/v1beta1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteTenantRequest.new
                #
                #   # Call the delete_tenant method.
                #   result = client.delete_tenant request
                #
                #   # The returned object is of type Google::Protobuf::Empty.
                #   p result
                #
                def delete_tenant request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteTenantRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.delete_tenant.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.delete_tenant.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.delete_tenant.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @saas_deployments_stub.delete_tenant request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Retrieve a collection of unit kinds.
                #
                # @overload list_unit_kinds(request, options = nil)
                #   Pass arguments to `list_unit_kinds` via a request object, either of type
                #   {::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListUnitKindsRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListUnitKindsRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload list_unit_kinds(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
                #   Pass arguments to `list_unit_kinds` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param parent [::String]
                #     Required. The parent of the unit kind.
                #   @param page_size [::Integer]
                #     The maximum number of unit kinds to send per page.
                #   @param page_token [::String]
                #     The page token: If the next_page_token from a previous response
                #     is provided, this request will send the subsequent page.
                #   @param filter [::String]
                #     Filter the list as specified in https://google.aip.dev/160.
                #   @param order_by [::String]
                #     Order results as specified in https://google.aip.dev/132.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitKind>]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitKind>]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/saas_platform/saas_service_mgmt/v1beta1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListUnitKindsRequest.new
                #
                #   # Call the list_unit_kinds method.
                #   result = client.list_unit_kinds request
                #
                #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
                #   # over elements, and API calls will be issued to fetch pages as needed.
                #   result.each do |item|
                #     # Each element is of type ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitKind.
                #     p item
                #   end
                #
                def list_unit_kinds request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListUnitKindsRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.list_unit_kinds.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.list_unit_kinds.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.list_unit_kinds.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @saas_deployments_stub.list_unit_kinds request, options do |result, operation|
                    result = ::Gapic::Rest::PagedEnumerable.new @saas_deployments_stub, :list_unit_kinds, "unit_kinds", request, result, options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Retrieve a single unit kind.
                #
                # @overload get_unit_kind(request, options = nil)
                #   Pass arguments to `get_unit_kind` via a request object, either of type
                #   {::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetUnitKindRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetUnitKindRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload get_unit_kind(name: nil)
                #   Pass arguments to `get_unit_kind` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The resource name of the resource within a service.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitKind]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitKind]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/saas_platform/saas_service_mgmt/v1beta1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetUnitKindRequest.new
                #
                #   # Call the get_unit_kind method.
                #   result = client.get_unit_kind request
                #
                #   # The returned object is of type Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitKind.
                #   p result
                #
                def get_unit_kind request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetUnitKindRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.get_unit_kind.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.get_unit_kind.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.get_unit_kind.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @saas_deployments_stub.get_unit_kind request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Create a new unit kind.
                #
                # @overload create_unit_kind(request, options = nil)
                #   Pass arguments to `create_unit_kind` via a request object, either of type
                #   {::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateUnitKindRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateUnitKindRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload create_unit_kind(parent: nil, unit_kind_id: nil, unit_kind: nil, validate_only: nil, request_id: nil)
                #   Pass arguments to `create_unit_kind` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param parent [::String]
                #     Required. The parent of the unit kind.
                #   @param unit_kind_id [::String]
                #     Required. The ID value for the new unit kind.
                #   @param unit_kind [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitKind, ::Hash]
                #     Required. The desired state for the unit kind.
                #   @param validate_only [::Boolean]
                #     If "validate_only" is set to true, the service will try to validate
                #     that this request would succeed, but will not actually make changes.
                #   @param request_id [::String]
                #     An optional request ID to identify requests. Specify a unique request ID
                #     so that if you must retry your request, the server will know to ignore
                #     the request if it has already been completed. The server will guarantee
                #     that for at least 60 minutes since the first request.
                #
                #     For example, consider a situation where you make an initial request and the
                #     request times out. If you make the request again with the same request
                #     ID, the server can check if original operation with the same request ID
                #     was received, and if so, will ignore the second request. This prevents
                #     clients from accidentally creating duplicate commitments.
                #
                #     The request ID must be a valid UUID with the exception that zero UUID is
                #     not supported (00000000-0000-0000-0000-000000000000).
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitKind]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitKind]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/saas_platform/saas_service_mgmt/v1beta1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateUnitKindRequest.new
                #
                #   # Call the create_unit_kind method.
                #   result = client.create_unit_kind request
                #
                #   # The returned object is of type Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitKind.
                #   p result
                #
                def create_unit_kind request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateUnitKindRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.create_unit_kind.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.create_unit_kind.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.create_unit_kind.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @saas_deployments_stub.create_unit_kind request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Update a single unit kind.
                #
                # @overload update_unit_kind(request, options = nil)
                #   Pass arguments to `update_unit_kind` via a request object, either of type
                #   {::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateUnitKindRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateUnitKindRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload update_unit_kind(unit_kind: nil, validate_only: nil, request_id: nil, update_mask: nil)
                #   Pass arguments to `update_unit_kind` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param unit_kind [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitKind, ::Hash]
                #     Required. The desired state for the unit kind.
                #   @param validate_only [::Boolean]
                #     If "validate_only" is set to true, the service will try to validate
                #     that this request would succeed, but will not actually make changes.
                #   @param request_id [::String]
                #     An optional request ID to identify requests. Specify a unique request ID
                #     so that if you must retry your request, the server will know to ignore
                #     the request if it has already been completed. The server will guarantee
                #     that for at least 60 minutes since the first request.
                #
                #     For example, consider a situation where you make an initial request and the
                #     request times out. If you make the request again with the same request
                #     ID, the server can check if original operation with the same request ID
                #     was received, and if so, will ignore the second request. This prevents
                #     clients from accidentally creating duplicate commitments.
                #
                #     The request ID must be a valid UUID with the exception that zero UUID is
                #     not supported (00000000-0000-0000-0000-000000000000).
                #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
                #     Field mask is used to specify the fields to be overwritten in the
                #     UnitKind resource by the update.
                #
                #     The fields specified in the update_mask are relative to the resource, not
                #     the full request. A field will be overwritten if it is in the mask.
                #
                #     If the user does not provide a mask then all fields in the
                #     UnitKind will be overwritten.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitKind]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitKind]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/saas_platform/saas_service_mgmt/v1beta1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateUnitKindRequest.new
                #
                #   # Call the update_unit_kind method.
                #   result = client.update_unit_kind request
                #
                #   # The returned object is of type Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitKind.
                #   p result
                #
                def update_unit_kind request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateUnitKindRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.update_unit_kind.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.update_unit_kind.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.update_unit_kind.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @saas_deployments_stub.update_unit_kind request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Delete a single unit kind.
                #
                # @overload delete_unit_kind(request, options = nil)
                #   Pass arguments to `delete_unit_kind` via a request object, either of type
                #   {::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteUnitKindRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteUnitKindRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload delete_unit_kind(name: nil, etag: nil, validate_only: nil, request_id: nil)
                #   Pass arguments to `delete_unit_kind` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The resource name of the resource within a service.
                #   @param etag [::String]
                #     The etag known to the client for the expected state of the unit kind. This
                #     is used with state-changing methods to prevent accidental overwrites when
                #     multiple user agents might be acting in parallel on the same resource.
                #
                #     An etag wildcard provide optimistic concurrency based on the expected
                #     existence of the unit kind. The Any wildcard (`*`) requires that the
                #     resource must already exists, and the Not Any wildcard (`!*`) requires that
                #     it must not.
                #   @param validate_only [::Boolean]
                #     If "validate_only" is set to true, the service will try to validate
                #     that this request would succeed, but will not actually make changes.
                #   @param request_id [::String]
                #     An optional request ID to identify requests. Specify a unique request ID
                #     so that if you must retry your request, the server will know to ignore
                #     the request if it has already been completed. The server will guarantee
                #     that for at least 60 minutes since the first request.
                #
                #     For example, consider a situation where you make an initial request and the
                #     request times out. If you make the request again with the same request
                #     ID, the server can check if original operation with the same request ID
                #     was received, and if so, will ignore the second request. This prevents
                #     clients from accidentally creating duplicate commitments.
                #
                #     The request ID must be a valid UUID with the exception that zero UUID is
                #     not supported (00000000-0000-0000-0000-000000000000).
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Protobuf::Empty]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Protobuf::Empty]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/saas_platform/saas_service_mgmt/v1beta1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteUnitKindRequest.new
                #
                #   # Call the delete_unit_kind method.
                #   result = client.delete_unit_kind request
                #
                #   # The returned object is of type Google::Protobuf::Empty.
                #   p result
                #
                def delete_unit_kind request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteUnitKindRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.delete_unit_kind.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.delete_unit_kind.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.delete_unit_kind.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @saas_deployments_stub.delete_unit_kind request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Retrieve a collection of units.
                #
                # @overload list_units(request, options = nil)
                #   Pass arguments to `list_units` via a request object, either of type
                #   {::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListUnitsRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListUnitsRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload list_units(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
                #   Pass arguments to `list_units` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param parent [::String]
                #     Required. The parent of the unit.
                #   @param page_size [::Integer]
                #     The maximum number of units to send per page.
                #   @param page_token [::String]
                #     The page token: If the next_page_token from a previous response
                #     is provided, this request will send the subsequent page.
                #   @param filter [::String]
                #     Filter the list as specified in https://google.aip.dev/160.
                #   @param order_by [::String]
                #     Order results as specified in https://google.aip.dev/132.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Unit>]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Unit>]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/saas_platform/saas_service_mgmt/v1beta1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListUnitsRequest.new
                #
                #   # Call the list_units method.
                #   result = client.list_units request
                #
                #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
                #   # over elements, and API calls will be issued to fetch pages as needed.
                #   result.each do |item|
                #     # Each element is of type ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Unit.
                #     p item
                #   end
                #
                def list_units request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListUnitsRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.list_units.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.list_units.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.list_units.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @saas_deployments_stub.list_units request, options do |result, operation|
                    result = ::Gapic::Rest::PagedEnumerable.new @saas_deployments_stub, :list_units, "units", request, result, options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Retrieve a single unit.
                #
                # @overload get_unit(request, options = nil)
                #   Pass arguments to `get_unit` via a request object, either of type
                #   {::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetUnitRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetUnitRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload get_unit(name: nil)
                #   Pass arguments to `get_unit` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The resource name of the resource within a service.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Unit]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Unit]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/saas_platform/saas_service_mgmt/v1beta1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetUnitRequest.new
                #
                #   # Call the get_unit method.
                #   result = client.get_unit request
                #
                #   # The returned object is of type Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Unit.
                #   p result
                #
                def get_unit request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetUnitRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.get_unit.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.get_unit.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.get_unit.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @saas_deployments_stub.get_unit request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Create a new unit.
                #
                # @overload create_unit(request, options = nil)
                #   Pass arguments to `create_unit` via a request object, either of type
                #   {::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateUnitRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateUnitRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload create_unit(parent: nil, unit_id: nil, unit: nil, validate_only: nil, request_id: nil)
                #   Pass arguments to `create_unit` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param parent [::String]
                #     Required. The parent of the unit.
                #   @param unit_id [::String]
                #     Required. The ID value for the new unit.
                #   @param unit [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Unit, ::Hash]
                #     Required. The desired state for the unit.
                #   @param validate_only [::Boolean]
                #     If "validate_only" is set to true, the service will try to validate
                #     that this request would succeed, but will not actually make changes.
                #   @param request_id [::String]
                #     An optional request ID to identify requests. Specify a unique request ID
                #     so that if you must retry your request, the server will know to ignore
                #     the request if it has already been completed. The server will guarantee
                #     that for at least 60 minutes since the first request.
                #
                #     For example, consider a situation where you make an initial request and the
                #     request times out. If you make the request again with the same request
                #     ID, the server can check if original operation with the same request ID
                #     was received, and if so, will ignore the second request. This prevents
                #     clients from accidentally creating duplicate commitments.
                #
                #     The request ID must be a valid UUID with the exception that zero UUID is
                #     not supported (00000000-0000-0000-0000-000000000000).
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Unit]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Unit]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/saas_platform/saas_service_mgmt/v1beta1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateUnitRequest.new
                #
                #   # Call the create_unit method.
                #   result = client.create_unit request
                #
                #   # The returned object is of type Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Unit.
                #   p result
                #
                def create_unit request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateUnitRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.create_unit.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.create_unit.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.create_unit.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @saas_deployments_stub.create_unit request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Update a single unit.
                #
                # @overload update_unit(request, options = nil)
                #   Pass arguments to `update_unit` via a request object, either of type
                #   {::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateUnitRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateUnitRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload update_unit(unit: nil, validate_only: nil, request_id: nil, update_mask: nil)
                #   Pass arguments to `update_unit` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param unit [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Unit, ::Hash]
                #     Required. The desired state for the unit.
                #   @param validate_only [::Boolean]
                #     If "validate_only" is set to true, the service will try to validate
                #     that this request would succeed, but will not actually make changes.
                #   @param request_id [::String]
                #     An optional request ID to identify requests. Specify a unique request ID
                #     so that if you must retry your request, the server will know to ignore
                #     the request if it has already been completed. The server will guarantee
                #     that for at least 60 minutes since the first request.
                #
                #     For example, consider a situation where you make an initial request and the
                #     request times out. If you make the request again with the same request
                #     ID, the server can check if original operation with the same request ID
                #     was received, and if so, will ignore the second request. This prevents
                #     clients from accidentally creating duplicate commitments.
                #
                #     The request ID must be a valid UUID with the exception that zero UUID is
                #     not supported (00000000-0000-0000-0000-000000000000).
                #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
                #     Field mask is used to specify the fields to be overwritten in the
                #     Unit resource by the update.
                #
                #     The fields specified in the update_mask are relative to the resource, not
                #     the full request. A field will be overwritten if it is in the mask.
                #
                #     If the user does not provide a mask then all fields in the
                #     Unit will be overwritten.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Unit]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Unit]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/saas_platform/saas_service_mgmt/v1beta1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateUnitRequest.new
                #
                #   # Call the update_unit method.
                #   result = client.update_unit request
                #
                #   # The returned object is of type Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Unit.
                #   p result
                #
                def update_unit request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateUnitRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.update_unit.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.update_unit.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.update_unit.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @saas_deployments_stub.update_unit request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Delete a single unit.
                #
                # @overload delete_unit(request, options = nil)
                #   Pass arguments to `delete_unit` via a request object, either of type
                #   {::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteUnitRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteUnitRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload delete_unit(name: nil, etag: nil, validate_only: nil, request_id: nil)
                #   Pass arguments to `delete_unit` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The resource name of the resource within a service.
                #   @param etag [::String]
                #     The etag known to the client for the expected state of the unit. This is
                #     used with state-changing methods to prevent accidental overwrites when
                #     multiple user agents might be acting in parallel on the same resource.
                #
                #     An etag wildcard provide optimistic concurrency based on the expected
                #     existence of the unit. The Any wildcard (`*`) requires that the resource
                #     must already exists, and the Not Any wildcard (`!*`) requires that it must
                #     not.
                #   @param validate_only [::Boolean]
                #     If "validate_only" is set to true, the service will try to validate
                #     that this request would succeed, but will not actually make changes.
                #   @param request_id [::String]
                #     An optional request ID to identify requests. Specify a unique request ID
                #     so that if you must retry your request, the server will know to ignore
                #     the request if it has already been completed. The server will guarantee
                #     that for at least 60 minutes since the first request.
                #
                #     For example, consider a situation where you make an initial request and the
                #     request times out. If you make the request again with the same request
                #     ID, the server can check if original operation with the same request ID
                #     was received, and if so, will ignore the second request. This prevents
                #     clients from accidentally creating duplicate commitments.
                #
                #     The request ID must be a valid UUID with the exception that zero UUID is
                #     not supported (00000000-0000-0000-0000-000000000000).
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Protobuf::Empty]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Protobuf::Empty]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/saas_platform/saas_service_mgmt/v1beta1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteUnitRequest.new
                #
                #   # Call the delete_unit method.
                #   result = client.delete_unit request
                #
                #   # The returned object is of type Google::Protobuf::Empty.
                #   p result
                #
                def delete_unit request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteUnitRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.delete_unit.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.delete_unit.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.delete_unit.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @saas_deployments_stub.delete_unit request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Retrieve a collection of unit operations.
                #
                # @overload list_unit_operations(request, options = nil)
                #   Pass arguments to `list_unit_operations` via a request object, either of type
                #   {::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListUnitOperationsRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListUnitOperationsRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload list_unit_operations(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
                #   Pass arguments to `list_unit_operations` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param parent [::String]
                #     Required. The parent of the unit operation.
                #   @param page_size [::Integer]
                #     The maximum number of unit operations to send per page.
                #   @param page_token [::String]
                #     The page token: If the next_page_token from a previous response
                #     is provided, this request will send the subsequent page.
                #   @param filter [::String]
                #     Filter the list as specified in https://google.aip.dev/160.
                #   @param order_by [::String]
                #     Order results as specified in https://google.aip.dev/132.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitOperation>]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitOperation>]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/saas_platform/saas_service_mgmt/v1beta1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListUnitOperationsRequest.new
                #
                #   # Call the list_unit_operations method.
                #   result = client.list_unit_operations request
                #
                #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
                #   # over elements, and API calls will be issued to fetch pages as needed.
                #   result.each do |item|
                #     # Each element is of type ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitOperation.
                #     p item
                #   end
                #
                def list_unit_operations request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListUnitOperationsRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.list_unit_operations.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.list_unit_operations.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.list_unit_operations.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @saas_deployments_stub.list_unit_operations request, options do |result, operation|
                    result = ::Gapic::Rest::PagedEnumerable.new @saas_deployments_stub, :list_unit_operations, "unit_operations", request, result, options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Retrieve a single unit operation.
                #
                # @overload get_unit_operation(request, options = nil)
                #   Pass arguments to `get_unit_operation` via a request object, either of type
                #   {::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetUnitOperationRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetUnitOperationRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload get_unit_operation(name: nil)
                #   Pass arguments to `get_unit_operation` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The resource name of the resource within a service.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitOperation]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitOperation]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/saas_platform/saas_service_mgmt/v1beta1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetUnitOperationRequest.new
                #
                #   # Call the get_unit_operation method.
                #   result = client.get_unit_operation request
                #
                #   # The returned object is of type Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitOperation.
                #   p result
                #
                def get_unit_operation request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetUnitOperationRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.get_unit_operation.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.get_unit_operation.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.get_unit_operation.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @saas_deployments_stub.get_unit_operation request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Create a new unit operation.
                #
                # @overload create_unit_operation(request, options = nil)
                #   Pass arguments to `create_unit_operation` via a request object, either of type
                #   {::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateUnitOperationRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateUnitOperationRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload create_unit_operation(parent: nil, unit_operation_id: nil, unit_operation: nil, validate_only: nil, request_id: nil)
                #   Pass arguments to `create_unit_operation` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param parent [::String]
                #     Required. The parent of the unit operation.
                #   @param unit_operation_id [::String]
                #     Required. The ID value for the new unit operation.
                #   @param unit_operation [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitOperation, ::Hash]
                #     Required. The desired state for the unit operation.
                #   @param validate_only [::Boolean]
                #     If "validate_only" is set to true, the service will try to validate
                #     that this request would succeed, but will not actually make changes.
                #   @param request_id [::String]
                #     An optional request ID to identify requests. Specify a unique request ID
                #     so that if you must retry your request, the server will know to ignore
                #     the request if it has already been completed. The server will guarantee
                #     that for at least 60 minutes since the first request.
                #
                #     For example, consider a situation where you make an initial request and the
                #     request times out. If you make the request again with the same request
                #     ID, the server can check if original operation with the same request ID
                #     was received, and if so, will ignore the second request. This prevents
                #     clients from accidentally creating duplicate commitments.
                #
                #     The request ID must be a valid UUID with the exception that zero UUID is
                #     not supported (00000000-0000-0000-0000-000000000000).
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitOperation]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitOperation]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/saas_platform/saas_service_mgmt/v1beta1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateUnitOperationRequest.new
                #
                #   # Call the create_unit_operation method.
                #   result = client.create_unit_operation request
                #
                #   # The returned object is of type Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitOperation.
                #   p result
                #
                def create_unit_operation request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateUnitOperationRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.create_unit_operation.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.create_unit_operation.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.create_unit_operation.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @saas_deployments_stub.create_unit_operation request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Update a single unit operation.
                #
                # @overload update_unit_operation(request, options = nil)
                #   Pass arguments to `update_unit_operation` via a request object, either of type
                #   {::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateUnitOperationRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateUnitOperationRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload update_unit_operation(unit_operation: nil, validate_only: nil, request_id: nil, update_mask: nil)
                #   Pass arguments to `update_unit_operation` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param unit_operation [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitOperation, ::Hash]
                #     Required. The desired state for the unit operation.
                #   @param validate_only [::Boolean]
                #     If "validate_only" is set to true, the service will try to validate
                #     that this request would succeed, but will not actually make changes.
                #   @param request_id [::String]
                #     An optional request ID to identify requests. Specify a unique request ID
                #     so that if you must retry your request, the server will know to ignore
                #     the request if it has already been completed. The server will guarantee
                #     that for at least 60 minutes since the first request.
                #
                #     For example, consider a situation where you make an initial request and the
                #     request times out. If you make the request again with the same request
                #     ID, the server can check if original operation with the same request ID
                #     was received, and if so, will ignore the second request. This prevents
                #     clients from accidentally creating duplicate commitments.
                #
                #     The request ID must be a valid UUID with the exception that zero UUID is
                #     not supported (00000000-0000-0000-0000-000000000000).
                #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
                #     Field mask is used to specify the fields to be overwritten in the
                #     UnitOperation resource by the update.
                #
                #     The fields specified in the update_mask are relative to the resource, not
                #     the full request. A field will be overwritten if it is in the mask.
                #
                #     If the user does not provide a mask then all fields in the
                #     UnitOperation will be overwritten.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitOperation]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitOperation]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/saas_platform/saas_service_mgmt/v1beta1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateUnitOperationRequest.new
                #
                #   # Call the update_unit_operation method.
                #   result = client.update_unit_operation request
                #
                #   # The returned object is of type Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UnitOperation.
                #   p result
                #
                def update_unit_operation request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateUnitOperationRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.update_unit_operation.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.update_unit_operation.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.update_unit_operation.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @saas_deployments_stub.update_unit_operation request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Delete a single unit operation.
                #
                # @overload delete_unit_operation(request, options = nil)
                #   Pass arguments to `delete_unit_operation` via a request object, either of type
                #   {::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteUnitOperationRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteUnitOperationRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload delete_unit_operation(name: nil, etag: nil, validate_only: nil, request_id: nil)
                #   Pass arguments to `delete_unit_operation` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The resource name of the resource within a service.
                #   @param etag [::String]
                #     The etag known to the client for the expected state of the unit operation.
                #     This is used with state-changing methods to prevent accidental overwrites
                #     when multiple user agents might be acting in parallel on the same resource.
                #
                #     An etag wildcard provide optimistic concurrency based on the expected
                #     existence of the unit operation. The Any wildcard (`*`) requires that the
                #     resource must already exists, and the Not Any wildcard (`!*`) requires that
                #     it must not.
                #   @param validate_only [::Boolean]
                #     If "validate_only" is set to true, the service will try to validate
                #     that this request would succeed, but will not actually make changes.
                #   @param request_id [::String]
                #     An optional request ID to identify requests. Specify a unique request ID
                #     so that if you must retry your request, the server will know to ignore
                #     the request if it has already been completed. The server will guarantee
                #     that for at least 60 minutes since the first request.
                #
                #     For example, consider a situation where you make an initial request and the
                #     request times out. If you make the request again with the same request
                #     ID, the server can check if original operation with the same request ID
                #     was received, and if so, will ignore the second request. This prevents
                #     clients from accidentally creating duplicate commitments.
                #
                #     The request ID must be a valid UUID with the exception that zero UUID is
                #     not supported (00000000-0000-0000-0000-000000000000).
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Protobuf::Empty]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Protobuf::Empty]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/saas_platform/saas_service_mgmt/v1beta1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteUnitOperationRequest.new
                #
                #   # Call the delete_unit_operation method.
                #   result = client.delete_unit_operation request
                #
                #   # The returned object is of type Google::Protobuf::Empty.
                #   p result
                #
                def delete_unit_operation request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteUnitOperationRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.delete_unit_operation.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.delete_unit_operation.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.delete_unit_operation.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @saas_deployments_stub.delete_unit_operation request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Retrieve a collection of releases.
                #
                # @overload list_releases(request, options = nil)
                #   Pass arguments to `list_releases` via a request object, either of type
                #   {::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListReleasesRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListReleasesRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload list_releases(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
                #   Pass arguments to `list_releases` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param parent [::String]
                #     Required. The parent of the release.
                #   @param page_size [::Integer]
                #     The maximum number of releases to send per page.
                #   @param page_token [::String]
                #     The page token: If the next_page_token from a previous response
                #     is provided, this request will send the subsequent page.
                #   @param filter [::String]
                #     Filter the list as specified in https://google.aip.dev/160.
                #   @param order_by [::String]
                #     Order results as specified in https://google.aip.dev/132.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Release>]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Release>]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/saas_platform/saas_service_mgmt/v1beta1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListReleasesRequest.new
                #
                #   # Call the list_releases method.
                #   result = client.list_releases request
                #
                #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
                #   # over elements, and API calls will be issued to fetch pages as needed.
                #   result.each do |item|
                #     # Each element is of type ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Release.
                #     p item
                #   end
                #
                def list_releases request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::ListReleasesRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.list_releases.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.list_releases.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.list_releases.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @saas_deployments_stub.list_releases request, options do |result, operation|
                    result = ::Gapic::Rest::PagedEnumerable.new @saas_deployments_stub, :list_releases, "releases", request, result, options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Retrieve a single release.
                #
                # @overload get_release(request, options = nil)
                #   Pass arguments to `get_release` via a request object, either of type
                #   {::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetReleaseRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetReleaseRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload get_release(name: nil)
                #   Pass arguments to `get_release` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The resource name of the resource within a service.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Release]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Release]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/saas_platform/saas_service_mgmt/v1beta1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetReleaseRequest.new
                #
                #   # Call the get_release method.
                #   result = client.get_release request
                #
                #   # The returned object is of type Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Release.
                #   p result
                #
                def get_release request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::GetReleaseRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.get_release.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.get_release.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.get_release.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @saas_deployments_stub.get_release request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Create a new release.
                #
                # @overload create_release(request, options = nil)
                #   Pass arguments to `create_release` via a request object, either of type
                #   {::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateReleaseRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateReleaseRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload create_release(parent: nil, release_id: nil, release: nil, validate_only: nil, request_id: nil)
                #   Pass arguments to `create_release` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param parent [::String]
                #     Required. The parent of the release.
                #   @param release_id [::String]
                #     Required. The ID value for the new release.
                #   @param release [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Release, ::Hash]
                #     Required. The desired state for the release.
                #   @param validate_only [::Boolean]
                #     If "validate_only" is set to true, the service will try to validate
                #     that this request would succeed, but will not actually make changes.
                #   @param request_id [::String]
                #     An optional request ID to identify requests. Specify a unique request ID
                #     so that if you must retry your request, the server will know to ignore
                #     the request if it has already been completed. The server will guarantee
                #     that for at least 60 minutes since the first request.
                #
                #     For example, consider a situation where you make an initial request and the
                #     request times out. If you make the request again with the same request
                #     ID, the server can check if original operation with the same request ID
                #     was received, and if so, will ignore the second request. This prevents
                #     clients from accidentally creating duplicate commitments.
                #
                #     The request ID must be a valid UUID with the exception that zero UUID is
                #     not supported (00000000-0000-0000-0000-000000000000).
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Release]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Release]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/saas_platform/saas_service_mgmt/v1beta1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateReleaseRequest.new
                #
                #   # Call the create_release method.
                #   result = client.create_release request
                #
                #   # The returned object is of type Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Release.
                #   p result
                #
                def create_release request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::CreateReleaseRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.create_release.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.create_release.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.create_release.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @saas_deployments_stub.create_release request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Update a single release.
                #
                # @overload update_release(request, options = nil)
                #   Pass arguments to `update_release` via a request object, either of type
                #   {::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateReleaseRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateReleaseRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload update_release(release: nil, validate_only: nil, request_id: nil, update_mask: nil)
                #   Pass arguments to `update_release` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param release [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Release, ::Hash]
                #     Required. The desired state for the release.
                #   @param validate_only [::Boolean]
                #     If "validate_only" is set to true, the service will try to validate
                #     that this request would succeed, but will not actually make changes.
                #   @param request_id [::String]
                #     An optional request ID to identify requests. Specify a unique request ID
                #     so that if you must retry your request, the server will know to ignore
                #     the request if it has already been completed. The server will guarantee
                #     that for at least 60 minutes since the first request.
                #
                #     For example, consider a situation where you make an initial request and the
                #     request times out. If you make the request again with the same request
                #     ID, the server can check if original operation with the same request ID
                #     was received, and if so, will ignore the second request. This prevents
                #     clients from accidentally creating duplicate commitments.
                #
                #     The request ID must be a valid UUID with the exception that zero UUID is
                #     not supported (00000000-0000-0000-0000-000000000000).
                #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
                #     Field mask is used to specify the fields to be overwritten in the
                #     Release resource by the update.
                #
                #     The fields specified in the update_mask are relative to the resource, not
                #     the full request. A field will be overwritten if it is in the mask.
                #
                #     If the user does not provide a mask then all fields in the
                #     Release will be overwritten.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Release]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Release]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/saas_platform/saas_service_mgmt/v1beta1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateReleaseRequest.new
                #
                #   # Call the update_release method.
                #   result = client.update_release request
                #
                #   # The returned object is of type Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::Release.
                #   p result
                #
                def update_release request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::UpdateReleaseRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.update_release.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.update_release.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.update_release.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @saas_deployments_stub.update_release request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Delete a single release.
                #
                # @overload delete_release(request, options = nil)
                #   Pass arguments to `delete_release` via a request object, either of type
                #   {::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteReleaseRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteReleaseRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload delete_release(name: nil, etag: nil, validate_only: nil, request_id: nil)
                #   Pass arguments to `delete_release` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The resource name of the resource within a service.
                #   @param etag [::String]
                #     The etag known to the client for the expected state of the release. This is
                #     used with state-changing methods to prevent accidental overwrites when
                #     multiple user agents might be acting in parallel on the same resource.
                #
                #     An etag wildcard provide optimistic concurrency based on the expected
                #     existence of the release. The Any wildcard (`*`) requires that the resource
                #     must already exists, and the Not Any wildcard (`!*`) requires that it must
                #     not.
                #   @param validate_only [::Boolean]
                #     If "validate_only" is set to true, the service will try to validate
                #     that this request would succeed, but will not actually make changes.
                #   @param request_id [::String]
                #     An optional request ID to identify requests. Specify a unique request ID
                #     so that if you must retry your request, the server will know to ignore
                #     the request if it has already been completed. The server will guarantee
                #     that for at least 60 minutes since the first request.
                #
                #     For example, consider a situation where you make an initial request and the
                #     request times out. If you make the request again with the same request
                #     ID, the server can check if original operation with the same request ID
                #     was received, and if so, will ignore the second request. This prevents
                #     clients from accidentally creating duplicate commitments.
                #
                #     The request ID must be a valid UUID with the exception that zero UUID is
                #     not supported (00000000-0000-0000-0000-000000000000).
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Protobuf::Empty]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Protobuf::Empty]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/saas_platform/saas_service_mgmt/v1beta1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteReleaseRequest.new
                #
                #   # Call the delete_release method.
                #   result = client.delete_release request
                #
                #   # The returned object is of type Google::Protobuf::Empty.
                #   p result
                #
                def delete_release request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::DeleteReleaseRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.delete_release.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.delete_release.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.delete_release.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @saas_deployments_stub.delete_release request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Configuration class for the SaasDeployments REST API.
                #
                # This class represents the configuration for SaasDeployments REST,
                # providing control over timeouts, retry behavior, logging, transport
                # parameters, and other low-level controls. Certain parameters can also be
                # applied individually to specific RPCs. See
                # {::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client::Configuration::Rpcs}
                # for a list of RPCs that can be configured independently.
                #
                # Configuration can be applied globally to all clients, or to a single client
                # on construction.
                #
                # @example
                #
                #   # Modify the global config, setting the timeout for
                #   # list_saas to 20 seconds,
                #   # and all remaining timeouts to 10 seconds.
                #   ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.configure do |config|
                #     config.timeout = 10.0
                #     config.rpcs.list_saas.timeout = 20.0
                #   end
                #
                #   # Apply the above configuration only to a new client.
                #   client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new do |config|
                #     config.timeout = 10.0
                #     config.rpcs.list_saas.timeout = 20.0
                #   end
                #
                # @!attribute [rw] endpoint
                #   A custom service endpoint, as a hostname or hostname:port. The default is
                #   nil, indicating to use the default endpoint in the current universe domain.
                #   @return [::String,nil]
                # @!attribute [rw] credentials
                #   Credentials to send with calls. You may provide any of the following types:
                #    *  (`String`) The path to a service account key file in JSON format
                #    *  (`Hash`) A service account key as a Hash
                #    *  (`Google::Auth::Credentials`) A googleauth credentials object
                #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
                #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
                #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
                #    *  (`nil`) indicating no credentials
                #
                #   Warning: If you accept a credential configuration (JSON file or Hash) from an
                #   external source for authentication to Google Cloud, you must validate it before
                #   providing it to a Google API client library. Providing an unvalidated credential
                #   configuration to Google APIs can compromise the security of your systems and data.
                #   For more information, refer to [Validate credential configurations from external
                #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
                #   @return [::Object]
                # @!attribute [rw] scope
                #   The OAuth scopes
                #   @return [::Array<::String>]
                # @!attribute [rw] lib_name
                #   The library name as recorded in instrumentation and logging
                #   @return [::String]
                # @!attribute [rw] lib_version
                #   The library version as recorded in instrumentation and logging
                #   @return [::String]
                # @!attribute [rw] timeout
                #   The call timeout in seconds.
                #   @return [::Numeric]
                # @!attribute [rw] metadata
                #   Additional headers to be sent with the call.
                #   @return [::Hash{::Symbol=>::String}]
                # @!attribute [rw] retry_policy
                #   The retry policy. The value is a hash with the following keys:
                #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #       trigger a retry.
                #   @return [::Hash]
                # @!attribute [rw] quota_project
                #   A separate project against which to charge quota.
                #   @return [::String]
                # @!attribute [rw] universe_domain
                #   The universe domain within which to make requests. This determines the
                #   default endpoint URL. The default value of nil uses the environment
                #   universe (usually the default "googleapis.com" universe).
                #   @return [::String,nil]
                # @!attribute [rw] logger
                #   A custom logger to use for request/response debug logging, or the value
                #   `:default` (the default) to construct a default logger, or `nil` to
                #   explicitly disable logging.
                #   @return [::Logger,:default,nil]
                #
                class Configuration
                  extend ::Gapic::Config

                  # @private
                  # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                  DEFAULT_ENDPOINT = "saasservicemgmt.googleapis.com"

                  config_attr :endpoint,      nil, ::String, nil
                  config_attr :credentials,   nil do |value|
                    allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                    allowed.any? { |klass| klass === value }
                  end
                  config_attr :scope,         nil, ::String, ::Array, nil
                  config_attr :lib_name,      nil, ::String, nil
                  config_attr :lib_version,   nil, ::String, nil
                  config_attr :timeout,       nil, ::Numeric, nil
                  config_attr :metadata,      nil, ::Hash, nil
                  config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                  config_attr :quota_project, nil, ::String, nil
                  config_attr :universe_domain, nil, ::String, nil

                  # @private
                  # Overrides for http bindings for the RPCs of this service
                  # are only used when this service is used as mixin, and only
                  # by the host service.
                  # @return [::Hash{::Symbol=>::Array<::Gapic::Rest::GrpcTranscoder::HttpBinding>}]
                  config_attr :bindings_override, {}, ::Hash, nil
                  config_attr :logger, :default, ::Logger, nil, :default

                  # @private
                  def initialize parent_config = nil
                    @parent_config = parent_config unless parent_config.nil?

                    yield self if block_given?
                  end

                  ##
                  # Configurations for individual RPCs
                  # @return [Rpcs]
                  #
                  def rpcs
                    @rpcs ||= begin
                      parent_rpcs = nil
                      parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                      Rpcs.new parent_rpcs
                    end
                  end

                  ##
                  # Configuration RPC class for the SaasDeployments API.
                  #
                  # Includes fields providing the configuration for each RPC in this service.
                  # Each configuration object is of type `Gapic::Config::Method` and includes
                  # the following configuration fields:
                  #
                  #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                  #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                  #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                  #     include the following keys:
                  #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                  #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                  #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                  #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                  #         trigger a retry.
                  #
                  class Rpcs
                    ##
                    # RPC-specific configuration for `list_saas`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :list_saas
                    ##
                    # RPC-specific configuration for `get_saas`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :get_saas
                    ##
                    # RPC-specific configuration for `create_saas`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :create_saas
                    ##
                    # RPC-specific configuration for `update_saas`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :update_saas
                    ##
                    # RPC-specific configuration for `delete_saas`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :delete_saas
                    ##
                    # RPC-specific configuration for `list_tenants`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :list_tenants
                    ##
                    # RPC-specific configuration for `get_tenant`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :get_tenant
                    ##
                    # RPC-specific configuration for `create_tenant`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :create_tenant
                    ##
                    # RPC-specific configuration for `update_tenant`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :update_tenant
                    ##
                    # RPC-specific configuration for `delete_tenant`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :delete_tenant
                    ##
                    # RPC-specific configuration for `list_unit_kinds`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :list_unit_kinds
                    ##
                    # RPC-specific configuration for `get_unit_kind`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :get_unit_kind
                    ##
                    # RPC-specific configuration for `create_unit_kind`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :create_unit_kind
                    ##
                    # RPC-specific configuration for `update_unit_kind`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :update_unit_kind
                    ##
                    # RPC-specific configuration for `delete_unit_kind`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :delete_unit_kind
                    ##
                    # RPC-specific configuration for `list_units`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :list_units
                    ##
                    # RPC-specific configuration for `get_unit`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :get_unit
                    ##
                    # RPC-specific configuration for `create_unit`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :create_unit
                    ##
                    # RPC-specific configuration for `update_unit`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :update_unit
                    ##
                    # RPC-specific configuration for `delete_unit`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :delete_unit
                    ##
                    # RPC-specific configuration for `list_unit_operations`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :list_unit_operations
                    ##
                    # RPC-specific configuration for `get_unit_operation`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :get_unit_operation
                    ##
                    # RPC-specific configuration for `create_unit_operation`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :create_unit_operation
                    ##
                    # RPC-specific configuration for `update_unit_operation`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :update_unit_operation
                    ##
                    # RPC-specific configuration for `delete_unit_operation`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :delete_unit_operation
                    ##
                    # RPC-specific configuration for `list_releases`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :list_releases
                    ##
                    # RPC-specific configuration for `get_release`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :get_release
                    ##
                    # RPC-specific configuration for `create_release`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :create_release
                    ##
                    # RPC-specific configuration for `update_release`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :update_release
                    ##
                    # RPC-specific configuration for `delete_release`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :delete_release

                    # @private
                    def initialize parent_rpcs = nil
                      list_saas_config = parent_rpcs.list_saas if parent_rpcs.respond_to? :list_saas
                      @list_saas = ::Gapic::Config::Method.new list_saas_config
                      get_saas_config = parent_rpcs.get_saas if parent_rpcs.respond_to? :get_saas
                      @get_saas = ::Gapic::Config::Method.new get_saas_config
                      create_saas_config = parent_rpcs.create_saas if parent_rpcs.respond_to? :create_saas
                      @create_saas = ::Gapic::Config::Method.new create_saas_config
                      update_saas_config = parent_rpcs.update_saas if parent_rpcs.respond_to? :update_saas
                      @update_saas = ::Gapic::Config::Method.new update_saas_config
                      delete_saas_config = parent_rpcs.delete_saas if parent_rpcs.respond_to? :delete_saas
                      @delete_saas = ::Gapic::Config::Method.new delete_saas_config
                      list_tenants_config = parent_rpcs.list_tenants if parent_rpcs.respond_to? :list_tenants
                      @list_tenants = ::Gapic::Config::Method.new list_tenants_config
                      get_tenant_config = parent_rpcs.get_tenant if parent_rpcs.respond_to? :get_tenant
                      @get_tenant = ::Gapic::Config::Method.new get_tenant_config
                      create_tenant_config = parent_rpcs.create_tenant if parent_rpcs.respond_to? :create_tenant
                      @create_tenant = ::Gapic::Config::Method.new create_tenant_config
                      update_tenant_config = parent_rpcs.update_tenant if parent_rpcs.respond_to? :update_tenant
                      @update_tenant = ::Gapic::Config::Method.new update_tenant_config
                      delete_tenant_config = parent_rpcs.delete_tenant if parent_rpcs.respond_to? :delete_tenant
                      @delete_tenant = ::Gapic::Config::Method.new delete_tenant_config
                      list_unit_kinds_config = parent_rpcs.list_unit_kinds if parent_rpcs.respond_to? :list_unit_kinds
                      @list_unit_kinds = ::Gapic::Config::Method.new list_unit_kinds_config
                      get_unit_kind_config = parent_rpcs.get_unit_kind if parent_rpcs.respond_to? :get_unit_kind
                      @get_unit_kind = ::Gapic::Config::Method.new get_unit_kind_config
                      create_unit_kind_config = parent_rpcs.create_unit_kind if parent_rpcs.respond_to? :create_unit_kind
                      @create_unit_kind = ::Gapic::Config::Method.new create_unit_kind_config
                      update_unit_kind_config = parent_rpcs.update_unit_kind if parent_rpcs.respond_to? :update_unit_kind
                      @update_unit_kind = ::Gapic::Config::Method.new update_unit_kind_config
                      delete_unit_kind_config = parent_rpcs.delete_unit_kind if parent_rpcs.respond_to? :delete_unit_kind
                      @delete_unit_kind = ::Gapic::Config::Method.new delete_unit_kind_config
                      list_units_config = parent_rpcs.list_units if parent_rpcs.respond_to? :list_units
                      @list_units = ::Gapic::Config::Method.new list_units_config
                      get_unit_config = parent_rpcs.get_unit if parent_rpcs.respond_to? :get_unit
                      @get_unit = ::Gapic::Config::Method.new get_unit_config
                      create_unit_config = parent_rpcs.create_unit if parent_rpcs.respond_to? :create_unit
                      @create_unit = ::Gapic::Config::Method.new create_unit_config
                      update_unit_config = parent_rpcs.update_unit if parent_rpcs.respond_to? :update_unit
                      @update_unit = ::Gapic::Config::Method.new update_unit_config
                      delete_unit_config = parent_rpcs.delete_unit if parent_rpcs.respond_to? :delete_unit
                      @delete_unit = ::Gapic::Config::Method.new delete_unit_config
                      list_unit_operations_config = parent_rpcs.list_unit_operations if parent_rpcs.respond_to? :list_unit_operations
                      @list_unit_operations = ::Gapic::Config::Method.new list_unit_operations_config
                      get_unit_operation_config = parent_rpcs.get_unit_operation if parent_rpcs.respond_to? :get_unit_operation
                      @get_unit_operation = ::Gapic::Config::Method.new get_unit_operation_config
                      create_unit_operation_config = parent_rpcs.create_unit_operation if parent_rpcs.respond_to? :create_unit_operation
                      @create_unit_operation = ::Gapic::Config::Method.new create_unit_operation_config
                      update_unit_operation_config = parent_rpcs.update_unit_operation if parent_rpcs.respond_to? :update_unit_operation
                      @update_unit_operation = ::Gapic::Config::Method.new update_unit_operation_config
                      delete_unit_operation_config = parent_rpcs.delete_unit_operation if parent_rpcs.respond_to? :delete_unit_operation
                      @delete_unit_operation = ::Gapic::Config::Method.new delete_unit_operation_config
                      list_releases_config = parent_rpcs.list_releases if parent_rpcs.respond_to? :list_releases
                      @list_releases = ::Gapic::Config::Method.new list_releases_config
                      get_release_config = parent_rpcs.get_release if parent_rpcs.respond_to? :get_release
                      @get_release = ::Gapic::Config::Method.new get_release_config
                      create_release_config = parent_rpcs.create_release if parent_rpcs.respond_to? :create_release
                      @create_release = ::Gapic::Config::Method.new create_release_config
                      update_release_config = parent_rpcs.update_release if parent_rpcs.respond_to? :update_release
                      @update_release = ::Gapic::Config::Method.new update_release_config
                      delete_release_config = parent_rpcs.delete_release if parent_rpcs.respond_to? :delete_release
                      @delete_release = ::Gapic::Config::Method.new delete_release_config

                      yield self if block_given?
                    end
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
