# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module SaasPlatform
      module SaasServiceMgmt
        module V1beta1
          module SaasDeployments
            # Path helper methods for the SaasDeployments API.
            module Paths
              ##
              # Create a fully-qualified Location resource string.
              #
              # The resource will be in the following format:
              #
              # `projects/{project}/locations/{location}`
              #
              # @param project [String]
              # @param location [String]
              #
              # @return [::String]
              def location_path project:, location:
                raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

                "projects/#{project}/locations/#{location}"
              end

              ##
              # Create a fully-qualified Release resource string.
              #
              # The resource will be in the following format:
              #
              # `projects/{project}/locations/{location}/releases/{release}`
              #
              # @param project [String]
              # @param location [String]
              # @param release [String]
              #
              # @return [::String]
              def release_path project:, location:, release:
                raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                "projects/#{project}/locations/#{location}/releases/#{release}"
              end

              ##
              # Create a fully-qualified Rollout resource string.
              #
              # The resource will be in the following format:
              #
              # `projects/{project}/locations/{location}/rollouts/{rollout_id}`
              #
              # @param project [String]
              # @param location [String]
              # @param rollout_id [String]
              #
              # @return [::String]
              def rollout_path project:, location:, rollout_id:
                raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                "projects/#{project}/locations/#{location}/rollouts/#{rollout_id}"
              end

              ##
              # Create a fully-qualified Saas resource string.
              #
              # The resource will be in the following format:
              #
              # `projects/{project}/locations/{location}/saas/{saas}`
              #
              # @param project [String]
              # @param location [String]
              # @param saas [String]
              #
              # @return [::String]
              def saas_path project:, location:, saas:
                raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                "projects/#{project}/locations/#{location}/saas/#{saas}"
              end

              ##
              # Create a fully-qualified Tenant resource string.
              #
              # The resource will be in the following format:
              #
              # `projects/{project}/locations/{location}/tenants/{tenant}`
              #
              # @param project [String]
              # @param location [String]
              # @param tenant [String]
              #
              # @return [::String]
              def tenant_path project:, location:, tenant:
                raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                "projects/#{project}/locations/#{location}/tenants/#{tenant}"
              end

              ##
              # Create a fully-qualified Unit resource string.
              #
              # The resource will be in the following format:
              #
              # `projects/{project}/locations/{location}/units/{unit}`
              #
              # @param project [String]
              # @param location [String]
              # @param unit [String]
              #
              # @return [::String]
              def unit_path project:, location:, unit:
                raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                "projects/#{project}/locations/#{location}/units/#{unit}"
              end

              ##
              # Create a fully-qualified UnitKind resource string.
              #
              # The resource will be in the following format:
              #
              # `projects/{project}/locations/{location}/unitKinds/{unit_kind}`
              #
              # @param project [String]
              # @param location [String]
              # @param unit_kind [String]
              #
              # @return [::String]
              def unit_kind_path project:, location:, unit_kind:
                raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                "projects/#{project}/locations/#{location}/unitKinds/#{unit_kind}"
              end

              ##
              # Create a fully-qualified UnitOperation resource string.
              #
              # The resource will be in the following format:
              #
              # `projects/{project}/locations/{location}/unitOperations/{unit_operation}`
              #
              # @param project [String]
              # @param location [String]
              # @param unit_operation [String]
              #
              # @return [::String]
              def unit_operation_path project:, location:, unit_operation:
                raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                "projects/#{project}/locations/#{location}/unitOperations/#{unit_operation}"
              end

              extend self
            end
          end
        end
      end
    end
  end
end
