# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "gapic/common"
require "gapic/config"
require "gapic/config/method"

require "google/cloud/saas_platform/saas_service_mgmt/v1beta1/version"

require "google/cloud/saas_platform/saas_service_mgmt/v1beta1/saas_deployments/credentials"
require "google/cloud/saas_platform/saas_service_mgmt/v1beta1/saas_deployments/paths"
require "google/cloud/saas_platform/saas_service_mgmt/v1beta1/saas_deployments/client"
require "google/cloud/saas_platform/saas_service_mgmt/v1beta1/saas_deployments/rest"

module Google
  module Cloud
    module SaasPlatform
      module SaasServiceMgmt
        module V1beta1
          ##
          # Manages the deployment of SaaS services.
          #
          # @example Load this service and instantiate a gRPC client
          #
          #     require "google/cloud/saas_platform/saas_service_mgmt/v1beta1/saas_deployments"
          #     client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Client.new
          #
          # @example Load this service and instantiate a REST client
          #
          #     require "google/cloud/saas_platform/saas_service_mgmt/v1beta1/saas_deployments/rest"
          #     client = ::Google::Cloud::SaasPlatform::SaasServiceMgmt::V1beta1::SaasDeployments::Rest::Client.new
          #
          module SaasDeployments
          end
        end
      end
    end
  end
end

helper_path = ::File.join __dir__, "saas_deployments", "helpers.rb"
require "google/cloud/saas_platform/saas_service_mgmt/v1beta1/saas_deployments/helpers" if ::File.file? helper_path
