# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Run
      module V2
        # WorkerPoolRevisionTemplate describes the data a worker pool revision should
        # have when created from a template.
        # @!attribute [rw] revision
        #   @return [::String]
        #     Optional. The unique name for the revision. If this field is omitted, it
        #     will be automatically generated based on the WorkerPool name.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Unstructured key value map that can be used to organize and
        #     categorize objects. User-provided labels are shared with Google's billing
        #     system, so they can be used to filter, or break down billing charges by
        #     team, component, environment, state, etc. For more information, visit
        #     https://cloud.google.com/resource-manager/docs/creating-managing-labels or
        #     https://cloud.google.com/run/docs/configuring/labels.
        #
        #     Cloud Run API v2 does not support labels with `run.googleapis.com`,
        #     `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
        #     namespaces, and they will be rejected. All system labels in v1 now have a
        #     corresponding field in v2 WorkerPoolRevisionTemplate.
        # @!attribute [rw] annotations
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Unstructured key value map that may be set by external tools to
        #     store and arbitrary metadata. They are not queryable and should be
        #     preserved when modifying objects.
        #
        #     Cloud Run API v2 does not support annotations with `run.googleapis.com`,
        #     `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
        #     namespaces, and they will be rejected. All system annotations in v1 now
        #     have a corresponding field in v2 WorkerPoolRevisionTemplate.
        #
        #     This field follows Kubernetes annotations' namespacing, limits, and
        #     rules.
        # @!attribute [rw] vpc_access
        #   @return [::Google::Cloud::Run::V2::VpcAccess]
        #     Optional. VPC Access configuration to use for this Revision. For more
        #     information, visit
        #     https://cloud.google.com/run/docs/configuring/connecting-vpc.
        # @!attribute [rw] service_account
        #   @return [::String]
        #     Optional. Email address of the IAM service account associated with the
        #     revision of the service. The service account represents the identity of the
        #     running revision, and determines what permissions the revision has. If not
        #     provided, the revision will use the project's default service account.
        # @!attribute [rw] containers
        #   @return [::Array<::Google::Cloud::Run::V2::Container>]
        #     Holds list of the containers that defines the unit of execution for this
        #     Revision.
        # @!attribute [rw] volumes
        #   @return [::Array<::Google::Cloud::Run::V2::Volume>]
        #     Optional. A list of Volumes to make available to containers.
        # @!attribute [rw] encryption_key
        #   @return [::String]
        #     A reference to a customer managed encryption key (CMEK) to use to encrypt
        #     this container image. For more information, go to
        #     https://cloud.google.com/run/docs/securing/using-cmek
        # @!attribute [rw] service_mesh
        #   @return [::Google::Cloud::Run::V2::ServiceMesh]
        #     Optional. Enables service mesh connectivity.
        # @!attribute [rw] encryption_key_revocation_action
        #   @return [::Google::Cloud::Run::V2::EncryptionKeyRevocationAction]
        #     Optional. The action to take if the encryption key is revoked.
        # @!attribute [rw] encryption_key_shutdown_duration
        #   @return [::Google::Protobuf::Duration]
        #     Optional. If encryption_key_revocation_action is SHUTDOWN, the duration
        #     before shutting down all instances. The minimum increment is 1 hour.
        # @!attribute [rw] node_selector
        #   @return [::Google::Cloud::Run::V2::NodeSelector]
        #     Optional. The node selector for the revision template.
        class WorkerPoolRevisionTemplate
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class AnnotationsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
