# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Run
      module V2
        # VPC Access settings. For more information on sending traffic to a VPC
        # network, visit https://cloud.google.com/run/docs/configuring/connecting-vpc.
        # @!attribute [rw] connector
        #   @return [::String]
        #     VPC Access connector name.
        #     Format: `projects/{project}/locations/{location}/connectors/{connector}`,
        #     where `{project}` can be project id or number.
        #     For more information on sending traffic to a VPC network via a connector,
        #     visit https://cloud.google.com/run/docs/configuring/vpc-connectors.
        # @!attribute [rw] egress
        #   @return [::Google::Cloud::Run::V2::VpcAccess::VpcEgress]
        #     Optional. Traffic VPC egress settings. If not provided, it defaults to
        #     PRIVATE_RANGES_ONLY.
        # @!attribute [rw] network_interfaces
        #   @return [::Array<::Google::Cloud::Run::V2::VpcAccess::NetworkInterface>]
        #     Optional. Direct VPC egress settings. Currently only single network
        #     interface is supported.
        class VpcAccess
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Direct VPC egress settings.
          # @!attribute [rw] network
          #   @return [::String]
          #     Optional. The VPC network that the Cloud Run resource will be able to
          #     send traffic to. At least one of network or subnetwork must be specified.
          #     If both network and subnetwork are specified, the given VPC subnetwork
          #     must belong to the given VPC network. If network is not specified, it
          #     will be looked up from the subnetwork.
          # @!attribute [rw] subnetwork
          #   @return [::String]
          #     Optional. The VPC subnetwork that the Cloud Run resource will get IPs
          #     from. At least one of network or subnetwork must be specified. If both
          #     network and subnetwork are specified, the given VPC subnetwork must
          #     belong to the given VPC network. If subnetwork is not specified, the
          #     subnetwork with the same name with the network will be used.
          # @!attribute [rw] tags
          #   @return [::Array<::String>]
          #     Optional. Network tags applied to this Cloud Run resource.
          class NetworkInterface
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Egress options for VPC access.
          module VpcEgress
            # Unspecified
            VPC_EGRESS_UNSPECIFIED = 0

            # All outbound traffic is routed through the VPC connector.
            ALL_TRAFFIC = 1

            # Only private IP ranges are routed through the VPC connector.
            PRIVATE_RANGES_ONLY = 2
          end
        end

        # Settings for Binary Authorization feature.
        # @!attribute [rw] use_default
        #   @return [::Boolean]
        #     Optional. If True, indicates to use the default project's binary
        #     authorization policy. If False, binary authorization will be disabled.
        #
        #     Note: The following fields are mutually exclusive: `use_default`, `policy`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] policy
        #   @return [::String]
        #     Optional. The path to a binary authorization policy.
        #     Format: `projects/{project}/platforms/cloudRun/{policy-name}`
        #
        #     Note: The following fields are mutually exclusive: `policy`, `use_default`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] breakglass_justification
        #   @return [::String]
        #     Optional. If present, indicates to use Breakglass using this justification.
        #     If use_default is False, then it must be empty.
        #     For more information on breakglass, see
        #     https://cloud.google.com/binary-authorization/docs/using-breakglass
        class BinaryAuthorization
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Settings for revision-level scaling settings.
        # @!attribute [rw] min_instance_count
        #   @return [::Integer]
        #     Optional. Minimum number of serving instances that this resource should
        #     have.
        # @!attribute [rw] max_instance_count
        #   @return [::Integer]
        #     Optional. Maximum number of serving instances that this resource should
        #     have. When unspecified, the field is set to the server default value of
        #     100. For more information see
        #     https://cloud.google.com/run/docs/configuring/max-instances
        class RevisionScaling
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Settings for Cloud Service Mesh. For more information see
        # https://cloud.google.com/service-mesh/docs/overview.
        # @!attribute [rw] mesh
        #   @return [::String]
        #     The Mesh resource name. Format:
        #     `projects/{project}/locations/global/meshes/{mesh}`, where `{project}` can
        #     be project id or number.
        class ServiceMesh
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Scaling settings applied at the service level rather than
        # at the revision level.
        # @!attribute [rw] min_instance_count
        #   @return [::Integer]
        #     Optional. total min instances for the service. This number of instances is
        #     divided among all revisions with specified traffic based on the percent
        #     of traffic they are receiving.
        # @!attribute [rw] scaling_mode
        #   @return [::Google::Cloud::Run::V2::ServiceScaling::ScalingMode]
        #     Optional. The scaling mode for the service.
        # @!attribute [rw] manual_instance_count
        #   @return [::Integer]
        #     Optional. total instance count for the service in manual scaling mode. This
        #     number of instances is divided among all revisions with specified traffic
        #     based on the percent of traffic they are receiving.
        class ServiceScaling
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The scaling mode for the service. If not provided, it defaults to
          # AUTOMATIC.
          module ScalingMode
            # Unspecified.
            SCALING_MODE_UNSPECIFIED = 0

            # Scale based on traffic between min and max instances.
            AUTOMATIC = 1

            # Scale to exactly min instances and ignore max instances.
            MANUAL = 2
          end
        end

        # Worker pool scaling settings.
        # @!attribute [rw] manual_instance_count
        #   @return [::Integer]
        #     Optional. The total number of instances in manual scaling mode.
        class WorkerPoolScaling
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Hardware constraints configuration.
        # @!attribute [rw] accelerator
        #   @return [::String]
        #     Required. GPU accelerator type to attach to an instance.
        class NodeSelector
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Describes the Build step of the function that builds a container from the
        # given source.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The Cloud Build name of the latest successful deployment of
        #     the function.
        # @!attribute [rw] source_location
        #   @return [::String]
        #     The Cloud Storage bucket URI where the function source code is located.
        # @!attribute [rw] function_target
        #   @return [::String]
        #     Optional. The name of the function (as defined in source code) that will be
        #     executed. Defaults to the resource name suffix, if not specified. For
        #     backward compatibility, if function with given name is not found, then the
        #     system will try to use function named "function".
        # @!attribute [rw] image_uri
        #   @return [::String]
        #     Optional. Artifact Registry URI to store the built image.
        # @!attribute [rw] base_image
        #   @return [::String]
        #     Optional. The base image used to build the function.
        # @!attribute [rw] enable_automatic_updates
        #   @return [::Boolean]
        #     Optional. Sets whether the function will receive automatic base image
        #     updates.
        # @!attribute [rw] worker_pool
        #   @return [::String]
        #     Optional. Name of the Cloud Build Custom Worker Pool that should be used to
        #     build the Cloud Run function. The format of this field is
        #     `projects/{project}/locations/{region}/workerPools/{workerPool}` where
        #     `{project}` and `{region}` are the project id and region respectively where
        #     the worker pool is defined and `{workerPool}` is the short name of the
        #     worker pool.
        # @!attribute [rw] environment_variables
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. User-provided build-time environment variables for the function
        # @!attribute [rw] service_account
        #   @return [::String]
        #     Optional. Service account to be used for building the container. The format
        #     of this field is
        #     `projects/{projectId}/serviceAccounts/{serviceAccountEmail}`.
        class BuildConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class EnvironmentVariablesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Allowed ingress traffic for the Container.
        module IngressTraffic
          # Unspecified
          INGRESS_TRAFFIC_UNSPECIFIED = 0

          # All inbound traffic is allowed.
          INGRESS_TRAFFIC_ALL = 1

          # Only internal traffic is allowed.
          INGRESS_TRAFFIC_INTERNAL_ONLY = 2

          # Both internal and Google Cloud Load Balancer traffic is allowed.
          INGRESS_TRAFFIC_INTERNAL_LOAD_BALANCER = 3

          # No ingress traffic is allowed.
          INGRESS_TRAFFIC_NONE = 4
        end

        # Alternatives for execution environments.
        module ExecutionEnvironment
          # Unspecified
          EXECUTION_ENVIRONMENT_UNSPECIFIED = 0

          # Uses the First Generation environment.
          EXECUTION_ENVIRONMENT_GEN1 = 1

          # Uses Second Generation environment.
          EXECUTION_ENVIRONMENT_GEN2 = 2
        end

        # Specifies behavior if an encryption key used by a resource is revoked.
        module EncryptionKeyRevocationAction
          # Unspecified
          ENCRYPTION_KEY_REVOCATION_ACTION_UNSPECIFIED = 0

          # Prevents the creation of new instances.
          PREVENT_NEW = 1

          # Shuts down existing instances, and prevents creation of new ones.
          SHUTDOWN = 2
        end
      end
    end
  end
end
