# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Run
      module V2
        # Holds a single traffic routing entry for the Service. Allocations can be done
        # to a specific Revision name, or pointing to the latest Ready Revision.
        # @!attribute [rw] type
        #   @return [::Google::Cloud::Run::V2::TrafficTargetAllocationType]
        #     The allocation type for this traffic target.
        # @!attribute [rw] revision
        #   @return [::String]
        #     Revision to which to send this portion of traffic, if traffic allocation is
        #     by revision.
        # @!attribute [rw] percent
        #   @return [::Integer]
        #     Specifies percent of the traffic to this Revision.
        #     This defaults to zero if unspecified.
        # @!attribute [rw] tag
        #   @return [::String]
        #     Indicates a string to be part of the URI to exclusively reference this
        #     target.
        class TrafficTarget
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the observed state of a single `TrafficTarget` entry.
        # @!attribute [rw] type
        #   @return [::Google::Cloud::Run::V2::TrafficTargetAllocationType]
        #     The allocation type for this traffic target.
        # @!attribute [rw] revision
        #   @return [::String]
        #     Revision to which this traffic is sent.
        # @!attribute [rw] percent
        #   @return [::Integer]
        #     Specifies percent of the traffic to this Revision.
        # @!attribute [rw] tag
        #   @return [::String]
        #     Indicates the string used in the URI to exclusively reference this target.
        # @!attribute [rw] uri
        #   @return [::String]
        #     Displays the target URI.
        class TrafficTargetStatus
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The type of instance allocation.
        module TrafficTargetAllocationType
          # Unspecified instance allocation type.
          TRAFFIC_TARGET_ALLOCATION_TYPE_UNSPECIFIED = 0

          # Allocates instances to the Service's latest ready Revision.
          TRAFFIC_TARGET_ALLOCATION_TYPE_LATEST = 1

          # Allocates instances to a Revision by name.
          TRAFFIC_TARGET_ALLOCATION_TYPE_REVISION = 2
        end
      end
    end
  end
end
