# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Run
      module V2
        # Request message for obtaining a Task by its full name.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The full name of the Task.
        #     Format:
        #     projects/\\{project}/locations/\\{location}/jobs/\\{job}/executions/\\{execution}/tasks/\\{task}
        class GetTaskRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for retrieving a list of Tasks.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The Execution from which the Tasks should be listed.
        #     To list all Tasks across Executions of a Job, use "-" instead of Execution
        #     name. To list all Tasks across Jobs, use "-" instead of Job name. Format:
        #     projects/\\{project}/locations/\\{location}/jobs/\\{job}/executions/\\{execution}
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Maximum number of Tasks to return in this call.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token received from a previous call to ListTasks.
        #     All other parameters must match.
        # @!attribute [rw] show_deleted
        #   @return [::Boolean]
        #     If true, returns deleted (but unexpired) resources along with active ones.
        class ListTasksRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message containing a list of Tasks.
        # @!attribute [rw] tasks
        #   @return [::Array<::Google::Cloud::Run::V2::Task>]
        #     The resulting list of Tasks.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token indicating there are more items than page_size. Use it in the next
        #     ListTasks request to continue.
        class ListTasksResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Task represents a single run of a container to completion.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The unique name of this Task.
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. Server assigned unique identifier for the Task. The value is a
        #     UUID4 string and guaranteed to remain unchanged until the resource is
        #     deleted.
        # @!attribute [r] generation
        #   @return [::Integer]
        #     Output only. A number that monotonically increases every time the user
        #     modifies the desired state.
        # @!attribute [r] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Output only. Unstructured key value map that can be used to organize and
        #     categorize objects. User-provided labels are shared with Google's billing
        #     system, so they can be used to filter, or break down billing charges by
        #     team, component, environment, state, etc. For more information, visit
        #     https://cloud.google.com/resource-manager/docs/creating-managing-labels or
        #     https://cloud.google.com/run/docs/configuring/labels
        # @!attribute [r] annotations
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Output only. Unstructured key value map that may
        #     be set by external tools to store and arbitrary metadata.
        #     They are not queryable and should be preserved
        #     when modifying objects.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Represents time when the task was created by the system.
        #     It is not guaranteed to be set in happens-before order across separate
        #     operations.
        # @!attribute [r] scheduled_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Represents time when the task was scheduled to run by the
        #     system. It is not guaranteed to be set in happens-before order across
        #     separate operations.
        # @!attribute [r] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Represents time when the task started to run.
        #     It is not guaranteed to be set in happens-before order across separate
        #     operations.
        # @!attribute [r] completion_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Represents time when the Task was completed. It is not
        #     guaranteed to be set in happens-before order across separate operations.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The last-modified time.
        # @!attribute [r] delete_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. For a deleted resource, the deletion time. It is only
        #     populated as a response to a Delete request.
        # @!attribute [r] expire_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. For a deleted resource, the time after which it will be
        #     permamently deleted. It is only populated as a response to a Delete
        #     request.
        # @!attribute [r] job
        #   @return [::String]
        #     Output only. The name of the parent Job.
        # @!attribute [r] execution
        #   @return [::String]
        #     Output only. The name of the parent Execution.
        # @!attribute [rw] containers
        #   @return [::Array<::Google::Cloud::Run::V2::Container>]
        #     Holds the single container that defines the unit of execution for this
        #     task.
        # @!attribute [rw] volumes
        #   @return [::Array<::Google::Cloud::Run::V2::Volume>]
        #     A list of Volumes to make available to containers.
        # @!attribute [rw] max_retries
        #   @return [::Integer]
        #     Number of retries allowed per Task, before marking this Task failed.
        # @!attribute [rw] timeout
        #   @return [::Google::Protobuf::Duration]
        #     Max allowed time duration the Task may be active before the system will
        #     actively try to mark it failed and kill associated containers. This applies
        #     per attempt of a task, meaning each retry can run for the full timeout.
        # @!attribute [rw] service_account
        #   @return [::String]
        #     Email address of the IAM service account associated with the Task of a
        #     Job. The service account represents the identity of the
        #     running task, and determines what permissions the task has. If
        #     not provided, the task will use the project's default service account.
        # @!attribute [rw] execution_environment
        #   @return [::Google::Cloud::Run::V2::ExecutionEnvironment]
        #     The execution environment being used to host this Task.
        # @!attribute [r] reconciling
        #   @return [::Boolean]
        #     Output only. Indicates whether the resource's reconciliation is still in
        #     progress. See comments in `Job.reconciling` for additional information on
        #     reconciliation process in Cloud Run.
        # @!attribute [r] conditions
        #   @return [::Array<::Google::Cloud::Run::V2::Condition>]
        #     Output only. The Condition of this Task, containing its readiness status,
        #     and detailed error information in case it did not reach the desired state.
        # @!attribute [r] observed_generation
        #   @return [::Integer]
        #     Output only. The generation of this Task. See comments in `Job.reconciling`
        #     for additional information on reconciliation process in Cloud Run.
        # @!attribute [r] index
        #   @return [::Integer]
        #     Output only. Index of the Task, unique per execution, and beginning at 0.
        # @!attribute [r] retried
        #   @return [::Integer]
        #     Output only. The number of times this Task was retried.
        #     Tasks are retried when they fail up to the maxRetries limit.
        # @!attribute [r] last_attempt_result
        #   @return [::Google::Cloud::Run::V2::TaskAttemptResult]
        #     Output only. Result of the last attempt of this Task.
        # @!attribute [r] encryption_key
        #   @return [::String]
        #     Output only. A reference to a customer managed encryption key (CMEK) to use
        #     to encrypt this container image. For more information, go to
        #     https://cloud.google.com/run/docs/securing/using-cmek
        # @!attribute [r] vpc_access
        #   @return [::Google::Cloud::Run::V2::VpcAccess]
        #     Output only. VPC Access configuration to use for this Task. For more
        #     information, visit
        #     https://cloud.google.com/run/docs/configuring/connecting-vpc.
        # @!attribute [r] log_uri
        #   @return [::String]
        #     Output only. URI where logs for this execution can be found in Cloud
        #     Console.
        # @!attribute [r] satisfies_pzs
        #   @return [::Boolean]
        #     Output only. Reserved for future use.
        # @!attribute [r] node_selector
        #   @return [::Google::Cloud::Run::V2::NodeSelector]
        #     Output only. The node selector for the task.
        # @!attribute [r] gpu_zonal_redundancy_disabled
        #   @return [::Boolean]
        #     Optional. Output only. True if GPU zonal redundancy is disabled on this
        #     task.
        # @!attribute [r] etag
        #   @return [::String]
        #     Output only. A system-generated fingerprint for this version of the
        #     resource. May be used to detect modification conflict during updates.
        class Task
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class AnnotationsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Result of a task attempt.
        # @!attribute [r] status
        #   @return [::Google::Rpc::Status]
        #     Output only. The status of this attempt.
        #     If the status code is OK, then the attempt succeeded.
        # @!attribute [r] exit_code
        #   @return [::Integer]
        #     Output only. The exit code of this attempt.
        #     This may be unset if the container was unable to exit cleanly with a code
        #     due to some other failure.
        #     See status field for possible failure details.
        #
        #     At most one of exit_code or term_signal will be set.
        # @!attribute [r] term_signal
        #   @return [::Integer]
        #     Output only. Termination signal of the container. This is set to non-zero
        #     if the container is terminated by the system.
        #
        #     At most one of exit_code or term_signal will be set.
        class TaskAttemptResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
