# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Run
      module V2
        # Request message for creating a Service.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The location and project in which this service should be created.
        #     Format: projects/\\{project}/locations/\\{location}, where \\{project} can be
        #     project id or number. Only lowercase characters, digits, and hyphens.
        # @!attribute [rw] service
        #   @return [::Google::Cloud::Run::V2::Service]
        #     Required. The Service instance to create.
        # @!attribute [rw] service_id
        #   @return [::String]
        #     Required. The unique identifier for the Service. It must begin with letter,
        #     and cannot end with hyphen; must contain fewer than 50 characters.
        #     The name of the service becomes \\{parent}/services/\\{service_id}.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Indicates that the request should be validated and default values
        #     populated, without persisting the request or creating any resources.
        class CreateServiceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for updating a service.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. The list of fields to be updated.
        # @!attribute [rw] service
        #   @return [::Google::Cloud::Run::V2::Service]
        #     Required. The Service to be updated.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Indicates that the request should be validated and default values
        #     populated, without persisting the request or updating any resources.
        # @!attribute [rw] allow_missing
        #   @return [::Boolean]
        #     Optional. If set to true, and if the Service does not exist, it will create
        #     a new one. The caller must have 'run.services.create' permissions if this
        #     is set to true and the Service does not exist.
        class UpdateServiceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for retrieving a list of Services.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The location and project to list resources on.
        #     Location must be a valid Google Cloud region, and cannot be the "-"
        #     wildcard. Format: projects/\\{project}/locations/\\{location}, where \\{project}
        #     can be project id or number.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Maximum number of Services to return in this call.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token received from a previous call to ListServices.
        #     All other parameters must match.
        # @!attribute [rw] show_deleted
        #   @return [::Boolean]
        #     If true, returns deleted (but unexpired) resources along with active ones.
        class ListServicesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message containing a list of Services.
        # @!attribute [rw] services
        #   @return [::Array<::Google::Cloud::Run::V2::Service>]
        #     The resulting list of Services.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token indicating there are more items than page_size. Use it in the next
        #     ListServices request to continue.
        class ListServicesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for obtaining a Service by its full name.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The full name of the Service.
        #     Format: projects/\\{project}/locations/\\{location}/services/\\{service}, where
        #     \\{project} can be project id or number.
        class GetServiceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message to delete a Service by its full name.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The full name of the Service.
        #     Format: projects/\\{project}/locations/\\{location}/services/\\{service}, where
        #     \\{project} can be project id or number.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Indicates that the request should be validated without actually
        #     deleting any resources.
        # @!attribute [rw] etag
        #   @return [::String]
        #     A system-generated fingerprint for this version of the
        #     resource. May be used to detect modification conflict during updates.
        class DeleteServiceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Service acts as a top-level container that manages a set of
        # configurations and revision templates which implement a network service.
        # Service exists to provide a singular abstraction which can be access
        # controlled, reasoned about, and which encapsulates software lifecycle
        # decisions such as rollout policy and team resource ownership.
        # @!attribute [rw] name
        #   @return [::String]
        #     The fully qualified name of this Service. In CreateServiceRequest, this
        #     field is ignored, and instead composed from CreateServiceRequest.parent and
        #     CreateServiceRequest.service_id.
        #
        #     Format:
        #     projects/\\{project}/locations/\\{location}/services/\\{service_id}
        # @!attribute [rw] description
        #   @return [::String]
        #     User-provided description of the Service. This field currently has a
        #     512-character limit.
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. Server assigned unique identifier for the trigger. The value
        #     is a UUID4 string and guaranteed to remain unchanged until the resource is
        #     deleted.
        # @!attribute [r] generation
        #   @return [::Integer]
        #     Output only. A number that monotonically increases every time the user
        #     modifies the desired state.
        #     Please note that unlike v1, this is an int64 value. As with most Google
        #     APIs, its JSON representation will be a `string` instead of an `integer`.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Unstructured key value map that can be used to organize and
        #     categorize objects. User-provided labels are shared with Google's billing
        #     system, so they can be used to filter, or break down billing charges by
        #     team, component, environment, state, etc. For more information, visit
        #     https://cloud.google.com/resource-manager/docs/creating-managing-labels or
        #     https://cloud.google.com/run/docs/configuring/labels.
        #
        #     <p>Cloud Run API v2 does not support labels with  `run.googleapis.com`,
        #     `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
        #     namespaces, and they will be rejected. All system labels in v1 now have a
        #     corresponding field in v2 Service.
        # @!attribute [rw] annotations
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Unstructured key value map that may be set by external tools to
        #     store and arbitrary metadata. They are not queryable and should be
        #     preserved when modifying objects.
        #
        #     <p>Cloud Run API v2 does not support annotations with `run.googleapis.com`,
        #     `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
        #     namespaces, and they will be rejected in new resources. All system
        #     annotations in v1 now have a corresponding field in v2 Service.
        #
        #     <p>This field follows Kubernetes
        #     annotations' namespacing, limits, and rules.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The creation time.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The last-modified time.
        # @!attribute [r] delete_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The deletion time. It is only populated as a response to a
        #     Delete request.
        # @!attribute [r] expire_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. For a deleted resource, the time after which it will be
        #     permanently deleted.
        # @!attribute [r] creator
        #   @return [::String]
        #     Output only. Email address of the authenticated creator.
        # @!attribute [r] last_modifier
        #   @return [::String]
        #     Output only. Email address of the last authenticated modifier.
        # @!attribute [rw] client
        #   @return [::String]
        #     Arbitrary identifier for the API client.
        # @!attribute [rw] client_version
        #   @return [::String]
        #     Arbitrary version identifier for the API client.
        # @!attribute [rw] ingress
        #   @return [::Google::Cloud::Run::V2::IngressTraffic]
        #     Optional. Provides the ingress settings for this Service. On output,
        #     returns the currently observed ingress settings, or
        #     INGRESS_TRAFFIC_UNSPECIFIED if no revision is active.
        # @!attribute [rw] launch_stage
        #   @return [::Google::Api::LaunchStage]
        #     Optional. The launch stage as defined by [Google Cloud Platform
        #     Launch Stages](https://cloud.google.com/terms/launch-stages).
        #     Cloud Run supports `ALPHA`, `BETA`, and `GA`. If no value is specified, GA
        #     is assumed.
        #     Set the launch stage to a preview stage on input to allow use of preview
        #     features in that stage. On read (or output), describes whether the resource
        #     uses preview features.
        #
        #     For example, if ALPHA is provided as input, but only BETA and GA-level
        #     features are used, this field will be BETA on output.
        # @!attribute [rw] binary_authorization
        #   @return [::Google::Cloud::Run::V2::BinaryAuthorization]
        #     Optional. Settings for the Binary Authorization feature.
        # @!attribute [rw] template
        #   @return [::Google::Cloud::Run::V2::RevisionTemplate]
        #     Required. The template used to create revisions for this Service.
        # @!attribute [rw] traffic
        #   @return [::Array<::Google::Cloud::Run::V2::TrafficTarget>]
        #     Optional. Specifies how to distribute traffic over a collection of
        #     Revisions belonging to the Service. If traffic is empty or not provided,
        #     defaults to 100% traffic to the latest `Ready` Revision.
        # @!attribute [rw] scaling
        #   @return [::Google::Cloud::Run::V2::ServiceScaling]
        #     Optional. Specifies service-level scaling settings
        # @!attribute [rw] invoker_iam_disabled
        #   @return [::Boolean]
        #     Optional. Disables IAM permission check for run.routes.invoke for callers
        #     of this service. This feature is available by invitation only. For more
        #     information, visit
        #     https://cloud.google.com/run/docs/securing/managing-access#invoker_check.
        # @!attribute [rw] default_uri_disabled
        #   @return [::Boolean]
        #     Optional. Disables public resolution of the default URI of this service.
        # @!attribute [r] urls
        #   @return [::Array<::String>]
        #     Output only. All URLs serving traffic for this Service.
        # @!attribute [rw] custom_audiences
        #   @return [::Array<::String>]
        #     One or more custom audiences that you want this service to support. Specify
        #     each custom audience as the full URL in a string. The custom audiences are
        #     encoded in the token and used to authenticate requests. For more
        #     information, see
        #     https://cloud.google.com/run/docs/configuring/custom-audiences.
        # @!attribute [r] observed_generation
        #   @return [::Integer]
        #     Output only. The generation of this Service currently serving traffic. See
        #     comments in `reconciling` for additional information on reconciliation
        #     process in Cloud Run. Please note that unlike v1, this is an int64 value.
        #     As with most Google APIs, its JSON representation will be a `string`
        #     instead of an `integer`.
        # @!attribute [r] terminal_condition
        #   @return [::Google::Cloud::Run::V2::Condition]
        #     Output only. The Condition of this Service, containing its readiness
        #     status, and detailed error information in case it did not reach a serving
        #     state. See comments in `reconciling` for additional information on
        #     reconciliation process in Cloud Run.
        # @!attribute [r] conditions
        #   @return [::Array<::Google::Cloud::Run::V2::Condition>]
        #     Output only. The Conditions of all other associated sub-resources. They
        #     contain additional diagnostics information in case the Service does not
        #     reach its Serving state. See comments in `reconciling` for additional
        #     information on reconciliation process in Cloud Run.
        # @!attribute [r] latest_ready_revision
        #   @return [::String]
        #     Output only. Name of the latest revision that is serving traffic. See
        #     comments in `reconciling` for additional information on reconciliation
        #     process in Cloud Run.
        # @!attribute [r] latest_created_revision
        #   @return [::String]
        #     Output only. Name of the last created revision. See comments in
        #     `reconciling` for additional information on reconciliation process in Cloud
        #     Run.
        # @!attribute [r] traffic_statuses
        #   @return [::Array<::Google::Cloud::Run::V2::TrafficTargetStatus>]
        #     Output only. Detailed status information for corresponding traffic targets.
        #     See comments in `reconciling` for additional information on reconciliation
        #     process in Cloud Run.
        # @!attribute [r] uri
        #   @return [::String]
        #     Output only. The main URI in which this Service is serving traffic.
        # @!attribute [r] satisfies_pzs
        #   @return [::Boolean]
        #     Output only. Reserved for future use.
        # @!attribute [rw] build_config
        #   @return [::Google::Cloud::Run::V2::BuildConfig]
        #     Optional. Configuration for building a Cloud Run function.
        # @!attribute [r] reconciling
        #   @return [::Boolean]
        #     Output only. Returns true if the Service is currently being acted upon by
        #     the system to bring it into the desired state.
        #
        #     When a new Service is created, or an existing one is updated, Cloud Run
        #     will asynchronously perform all necessary steps to bring the Service to the
        #     desired serving state. This process is called reconciliation.
        #     While reconciliation is in process, `observed_generation`,
        #     `latest_ready_revision`, `traffic_statuses`, and `uri` will have transient
        #     values that might mismatch the intended state: Once reconciliation is over
        #     (and this field is false), there are two possible outcomes: reconciliation
        #     succeeded and the serving state matches the Service, or there was an error,
        #     and reconciliation failed. This state can be found in
        #     `terminal_condition.state`.
        #
        #     If reconciliation succeeded, the following fields will match: `traffic` and
        #     `traffic_statuses`, `observed_generation` and `generation`,
        #     `latest_ready_revision` and `latest_created_revision`.
        #
        #     If reconciliation failed, `traffic_statuses`, `observed_generation`, and
        #     `latest_ready_revision` will have the state of the last serving revision,
        #     or empty for newly created Services. Additional information on the failure
        #     can be found in `terminal_condition` and `conditions`.
        # @!attribute [r] etag
        #   @return [::String]
        #     Output only. A system-generated fingerprint for this version of the
        #     resource. May be used to detect modification conflict during updates.
        class Service
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class AnnotationsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
