# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Run
      module V2
        # Request message for obtaining a Revision by its full name.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The full name of the Revision.
        #     Format:
        #     projects/\\{project}/locations/\\{location}/services/\\{service}/revisions/\\{revision}
        class GetRevisionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for retrieving a list of Revisions.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The Service from which the Revisions should be listed.
        #     To list all Revisions across Services, use "-" instead of Service name.
        #     Format:
        #     projects/\\{project}/locations/\\{location}/services/\\{service}
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Maximum number of revisions to return in this call.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token received from a previous call to ListRevisions.
        #     All other parameters must match.
        # @!attribute [rw] show_deleted
        #   @return [::Boolean]
        #     If true, returns deleted (but unexpired) resources along with active ones.
        class ListRevisionsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message containing a list of Revisions.
        # @!attribute [rw] revisions
        #   @return [::Array<::Google::Cloud::Run::V2::Revision>]
        #     The resulting list of Revisions.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token indicating there are more items than page_size. Use it in the next
        #     ListRevisions request to continue.
        class ListRevisionsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for deleting a retired Revision.
        # Revision lifecycle is usually managed by making changes to the parent
        # Service. Only retired revisions can be deleted with this API.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the Revision to delete.
        #     Format:
        #     projects/\\{project}/locations/\\{location}/services/\\{service}/revisions/\\{revision}
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Indicates that the request should be validated without actually
        #     deleting any resources.
        # @!attribute [rw] etag
        #   @return [::String]
        #     A system-generated fingerprint for this version of the
        #     resource. This may be used to detect modification conflict during updates.
        class DeleteRevisionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A Revision is an immutable snapshot of code and configuration.  A Revision
        # references a container image. Revisions are only created by updates to its
        # parent Service.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The unique name of this Revision.
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. Server assigned unique identifier for the Revision. The value
        #     is a UUID4 string and guaranteed to remain unchanged until the resource is
        #     deleted.
        # @!attribute [r] generation
        #   @return [::Integer]
        #     Output only. A number that monotonically increases every time the user
        #     modifies the desired state.
        # @!attribute [r] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Output only. Unstructured key value map that can be used to organize and
        #     categorize objects. User-provided labels are shared with Google's billing
        #     system, so they can be used to filter, or break down billing charges by
        #     team, component, environment, state, etc. For more information, visit
        #     https://cloud.google.com/resource-manager/docs/creating-managing-labels or
        #     https://cloud.google.com/run/docs/configuring/labels.
        # @!attribute [r] annotations
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Output only. Unstructured key value map that may
        #     be set by external tools to store and arbitrary metadata.
        #     They are not queryable and should be preserved
        #     when modifying objects.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The creation time.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The last-modified time.
        # @!attribute [r] delete_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. For a deleted resource, the deletion time. It is only
        #     populated as a response to a Delete request.
        # @!attribute [r] expire_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. For a deleted resource, the time after which it will be
        #     permamently deleted. It is only populated as a response to a Delete
        #     request.
        # @!attribute [rw] launch_stage
        #   @return [::Google::Api::LaunchStage]
        #     The least stable launch stage needed to create this resource, as defined by
        #     [Google Cloud Platform Launch
        #     Stages](https://cloud.google.com/terms/launch-stages). Cloud Run supports
        #     `ALPHA`, `BETA`, and `GA`.
        #
        #     Note that this value might not be what was used
        #     as input. For example, if ALPHA was provided as input in the parent
        #     resource, but only BETA and GA-level features are were, this field will be
        #     BETA.
        # @!attribute [r] service
        #   @return [::String]
        #     Output only. The name of the parent service.
        # @!attribute [rw] scaling
        #   @return [::Google::Cloud::Run::V2::RevisionScaling]
        #     Scaling settings for this revision.
        # @!attribute [rw] vpc_access
        #   @return [::Google::Cloud::Run::V2::VpcAccess]
        #     VPC Access configuration for this Revision. For more information, visit
        #     https://cloud.google.com/run/docs/configuring/connecting-vpc.
        # @!attribute [rw] max_instance_request_concurrency
        #   @return [::Integer]
        #     Sets the maximum number of requests that each serving instance can receive.
        # @!attribute [rw] timeout
        #   @return [::Google::Protobuf::Duration]
        #     Max allowed time for an instance to respond to a request.
        # @!attribute [rw] service_account
        #   @return [::String]
        #     Email address of the IAM service account associated with the revision of
        #     the service. The service account represents the identity of the running
        #     revision, and determines what permissions the revision has.
        # @!attribute [rw] containers
        #   @return [::Array<::Google::Cloud::Run::V2::Container>]
        #     Holds the single container that defines the unit of execution for this
        #     Revision.
        # @!attribute [rw] volumes
        #   @return [::Array<::Google::Cloud::Run::V2::Volume>]
        #     A list of Volumes to make available to containers.
        # @!attribute [rw] execution_environment
        #   @return [::Google::Cloud::Run::V2::ExecutionEnvironment]
        #     The execution environment being used to host this Revision.
        # @!attribute [rw] encryption_key
        #   @return [::String]
        #     A reference to a customer managed encryption key (CMEK) to use to encrypt
        #     this container image. For more information, go to
        #     https://cloud.google.com/run/docs/securing/using-cmek
        # @!attribute [rw] service_mesh
        #   @return [::Google::Cloud::Run::V2::ServiceMesh]
        #     Enables service mesh connectivity.
        # @!attribute [rw] encryption_key_revocation_action
        #   @return [::Google::Cloud::Run::V2::EncryptionKeyRevocationAction]
        #     The action to take if the encryption key is revoked.
        # @!attribute [rw] encryption_key_shutdown_duration
        #   @return [::Google::Protobuf::Duration]
        #     If encryption_key_revocation_action is SHUTDOWN, the duration before
        #     shutting down all instances. The minimum increment is 1 hour.
        # @!attribute [r] reconciling
        #   @return [::Boolean]
        #     Output only. Indicates whether the resource's reconciliation is still in
        #     progress. See comments in `Service.reconciling` for additional information
        #     on reconciliation process in Cloud Run.
        # @!attribute [r] conditions
        #   @return [::Array<::Google::Cloud::Run::V2::Condition>]
        #     Output only. The Condition of this Revision, containing its readiness
        #     status, and detailed error information in case it did not reach a serving
        #     state.
        # @!attribute [r] observed_generation
        #   @return [::Integer]
        #     Output only. The generation of this Revision currently serving traffic. See
        #     comments in `reconciling` for additional information on reconciliation
        #     process in Cloud Run.
        # @!attribute [r] log_uri
        #   @return [::String]
        #     Output only. The Google Console URI to obtain logs for the Revision.
        # @!attribute [r] satisfies_pzs
        #   @return [::Boolean]
        #     Output only. Reserved for future use.
        # @!attribute [rw] session_affinity
        #   @return [::Boolean]
        #     Enable session affinity.
        # @!attribute [r] scaling_status
        #   @return [::Google::Cloud::Run::V2::RevisionScalingStatus]
        #     Output only. The current effective scaling settings for the revision.
        # @!attribute [rw] node_selector
        #   @return [::Google::Cloud::Run::V2::NodeSelector]
        #     The node selector for the revision.
        # @!attribute [r] gpu_zonal_redundancy_disabled
        #   @return [::Boolean]
        #     Optional. Output only. True if GPU zonal redundancy is disabled on this
        #     revision.
        # @!attribute [r] creator
        #   @return [::String]
        #     Output only. Email address of the authenticated creator.
        # @!attribute [r] etag
        #   @return [::String]
        #     Output only. A system-generated fingerprint for this version of the
        #     resource. May be used to detect modification conflict during updates.
        class Revision
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class AnnotationsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
