# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Run
      module V2
        # A single application container.
        # This specifies both the container to run, the command to run in the container
        # and the arguments to supply to it.
        # Note that additional arguments can be supplied by the system to the container
        # at runtime.
        # @!attribute [rw] name
        #   @return [::String]
        #     Name of the container specified as a DNS_LABEL (RFC 1123).
        # @!attribute [rw] image
        #   @return [::String]
        #     Required. Name of the container image in Dockerhub, Google Artifact
        #     Registry, or Google Container Registry. If the host is not provided,
        #     Dockerhub is assumed.
        # @!attribute [rw] command
        #   @return [::Array<::String>]
        #     Entrypoint array. Not executed within a shell.
        #     The docker image's ENTRYPOINT is used if this is not provided.
        # @!attribute [rw] args
        #   @return [::Array<::String>]
        #     Arguments to the entrypoint.
        #     The docker image's CMD is used if this is not provided.
        # @!attribute [rw] env
        #   @return [::Array<::Google::Cloud::Run::V2::EnvVar>]
        #     List of environment variables to set in the container.
        # @!attribute [rw] resources
        #   @return [::Google::Cloud::Run::V2::ResourceRequirements]
        #     Compute Resource requirements by this container.
        # @!attribute [rw] ports
        #   @return [::Array<::Google::Cloud::Run::V2::ContainerPort>]
        #     List of ports to expose from the container. Only a single port can be
        #     specified. The specified ports must be listening on all interfaces
        #     (0.0.0.0) within the container to be accessible.
        #
        #     If omitted, a port number will be chosen and passed to the container
        #     through the PORT environment variable for the container to listen on.
        # @!attribute [rw] volume_mounts
        #   @return [::Array<::Google::Cloud::Run::V2::VolumeMount>]
        #     Volume to mount into the container's filesystem.
        # @!attribute [rw] working_dir
        #   @return [::String]
        #     Container's working directory.
        #     If not specified, the container runtime's default will be used, which
        #     might be configured in the container image.
        # @!attribute [rw] liveness_probe
        #   @return [::Google::Cloud::Run::V2::Probe]
        #     Periodic probe of container liveness.
        #     Container will be restarted if the probe fails.
        # @!attribute [rw] startup_probe
        #   @return [::Google::Cloud::Run::V2::Probe]
        #     Startup probe of application within the container.
        #     All other probes are disabled if a startup probe is provided, until it
        #     succeeds. Container will not be added to service endpoints if the probe
        #     fails.
        # @!attribute [rw] depends_on
        #   @return [::Array<::String>]
        #     Names of the containers that must start before this container.
        # @!attribute [rw] base_image_uri
        #   @return [::String]
        #     Base image for this container. Only supported for services. If set, it
        #     indicates that the service is enrolled into automatic base image update.
        # @!attribute [r] build_info
        #   @return [::Google::Cloud::Run::V2::BuildInfo]
        #     Output only. The build info of the container image.
        class Container
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ResourceRequirements describes the compute resource requirements.
        # @!attribute [rw] limits
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Only `memory` and `cpu` keys in the map are supported.
        #
        #     <p>Notes:
        #      * The only supported values for CPU are '1', '2', '4', and '8'. Setting 4
        #     CPU requires at least 2Gi of memory. For more information, go to
        #     https://cloud.google.com/run/docs/configuring/cpu.
        #       * For supported 'memory' values and syntax, go to
        #      https://cloud.google.com/run/docs/configuring/memory-limits
        # @!attribute [rw] cpu_idle
        #   @return [::Boolean]
        #     Determines whether CPU is only allocated during requests (true by default).
        #     However, if ResourceRequirements is set, the caller must explicitly
        #     set this field to true to preserve the default behavior.
        # @!attribute [rw] startup_cpu_boost
        #   @return [::Boolean]
        #     Determines whether CPU should be boosted on startup of a new container
        #     instance above the requested CPU threshold, this can help reduce cold-start
        #     latency.
        class ResourceRequirements
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LimitsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # EnvVar represents an environment variable present in a Container.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the environment variable. Must not exceed 32768
        #     characters.
        # @!attribute [rw] value
        #   @return [::String]
        #     Literal value of the environment variable.
        #     Defaults to "", and the maximum length is 32768 bytes.
        #     Variable references are not supported in Cloud Run.
        #
        #     Note: The following fields are mutually exclusive: `value`, `value_source`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] value_source
        #   @return [::Google::Cloud::Run::V2::EnvVarSource]
        #     Source for the environment variable's value.
        #
        #     Note: The following fields are mutually exclusive: `value_source`, `value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class EnvVar
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # EnvVarSource represents a source for the value of an EnvVar.
        # @!attribute [rw] secret_key_ref
        #   @return [::Google::Cloud::Run::V2::SecretKeySelector]
        #     Selects a secret and a specific version from Cloud Secret Manager.
        class EnvVarSource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # SecretEnvVarSource represents a source for the value of an EnvVar.
        # @!attribute [rw] secret
        #   @return [::String]
        #     Required. The name of the secret in Cloud Secret Manager.
        #     Format: \\{secret_name} if the secret is in the same project.
        #     projects/\\{project}/secrets/\\{secret_name} if the secret is
        #     in a different project.
        # @!attribute [rw] version
        #   @return [::String]
        #     The Cloud Secret Manager secret version.
        #     Can be 'latest' for the latest version, an integer for a specific version,
        #     or a version alias.
        class SecretKeySelector
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ContainerPort represents a network port in a single container.
        # @!attribute [rw] name
        #   @return [::String]
        #     If specified, used to specify which protocol to use.
        #     Allowed values are "http1" and "h2c".
        # @!attribute [rw] container_port
        #   @return [::Integer]
        #     Port number the container listens on.
        #     This must be a valid TCP port number, 0 < container_port < 65536.
        class ContainerPort
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # VolumeMount describes a mounting of a Volume within a container.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. This must match the Name of a Volume.
        # @!attribute [rw] mount_path
        #   @return [::String]
        #     Required. Path within the container at which the volume should be mounted.
        #     Must not contain ':'. For Cloud SQL volumes, it can be left empty, or must
        #     otherwise be `/cloudsql`. All instances defined in the Volume will be
        #     available as `/cloudsql/[instance]`. For more information on Cloud SQL
        #     volumes, visit https://cloud.google.com/sql/docs/mysql/connect-run
        class VolumeMount
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Volume represents a named volume in a container.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Volume's name.
        # @!attribute [rw] secret
        #   @return [::Google::Cloud::Run::V2::SecretVolumeSource]
        #     Secret represents a secret that should populate this volume.
        #
        #     Note: The following fields are mutually exclusive: `secret`, `cloud_sql_instance`, `empty_dir`, `nfs`, `gcs`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] cloud_sql_instance
        #   @return [::Google::Cloud::Run::V2::CloudSqlInstance]
        #     For Cloud SQL volumes, contains the specific instances that should be
        #     mounted. Visit https://cloud.google.com/sql/docs/mysql/connect-run for
        #     more information on how to connect Cloud SQL and Cloud Run.
        #
        #     Note: The following fields are mutually exclusive: `cloud_sql_instance`, `secret`, `empty_dir`, `nfs`, `gcs`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] empty_dir
        #   @return [::Google::Cloud::Run::V2::EmptyDirVolumeSource]
        #     Ephemeral storage used as a shared volume.
        #
        #     Note: The following fields are mutually exclusive: `empty_dir`, `secret`, `cloud_sql_instance`, `nfs`, `gcs`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] nfs
        #   @return [::Google::Cloud::Run::V2::NFSVolumeSource]
        #     For NFS Voumes, contains the path to the nfs Volume
        #
        #     Note: The following fields are mutually exclusive: `nfs`, `secret`, `cloud_sql_instance`, `empty_dir`, `gcs`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] gcs
        #   @return [::Google::Cloud::Run::V2::GCSVolumeSource]
        #     Persistent storage backed by a Google Cloud Storage bucket.
        #
        #     Note: The following fields are mutually exclusive: `gcs`, `secret`, `cloud_sql_instance`, `empty_dir`, `nfs`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class Volume
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The secret's value will be presented as the content of a file whose
        # name is defined in the item path. If no items are defined, the name of
        # the file is the secret.
        # @!attribute [rw] secret
        #   @return [::String]
        #     Required. The name of the secret in Cloud Secret Manager.
        #     Format: \\{secret} if the secret is in the same project.
        #     projects/\\{project}/secrets/\\{secret} if the secret is
        #     in a different project.
        # @!attribute [rw] items
        #   @return [::Array<::Google::Cloud::Run::V2::VersionToPath>]
        #     If unspecified, the volume will expose a file whose name is the
        #     secret, relative to VolumeMount.mount_path.
        #     If specified, the key will be used as the version to fetch from Cloud
        #     Secret Manager and the path will be the name of the file exposed in the
        #     volume. When items are defined, they must specify a path and a version.
        # @!attribute [rw] default_mode
        #   @return [::Integer]
        #     Integer representation of mode bits to use on created files by default.
        #     Must be a value between 0000 and 0777 (octal), defaulting to 0444.
        #     Directories within the path are not affected by  this setting.
        #
        #     Notes
        #
        #     * Internally, a umask of 0222 will be applied to any non-zero value.
        #     * This is an integer representation of the mode bits. So, the octal
        #     integer value should look exactly as the chmod numeric notation with a
        #     leading zero. Some examples: for chmod 640 (u=rw,g=r), set to 0640 (octal)
        #     or 416 (base-10). For chmod 755 (u=rwx,g=rx,o=rx), set to 0755 (octal) or
        #     493 (base-10).
        #     * This might be in conflict with other options that affect the
        #     file mode, like fsGroup, and the result can be other mode bits set.
        #
        #     This might be in conflict with other options that affect the
        #     file mode, like fsGroup, and as a result, other mode bits could be set.
        class SecretVolumeSource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # VersionToPath maps a specific version of a secret to a relative file to mount
        # to, relative to VolumeMount's mount_path.
        # @!attribute [rw] path
        #   @return [::String]
        #     Required. The relative path of the secret in the container.
        # @!attribute [rw] version
        #   @return [::String]
        #     The Cloud Secret Manager secret version.
        #     Can be 'latest' for the latest value, or an integer or a secret alias for a
        #     specific version.
        # @!attribute [rw] mode
        #   @return [::Integer]
        #     Integer octal mode bits to use on this file, must be a value between
        #     01 and 0777 (octal). If 0 or not set, the Volume's default mode will be
        #     used.
        #
        #     Notes
        #
        #     * Internally, a umask of 0222 will be applied to any non-zero value.
        #     * This is an integer representation of the mode bits. So, the octal
        #     integer value should look exactly as the chmod numeric notation with a
        #     leading zero. Some examples: for chmod 640 (u=rw,g=r), set to 0640 (octal)
        #     or 416 (base-10). For chmod 755 (u=rwx,g=rx,o=rx), set to 0755 (octal) or
        #     493 (base-10).
        #     * This might be in conflict with other options that affect the
        #     file mode, like fsGroup, and the result can be other mode bits set.
        class VersionToPath
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a set of Cloud SQL instances. Each one will be available under
        # /cloudsql/[instance]. Visit
        # https://cloud.google.com/sql/docs/mysql/connect-run for more information on
        # how to connect Cloud SQL and Cloud Run.
        # @!attribute [rw] instances
        #   @return [::Array<::String>]
        #     The Cloud SQL instance connection names, as can be found in
        #     https://console.cloud.google.com/sql/instances. Visit
        #     https://cloud.google.com/sql/docs/mysql/connect-run for more information on
        #     how to connect Cloud SQL and Cloud Run. Format:
        #     \\{project}:\\{location}:\\{instance}
        class CloudSqlInstance
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # In memory (tmpfs) ephemeral storage.
        # It is ephemeral in the sense that when the sandbox is taken down, the data is
        # destroyed with it (it does not persist across sandbox runs).
        # @!attribute [rw] medium
        #   @return [::Google::Cloud::Run::V2::EmptyDirVolumeSource::Medium]
        #     The medium on which the data is stored. Acceptable values today is only
        #     MEMORY or none. When none, the default will currently be backed by memory
        #     but could change over time. +optional
        # @!attribute [rw] size_limit
        #   @return [::String]
        #     Limit on the storage usable by this EmptyDir volume.
        #     The size limit is also applicable for memory medium.
        #     The maximum usage on memory medium EmptyDir would be the minimum value
        #     between the SizeLimit specified here and the sum of memory limits of all
        #     containers. The default is nil which means that the limit is undefined.
        #     More info:
        #     https://cloud.google.com/run/docs/configuring/in-memory-volumes#configure-volume.
        #     Info in Kubernetes:
        #     https://kubernetes.io/docs/concepts/storage/volumes/#emptydir
        class EmptyDirVolumeSource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The different types of medium supported for EmptyDir.
          module Medium
            # When not specified, falls back to the default implementation which
            # is currently in memory (this may change over time).
            MEDIUM_UNSPECIFIED = 0

            # Explicitly set the EmptyDir to be in memory. Uses tmpfs.
            MEMORY = 1
          end
        end

        # Represents an NFS mount.
        # @!attribute [rw] server
        #   @return [::String]
        #     Hostname or IP address of the NFS server
        # @!attribute [rw] path
        #   @return [::String]
        #     Path that is exported by the NFS server.
        # @!attribute [rw] read_only
        #   @return [::Boolean]
        #     If true, the volume will be mounted as read only for all mounts.
        class NFSVolumeSource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a volume backed by a Cloud Storage bucket using Cloud Storage
        # FUSE.
        # @!attribute [rw] bucket
        #   @return [::String]
        #     Cloud Storage Bucket name.
        # @!attribute [rw] read_only
        #   @return [::Boolean]
        #     If true, the volume will be mounted as read only for all mounts.
        # @!attribute [rw] mount_options
        #   @return [::Array<::String>]
        #     A list of additional flags to pass to the gcsfuse CLI.
        #     Options should be specified without the leading "--".
        class GCSVolumeSource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Probe describes a health check to be performed against a container to
        # determine whether it is alive or ready to receive traffic.
        # @!attribute [rw] initial_delay_seconds
        #   @return [::Integer]
        #     Optional. Number of seconds after the container has started before the
        #     probe is initiated. Defaults to 0 seconds. Minimum value is 0. Maximum
        #     value for liveness probe is 3600. Maximum value for startup probe is 240.
        # @!attribute [rw] timeout_seconds
        #   @return [::Integer]
        #     Optional. Number of seconds after which the probe times out.
        #     Defaults to 1 second. Minimum value is 1. Maximum value is 3600.
        #     Must be smaller than period_seconds.
        # @!attribute [rw] period_seconds
        #   @return [::Integer]
        #     Optional. How often (in seconds) to perform the probe.
        #     Default to 10 seconds. Minimum value is 1. Maximum value for liveness probe
        #     is 3600. Maximum value for startup probe is 240.
        #     Must be greater or equal than timeout_seconds.
        # @!attribute [rw] failure_threshold
        #   @return [::Integer]
        #     Optional. Minimum consecutive failures for the probe to be considered
        #     failed after having succeeded. Defaults to 3. Minimum value is 1.
        # @!attribute [rw] http_get
        #   @return [::Google::Cloud::Run::V2::HTTPGetAction]
        #     Optional. HTTPGet specifies the http request to perform.
        #     Exactly one of httpGet, tcpSocket, or grpc must be specified.
        #
        #     Note: The following fields are mutually exclusive: `http_get`, `tcp_socket`, `grpc`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] tcp_socket
        #   @return [::Google::Cloud::Run::V2::TCPSocketAction]
        #     Optional. TCPSocket specifies an action involving a TCP port.
        #     Exactly one of httpGet, tcpSocket, or grpc must be specified.
        #
        #     Note: The following fields are mutually exclusive: `tcp_socket`, `http_get`, `grpc`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] grpc
        #   @return [::Google::Cloud::Run::V2::GRPCAction]
        #     Optional. GRPC specifies an action involving a gRPC port.
        #     Exactly one of httpGet, tcpSocket, or grpc must be specified.
        #
        #     Note: The following fields are mutually exclusive: `grpc`, `http_get`, `tcp_socket`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class Probe
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # HTTPGetAction describes an action based on HTTP Get requests.
        # @!attribute [rw] path
        #   @return [::String]
        #     Optional. Path to access on the HTTP server. Defaults to '/'.
        # @!attribute [rw] http_headers
        #   @return [::Array<::Google::Cloud::Run::V2::HTTPHeader>]
        #     Optional. Custom headers to set in the request. HTTP allows repeated
        #     headers.
        # @!attribute [rw] port
        #   @return [::Integer]
        #     Optional. Port number to access on the container. Must be in the range 1 to
        #     65535. If not specified, defaults to the exposed port of the container,
        #     which is the value of container.ports[0].containerPort.
        class HTTPGetAction
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # HTTPHeader describes a custom header to be used in HTTP probes
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The header field name
        # @!attribute [rw] value
        #   @return [::String]
        #     Optional. The header field value
        class HTTPHeader
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # TCPSocketAction describes an action based on opening a socket
        # @!attribute [rw] port
        #   @return [::Integer]
        #     Optional. Port number to access on the container. Must be in the range 1 to
        #     65535. If not specified, defaults to the exposed port of the container,
        #     which is the value of container.ports[0].containerPort.
        class TCPSocketAction
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # GRPCAction describes an action involving a GRPC port.
        # @!attribute [rw] port
        #   @return [::Integer]
        #     Optional. Port number of the gRPC service. Number must be in the range 1 to
        #     65535. If not specified, defaults to the exposed port of the container,
        #     which is the value of container.ports[0].containerPort.
        # @!attribute [rw] service
        #   @return [::String]
        #     Optional. Service is the name of the service to place in the gRPC
        #     HealthCheckRequest (see
        #     https://github.com/grpc/grpc/blob/master/doc/health-checking.md ). If this
        #     is not specified, the default behavior is defined by gRPC.
        class GRPCAction
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Build information of the image.
        # @!attribute [r] function_target
        #   @return [::String]
        #     Output only. Entry point of the function when the image is a Cloud Run
        #     function.
        # @!attribute [r] source_location
        #   @return [::String]
        #     Output only. Source code location of the image.
        class BuildInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
