# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Run
      module V2
        # Holds a single instance split entry for the Worker. Allocations can be done
        # to a specific Revision name, or pointing to the latest Ready Revision.
        # @!attribute [rw] type
        #   @return [::Google::Cloud::Run::V2::InstanceSplitAllocationType]
        #     The allocation type for this instance split.
        # @!attribute [rw] revision
        #   @return [::String]
        #     Revision to which to assign this portion of instances, if split allocation
        #     is by revision.
        # @!attribute [rw] percent
        #   @return [::Integer]
        #     Specifies percent of the instance split to this Revision.
        #     This defaults to zero if unspecified.
        class InstanceSplit
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the observed state of a single `InstanceSplit` entry.
        # @!attribute [rw] type
        #   @return [::Google::Cloud::Run::V2::InstanceSplitAllocationType]
        #     The allocation type for this instance split.
        # @!attribute [rw] revision
        #   @return [::String]
        #     Revision to which this instance split is assigned.
        # @!attribute [rw] percent
        #   @return [::Integer]
        #     Specifies percent of the instance split to this Revision.
        class InstanceSplitStatus
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The type of instance split allocation.
        module InstanceSplitAllocationType
          # Unspecified instance allocation type.
          INSTANCE_SPLIT_ALLOCATION_TYPE_UNSPECIFIED = 0

          # Allocates instances to the Service's latest ready Revision.
          INSTANCE_SPLIT_ALLOCATION_TYPE_LATEST = 1

          # Allocates instances to a Revision by name.
          INSTANCE_SPLIT_ALLOCATION_TYPE_REVISION = 2
        end
      end
    end
  end
end
