# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

# Require this file early so that the version constant gets defined before
# requiring "google/cloud". This is because google-cloud-core will load the
# entrypoint (gem name) file, which in turn re-requires this file (hence
# causing a require cycle) unless the version constant is already defined.
require "google/cloud/run/client/version"

require "googleauth"
gem "google-cloud-core"
require "google/cloud" unless defined? ::Google::Cloud.new
require "google/cloud/config"

# Set the default configuration
::Google::Cloud.configure.add_config! :run do |config|
  config.add_field! :endpoint,      nil, match: ::String
  config.add_field! :credentials,   nil, match: [::String, ::Hash, ::Google::Auth::Credentials]
  config.add_field! :scope,         nil, match: [::Array, ::String]
  config.add_field! :lib_name,      nil, match: ::String
  config.add_field! :lib_version,   nil, match: ::String
  config.add_field! :interceptors,  nil, match: ::Array
  config.add_field! :timeout,       nil, match: ::Numeric
  config.add_field! :metadata,      nil, match: ::Hash
  config.add_field! :retry_policy,  nil, match: [::Hash, ::Proc]
  config.add_field! :quota_project, nil, match: ::String
  config.add_field! :universe_domain, nil, match: ::String
end

module Google
  module Cloud
    module Run
      ##
      # Create a new client object for Builds.
      #
      # By default, this returns an instance of
      # [Google::Cloud::Run::V2::Builds::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-run-v2/latest/Google-Cloud-Run-V2-Builds-Client)
      # for a gRPC client for version V2 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the Builds service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the Builds service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::Run.builds_available?}.
      #
      # ## About Builds
      #
      # Cloud Run Build Control Plane API
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v2`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.builds version: :v2, transport: :grpc, &block
        require "google/cloud/run/#{version.to_s.downcase}"

        package_name = Google::Cloud::Run
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::Run.const_get(package_name).const_get(:Builds)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the Builds service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::Run.builds}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the Builds service,
      # or if the versioned client gem needs an update to support the Builds service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v2`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.builds_available? version: :v2, transport: :grpc
        require "google/cloud/run/#{version.to_s.downcase}"
        package_name = Google::Cloud::Run
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::Run.const_get package_name
        return false unless service_module.const_defined? :Builds
        service_module = service_module.const_get :Builds
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for Executions.
      #
      # By default, this returns an instance of
      # [Google::Cloud::Run::V2::Executions::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-run-v2/latest/Google-Cloud-Run-V2-Executions-Client)
      # for a gRPC client for version V2 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the Executions service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the Executions service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::Run.executions_available?}.
      #
      # ## About Executions
      #
      # Cloud Run Execution Control Plane API.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v2`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.executions version: :v2, transport: :grpc, &block
        require "google/cloud/run/#{version.to_s.downcase}"

        package_name = Google::Cloud::Run
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::Run.const_get(package_name).const_get(:Executions)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the Executions service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::Run.executions}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the Executions service,
      # or if the versioned client gem needs an update to support the Executions service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v2`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.executions_available? version: :v2, transport: :grpc
        require "google/cloud/run/#{version.to_s.downcase}"
        package_name = Google::Cloud::Run
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::Run.const_get package_name
        return false unless service_module.const_defined? :Executions
        service_module = service_module.const_get :Executions
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for Jobs.
      #
      # By default, this returns an instance of
      # [Google::Cloud::Run::V2::Jobs::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-run-v2/latest/Google-Cloud-Run-V2-Jobs-Client)
      # for a gRPC client for version V2 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the Jobs service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the Jobs service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::Run.jobs_available?}.
      #
      # ## About Jobs
      #
      # Cloud Run Job Control Plane API.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v2`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.jobs version: :v2, transport: :grpc, &block
        require "google/cloud/run/#{version.to_s.downcase}"

        package_name = Google::Cloud::Run
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::Run.const_get(package_name).const_get(:Jobs)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the Jobs service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::Run.jobs}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the Jobs service,
      # or if the versioned client gem needs an update to support the Jobs service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v2`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.jobs_available? version: :v2, transport: :grpc
        require "google/cloud/run/#{version.to_s.downcase}"
        package_name = Google::Cloud::Run
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::Run.const_get package_name
        return false unless service_module.const_defined? :Jobs
        service_module = service_module.const_get :Jobs
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for Revisions.
      #
      # By default, this returns an instance of
      # [Google::Cloud::Run::V2::Revisions::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-run-v2/latest/Google-Cloud-Run-V2-Revisions-Client)
      # for a gRPC client for version V2 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the Revisions service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the Revisions service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::Run.revisions_available?}.
      #
      # ## About Revisions
      #
      # Cloud Run Revision Control Plane API.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v2`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.revisions version: :v2, transport: :grpc, &block
        require "google/cloud/run/#{version.to_s.downcase}"

        package_name = Google::Cloud::Run
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::Run.const_get(package_name).const_get(:Revisions)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the Revisions service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::Run.revisions}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the Revisions service,
      # or if the versioned client gem needs an update to support the Revisions service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v2`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.revisions_available? version: :v2, transport: :grpc
        require "google/cloud/run/#{version.to_s.downcase}"
        package_name = Google::Cloud::Run
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::Run.const_get package_name
        return false unless service_module.const_defined? :Revisions
        service_module = service_module.const_get :Revisions
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for Services.
      #
      # By default, this returns an instance of
      # [Google::Cloud::Run::V2::Services::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-run-v2/latest/Google-Cloud-Run-V2-Services-Client)
      # for a gRPC client for version V2 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the Services service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the Services service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::Run.services_available?}.
      #
      # ## About Services
      #
      # Cloud Run Service Control Plane API
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v2`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.services version: :v2, transport: :grpc, &block
        require "google/cloud/run/#{version.to_s.downcase}"

        package_name = Google::Cloud::Run
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::Run.const_get(package_name).const_get(:Services)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the Services service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::Run.services}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the Services service,
      # or if the versioned client gem needs an update to support the Services service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v2`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.services_available? version: :v2, transport: :grpc
        require "google/cloud/run/#{version.to_s.downcase}"
        package_name = Google::Cloud::Run
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::Run.const_get package_name
        return false unless service_module.const_defined? :Services
        service_module = service_module.const_get :Services
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for Tasks.
      #
      # By default, this returns an instance of
      # [Google::Cloud::Run::V2::Tasks::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-run-v2/latest/Google-Cloud-Run-V2-Tasks-Client)
      # for a gRPC client for version V2 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the Tasks service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the Tasks service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::Run.tasks_available?}.
      #
      # ## About Tasks
      #
      # Cloud Run Task Control Plane API.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v2`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.tasks version: :v2, transport: :grpc, &block
        require "google/cloud/run/#{version.to_s.downcase}"

        package_name = Google::Cloud::Run
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::Run.const_get(package_name).const_get(:Tasks)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the Tasks service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::Run.tasks}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the Tasks service,
      # or if the versioned client gem needs an update to support the Tasks service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v2`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.tasks_available? version: :v2, transport: :grpc
        require "google/cloud/run/#{version.to_s.downcase}"
        package_name = Google::Cloud::Run
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::Run.const_get package_name
        return false unless service_module.const_defined? :Tasks
        service_module = service_module.const_get :Tasks
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for WorkerPools.
      #
      # By default, this returns an instance of
      # [Google::Cloud::Run::V2::WorkerPools::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-run-v2/latest/Google-Cloud-Run-V2-WorkerPools-Client)
      # for a gRPC client for version V2 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the WorkerPools service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the WorkerPools service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::Run.worker_pools_available?}.
      #
      # ## About WorkerPools
      #
      # Cloud Run WorkerPool Control Plane API.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v2`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.worker_pools version: :v2, transport: :grpc, &block
        require "google/cloud/run/#{version.to_s.downcase}"

        package_name = Google::Cloud::Run
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::Run.const_get(package_name).const_get(:WorkerPools)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the WorkerPools service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::Run.worker_pools}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the WorkerPools service,
      # or if the versioned client gem needs an update to support the WorkerPools service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v2`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.worker_pools_available? version: :v2, transport: :grpc
        require "google/cloud/run/#{version.to_s.downcase}"
        package_name = Google::Cloud::Run
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::Run.const_get package_name
        return false unless service_module.const_defined? :WorkerPools
        service_module = service_module.const_get :WorkerPools
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Configure the google-cloud-run-client library.
      #
      # The following configuration parameters are supported:
      #
      # * `credentials` (*type:* `String, Hash, Google::Auth::Credentials`) -
      #   The path to the keyfile as a String, the contents of the keyfile as a
      #   Hash, or a Google::Auth::Credentials object.
      # * `lib_name` (*type:* `String`) -
      #   The library name as recorded in instrumentation and logging.
      # * `lib_version` (*type:* `String`) -
      #   The library version as recorded in instrumentation and logging.
      # * `interceptors` (*type:* `Array<GRPC::ClientInterceptor>`) -
      #   An array of interceptors that are run before calls are executed.
      # * `timeout` (*type:* `Numeric`) -
      #   Default timeout in seconds.
      # * `metadata` (*type:* `Hash{Symbol=>String}`) -
      #   Additional headers to be sent with the call.
      # * `retry_policy` (*type:* `Hash`) -
      #   The retry policy. The value is a hash with the following keys:
      #     * `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
      #     * `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
      #     * `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
      #     * `:retry_codes` (*type:* `Array<String>`) -
      #       The error codes that should trigger a retry.
      #
      # @return [::Google::Cloud::Config] The default configuration used by this library
      #
      def self.configure
        yield ::Google::Cloud.configure.run if block_given?

        ::Google::Cloud.configure.run
      end
    end
  end
end

helper_path = ::File.join __dir__, "run", "helpers.rb"
require "google/cloud/run/helpers" if ::File.file? helper_path
