# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "google/cloud/retail"
require "gapic/common"
require "gapic/grpc"
require "gapic/rest"

class Google::Cloud::Retail::ClientConstructionMinitest < Minitest::Test
  class DummyStub
    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_analytics_service_grpc
    skip unless Google::Cloud::Retail.analytics_service_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::Retail.analytics_service transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::Retail::V2::AnalyticsService::Client, client
    end
  end

  def test_analytics_service_rest
    skip unless Google::Cloud::Retail.analytics_service_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::Retail.analytics_service transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::Retail::V2::AnalyticsService::Rest::Client, client
    end
  end

  def test_catalog_service_grpc
    skip unless Google::Cloud::Retail.catalog_service_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::Retail.catalog_service transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::Retail::V2::CatalogService::Client, client
    end
  end

  def test_catalog_service_rest
    skip unless Google::Cloud::Retail.catalog_service_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::Retail.catalog_service transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::Retail::V2::CatalogService::Rest::Client, client
    end
  end

  def test_completion_service_grpc
    skip unless Google::Cloud::Retail.completion_service_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::Retail.completion_service transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::Retail::V2::CompletionService::Client, client
    end
  end

  def test_completion_service_rest
    skip unless Google::Cloud::Retail.completion_service_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::Retail.completion_service transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::Retail::V2::CompletionService::Rest::Client, client
    end
  end

  def test_control_service_grpc
    skip unless Google::Cloud::Retail.control_service_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::Retail.control_service transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::Retail::V2::ControlService::Client, client
    end
  end

  def test_control_service_rest
    skip unless Google::Cloud::Retail.control_service_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::Retail.control_service transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::Retail::V2::ControlService::Rest::Client, client
    end
  end

  def test_search_service_grpc
    skip unless Google::Cloud::Retail.search_service_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::Retail.search_service transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::Retail::V2::SearchService::Client, client
    end
  end

  def test_search_service_rest
    skip unless Google::Cloud::Retail.search_service_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::Retail.search_service transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::Retail::V2::SearchService::Rest::Client, client
    end
  end

  def test_conversational_search_service_grpc
    skip unless Google::Cloud::Retail.conversational_search_service_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::Retail.conversational_search_service transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::Retail::V2::ConversationalSearchService::Client, client
    end
  end

  def test_conversational_search_service_rest
    skip unless Google::Cloud::Retail.conversational_search_service_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::Retail.conversational_search_service transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::Retail::V2::ConversationalSearchService::Rest::Client, client
    end
  end

  def test_generative_question_service_grpc
    skip unless Google::Cloud::Retail.generative_question_service_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::Retail.generative_question_service transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::Retail::V2::GenerativeQuestionService::Client, client
    end
  end

  def test_generative_question_service_rest
    skip unless Google::Cloud::Retail.generative_question_service_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::Retail.generative_question_service transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::Retail::V2::GenerativeQuestionService::Rest::Client, client
    end
  end

  def test_model_service_grpc
    skip unless Google::Cloud::Retail.model_service_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::Retail.model_service transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::Retail::V2::ModelService::Client, client
    end
  end

  def test_model_service_rest
    skip unless Google::Cloud::Retail.model_service_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::Retail.model_service transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::Retail::V2::ModelService::Rest::Client, client
    end
  end

  def test_prediction_service_grpc
    skip unless Google::Cloud::Retail.prediction_service_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::Retail.prediction_service transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::Retail::V2::PredictionService::Client, client
    end
  end

  def test_prediction_service_rest
    skip unless Google::Cloud::Retail.prediction_service_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::Retail.prediction_service transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::Retail::V2::PredictionService::Rest::Client, client
    end
  end

  def test_product_service_grpc
    skip unless Google::Cloud::Retail.product_service_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::Retail.product_service transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::Retail::V2::ProductService::Client, client
    end
  end

  def test_product_service_rest
    skip unless Google::Cloud::Retail.product_service_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::Retail.product_service transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::Retail::V2::ProductService::Rest::Client, client
    end
  end

  def test_serving_config_service_grpc
    skip unless Google::Cloud::Retail.serving_config_service_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::Retail.serving_config_service transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::Retail::V2::ServingConfigService::Client, client
    end
  end

  def test_serving_config_service_rest
    skip unless Google::Cloud::Retail.serving_config_service_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::Retail.serving_config_service transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::Retail::V2::ServingConfigService::Rest::Client, client
    end
  end

  def test_user_event_service_grpc
    skip unless Google::Cloud::Retail.user_event_service_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::Retail.user_event_service transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::Retail::V2::UserEventService::Client, client
    end
  end

  def test_user_event_service_rest
    skip unless Google::Cloud::Retail.user_event_service_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::Retail.user_event_service transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::Retail::V2::UserEventService::Rest::Client, client
    end
  end
end
