# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/retail/v2/serving_config_service_pb"
require "google/cloud/retail/v2/serving_config_service/rest"


class ::Google::Cloud::Retail::V2::ServingConfigService::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_serving_config
    # Create test objects.
    client_result = ::Google::Cloud::Retail::V2::ServingConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    serving_config = {}
    serving_config_id = "hello world"

    create_serving_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Retail::V2::ServingConfigService::Rest::ServiceStub.stub :transcode_create_serving_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_serving_config_client_stub do
        # Create client
        client = ::Google::Cloud::Retail::V2::ServingConfigService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_serving_config({ parent: parent, serving_config: serving_config, serving_config_id: serving_config_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_serving_config parent: parent, serving_config: serving_config, serving_config_id: serving_config_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_serving_config ::Google::Cloud::Retail::V2::CreateServingConfigRequest.new(parent: parent, serving_config: serving_config, serving_config_id: serving_config_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_serving_config({ parent: parent, serving_config: serving_config, serving_config_id: serving_config_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_serving_config(::Google::Cloud::Retail::V2::CreateServingConfigRequest.new(parent: parent, serving_config: serving_config, serving_config_id: serving_config_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_serving_config_client_stub.call_count
      end
    end
  end

  def test_delete_serving_config
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_serving_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Retail::V2::ServingConfigService::Rest::ServiceStub.stub :transcode_delete_serving_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_serving_config_client_stub do
        # Create client
        client = ::Google::Cloud::Retail::V2::ServingConfigService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_serving_config({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_serving_config name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_serving_config ::Google::Cloud::Retail::V2::DeleteServingConfigRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_serving_config({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_serving_config(::Google::Cloud::Retail::V2::DeleteServingConfigRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_serving_config_client_stub.call_count
      end
    end
  end

  def test_update_serving_config
    # Create test objects.
    client_result = ::Google::Cloud::Retail::V2::ServingConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    serving_config = {}
    update_mask = {}

    update_serving_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Retail::V2::ServingConfigService::Rest::ServiceStub.stub :transcode_update_serving_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_serving_config_client_stub do
        # Create client
        client = ::Google::Cloud::Retail::V2::ServingConfigService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_serving_config({ serving_config: serving_config, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_serving_config serving_config: serving_config, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_serving_config ::Google::Cloud::Retail::V2::UpdateServingConfigRequest.new(serving_config: serving_config, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_serving_config({ serving_config: serving_config, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_serving_config(::Google::Cloud::Retail::V2::UpdateServingConfigRequest.new(serving_config: serving_config, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_serving_config_client_stub.call_count
      end
    end
  end

  def test_get_serving_config
    # Create test objects.
    client_result = ::Google::Cloud::Retail::V2::ServingConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_serving_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Retail::V2::ServingConfigService::Rest::ServiceStub.stub :transcode_get_serving_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_serving_config_client_stub do
        # Create client
        client = ::Google::Cloud::Retail::V2::ServingConfigService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_serving_config({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_serving_config name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_serving_config ::Google::Cloud::Retail::V2::GetServingConfigRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_serving_config({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_serving_config(::Google::Cloud::Retail::V2::GetServingConfigRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_serving_config_client_stub.call_count
      end
    end
  end

  def test_list_serving_configs
    # Create test objects.
    client_result = ::Google::Cloud::Retail::V2::ListServingConfigsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_serving_configs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Retail::V2::ServingConfigService::Rest::ServiceStub.stub :transcode_list_serving_configs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_serving_configs_client_stub do
        # Create client
        client = ::Google::Cloud::Retail::V2::ServingConfigService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_serving_configs({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_serving_configs parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_serving_configs ::Google::Cloud::Retail::V2::ListServingConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_serving_configs({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_serving_configs(::Google::Cloud::Retail::V2::ListServingConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_serving_configs_client_stub.call_count
      end
    end
  end

  def test_add_control
    # Create test objects.
    client_result = ::Google::Cloud::Retail::V2::ServingConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    serving_config = "hello world"
    control_id = "hello world"

    add_control_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Retail::V2::ServingConfigService::Rest::ServiceStub.stub :transcode_add_control_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, add_control_client_stub do
        # Create client
        client = ::Google::Cloud::Retail::V2::ServingConfigService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.add_control({ serving_config: serving_config, control_id: control_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.add_control serving_config: serving_config, control_id: control_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.add_control ::Google::Cloud::Retail::V2::AddControlRequest.new(serving_config: serving_config, control_id: control_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.add_control({ serving_config: serving_config, control_id: control_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.add_control(::Google::Cloud::Retail::V2::AddControlRequest.new(serving_config: serving_config, control_id: control_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, add_control_client_stub.call_count
      end
    end
  end

  def test_remove_control
    # Create test objects.
    client_result = ::Google::Cloud::Retail::V2::ServingConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    serving_config = "hello world"
    control_id = "hello world"

    remove_control_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Retail::V2::ServingConfigService::Rest::ServiceStub.stub :transcode_remove_control_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, remove_control_client_stub do
        # Create client
        client = ::Google::Cloud::Retail::V2::ServingConfigService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.remove_control({ serving_config: serving_config, control_id: control_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.remove_control serving_config: serving_config, control_id: control_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.remove_control ::Google::Cloud::Retail::V2::RemoveControlRequest.new(serving_config: serving_config, control_id: control_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.remove_control({ serving_config: serving_config, control_id: control_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.remove_control(::Google::Cloud::Retail::V2::RemoveControlRequest.new(serving_config: serving_config, control_id: control_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, remove_control_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Retail::V2::ServingConfigService::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Retail::V2::ServingConfigService::Rest::Client::Configuration, config
  end
end
