# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/retail/v2/product_service_pb"
require "google/cloud/retail/v2/product_service/rest"


class ::Google::Cloud::Retail::V2::ProductService::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_product
    # Create test objects.
    client_result = ::Google::Cloud::Retail::V2::Product.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    product = {}
    product_id = "hello world"

    create_product_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Retail::V2::ProductService::Rest::ServiceStub.stub :transcode_create_product_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_product_client_stub do
        # Create client
        client = ::Google::Cloud::Retail::V2::ProductService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_product({ parent: parent, product: product, product_id: product_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_product parent: parent, product: product, product_id: product_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_product ::Google::Cloud::Retail::V2::CreateProductRequest.new(parent: parent, product: product, product_id: product_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_product({ parent: parent, product: product, product_id: product_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_product(::Google::Cloud::Retail::V2::CreateProductRequest.new(parent: parent, product: product, product_id: product_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_product_client_stub.call_count
      end
    end
  end

  def test_get_product
    # Create test objects.
    client_result = ::Google::Cloud::Retail::V2::Product.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_product_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Retail::V2::ProductService::Rest::ServiceStub.stub :transcode_get_product_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_product_client_stub do
        # Create client
        client = ::Google::Cloud::Retail::V2::ProductService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_product({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_product name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_product ::Google::Cloud::Retail::V2::GetProductRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_product({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_product(::Google::Cloud::Retail::V2::GetProductRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_product_client_stub.call_count
      end
    end
  end

  def test_list_products
    # Create test objects.
    client_result = ::Google::Cloud::Retail::V2::ListProductsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    read_mask = {}

    list_products_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Retail::V2::ProductService::Rest::ServiceStub.stub :transcode_list_products_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_products_client_stub do
        # Create client
        client = ::Google::Cloud::Retail::V2::ProductService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_products({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, read_mask: read_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_products parent: parent, page_size: page_size, page_token: page_token, filter: filter, read_mask: read_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_products ::Google::Cloud::Retail::V2::ListProductsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, read_mask: read_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_products({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, read_mask: read_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_products(::Google::Cloud::Retail::V2::ListProductsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, read_mask: read_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_products_client_stub.call_count
      end
    end
  end

  def test_update_product
    # Create test objects.
    client_result = ::Google::Cloud::Retail::V2::Product.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    product = {}
    update_mask = {}
    allow_missing = true

    update_product_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Retail::V2::ProductService::Rest::ServiceStub.stub :transcode_update_product_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_product_client_stub do
        # Create client
        client = ::Google::Cloud::Retail::V2::ProductService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_product({ product: product, update_mask: update_mask, allow_missing: allow_missing }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_product product: product, update_mask: update_mask, allow_missing: allow_missing do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_product ::Google::Cloud::Retail::V2::UpdateProductRequest.new(product: product, update_mask: update_mask, allow_missing: allow_missing) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_product({ product: product, update_mask: update_mask, allow_missing: allow_missing }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_product(::Google::Cloud::Retail::V2::UpdateProductRequest.new(product: product, update_mask: update_mask, allow_missing: allow_missing), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_product_client_stub.call_count
      end
    end
  end

  def test_delete_product
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_product_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Retail::V2::ProductService::Rest::ServiceStub.stub :transcode_delete_product_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_product_client_stub do
        # Create client
        client = ::Google::Cloud::Retail::V2::ProductService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_product({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_product name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_product ::Google::Cloud::Retail::V2::DeleteProductRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_product({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_product(::Google::Cloud::Retail::V2::DeleteProductRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_product_client_stub.call_count
      end
    end
  end

  def test_purge_products
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    force = true

    purge_products_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Retail::V2::ProductService::Rest::ServiceStub.stub :transcode_purge_products_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, purge_products_client_stub do
        # Create client
        client = ::Google::Cloud::Retail::V2::ProductService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.purge_products({ parent: parent, filter: filter, force: force }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.purge_products parent: parent, filter: filter, force: force do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.purge_products ::Google::Cloud::Retail::V2::PurgeProductsRequest.new(parent: parent, filter: filter, force: force) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.purge_products({ parent: parent, filter: filter, force: force }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.purge_products(::Google::Cloud::Retail::V2::PurgeProductsRequest.new(parent: parent, filter: filter, force: force), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, purge_products_client_stub.call_count
      end
    end
  end

  def test_import_products
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    request_id = "hello world"
    input_config = {}
    errors_config = {}
    update_mask = {}
    reconciliation_mode = :RECONCILIATION_MODE_UNSPECIFIED
    notification_pubsub_topic = "hello world"

    import_products_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Retail::V2::ProductService::Rest::ServiceStub.stub :transcode_import_products_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, import_products_client_stub do
        # Create client
        client = ::Google::Cloud::Retail::V2::ProductService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.import_products({ parent: parent, request_id: request_id, input_config: input_config, errors_config: errors_config, update_mask: update_mask, reconciliation_mode: reconciliation_mode, notification_pubsub_topic: notification_pubsub_topic }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.import_products parent: parent, request_id: request_id, input_config: input_config, errors_config: errors_config, update_mask: update_mask, reconciliation_mode: reconciliation_mode, notification_pubsub_topic: notification_pubsub_topic do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.import_products ::Google::Cloud::Retail::V2::ImportProductsRequest.new(parent: parent, request_id: request_id, input_config: input_config, errors_config: errors_config, update_mask: update_mask, reconciliation_mode: reconciliation_mode, notification_pubsub_topic: notification_pubsub_topic) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.import_products({ parent: parent, request_id: request_id, input_config: input_config, errors_config: errors_config, update_mask: update_mask, reconciliation_mode: reconciliation_mode, notification_pubsub_topic: notification_pubsub_topic }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.import_products(::Google::Cloud::Retail::V2::ImportProductsRequest.new(parent: parent, request_id: request_id, input_config: input_config, errors_config: errors_config, update_mask: update_mask, reconciliation_mode: reconciliation_mode, notification_pubsub_topic: notification_pubsub_topic), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, import_products_client_stub.call_count
      end
    end
  end

  def test_set_inventory
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    inventory = {}
    set_mask = {}
    set_time = {}
    allow_missing = true

    set_inventory_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Retail::V2::ProductService::Rest::ServiceStub.stub :transcode_set_inventory_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, set_inventory_client_stub do
        # Create client
        client = ::Google::Cloud::Retail::V2::ProductService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.set_inventory({ inventory: inventory, set_mask: set_mask, set_time: set_time, allow_missing: allow_missing }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.set_inventory inventory: inventory, set_mask: set_mask, set_time: set_time, allow_missing: allow_missing do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.set_inventory ::Google::Cloud::Retail::V2::SetInventoryRequest.new(inventory: inventory, set_mask: set_mask, set_time: set_time, allow_missing: allow_missing) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.set_inventory({ inventory: inventory, set_mask: set_mask, set_time: set_time, allow_missing: allow_missing }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.set_inventory(::Google::Cloud::Retail::V2::SetInventoryRequest.new(inventory: inventory, set_mask: set_mask, set_time: set_time, allow_missing: allow_missing), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, set_inventory_client_stub.call_count
      end
    end
  end

  def test_add_fulfillment_places
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    product = "hello world"
    type = "hello world"
    place_ids = ["hello world"]
    add_time = {}
    allow_missing = true

    add_fulfillment_places_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Retail::V2::ProductService::Rest::ServiceStub.stub :transcode_add_fulfillment_places_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, add_fulfillment_places_client_stub do
        # Create client
        client = ::Google::Cloud::Retail::V2::ProductService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.add_fulfillment_places({ product: product, type: type, place_ids: place_ids, add_time: add_time, allow_missing: allow_missing }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.add_fulfillment_places product: product, type: type, place_ids: place_ids, add_time: add_time, allow_missing: allow_missing do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.add_fulfillment_places ::Google::Cloud::Retail::V2::AddFulfillmentPlacesRequest.new(product: product, type: type, place_ids: place_ids, add_time: add_time, allow_missing: allow_missing) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.add_fulfillment_places({ product: product, type: type, place_ids: place_ids, add_time: add_time, allow_missing: allow_missing }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.add_fulfillment_places(::Google::Cloud::Retail::V2::AddFulfillmentPlacesRequest.new(product: product, type: type, place_ids: place_ids, add_time: add_time, allow_missing: allow_missing), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, add_fulfillment_places_client_stub.call_count
      end
    end
  end

  def test_remove_fulfillment_places
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    product = "hello world"
    type = "hello world"
    place_ids = ["hello world"]
    remove_time = {}
    allow_missing = true

    remove_fulfillment_places_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Retail::V2::ProductService::Rest::ServiceStub.stub :transcode_remove_fulfillment_places_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, remove_fulfillment_places_client_stub do
        # Create client
        client = ::Google::Cloud::Retail::V2::ProductService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.remove_fulfillment_places({ product: product, type: type, place_ids: place_ids, remove_time: remove_time, allow_missing: allow_missing }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.remove_fulfillment_places product: product, type: type, place_ids: place_ids, remove_time: remove_time, allow_missing: allow_missing do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.remove_fulfillment_places ::Google::Cloud::Retail::V2::RemoveFulfillmentPlacesRequest.new(product: product, type: type, place_ids: place_ids, remove_time: remove_time, allow_missing: allow_missing) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.remove_fulfillment_places({ product: product, type: type, place_ids: place_ids, remove_time: remove_time, allow_missing: allow_missing }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.remove_fulfillment_places(::Google::Cloud::Retail::V2::RemoveFulfillmentPlacesRequest.new(product: product, type: type, place_ids: place_ids, remove_time: remove_time, allow_missing: allow_missing), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, remove_fulfillment_places_client_stub.call_count
      end
    end
  end

  def test_add_local_inventories
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    product = "hello world"
    local_inventories = [{}]
    add_mask = {}
    add_time = {}
    allow_missing = true

    add_local_inventories_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Retail::V2::ProductService::Rest::ServiceStub.stub :transcode_add_local_inventories_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, add_local_inventories_client_stub do
        # Create client
        client = ::Google::Cloud::Retail::V2::ProductService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.add_local_inventories({ product: product, local_inventories: local_inventories, add_mask: add_mask, add_time: add_time, allow_missing: allow_missing }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.add_local_inventories product: product, local_inventories: local_inventories, add_mask: add_mask, add_time: add_time, allow_missing: allow_missing do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.add_local_inventories ::Google::Cloud::Retail::V2::AddLocalInventoriesRequest.new(product: product, local_inventories: local_inventories, add_mask: add_mask, add_time: add_time, allow_missing: allow_missing) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.add_local_inventories({ product: product, local_inventories: local_inventories, add_mask: add_mask, add_time: add_time, allow_missing: allow_missing }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.add_local_inventories(::Google::Cloud::Retail::V2::AddLocalInventoriesRequest.new(product: product, local_inventories: local_inventories, add_mask: add_mask, add_time: add_time, allow_missing: allow_missing), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, add_local_inventories_client_stub.call_count
      end
    end
  end

  def test_remove_local_inventories
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    product = "hello world"
    place_ids = ["hello world"]
    remove_time = {}
    allow_missing = true

    remove_local_inventories_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Retail::V2::ProductService::Rest::ServiceStub.stub :transcode_remove_local_inventories_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, remove_local_inventories_client_stub do
        # Create client
        client = ::Google::Cloud::Retail::V2::ProductService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.remove_local_inventories({ product: product, place_ids: place_ids, remove_time: remove_time, allow_missing: allow_missing }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.remove_local_inventories product: product, place_ids: place_ids, remove_time: remove_time, allow_missing: allow_missing do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.remove_local_inventories ::Google::Cloud::Retail::V2::RemoveLocalInventoriesRequest.new(product: product, place_ids: place_ids, remove_time: remove_time, allow_missing: allow_missing) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.remove_local_inventories({ product: product, place_ids: place_ids, remove_time: remove_time, allow_missing: allow_missing }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.remove_local_inventories(::Google::Cloud::Retail::V2::RemoveLocalInventoriesRequest.new(product: product, place_ids: place_ids, remove_time: remove_time, allow_missing: allow_missing), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, remove_local_inventories_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Retail::V2::ProductService::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Retail::V2::ProductService::Rest::Client::Configuration, config
  end
end
