# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/retail/v2/generative_question_service_pb"
require "google/cloud/retail/v2/generative_question_service"

class ::Google::Cloud::Retail::V2::GenerativeQuestionService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_update_generative_questions_feature_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Retail::V2::GenerativeQuestionsFeatureConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    generative_questions_feature_config = {}
    update_mask = {}

    update_generative_questions_feature_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_generative_questions_feature_config, name
      assert_kind_of ::Google::Cloud::Retail::V2::UpdateGenerativeQuestionsFeatureConfigRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Retail::V2::GenerativeQuestionsFeatureConfig), request["generative_questions_feature_config"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_generative_questions_feature_config_client_stub do
      # Create client
      client = ::Google::Cloud::Retail::V2::GenerativeQuestionService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_generative_questions_feature_config({ generative_questions_feature_config: generative_questions_feature_config, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_generative_questions_feature_config generative_questions_feature_config: generative_questions_feature_config, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_generative_questions_feature_config ::Google::Cloud::Retail::V2::UpdateGenerativeQuestionsFeatureConfigRequest.new(generative_questions_feature_config: generative_questions_feature_config, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_generative_questions_feature_config({ generative_questions_feature_config: generative_questions_feature_config, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_generative_questions_feature_config(::Google::Cloud::Retail::V2::UpdateGenerativeQuestionsFeatureConfigRequest.new(generative_questions_feature_config: generative_questions_feature_config, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_generative_questions_feature_config_client_stub.call_rpc_count
    end
  end

  def test_get_generative_questions_feature_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Retail::V2::GenerativeQuestionsFeatureConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    catalog = "hello world"

    get_generative_questions_feature_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_generative_questions_feature_config, name
      assert_kind_of ::Google::Cloud::Retail::V2::GetGenerativeQuestionsFeatureConfigRequest, request
      assert_equal "hello world", request["catalog"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_generative_questions_feature_config_client_stub do
      # Create client
      client = ::Google::Cloud::Retail::V2::GenerativeQuestionService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_generative_questions_feature_config({ catalog: catalog }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_generative_questions_feature_config catalog: catalog do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_generative_questions_feature_config ::Google::Cloud::Retail::V2::GetGenerativeQuestionsFeatureConfigRequest.new(catalog: catalog) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_generative_questions_feature_config({ catalog: catalog }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_generative_questions_feature_config(::Google::Cloud::Retail::V2::GetGenerativeQuestionsFeatureConfigRequest.new(catalog: catalog), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_generative_questions_feature_config_client_stub.call_rpc_count
    end
  end

  def test_list_generative_question_configs
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Retail::V2::ListGenerativeQuestionConfigsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"

    list_generative_question_configs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_generative_question_configs, name
      assert_kind_of ::Google::Cloud::Retail::V2::ListGenerativeQuestionConfigsRequest, request
      assert_equal "hello world", request["parent"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_generative_question_configs_client_stub do
      # Create client
      client = ::Google::Cloud::Retail::V2::GenerativeQuestionService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_generative_question_configs({ parent: parent }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_generative_question_configs parent: parent do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_generative_question_configs ::Google::Cloud::Retail::V2::ListGenerativeQuestionConfigsRequest.new(parent: parent) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_generative_question_configs({ parent: parent }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_generative_question_configs(::Google::Cloud::Retail::V2::ListGenerativeQuestionConfigsRequest.new(parent: parent), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_generative_question_configs_client_stub.call_rpc_count
    end
  end

  def test_update_generative_question_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Retail::V2::GenerativeQuestionConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    generative_question_config = {}
    update_mask = {}

    update_generative_question_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_generative_question_config, name
      assert_kind_of ::Google::Cloud::Retail::V2::UpdateGenerativeQuestionConfigRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Retail::V2::GenerativeQuestionConfig), request["generative_question_config"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_generative_question_config_client_stub do
      # Create client
      client = ::Google::Cloud::Retail::V2::GenerativeQuestionService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_generative_question_config({ generative_question_config: generative_question_config, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_generative_question_config generative_question_config: generative_question_config, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_generative_question_config ::Google::Cloud::Retail::V2::UpdateGenerativeQuestionConfigRequest.new(generative_question_config: generative_question_config, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_generative_question_config({ generative_question_config: generative_question_config, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_generative_question_config(::Google::Cloud::Retail::V2::UpdateGenerativeQuestionConfigRequest.new(generative_question_config: generative_question_config, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_generative_question_config_client_stub.call_rpc_count
    end
  end

  def test_batch_update_generative_question_configs
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Retail::V2::BatchUpdateGenerativeQuestionConfigsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    requests = [{}]

    batch_update_generative_question_configs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :batch_update_generative_question_configs, name
      assert_kind_of ::Google::Cloud::Retail::V2::BatchUpdateGenerativeQuestionConfigsRequest, request
      assert_equal "hello world", request["parent"]
      assert_kind_of ::Google::Cloud::Retail::V2::UpdateGenerativeQuestionConfigRequest, request["requests"].first
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, batch_update_generative_question_configs_client_stub do
      # Create client
      client = ::Google::Cloud::Retail::V2::GenerativeQuestionService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.batch_update_generative_question_configs({ parent: parent, requests: requests }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.batch_update_generative_question_configs parent: parent, requests: requests do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.batch_update_generative_question_configs ::Google::Cloud::Retail::V2::BatchUpdateGenerativeQuestionConfigsRequest.new(parent: parent, requests: requests) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.batch_update_generative_question_configs({ parent: parent, requests: requests }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.batch_update_generative_question_configs(::Google::Cloud::Retail::V2::BatchUpdateGenerativeQuestionConfigsRequest.new(parent: parent, requests: requests), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, batch_update_generative_question_configs_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Retail::V2::GenerativeQuestionService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Retail::V2::GenerativeQuestionService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Retail::V2::GenerativeQuestionService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::Retail::V2::GenerativeQuestionService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
