# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/retail/v2/conversational_search_service_pb"
require "google/cloud/retail/v2/conversational_search_service"

class ::Google::Cloud::Retail::V2::ConversationalSearchService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_conversational_search
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Retail::V2::ConversationalSearchResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a server streaming method.
    placement = "hello world"
    branch = "hello world"
    query = "hello world"
    page_categories = ["hello world"]
    conversation_id = "hello world"
    search_params = {}
    visitor_id = "hello world"
    user_info = {}
    conversational_filtering_spec = {}
    user_labels = {}
    safety_settings = [{}]

    conversational_search_client_stub = ClientStub.new [grpc_response].to_enum, grpc_operation do |name, request, options:|
      assert_equal :conversational_search, name
      assert_kind_of ::Google::Cloud::Retail::V2::ConversationalSearchRequest, request
      assert_equal "hello world", request["placement"]
      assert_equal "hello world", request["branch"]
      assert_equal "hello world", request["query"]
      assert_equal ["hello world"], request["page_categories"]
      assert_equal "hello world", request["conversation_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Retail::V2::ConversationalSearchRequest::SearchParams), request["search_params"]
      assert_equal "hello world", request["visitor_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Retail::V2::UserInfo), request["user_info"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Retail::V2::ConversationalSearchRequest::ConversationalFilteringSpec), request["conversational_filtering_spec"]
      assert_equal({}, request["user_labels"].to_h)
      assert_kind_of ::Google::Cloud::Retail::V2::SafetySetting, request["safety_settings"].first
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, conversational_search_client_stub do
      # Create client
      client = ::Google::Cloud::Retail::V2::ConversationalSearchService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.conversational_search({ placement: placement, branch: branch, query: query, page_categories: page_categories, conversation_id: conversation_id, search_params: search_params, visitor_id: visitor_id, user_info: user_info, conversational_filtering_spec: conversational_filtering_spec, user_labels: user_labels, safety_settings: safety_settings }) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Retail::V2::ConversationalSearchResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.conversational_search placement: placement, branch: branch, query: query, page_categories: page_categories, conversation_id: conversation_id, search_params: search_params, visitor_id: visitor_id, user_info: user_info, conversational_filtering_spec: conversational_filtering_spec, user_labels: user_labels, safety_settings: safety_settings do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Retail::V2::ConversationalSearchResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.conversational_search ::Google::Cloud::Retail::V2::ConversationalSearchRequest.new(placement: placement, branch: branch, query: query, page_categories: page_categories, conversation_id: conversation_id, search_params: search_params, visitor_id: visitor_id, user_info: user_info, conversational_filtering_spec: conversational_filtering_spec, user_labels: user_labels, safety_settings: safety_settings) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Retail::V2::ConversationalSearchResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.conversational_search({ placement: placement, branch: branch, query: query, page_categories: page_categories, conversation_id: conversation_id, search_params: search_params, visitor_id: visitor_id, user_info: user_info, conversational_filtering_spec: conversational_filtering_spec, user_labels: user_labels, safety_settings: safety_settings }, grpc_options) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Retail::V2::ConversationalSearchResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.conversational_search(::Google::Cloud::Retail::V2::ConversationalSearchRequest.new(placement: placement, branch: branch, query: query, page_categories: page_categories, conversation_id: conversation_id, search_params: search_params, visitor_id: visitor_id, user_info: user_info, conversational_filtering_spec: conversational_filtering_spec, user_labels: user_labels, safety_settings: safety_settings), grpc_options) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Retail::V2::ConversationalSearchResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, conversational_search_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Retail::V2::ConversationalSearchService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Retail::V2::ConversationalSearchService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Retail::V2::ConversationalSearchService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::Retail::V2::ConversationalSearchService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
