# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/retail/v2/catalog_service_pb"
require "google/cloud/retail/v2/catalog_service"

class ::Google::Cloud::Retail::V2::CatalogService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_catalogs
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Retail::V2::ListCatalogsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_catalogs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_catalogs, name
      assert_kind_of ::Google::Cloud::Retail::V2::ListCatalogsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_catalogs_client_stub do
      # Create client
      client = ::Google::Cloud::Retail::V2::CatalogService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_catalogs({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_catalogs parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_catalogs ::Google::Cloud::Retail::V2::ListCatalogsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_catalogs({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_catalogs(::Google::Cloud::Retail::V2::ListCatalogsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_catalogs_client_stub.call_rpc_count
    end
  end

  def test_update_catalog
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Retail::V2::Catalog.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    catalog = {}
    update_mask = {}

    update_catalog_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_catalog, name
      assert_kind_of ::Google::Cloud::Retail::V2::UpdateCatalogRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Retail::V2::Catalog), request["catalog"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_catalog_client_stub do
      # Create client
      client = ::Google::Cloud::Retail::V2::CatalogService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_catalog({ catalog: catalog, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_catalog catalog: catalog, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_catalog ::Google::Cloud::Retail::V2::UpdateCatalogRequest.new(catalog: catalog, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_catalog({ catalog: catalog, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_catalog(::Google::Cloud::Retail::V2::UpdateCatalogRequest.new(catalog: catalog, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_catalog_client_stub.call_rpc_count
    end
  end

  def test_set_default_branch
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    catalog = "hello world"
    branch_id = "hello world"
    note = "hello world"
    force = true

    set_default_branch_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :set_default_branch, name
      assert_kind_of ::Google::Cloud::Retail::V2::SetDefaultBranchRequest, request
      assert_equal "hello world", request["catalog"]
      assert_equal "hello world", request["branch_id"]
      assert_equal "hello world", request["note"]
      assert_equal true, request["force"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, set_default_branch_client_stub do
      # Create client
      client = ::Google::Cloud::Retail::V2::CatalogService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.set_default_branch({ catalog: catalog, branch_id: branch_id, note: note, force: force }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.set_default_branch catalog: catalog, branch_id: branch_id, note: note, force: force do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.set_default_branch ::Google::Cloud::Retail::V2::SetDefaultBranchRequest.new(catalog: catalog, branch_id: branch_id, note: note, force: force) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.set_default_branch({ catalog: catalog, branch_id: branch_id, note: note, force: force }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.set_default_branch(::Google::Cloud::Retail::V2::SetDefaultBranchRequest.new(catalog: catalog, branch_id: branch_id, note: note, force: force), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, set_default_branch_client_stub.call_rpc_count
    end
  end

  def test_get_default_branch
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Retail::V2::GetDefaultBranchResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    catalog = "hello world"

    get_default_branch_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_default_branch, name
      assert_kind_of ::Google::Cloud::Retail::V2::GetDefaultBranchRequest, request
      assert_equal "hello world", request["catalog"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_default_branch_client_stub do
      # Create client
      client = ::Google::Cloud::Retail::V2::CatalogService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_default_branch({ catalog: catalog }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_default_branch catalog: catalog do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_default_branch ::Google::Cloud::Retail::V2::GetDefaultBranchRequest.new(catalog: catalog) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_default_branch({ catalog: catalog }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_default_branch(::Google::Cloud::Retail::V2::GetDefaultBranchRequest.new(catalog: catalog), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_default_branch_client_stub.call_rpc_count
    end
  end

  def test_get_completion_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Retail::V2::CompletionConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_completion_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_completion_config, name
      assert_kind_of ::Google::Cloud::Retail::V2::GetCompletionConfigRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_completion_config_client_stub do
      # Create client
      client = ::Google::Cloud::Retail::V2::CatalogService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_completion_config({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_completion_config name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_completion_config ::Google::Cloud::Retail::V2::GetCompletionConfigRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_completion_config({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_completion_config(::Google::Cloud::Retail::V2::GetCompletionConfigRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_completion_config_client_stub.call_rpc_count
    end
  end

  def test_update_completion_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Retail::V2::CompletionConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    completion_config = {}
    update_mask = {}

    update_completion_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_completion_config, name
      assert_kind_of ::Google::Cloud::Retail::V2::UpdateCompletionConfigRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Retail::V2::CompletionConfig), request["completion_config"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_completion_config_client_stub do
      # Create client
      client = ::Google::Cloud::Retail::V2::CatalogService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_completion_config({ completion_config: completion_config, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_completion_config completion_config: completion_config, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_completion_config ::Google::Cloud::Retail::V2::UpdateCompletionConfigRequest.new(completion_config: completion_config, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_completion_config({ completion_config: completion_config, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_completion_config(::Google::Cloud::Retail::V2::UpdateCompletionConfigRequest.new(completion_config: completion_config, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_completion_config_client_stub.call_rpc_count
    end
  end

  def test_get_attributes_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Retail::V2::AttributesConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_attributes_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_attributes_config, name
      assert_kind_of ::Google::Cloud::Retail::V2::GetAttributesConfigRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_attributes_config_client_stub do
      # Create client
      client = ::Google::Cloud::Retail::V2::CatalogService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_attributes_config({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_attributes_config name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_attributes_config ::Google::Cloud::Retail::V2::GetAttributesConfigRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_attributes_config({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_attributes_config(::Google::Cloud::Retail::V2::GetAttributesConfigRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_attributes_config_client_stub.call_rpc_count
    end
  end

  def test_update_attributes_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Retail::V2::AttributesConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    attributes_config = {}
    update_mask = {}

    update_attributes_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_attributes_config, name
      assert_kind_of ::Google::Cloud::Retail::V2::UpdateAttributesConfigRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Retail::V2::AttributesConfig), request["attributes_config"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_attributes_config_client_stub do
      # Create client
      client = ::Google::Cloud::Retail::V2::CatalogService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_attributes_config({ attributes_config: attributes_config, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_attributes_config attributes_config: attributes_config, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_attributes_config ::Google::Cloud::Retail::V2::UpdateAttributesConfigRequest.new(attributes_config: attributes_config, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_attributes_config({ attributes_config: attributes_config, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_attributes_config(::Google::Cloud::Retail::V2::UpdateAttributesConfigRequest.new(attributes_config: attributes_config, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_attributes_config_client_stub.call_rpc_count
    end
  end

  def test_add_catalog_attribute
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Retail::V2::AttributesConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    attributes_config = "hello world"
    catalog_attribute = {}

    add_catalog_attribute_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :add_catalog_attribute, name
      assert_kind_of ::Google::Cloud::Retail::V2::AddCatalogAttributeRequest, request
      assert_equal "hello world", request["attributes_config"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Retail::V2::CatalogAttribute), request["catalog_attribute"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, add_catalog_attribute_client_stub do
      # Create client
      client = ::Google::Cloud::Retail::V2::CatalogService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.add_catalog_attribute({ attributes_config: attributes_config, catalog_attribute: catalog_attribute }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.add_catalog_attribute attributes_config: attributes_config, catalog_attribute: catalog_attribute do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.add_catalog_attribute ::Google::Cloud::Retail::V2::AddCatalogAttributeRequest.new(attributes_config: attributes_config, catalog_attribute: catalog_attribute) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.add_catalog_attribute({ attributes_config: attributes_config, catalog_attribute: catalog_attribute }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.add_catalog_attribute(::Google::Cloud::Retail::V2::AddCatalogAttributeRequest.new(attributes_config: attributes_config, catalog_attribute: catalog_attribute), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, add_catalog_attribute_client_stub.call_rpc_count
    end
  end

  def test_remove_catalog_attribute
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Retail::V2::AttributesConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    attributes_config = "hello world"
    key = "hello world"

    remove_catalog_attribute_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :remove_catalog_attribute, name
      assert_kind_of ::Google::Cloud::Retail::V2::RemoveCatalogAttributeRequest, request
      assert_equal "hello world", request["attributes_config"]
      assert_equal "hello world", request["key"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, remove_catalog_attribute_client_stub do
      # Create client
      client = ::Google::Cloud::Retail::V2::CatalogService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.remove_catalog_attribute({ attributes_config: attributes_config, key: key }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.remove_catalog_attribute attributes_config: attributes_config, key: key do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.remove_catalog_attribute ::Google::Cloud::Retail::V2::RemoveCatalogAttributeRequest.new(attributes_config: attributes_config, key: key) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.remove_catalog_attribute({ attributes_config: attributes_config, key: key }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.remove_catalog_attribute(::Google::Cloud::Retail::V2::RemoveCatalogAttributeRequest.new(attributes_config: attributes_config, key: key), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, remove_catalog_attribute_client_stub.call_rpc_count
    end
  end

  def test_replace_catalog_attribute
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Retail::V2::AttributesConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    attributes_config = "hello world"
    catalog_attribute = {}
    update_mask = {}

    replace_catalog_attribute_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :replace_catalog_attribute, name
      assert_kind_of ::Google::Cloud::Retail::V2::ReplaceCatalogAttributeRequest, request
      assert_equal "hello world", request["attributes_config"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Retail::V2::CatalogAttribute), request["catalog_attribute"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, replace_catalog_attribute_client_stub do
      # Create client
      client = ::Google::Cloud::Retail::V2::CatalogService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.replace_catalog_attribute({ attributes_config: attributes_config, catalog_attribute: catalog_attribute, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.replace_catalog_attribute attributes_config: attributes_config, catalog_attribute: catalog_attribute, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.replace_catalog_attribute ::Google::Cloud::Retail::V2::ReplaceCatalogAttributeRequest.new(attributes_config: attributes_config, catalog_attribute: catalog_attribute, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.replace_catalog_attribute({ attributes_config: attributes_config, catalog_attribute: catalog_attribute, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.replace_catalog_attribute(::Google::Cloud::Retail::V2::ReplaceCatalogAttributeRequest.new(attributes_config: attributes_config, catalog_attribute: catalog_attribute, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, replace_catalog_attribute_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Retail::V2::CatalogService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Retail::V2::CatalogService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Retail::V2::CatalogService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::Retail::V2::CatalogService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
