# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

# [START retail_v2_generated_ConversationalSearchService_ConversationalSearch_sync]
require "google/cloud/retail/v2"

##
# Snippet for the conversational_search call in the ConversationalSearchService service
#
# This snippet has been automatically generated and should be regarded as a code
# template only. It will require modifications to work:
# - It may require correct/in-range values for request initialization.
# - It may require specifying regional endpoints when creating the service
# client as shown in https://cloud.google.com/ruby/docs/reference.
#
# This is an auto-generated example demonstrating basic usage of
# Google::Cloud::Retail::V2::ConversationalSearchService::Client#conversational_search.
#
def conversational_search
  # Create a client object. The client can be reused for multiple calls.
  client = Google::Cloud::Retail::V2::ConversationalSearchService::Client.new

  # Create a request. To set request fields, pass in keyword arguments.
  request = Google::Cloud::Retail::V2::ConversationalSearchRequest.new

  # Call the conversational_search method to start streaming.
  output = client.conversational_search request

  # The returned object is a streamed enumerable yielding elements of type
  # ::Google::Cloud::Retail::V2::ConversationalSearchResponse
  output.each do |current_response|
    p current_response
  end
end
# [END retail_v2_generated_ConversationalSearchService_ConversationalSearch_sync]
