# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Retail
      module V2
        # Product attribute which structured by an attribute name and value. This
        # structure is used in conversational search filters and answers. For example,
        # if we have `name=color` and `value=red`, this means that the color is `red`.
        # @!attribute [rw] name
        #   @return [::String]
        #     The attribute name.
        # @!attribute [rw] value
        #   @return [::String]
        #     The attribute value.
        class ProductAttributeValue
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Product attribute name and numeric interval.
        # @!attribute [rw] name
        #   @return [::String]
        #     The attribute name (e.g. "length")
        # @!attribute [rw] interval
        #   @return [::Google::Cloud::Retail::V2::Interval]
        #     The numeric interval (e.g. [10, 20))
        class ProductAttributeInterval
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # This field specifies the tile information including an attribute key,
        # attribute value. More fields will be added in the future, eg: product id
        # or product counts, etc.
        # @!attribute [rw] product_attribute_value
        #   @return [::Google::Cloud::Retail::V2::ProductAttributeValue]
        #     The product attribute key-value.
        #
        #     Note: The following fields are mutually exclusive: `product_attribute_value`, `product_attribute_interval`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] product_attribute_interval
        #   @return [::Google::Cloud::Retail::V2::ProductAttributeInterval]
        #     The product attribute key-numeric interval.
        #
        #     Note: The following fields are mutually exclusive: `product_attribute_interval`, `product_attribute_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] representative_product_id
        #   @return [::String]
        #     The representative product id for this tile.
        class Tile
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Retail::V2::SearchService::Client#search SearchService.Search} method.
        # @!attribute [rw] placement
        #   @return [::String]
        #     Required. The resource name of the Retail Search serving config, such as
        #     `projects/*/locations/global/catalogs/default_catalog/servingConfigs/default_serving_config`
        #     or the name of the legacy placement resource, such as
        #     `projects/*/locations/global/catalogs/default_catalog/placements/default_search`.
        #     This field is used to identify the serving config name and the set
        #     of models that are used to make the search.
        # @!attribute [rw] branch
        #   @return [::String]
        #     The branch resource name, such as
        #     `projects/*/locations/global/catalogs/default_catalog/branches/0`.
        #
        #     Use "default_branch" as the branch ID or leave this field empty, to search
        #     products under the default branch.
        # @!attribute [rw] query
        #   @return [::String]
        #     Raw search query.
        #
        #     If this field is empty, the request is considered a category browsing
        #     request and returned results are based on
        #     {::Google::Cloud::Retail::V2::SearchRequest#filter filter} and
        #     {::Google::Cloud::Retail::V2::SearchRequest#page_categories page_categories}.
        # @!attribute [rw] visitor_id
        #   @return [::String]
        #     Required. A unique identifier for tracking visitors. For example, this
        #     could be implemented with an HTTP cookie, which should be able to uniquely
        #     identify a visitor on a single device. This unique identifier should not
        #     change if the visitor logs in or out of the website.
        #
        #     This should be the same identifier as
        #     {::Google::Cloud::Retail::V2::UserEvent#visitor_id UserEvent.visitor_id}.
        #
        #     The field must be a UTF-8 encoded string with a length limit of 128
        #     characters. Otherwise, an INVALID_ARGUMENT error is returned.
        # @!attribute [rw] user_info
        #   @return [::Google::Cloud::Retail::V2::UserInfo]
        #     User information.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Maximum number of {::Google::Cloud::Retail::V2::Product Product}s to return. If
        #     unspecified, defaults to a reasonable value. The maximum allowed value is
        #     120. Values above 120 will be coerced to 120.
        #
        #     If this field is negative, an INVALID_ARGUMENT is returned.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token
        #     {::Google::Cloud::Retail::V2::SearchResponse#next_page_token SearchResponse.next_page_token},
        #     received from a previous
        #     {::Google::Cloud::Retail::V2::SearchService::Client#search SearchService.Search} call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     {::Google::Cloud::Retail::V2::SearchService::Client#search SearchService.Search} must
        #     match the call that provided the page token. Otherwise, an INVALID_ARGUMENT
        #     error is returned.
        # @!attribute [rw] offset
        #   @return [::Integer]
        #     A 0-indexed integer that specifies the current offset (that is, starting
        #     result location, amongst the {::Google::Cloud::Retail::V2::Product Product}s
        #     deemed by the API as relevant) in search results. This field is only
        #     considered if {::Google::Cloud::Retail::V2::SearchRequest#page_token page_token}
        #     is unset.
        #
        #     If this field is negative, an INVALID_ARGUMENT is returned.
        # @!attribute [rw] filter
        #   @return [::String]
        #     The filter syntax consists of an expression language for constructing a
        #     predicate from one or more fields of the products being filtered. Filter
        #     expression is case-sensitive. For more information, see
        #     [Filter](https://cloud.google.com/retail/docs/filter-and-order#filter).
        #
        #     If this field is unrecognizable, an INVALID_ARGUMENT is returned.
        # @!attribute [rw] canonical_filter
        #   @return [::String]
        #     The default filter that is applied when a user performs a search without
        #     checking any filters on the search page.
        #
        #     The filter applied to every search request when quality improvement such as
        #     query expansion is needed. In the case a query does not have a sufficient
        #     amount of results this filter will be used to determine whether or not to
        #     enable the query expansion flow. The original filter will still be used for
        #     the query expanded search.
        #     This field is strongly recommended to achieve high search quality.
        #
        #     For more information about filter syntax, see
        #     {::Google::Cloud::Retail::V2::SearchRequest#filter SearchRequest.filter}.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     The order in which products are returned. Products can be ordered by
        #     a field in an {::Google::Cloud::Retail::V2::Product Product} object. Leave it
        #     unset if ordered by relevance. OrderBy expression is case-sensitive. For
        #     more information, see
        #     [Order](https://cloud.google.com/retail/docs/filter-and-order#order).
        #
        #     If this field is unrecognizable, an INVALID_ARGUMENT is returned.
        # @!attribute [rw] facet_specs
        #   @return [::Array<::Google::Cloud::Retail::V2::SearchRequest::FacetSpec>]
        #     Facet specifications for faceted search. If empty, no facets are returned.
        #
        #     A maximum of 200 values are allowed. Otherwise, an INVALID_ARGUMENT error
        #     is returned.
        # @!attribute [rw] dynamic_facet_spec
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Google::Cloud::Retail::V2::SearchRequest::DynamicFacetSpec]
        #     Deprecated. Refer to https://cloud.google.com/retail/docs/configs#dynamic
        #     to enable dynamic facets. Do not set this field.
        #
        #     The specification for dynamically generated facets. Notice that only
        #     textual facets can be dynamically generated.
        # @!attribute [rw] boost_spec
        #   @return [::Google::Cloud::Retail::V2::SearchRequest::BoostSpec]
        #     Boost specification to boost certain products. For more information, see
        #     [Boost results](https://cloud.google.com/retail/docs/boosting).
        #
        #     Notice that if both
        #     {::Google::Cloud::Retail::V2::ServingConfig#boost_control_ids ServingConfig.boost_control_ids}
        #     and
        #     {::Google::Cloud::Retail::V2::SearchRequest#boost_spec SearchRequest.boost_spec}
        #     are set, the boost conditions from both places are evaluated. If a search
        #     request matches multiple boost conditions, the final boost score is equal
        #     to the sum of the boost scores from all matched boost conditions.
        # @!attribute [rw] query_expansion_spec
        #   @return [::Google::Cloud::Retail::V2::SearchRequest::QueryExpansionSpec]
        #     The query expansion specification that specifies the conditions under which
        #     query expansion occurs. For more information, see [Query
        #     expansion](https://cloud.google.com/retail/docs/result-size#query_expansion).
        # @!attribute [rw] variant_rollup_keys
        #   @return [::Array<::String>]
        #     The keys to fetch and rollup the matching
        #     {::Google::Cloud::Retail::V2::Product::Type::VARIANT variant}
        #     {::Google::Cloud::Retail::V2::Product Product}s attributes,
        #     {::Google::Cloud::Retail::V2::FulfillmentInfo FulfillmentInfo} or
        #     {::Google::Cloud::Retail::V2::LocalInventory LocalInventory}s attributes. The
        #     attributes from all the matching
        #     {::Google::Cloud::Retail::V2::Product::Type::VARIANT variant}
        #     {::Google::Cloud::Retail::V2::Product Product}s or
        #     {::Google::Cloud::Retail::V2::LocalInventory LocalInventory}s are merged and
        #     de-duplicated. Notice that rollup attributes will lead to extra query
        #     latency. Maximum number of keys is 30.
        #
        #     For {::Google::Cloud::Retail::V2::FulfillmentInfo FulfillmentInfo}, a
        #     fulfillment type and a fulfillment ID must be provided in the format of
        #     "fulfillmentType.fulfillmentId". E.g., in "pickupInStore.store123",
        #     "pickupInStore" is fulfillment type and "store123" is the store ID.
        #
        #     Supported keys are:
        #
        #     * colorFamilies
        #     * price
        #     * originalPrice
        #     * discount
        #     * variantId
        #     * inventory(place_id,price)
        #     * inventory(place_id,original_price)
        #     * inventory(place_id,attributes.key), where key is any key in the
        #       {::Google::Cloud::Retail::V2::LocalInventory#attributes Product.local_inventories.attributes}
        #       map.
        #     * attributes.key, where key is any key in the
        #       {::Google::Cloud::Retail::V2::Product#attributes Product.attributes} map.
        #     * pickupInStore.id, where id is any
        #     {::Google::Cloud::Retail::V2::FulfillmentInfo#place_ids FulfillmentInfo.place_ids}
        #     for {::Google::Cloud::Retail::V2::FulfillmentInfo#type FulfillmentInfo.type}
        #       "pickup-in-store".
        #     * shipToStore.id, where id is any
        #     {::Google::Cloud::Retail::V2::FulfillmentInfo#place_ids FulfillmentInfo.place_ids}
        #     for {::Google::Cloud::Retail::V2::FulfillmentInfo#type FulfillmentInfo.type}
        #       "ship-to-store".
        #     * sameDayDelivery.id, where id is any
        #     {::Google::Cloud::Retail::V2::FulfillmentInfo#place_ids FulfillmentInfo.place_ids}
        #     for {::Google::Cloud::Retail::V2::FulfillmentInfo#type FulfillmentInfo.type}
        #       "same-day-delivery".
        #     * nextDayDelivery.id, where id is any
        #     {::Google::Cloud::Retail::V2::FulfillmentInfo#place_ids FulfillmentInfo.place_ids}
        #     for {::Google::Cloud::Retail::V2::FulfillmentInfo#type FulfillmentInfo.type}
        #       "next-day-delivery".
        #     * customFulfillment1.id, where id is any
        #     {::Google::Cloud::Retail::V2::FulfillmentInfo#place_ids FulfillmentInfo.place_ids}
        #     for {::Google::Cloud::Retail::V2::FulfillmentInfo#type FulfillmentInfo.type}
        #       "custom-type-1".
        #     * customFulfillment2.id, where id is any
        #     {::Google::Cloud::Retail::V2::FulfillmentInfo#place_ids FulfillmentInfo.place_ids}
        #     for {::Google::Cloud::Retail::V2::FulfillmentInfo#type FulfillmentInfo.type}
        #       "custom-type-2".
        #     * customFulfillment3.id, where id is any
        #     {::Google::Cloud::Retail::V2::FulfillmentInfo#place_ids FulfillmentInfo.place_ids}
        #     for {::Google::Cloud::Retail::V2::FulfillmentInfo#type FulfillmentInfo.type}
        #       "custom-type-3".
        #     * customFulfillment4.id, where id is any
        #     {::Google::Cloud::Retail::V2::FulfillmentInfo#place_ids FulfillmentInfo.place_ids}
        #     for {::Google::Cloud::Retail::V2::FulfillmentInfo#type FulfillmentInfo.type}
        #       "custom-type-4".
        #     * customFulfillment5.id, where id is any
        #     {::Google::Cloud::Retail::V2::FulfillmentInfo#place_ids FulfillmentInfo.place_ids}
        #     for {::Google::Cloud::Retail::V2::FulfillmentInfo#type FulfillmentInfo.type}
        #       "custom-type-5".
        #
        #     If this field is set to an invalid value other than these, an
        #     INVALID_ARGUMENT error is returned.
        # @!attribute [rw] page_categories
        #   @return [::Array<::String>]
        #     The categories associated with a category page. Must be set for category
        #     navigation queries to achieve good search quality. The format should be
        #     the same as
        #     {::Google::Cloud::Retail::V2::UserEvent#page_categories UserEvent.page_categories};
        #
        #     To represent full path of category, use '>' sign to separate different
        #     hierarchies. If '>' is part of the category name, replace it with
        #     other character(s).
        #
        #     Category pages include special pages such as sales or promotions. For
        #     instance, a special sale page may have the category hierarchy:
        #     "pageCategories" : ["Sales > 2017 Black Friday Deals"].
        # @!attribute [rw] search_mode
        #   @return [::Google::Cloud::Retail::V2::SearchRequest::SearchMode]
        #     The search mode of the search request. If not specified, a single search
        #     request triggers both product search and faceted search.
        # @!attribute [rw] personalization_spec
        #   @return [::Google::Cloud::Retail::V2::SearchRequest::PersonalizationSpec]
        #     The specification for personalization.
        #
        #     Notice that if both
        #     {::Google::Cloud::Retail::V2::ServingConfig#personalization_spec ServingConfig.personalization_spec}
        #     and
        #     {::Google::Cloud::Retail::V2::SearchRequest#personalization_spec SearchRequest.personalization_spec}
        #     are set.
        #     {::Google::Cloud::Retail::V2::SearchRequest#personalization_spec SearchRequest.personalization_spec}
        #     will override
        #     {::Google::Cloud::Retail::V2::ServingConfig#personalization_spec ServingConfig.personalization_spec}.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     The labels applied to a resource must meet the following requirements:
        #
        #     * Each resource can have multiple labels, up to a maximum of 64.
        #     * Each label must be a key-value pair.
        #     * Keys have a minimum length of 1 character and a maximum length of 63
        #       characters and cannot be empty. Values can be empty and have a maximum
        #       length of 63 characters.
        #     * Keys and values can contain only lowercase letters, numeric characters,
        #       underscores, and dashes. All characters must use UTF-8 encoding, and
        #       international characters are allowed.
        #     * The key portion of a label must be unique. However, you can use the same
        #       key with multiple resources.
        #     * Keys must start with a lowercase letter or international character.
        #
        #     For more information, see [Requirements for
        #     labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
        #     in the Resource Manager documentation.
        # @!attribute [rw] spell_correction_spec
        #   @return [::Google::Cloud::Retail::V2::SearchRequest::SpellCorrectionSpec]
        #     The spell correction specification that specifies the mode under
        #     which spell correction will take effect.
        # @!attribute [rw] entity
        #   @return [::String]
        #     The entity for customers that may run multiple different entities, domains,
        #     sites or regions, for example, `Google US`, `Google Ads`, `Waymo`,
        #     `google.com`, `youtube.com`, etc.
        #     If this is set, it should be exactly matched with
        #     {::Google::Cloud::Retail::V2::UserEvent#entity UserEvent.entity} to get search
        #     results boosted by entity.
        # @!attribute [rw] conversational_search_spec
        #   @return [::Google::Cloud::Retail::V2::SearchRequest::ConversationalSearchSpec]
        #     Optional. This field specifies all conversational related parameters
        #     addition to traditional retail search.
        # @!attribute [rw] tile_navigation_spec
        #   @return [::Google::Cloud::Retail::V2::SearchRequest::TileNavigationSpec]
        #     Optional. This field specifies tile navigation related parameters.
        # @!attribute [rw] language_code
        #   @return [::String]
        #     Optional. The BCP-47 language code, such as "en-US" or "sr-Latn"
        #     [list](https://www.unicode.org/cldr/charts/46/summary/root.html). For more
        #     information, see [Standardized codes](https://google.aip.dev/143). This
        #     field helps to better interpret the query. If a value isn't specified, the
        #     query language code is automatically detected, which may not be accurate.
        # @!attribute [rw] region_code
        #   @return [::String]
        #     Optional. The Unicode country/region code (CLDR) of a location, such as
        #     "US" and "419"
        #     [list](https://www.unicode.org/cldr/charts/46/supplemental/territory_information.html).
        #     For more information, see [Standardized codes](https://google.aip.dev/143).
        #     If set, then results will be boosted based on the region_code provided.
        # @!attribute [rw] place_id
        #   @return [::String]
        #     Optional. An id corresponding to a place, such as a store id or region id.
        #     When specified, we use the price from the local inventory with the matching
        #     product's
        #     {::Google::Cloud::Retail::V2::LocalInventory#place_id LocalInventory.place_id}
        #     for revenue optimization.
        # @!attribute [rw] user_attributes
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Retail::V2::StringList}]
        #     Optional. The user attributes that could be used for personalization of
        #     search results.
        #     * Populate at most 100 key-value pairs per query.
        #     * Only supports string keys and repeated string values.
        #     * Duplcate keys are not allowed within a single query.
        #
        #     Example:
        #        user_attributes: [
        #         { key: "pets"
        #           value {
        #             values: "dog"
        #             values: "cat"
        #           }
        #         },
        #         { key: "state"
        #           value {
        #             values: "CA"
        #           }
        #         }
        #        ]
        class SearchRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A facet specification to perform faceted search.
          # @!attribute [rw] facet_key
          #   @return [::Google::Cloud::Retail::V2::SearchRequest::FacetSpec::FacetKey]
          #     Required. The facet key specification.
          # @!attribute [rw] limit
          #   @return [::Integer]
          #     Maximum of facet values that should be returned for this facet. If
          #     unspecified, defaults to 50. The maximum allowed value is 300. Values
          #     above 300 will be coerced to 300.
          #
          #     If this field is negative, an INVALID_ARGUMENT is returned.
          # @!attribute [rw] excluded_filter_keys
          #   @return [::Array<::String>]
          #     List of keys to exclude when faceting.
          #
          #     By default,
          #     {::Google::Cloud::Retail::V2::SearchRequest::FacetSpec::FacetKey#key FacetKey.key}
          #     is not excluded from the filter unless it is listed in this field.
          #
          #     Listing a facet key in this field allows its values to appear as facet
          #     results, even when they are filtered out of search results. Using this
          #     field does not affect what search results are returned.
          #
          #     For example, suppose there are 100 products with the color facet "Red"
          #     and 200 products with the color facet "Blue". A query containing the
          #     filter "colorFamilies:ANY("Red")" and having "colorFamilies" as
          #     {::Google::Cloud::Retail::V2::SearchRequest::FacetSpec::FacetKey#key FacetKey.key}
          #     would by default return only "Red" products in the search results, and
          #     also return "Red" with count 100 as the only color facet. Although there
          #     are also blue products available, "Blue" would not be shown as an
          #     available facet value.
          #
          #     If "colorFamilies" is listed in "excludedFilterKeys", then the query
          #     returns the facet values "Red" with count 100 and "Blue" with count
          #     200, because the "colorFamilies" key is now excluded from the filter.
          #     Because this field doesn't affect search results, the search results
          #     are still correctly filtered to return only "Red" products.
          #
          #     A maximum of 100 values are allowed. Otherwise, an INVALID_ARGUMENT error
          #     is returned.
          # @!attribute [rw] enable_dynamic_position
          #   @return [::Boolean]
          #     Enables dynamic position for this facet. If set to true, the position of
          #     this facet among all facets in the response is determined by Google
          #     Retail Search. It is ordered together with dynamic facets if dynamic
          #     facets is enabled. If set to false, the position of this facet in the
          #     response is the same as in the request, and it is ranked before
          #     the facets with dynamic position enable and all dynamic facets.
          #
          #     For example, you may always want to have rating facet returned in
          #     the response, but it's not necessarily to always display the rating facet
          #     at the top. In that case, you can set enable_dynamic_position to true so
          #     that the position of rating facet in response is determined by
          #     Google Retail Search.
          #
          #     Another example, assuming you have the following facets in the request:
          #
          #     * "rating", enable_dynamic_position = true
          #
          #     * "price", enable_dynamic_position = false
          #
          #     * "brands", enable_dynamic_position = false
          #
          #     And also you have a dynamic facets enable, which generates a facet
          #     "gender". Then, the final order of the facets in the response can be
          #     ("price", "brands", "rating", "gender") or ("price", "brands", "gender",
          #     "rating") depends on how Google Retail Search orders "gender" and
          #     "rating" facets. However, notice that "price" and "brands" are always
          #     ranked at first and second position because their enable_dynamic_position
          #     values are false.
          class FacetSpec
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Specifies how a facet is computed.
            # @!attribute [rw] key
            #   @return [::String]
            #     Required. Supported textual and numerical facet keys in
            #     {::Google::Cloud::Retail::V2::Product Product} object, over which the facet
            #     values are computed. Facet key is case-sensitive.
            #
            #     Allowed facet keys when
            #     {::Google::Cloud::Retail::V2::SearchRequest::FacetSpec::FacetKey#query FacetKey.query}
            #     is not specified:
            #
            #     * textual_field =
            #         * "brands"
            #         * "categories"
            #         * "genders"
            #         * "ageGroups"
            #         * "availability"
            #         * "colorFamilies"
            #         * "colors"
            #         * "sizes"
            #         * "materials"
            #         * "patterns"
            #         * "conditions"
            #         * "attributes.key"
            #         * "pickupInStore"
            #         * "shipToStore"
            #         * "sameDayDelivery"
            #         * "nextDayDelivery"
            #         * "customFulfillment1"
            #         * "customFulfillment2"
            #         * "customFulfillment3"
            #         * "customFulfillment4"
            #         * "customFulfillment5"
            #         * "inventory(place_id,attributes.key)"
            #
            #     * numerical_field =
            #         * "price"
            #         * "discount"
            #         * "rating"
            #         * "ratingCount"
            #         * "attributes.key"
            #         * "inventory(place_id,price)"
            #         * "inventory(place_id,original_price)"
            #         * "inventory(place_id,attributes.key)"
            # @!attribute [rw] intervals
            #   @return [::Array<::Google::Cloud::Retail::V2::Interval>]
            #     Set only if values should be bucketized into intervals. Must be set
            #     for facets with numerical values. Must not be set for facet with text
            #     values. Maximum number of intervals is 40.
            #
            #     For all numerical facet keys that appear in the list of products from
            #     the catalog, the percentiles 0, 10, 30, 50, 70, 90, and 100 are
            #     computed from their distribution weekly. If the model assigns a high
            #     score to a numerical facet key and its intervals are not specified in
            #     the search request, these percentiles become the bounds
            #     for its intervals and are returned in the response. If the
            #     facet key intervals are specified in the request, then the specified
            #     intervals are returned instead.
            # @!attribute [rw] restricted_values
            #   @return [::Array<::String>]
            #     Only get facet for the given restricted values. For example, when using
            #     "pickupInStore" as key and set restricted values to
            #     ["store123", "store456"], only facets for "store123" and "store456" are
            #     returned. Only supported on predefined textual fields, custom textual
            #     attributes and fulfillments. Maximum is 20.
            #
            #     Must be set for the fulfillment facet keys:
            #
            #     * pickupInStore
            #
            #     * shipToStore
            #
            #     * sameDayDelivery
            #
            #     * nextDayDelivery
            #
            #     * customFulfillment1
            #
            #     * customFulfillment2
            #
            #     * customFulfillment3
            #
            #     * customFulfillment4
            #
            #     * customFulfillment5
            # @!attribute [rw] prefixes
            #   @return [::Array<::String>]
            #     Only get facet values that start with the given string prefix. For
            #     example, suppose "categories" has three values "Women > Shoe",
            #     "Women > Dress" and "Men > Shoe". If set "prefixes" to "Women", the
            #     "categories" facet gives only "Women > Shoe" and "Women > Dress".
            #     Only supported on textual fields. Maximum is 10.
            # @!attribute [rw] contains
            #   @return [::Array<::String>]
            #     Only get facet values that contains the given strings. For example,
            #     suppose "categories" has three values "Women > Shoe",
            #     "Women > Dress" and "Men > Shoe". If set "contains" to "Shoe", the
            #     "categories" facet gives only "Women > Shoe" and "Men > Shoe".
            #     Only supported on textual fields. Maximum is 10.
            # @!attribute [rw] case_insensitive
            #   @return [::Boolean]
            #     True to make facet keys case insensitive when getting faceting
            #     values with prefixes or contains; false otherwise.
            # @!attribute [rw] order_by
            #   @return [::String]
            #     The order in which
            #     {::Google::Cloud::Retail::V2::SearchResponse::Facet#values SearchResponse.Facet.values}
            #     are returned.
            #
            #     Allowed values are:
            #
            #     * "count desc", which means order by
            #     {::Google::Cloud::Retail::V2::SearchResponse::Facet::FacetValue#count SearchResponse.Facet.values.count}
            #     descending.
            #
            #     * "value desc", which means order by
            #     {::Google::Cloud::Retail::V2::SearchResponse::Facet::FacetValue#value SearchResponse.Facet.values.value}
            #     descending.
            #       Only applies to textual facets.
            #
            #     If not set, textual values are sorted in [natural
            #     order](https://en.wikipedia.org/wiki/Natural_sort_order); numerical
            #     intervals are sorted in the order given by
            #     {::Google::Cloud::Retail::V2::SearchRequest::FacetSpec::FacetKey#intervals FacetSpec.FacetKey.intervals};
            #     {::Google::Cloud::Retail::V2::FulfillmentInfo#place_ids FulfillmentInfo.place_ids}
            #     are sorted in the order given by
            #     {::Google::Cloud::Retail::V2::SearchRequest::FacetSpec::FacetKey#restricted_values FacetSpec.FacetKey.restricted_values}.
            # @!attribute [rw] query
            #   @return [::String]
            #     The query that is used to compute facet for the given facet key.
            #     When provided, it overrides the default behavior of facet
            #     computation. The query syntax is the same as a filter expression. See
            #     {::Google::Cloud::Retail::V2::SearchRequest#filter SearchRequest.filter} for
            #     detail syntax and limitations. Notice that there is no limitation on
            #     {::Google::Cloud::Retail::V2::SearchRequest::FacetSpec::FacetKey#key FacetKey.key}
            #     when query is specified.
            #
            #     In the response,
            #     {::Google::Cloud::Retail::V2::SearchResponse::Facet::FacetValue#value SearchResponse.Facet.values.value}
            #     is always "1" and
            #     {::Google::Cloud::Retail::V2::SearchResponse::Facet::FacetValue#count SearchResponse.Facet.values.count}
            #     is the number of results that match the query.
            #
            #     For example, you can set a customized facet for "shipToStore",
            #     where
            #     {::Google::Cloud::Retail::V2::SearchRequest::FacetSpec::FacetKey#key FacetKey.key}
            #     is "customizedShipToStore", and
            #     {::Google::Cloud::Retail::V2::SearchRequest::FacetSpec::FacetKey#query FacetKey.query}
            #     is "availability: ANY(\"IN_STOCK\") AND shipToStore: ANY(\"123\")".
            #     Then the facet counts the products that are both in stock and ship
            #     to store "123".
            # @!attribute [rw] return_min_max
            #   @return [::Boolean]
            #     Returns the min and max value for each numerical facet intervals.
            #     Ignored for textual facets.
            class FacetKey
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # The specifications of dynamically generated facets.
          # @!attribute [rw] mode
          #   @return [::Google::Cloud::Retail::V2::SearchRequest::DynamicFacetSpec::Mode]
          #     Mode of the DynamicFacet feature.
          #     Defaults to
          #     {::Google::Cloud::Retail::V2::SearchRequest::DynamicFacetSpec::Mode::DISABLED Mode.DISABLED}
          #     if it's unset.
          class DynamicFacetSpec
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Enum to control DynamicFacet mode
            module Mode
              # Default value.
              MODE_UNSPECIFIED = 0

              # Disable Dynamic Facet.
              DISABLED = 1

              # Automatic mode built by Google Retail Search.
              ENABLED = 2
            end
          end

          # Boost specification to boost certain items.
          # @!attribute [rw] condition_boost_specs
          #   @return [::Array<::Google::Cloud::Retail::V2::SearchRequest::BoostSpec::ConditionBoostSpec>]
          #     Condition boost specifications. If a product matches multiple conditions
          #     in the specifications, boost scores from these specifications are all
          #     applied and combined in a non-linear way. Maximum number of
          #     specifications is 20.
          # @!attribute [rw] skip_boost_spec_validation
          #   @return [::Boolean]
          #     Whether to skip boostspec validation. If this field is set to true,
          #     invalid
          #     {::Google::Cloud::Retail::V2::SearchRequest::BoostSpec#condition_boost_specs BoostSpec.condition_boost_specs}
          #     will be ignored and valid
          #     {::Google::Cloud::Retail::V2::SearchRequest::BoostSpec#condition_boost_specs BoostSpec.condition_boost_specs}
          #     will still be applied.
          class BoostSpec
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Boost applies to products which match a condition.
            # @!attribute [rw] condition
            #   @return [::String]
            #     An expression which specifies a boost condition. The syntax and
            #     supported fields are the same as a filter expression. See
            #     {::Google::Cloud::Retail::V2::SearchRequest#filter SearchRequest.filter} for
            #     detail syntax and limitations.
            #
            #     Examples:
            #
            #     * To boost products with product ID "product_1" or "product_2", and
            #     color
            #       "Red" or "Blue":
            #         * (id: ANY("product_1", "product_2")) AND (colorFamilies:
            #         ANY("Red","Blue"))
            # @!attribute [rw] boost
            #   @return [::Float]
            #     Strength of the condition boost, which should be in [-1, 1]. Negative
            #     boost means demotion. Default is 0.0.
            #
            #     Setting to 1.0 gives the item a big promotion. However, it does not
            #     necessarily mean that the boosted item will be the top result at all
            #     times, nor that other items will be excluded. Results could still be
            #     shown even when none of them matches the condition. And results that
            #     are significantly more relevant to the search query can still trump
            #     your heavily favored but irrelevant items.
            #
            #     Setting to -1.0 gives the item a big demotion. However, results that
            #     are deeply relevant might still be shown. The item will have an
            #     upstream battle to get a fairly high ranking, but it is not blocked out
            #     completely.
            #
            #     Setting to 0.0 means no boost applied. The boosting condition is
            #     ignored.
            class ConditionBoostSpec
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Specification to determine under which conditions query expansion should
          # occur.
          # @!attribute [rw] condition
          #   @return [::Google::Cloud::Retail::V2::SearchRequest::QueryExpansionSpec::Condition]
          #     The condition under which query expansion should occur. Default to
          #     {::Google::Cloud::Retail::V2::SearchRequest::QueryExpansionSpec::Condition::DISABLED Condition.DISABLED}.
          # @!attribute [rw] pin_unexpanded_results
          #   @return [::Boolean]
          #     Whether to pin unexpanded results. The default value is false. If this
          #     field is set to true,
          #     unexpanded products are always at the top of the search results, followed
          #     by the expanded results.
          class QueryExpansionSpec
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Enum describing under which condition query expansion should occur.
            module Condition
              # Unspecified query expansion condition. In this case, server behavior
              # defaults to
              # {::Google::Cloud::Retail::V2::SearchRequest::QueryExpansionSpec::Condition::DISABLED Condition.DISABLED}.
              CONDITION_UNSPECIFIED = 0

              # Disabled query expansion. Only the exact search query is used, even if
              # {::Google::Cloud::Retail::V2::SearchResponse#total_size SearchResponse.total_size}
              # is zero.
              DISABLED = 1

              # Automatic query expansion built by Google Retail Search.
              AUTO = 3
            end
          end

          # The specification for personalization.
          # @!attribute [rw] mode
          #   @return [::Google::Cloud::Retail::V2::SearchRequest::PersonalizationSpec::Mode]
          #     Defaults to
          #     {::Google::Cloud::Retail::V2::SearchRequest::PersonalizationSpec::Mode::AUTO Mode.AUTO}.
          class PersonalizationSpec
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The personalization mode of each search request.
            module Mode
              # Default value. In this case, server behavior defaults to
              # {::Google::Cloud::Retail::V2::SearchRequest::PersonalizationSpec::Mode::AUTO Mode.AUTO}.
              MODE_UNSPECIFIED = 0

              # Let CRS decide whether to use personalization based on quality of user
              # event data.
              AUTO = 1

              # Disable personalization.
              DISABLED = 2
            end
          end

          # The specification for query spell correction.
          # @!attribute [rw] mode
          #   @return [::Google::Cloud::Retail::V2::SearchRequest::SpellCorrectionSpec::Mode]
          #     The mode under which spell correction should take effect to
          #     replace the original search query. Default to
          #     {::Google::Cloud::Retail::V2::SearchRequest::SpellCorrectionSpec::Mode::AUTO Mode.AUTO}.
          class SpellCorrectionSpec
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Enum describing under which mode spell correction should occur.
            module Mode
              # Unspecified spell correction mode. In this case, server behavior
              # defaults to
              # {::Google::Cloud::Retail::V2::SearchRequest::SpellCorrectionSpec::Mode::AUTO Mode.AUTO}.
              MODE_UNSPECIFIED = 0

              # Google Retail Search will try to find a spell suggestion if there
              # is any and put in the
              # {::Google::Cloud::Retail::V2::SearchResponse#corrected_query SearchResponse.corrected_query}.
              # The spell suggestion will not be used as the search query.
              SUGGESTION_ONLY = 1

              # Automatic spell correction built by Google Retail Search. Search will
              # be based on the corrected query if found.
              AUTO = 2
            end
          end

          # This field specifies all conversational related parameters addition to
          # traditional retail search.
          # @!attribute [rw] followup_conversation_requested
          #   @return [::Boolean]
          #     This field specifies whether the customer would like to do conversational
          #     search. If this field is set to true, conversational related extra
          #     information will be returned from server side, including follow-up
          #     question, answer options, etc.
          # @!attribute [rw] conversation_id
          #   @return [::String]
          #     This field specifies the conversation id, which maintains the state of
          #     the conversation between client side and server side. Use the value from
          #     the previous [ConversationalSearchResult.conversation_id][]. For the
          #     initial request, this should be empty.
          # @!attribute [rw] user_answer
          #   @return [::Google::Cloud::Retail::V2::SearchRequest::ConversationalSearchSpec::UserAnswer]
          #     This field specifies the current user answer during the conversational
          #     search. This can be either user selected from suggested answers or user
          #     input plain text.
          class ConversationalSearchSpec
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # This field specifies the current user answer during the conversational
            # search. This can be either user selected from suggested answers or user
            # input plain text.
            # @!attribute [rw] text_answer
            #   @return [::String]
            #     This field specifies the incremental input text from the user during
            #     the conversational search.
            #
            #     Note: The following fields are mutually exclusive: `text_answer`, `selected_answer`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] selected_answer
            #   @return [::Google::Cloud::Retail::V2::SearchRequest::ConversationalSearchSpec::UserAnswer::SelectedAnswer]
            #     This field specifies the selected attributes during the
            #     conversational search. This should be a subset of
            #     [ConversationalSearchResult.suggested_answers][].
            #
            #     Note: The following fields are mutually exclusive: `selected_answer`, `text_answer`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            class UserAnswer
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # This field specifies the selected answers during the conversational
              # search.
              # @!attribute [rw] product_attribute_values
              #   @deprecated This field is deprecated and may be removed in the next major version update.
              #   @return [::Array<::Google::Cloud::Retail::V2::ProductAttributeValue>]
              #     This field is deprecated and should not be set.
              # @!attribute [rw] product_attribute_value
              #   @return [::Google::Cloud::Retail::V2::ProductAttributeValue]
              #     This field specifies the selected answer which is a attribute
              #     key-value.
              class SelectedAnswer
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end
            end
          end

          # This field specifies tile navigation related parameters.
          # @!attribute [rw] tile_navigation_requested
          #   @return [::Boolean]
          #     This field specifies whether the customer would like to request tile
          #     navigation.
          # @!attribute [rw] applied_tiles
          #   @return [::Array<::Google::Cloud::Retail::V2::Tile>]
          #     This optional field specifies the tiles which are already clicked in
          #     client side. While the feature works without this field set, particularly
          #     for an initial query, it is highly recommended to set this field because
          #     it can improve the quality of the search response and removes possible
          #     duplicate tiles.
          #
          #     NOTE: This field is not being used for filtering search
          #     products. Client side should also put all the applied tiles in
          #     {::Google::Cloud::Retail::V2::SearchRequest#filter SearchRequest.filter}.
          class TileNavigationSpec
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::Retail::V2::StringList]
          class UserAttributesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The search mode of each search request.
          module SearchMode
            # Default value. In this case both product search and faceted search will
            # be performed. Both
            # {::Google::Cloud::Retail::V2::SearchResponse::SearchResult SearchResponse.SearchResult}
            # and {::Google::Cloud::Retail::V2::SearchResponse::Facet SearchResponse.Facet}
            # will be returned.
            SEARCH_MODE_UNSPECIFIED = 0

            # Only product search will be performed. The faceted search will be
            # disabled.
            #
            # Only
            # {::Google::Cloud::Retail::V2::SearchResponse::SearchResult SearchResponse.SearchResult}
            # will be returned.
            # {::Google::Cloud::Retail::V2::SearchResponse::Facet SearchResponse.Facet} will
            # not be returned, even if
            # {::Google::Cloud::Retail::V2::SearchRequest#facet_specs SearchRequest.facet_specs}
            # or
            # {::Google::Cloud::Retail::V2::SearchRequest#dynamic_facet_spec SearchRequest.dynamic_facet_spec}
            # is set.
            PRODUCT_SEARCH_ONLY = 1

            # Only faceted search will be performed. The product search will be
            # disabled.
            #
            # When in this mode, one or both of
            # {::Google::Cloud::Retail::V2::SearchRequest#facet_specs SearchRequest.facet_specs}
            # and
            # {::Google::Cloud::Retail::V2::SearchRequest#dynamic_facet_spec SearchRequest.dynamic_facet_spec}
            # should be set. Otherwise, an INVALID_ARGUMENT error is returned. Only
            # {::Google::Cloud::Retail::V2::SearchResponse::Facet SearchResponse.Facet} will
            # be returned.
            # {::Google::Cloud::Retail::V2::SearchResponse::SearchResult SearchResponse.SearchResult}
            # will not be returned.
            FACETED_SEARCH_ONLY = 2
          end
        end

        # Response message for
        # {::Google::Cloud::Retail::V2::SearchService::Client#search SearchService.Search} method.
        # @!attribute [rw] results
        #   @return [::Array<::Google::Cloud::Retail::V2::SearchResponse::SearchResult>]
        #     A list of matched items. The order represents the ranking.
        # @!attribute [rw] facets
        #   @return [::Array<::Google::Cloud::Retail::V2::SearchResponse::Facet>]
        #     Results of facets requested by user.
        # @!attribute [rw] total_size
        #   @return [::Integer]
        #     The estimated total count of matched items irrespective of pagination. The
        #     count of {::Google::Cloud::Retail::V2::SearchResponse#results results} returned
        #     by pagination may be less than the
        #     {::Google::Cloud::Retail::V2::SearchResponse#total_size total_size} that
        #     matches.
        # @!attribute [rw] corrected_query
        #   @return [::String]
        #     Contains the spell corrected query, if found. If the spell correction type
        #     is AUTOMATIC, then the search results are based on corrected_query.
        #     Otherwise the original query is used for search.
        # @!attribute [rw] attribution_token
        #   @return [::String]
        #     A unique search token. This should be included in the
        #     {::Google::Cloud::Retail::V2::UserEvent UserEvent} logs resulting from this
        #     search, which enables accurate attribution of search model performance.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token that can be sent as
        #     {::Google::Cloud::Retail::V2::SearchRequest#page_token SearchRequest.page_token}
        #     to retrieve the next page. If this field is omitted, there are no
        #     subsequent pages.
        # @!attribute [rw] query_expansion_info
        #   @return [::Google::Cloud::Retail::V2::SearchResponse::QueryExpansionInfo]
        #     Query expansion information for the returned results.
        # @!attribute [rw] redirect_uri
        #   @return [::String]
        #     The URI of a customer-defined redirect page. If redirect action is
        #     triggered, no search is performed, and only
        #     {::Google::Cloud::Retail::V2::SearchResponse#redirect_uri redirect_uri} and
        #     {::Google::Cloud::Retail::V2::SearchResponse#attribution_token attribution_token}
        #     are set in the response.
        # @!attribute [rw] applied_controls
        #   @return [::Array<::String>]
        #     The fully qualified resource name of applied
        #     [controls](https://cloud.google.com/retail/docs/serving-control-rules).
        # @!attribute [rw] pin_control_metadata
        #   @return [::Google::Cloud::Retail::V2::PinControlMetadata]
        #     Metadata for pin controls which were applicable to the request.
        #     This contains two map fields, one for all matched pins and one for pins
        #     which were matched but not applied.
        #
        #     The two maps are keyed by pin position, and the values are the product ids
        #     which were matched to that pin.
        # @!attribute [rw] invalid_condition_boost_specs
        #   @return [::Array<::Google::Cloud::Retail::V2::SearchRequest::BoostSpec::ConditionBoostSpec>]
        #     The invalid
        #     {::Google::Cloud::Retail::V2::SearchRequest::BoostSpec#condition_boost_specs SearchRequest.BoostSpec.condition_boost_specs}
        #     that are not applied during serving.
        # @!attribute [rw] experiment_info
        #   @return [::Array<::Google::Cloud::Retail::V2::ExperimentInfo>]
        #     Metadata related to A/B testing experiment associated with this
        #     response. Only exists when an experiment is triggered.
        # @!attribute [rw] conversational_search_result
        #   @return [::Google::Cloud::Retail::V2::SearchResponse::ConversationalSearchResult]
        #     This field specifies all related information that is needed on client
        #     side for UI rendering of conversational retail search.
        # @!attribute [rw] tile_navigation_result
        #   @return [::Google::Cloud::Retail::V2::SearchResponse::TileNavigationResult]
        #     This field specifies all related information for tile navigation that will
        #     be used in client side.
        class SearchResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Represents the search results.
          # @!attribute [rw] id
          #   @return [::String]
          #     {::Google::Cloud::Retail::V2::Product#id Product.id} of the searched
          #     {::Google::Cloud::Retail::V2::Product Product}.
          # @!attribute [rw] product
          #   @return [::Google::Cloud::Retail::V2::Product]
          #     The product data snippet in the search response. Only
          #     {::Google::Cloud::Retail::V2::Product#name Product.name} is guaranteed to be
          #     populated.
          #
          #     {::Google::Cloud::Retail::V2::Product#variants Product.variants} contains the
          #     product variants that match the search query. If there are multiple
          #     product variants matching the query, top 5 most relevant product variants
          #     are returned and ordered by relevancy.
          #
          #     If relevancy can be deternmined, use
          #     {::Google::Cloud::Retail::V2::SearchResponse::SearchResult#matching_variant_fields matching_variant_fields}
          #     to look up matched product variants fields. If relevancy cannot be
          #     determined, e.g. when searching "shoe" all products in a shoe product can
          #     be a match, 5 product variants are returned but order is meaningless.
          # @!attribute [rw] matching_variant_count
          #   @return [::Integer]
          #     The count of matched
          #     {::Google::Cloud::Retail::V2::Product::Type::VARIANT variant}
          #     {::Google::Cloud::Retail::V2::Product Product}s.
          # @!attribute [rw] matching_variant_fields
          #   @return [::Google::Protobuf::Map{::String => ::Google::Protobuf::FieldMask}]
          #     If a {::Google::Cloud::Retail::V2::Product::Type::VARIANT variant}
          #     {::Google::Cloud::Retail::V2::Product Product} matches the search query, this
          #     map indicates which {::Google::Cloud::Retail::V2::Product Product} fields are
          #     matched. The key is the
          #     {::Google::Cloud::Retail::V2::Product#name Product.name}, the value is a field
          #     mask of the matched {::Google::Cloud::Retail::V2::Product Product} fields. If
          #     matched attributes cannot be determined, this map will be empty.
          #
          #     For example, a key "sku1" with field mask
          #     "products.color_info" indicates there is a match between
          #     "sku1" {::Google::Cloud::Retail::V2::ColorInfo ColorInfo} and the query.
          # @!attribute [rw] variant_rollup_values
          #   @return [::Google::Protobuf::Map{::String => ::Google::Protobuf::Value}]
          #     The rollup matching
          #     {::Google::Cloud::Retail::V2::Product::Type::VARIANT variant}
          #     {::Google::Cloud::Retail::V2::Product Product} attributes. The key is one of
          #     the
          #     {::Google::Cloud::Retail::V2::SearchRequest#variant_rollup_keys SearchRequest.variant_rollup_keys}.
          #     The values are the merged and de-duplicated
          #     {::Google::Cloud::Retail::V2::Product Product} attributes. Notice that the
          #     rollup values are respect filter. For example, when filtering by
          #     "colorFamilies:ANY(\"red\")" and rollup "colorFamilies", only "red" is
          #     returned.
          #
          #     For textual and numerical attributes, the rollup values is a list of
          #     string or double values with type
          #     {::Google::Protobuf::ListValue google.protobuf.ListValue}. For example, if
          #     there are two variants with colors "red" and "blue", the rollup values
          #     are
          #
          #         { key: "colorFamilies"
          #           value {
          #             list_value {
          #               values { string_value: "red" }
          #               values { string_value: "blue" }
          #              }
          #           }
          #         }
          #
          #     For {::Google::Cloud::Retail::V2::FulfillmentInfo FulfillmentInfo}, the rollup
          #     values is a double value with type
          #     {::Google::Protobuf::Value google.protobuf.Value}. For example,
          #     `{key: "pickupInStore.store1" value { number_value: 10 }}` means a there
          #     are 10 variants in this product are available in the store "store1".
          # @!attribute [rw] personal_labels
          #   @return [::Array<::String>]
          #     Specifies previous events related to this product for this user based on
          #     {::Google::Cloud::Retail::V2::UserEvent UserEvent} with same
          #     {::Google::Cloud::Retail::V2::SearchRequest#visitor_id SearchRequest.visitor_id}
          #     or {::Google::Cloud::Retail::V2::UserInfo#user_id UserInfo.user_id}.
          #
          #     This is set only when
          #     {::Google::Cloud::Retail::V2::SearchRequest::PersonalizationSpec#mode SearchRequest.PersonalizationSpec.mode}
          #     is
          #     {::Google::Cloud::Retail::V2::SearchRequest::PersonalizationSpec::Mode::AUTO SearchRequest.PersonalizationSpec.Mode.AUTO}.
          #
          #     Possible values:
          #
          #     * `purchased`: Indicates that this product has been purchased before.
          # @!attribute [rw] model_scores
          #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Retail::V2::DoubleList}]
          #     Google provided available scores.
          class SearchResult
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::Google::Protobuf::FieldMask]
            class MatchingVariantFieldsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::Google::Protobuf::Value]
            class VariantRollupValuesEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::Google::Cloud::Retail::V2::DoubleList]
            class ModelScoresEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # A facet result.
          # @!attribute [rw] key
          #   @return [::String]
          #     The key for this facet. E.g., "colorFamilies" or "price" or
          #     "attributes.attr1".
          # @!attribute [rw] values
          #   @return [::Array<::Google::Cloud::Retail::V2::SearchResponse::Facet::FacetValue>]
          #     The facet values for this field.
          # @!attribute [rw] dynamic_facet
          #   @return [::Boolean]
          #     Whether the facet is dynamically generated.
          class Facet
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # A facet value which contains value names and their count.
            # @!attribute [rw] value
            #   @return [::String]
            #     Text value of a facet, such as "Black" for facet "colorFamilies".
            #
            #     Note: The following fields are mutually exclusive: `value`, `interval`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] interval
            #   @return [::Google::Cloud::Retail::V2::Interval]
            #     Interval value for a facet, such as [10, 20) for facet "price".
            #
            #     Note: The following fields are mutually exclusive: `interval`, `value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] count
            #   @return [::Integer]
            #     Number of items that have this facet value.
            # @!attribute [rw] min_value
            #   @return [::Float]
            #     The minimum value in the
            #     {::Google::Cloud::Retail::V2::SearchResponse::Facet::FacetValue#interval FacetValue.interval}.
            #     Only supported on numerical facets and returned if
            #     {::Google::Cloud::Retail::V2::SearchRequest::FacetSpec::FacetKey#return_min_max SearchRequest.FacetSpec.FacetKey.return_min_max}
            #     is true.
            # @!attribute [rw] max_value
            #   @return [::Float]
            #     The maximum value in the
            #     {::Google::Cloud::Retail::V2::SearchResponse::Facet::FacetValue#interval FacetValue.interval}.
            #     Only supported on numerical facets and returned if
            #     {::Google::Cloud::Retail::V2::SearchRequest::FacetSpec::FacetKey#return_min_max SearchRequest.FacetSpec.FacetKey.return_min_max}
            #     is true.
            class FacetValue
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Information describing query expansion including whether expansion has
          # occurred.
          # @!attribute [rw] expanded_query
          #   @return [::Boolean]
          #     Bool describing whether query expansion has occurred.
          # @!attribute [rw] pinned_result_count
          #   @return [::Integer]
          #     Number of pinned results. This field will only be set when expansion
          #     happens and
          #     {::Google::Cloud::Retail::V2::SearchRequest::QueryExpansionSpec#pin_unexpanded_results SearchRequest.QueryExpansionSpec.pin_unexpanded_results}
          #     is set to true.
          class QueryExpansionInfo
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # This field specifies all related information that is needed on client
          # side for UI rendering of conversational retail search.
          # @!attribute [rw] conversation_id
          #   @return [::String]
          #     Conversation UUID. This field will be stored in client side storage to
          #     maintain the conversation session with server and will be used for next
          #     search request's
          #     {::Google::Cloud::Retail::V2::SearchRequest::ConversationalSearchSpec#conversation_id SearchRequest.ConversationalSearchSpec.conversation_id}
          #     to restore conversation state in server.
          # @!attribute [rw] refined_query
          #   @return [::String]
          #     The current refined query for the conversational search. This field
          #     will be used in customer UI that the query in the search bar should be
          #     replaced with the refined query. For example, if
          #     {::Google::Cloud::Retail::V2::SearchRequest#query SearchRequest.query} is
          #     `dress` and next
          #     {::Google::Cloud::Retail::V2::SearchRequest::ConversationalSearchSpec::UserAnswer#text_answer SearchRequest.ConversationalSearchSpec.UserAnswer.text_answer}
          #     is `red color`, which does not match any product attribute value filters,
          #     the refined query will be `dress, red color`.
          # @!attribute [rw] additional_filters
          #   @deprecated This field is deprecated and may be removed in the next major version update.
          #   @return [::Array<::Google::Cloud::Retail::V2::SearchResponse::ConversationalSearchResult::AdditionalFilter>]
          #     This field is deprecated but will be kept for backward compatibility.
          #     There is expected to have only one additional filter and the value will
          #     be the same to the same as field `additional_filter`.
          # @!attribute [rw] followup_question
          #   @return [::String]
          #     The follow-up question. e.g., `What is the color?`
          # @!attribute [rw] suggested_answers
          #   @return [::Array<::Google::Cloud::Retail::V2::SearchResponse::ConversationalSearchResult::SuggestedAnswer>]
          #     The answer options provided to client for the follow-up question.
          # @!attribute [rw] additional_filter
          #   @return [::Google::Cloud::Retail::V2::SearchResponse::ConversationalSearchResult::AdditionalFilter]
          #     This is the incremental additional filters implied from the current
          #     user answer. User should add the suggested addition filters to the
          #     previous
          #     {::Google::Cloud::Retail::V2::SearchRequest#filter SearchRequest.filter},  and
          #     use the merged filter in the follow up search request.
          class ConversationalSearchResult
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Suggested answers to the follow-up question.
            # @!attribute [rw] product_attribute_value
            #   @return [::Google::Cloud::Retail::V2::ProductAttributeValue]
            #     Product attribute value, including an attribute key and an
            #     attribute value. Other types can be added here in the future.
            class SuggestedAnswer
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Additional filter that client side need to apply.
            # @!attribute [rw] product_attribute_value
            #   @return [::Google::Cloud::Retail::V2::ProductAttributeValue]
            #     Product attribute value, including an attribute key and an
            #     attribute value. Other types can be added here in the future.
            class AdditionalFilter
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # This field specifies all related information for tile navigation that will
          # be used in client side.
          # @!attribute [rw] tiles
          #   @return [::Array<::Google::Cloud::Retail::V2::Tile>]
          #     The current tiles that are used for tile navigation, sorted by
          #     engagement.
          class TileNavigationResult
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Metadata for active A/B testing experiment.
        # @!attribute [rw] serving_config_experiment
        #   @return [::Google::Cloud::Retail::V2::ExperimentInfo::ServingConfigExperiment]
        #     A/B test between existing Cloud Retail Search
        #     {::Google::Cloud::Retail::V2::ServingConfig ServingConfig}s.
        # @!attribute [rw] experiment
        #   @return [::String]
        #     The fully qualified resource name of the experiment that provides the
        #     serving config under test, should an active experiment exist. For example:
        #     `projects/*/locations/global/catalogs/default_catalog/experiments/experiment_id`
        class ExperimentInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Metadata for active serving config A/B tests.
          # @!attribute [rw] original_serving_config
          #   @return [::String]
          #     The fully qualified resource name of the original
          #     {::Google::Cloud::Retail::V2::SearchRequest#placement SearchRequest.placement}
          #     in the search request prior to reassignment by experiment API. For
          #     example: `projects/*/locations/*/catalogs/*/servingConfigs/*`.
          # @!attribute [rw] experiment_serving_config
          #   @return [::String]
          #     The fully qualified resource name of the serving config
          #     `Experiment.VariantArm.serving_config_id` responsible for generating
          #     the search response. For example:
          #     `projects/*/locations/*/catalogs/*/servingConfigs/*`.
          class ServingConfigExperiment
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
