# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Retail
      module V2
        # Safety settings.
        # @!attribute [rw] category
        #   @return [::Google::Cloud::Retail::V2::HarmCategory]
        #     Harm category.
        # @!attribute [rw] threshold
        #   @return [::Google::Cloud::Retail::V2::SafetySetting::HarmBlockThreshold]
        #     The harm block threshold.
        # @!attribute [rw] method
        #   @return [::Google::Cloud::Retail::V2::SafetySetting::HarmBlockMethod]
        #     Optional. Specify if the threshold is used for probability or severity
        #     score. If not specified, the threshold is used for probability score.
        class SafetySetting
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Probability based thresholds levels for blocking.
          module HarmBlockThreshold
            # Unspecified harm block threshold.
            HARM_BLOCK_THRESHOLD_UNSPECIFIED = 0

            # Block low threshold and above (i.e. block more).
            BLOCK_LOW_AND_ABOVE = 1

            # Block medium threshold and above.
            BLOCK_MEDIUM_AND_ABOVE = 2

            # Block only high threshold (i.e. block less).
            BLOCK_ONLY_HIGH = 3

            # Block none.
            BLOCK_NONE = 4

            # Turn off the safety filter.
            OFF = 5
          end

          # Probability vs severity.
          module HarmBlockMethod
            # The harm block method is unspecified.
            HARM_BLOCK_METHOD_UNSPECIFIED = 0

            # The harm block method uses both probability and severity scores.
            SEVERITY = 1

            # The harm block method uses the probability score.
            PROBABILITY = 2
          end
        end

        # Harm categories that will block the content.
        module HarmCategory
          # The harm category is unspecified.
          HARM_CATEGORY_UNSPECIFIED = 0

          # The harm category is hate speech.
          HARM_CATEGORY_HATE_SPEECH = 1

          # The harm category is dangerous content.
          HARM_CATEGORY_DANGEROUS_CONTENT = 2

          # The harm category is harassment.
          HARM_CATEGORY_HARASSMENT = 3

          # The harm category is sexually explicit content.
          HARM_CATEGORY_SEXUALLY_EXPLICIT = 4

          # The harm category is civic integrity.
          HARM_CATEGORY_CIVIC_INTEGRITY = 5
        end
      end
    end
  end
end
