# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Retail
      module V2
        # Request for creating a model.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource under which to create the model. Format:
        #     `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}`
        # @!attribute [rw] model
        #   @return [::Google::Cloud::Retail::V2::Model]
        #     Required. The payload of the {::Google::Cloud::Retail::V2::Model Model}  to
        #     create.
        # @!attribute [rw] dry_run
        #   @return [::Boolean]
        #     Optional. Whether to run a dry run to validate the request (without
        #     actually creating the model).
        class CreateModelRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for updating an existing model.
        # @!attribute [rw] model
        #   @return [::Google::Cloud::Retail::V2::Model]
        #     Required. The body of the updated {::Google::Cloud::Retail::V2::Model Model}.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Indicates which fields in the provided 'model' to
        #     update. If not set, by default updates all fields.
        class UpdateModelRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for getting a model.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the {::Google::Cloud::Retail::V2::Model Model} to
        #     get. Format:
        #     `projects/{project_number}/locations/{location_id}/catalogs/{catalog}/models/{model_id}`
        class GetModelRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for pausing training of a model.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the model to pause.
        #     Format:
        #     `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/models/{model_id}`
        class PauseModelRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for resuming training of a model.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the model to resume.
        #     Format:
        #     `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/models/{model_id}`
        class ResumeModelRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for listing models associated with a resource.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent for which to list models.
        #     Format:
        #     `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Maximum number of results to return. If unspecified, defaults
        #     to 50. Max allowed value is 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous `ListModels`
        #     call. Provide this to retrieve the subsequent page.
        class ListModelsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for deleting a model.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the {::Google::Cloud::Retail::V2::Model Model} to
        #     delete. Format:
        #     `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/models/{model_id}`
        class DeleteModelRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response to a ListModelRequest.
        # @!attribute [rw] models
        #   @return [::Array<::Google::Cloud::Retail::V2::Model>]
        #     List of Models.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Pagination token, if not returned indicates the last page.
        class ListModelsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to manually start a tuning process now (instead of waiting for
        # the periodically scheduled tuning to happen).
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the model to tune.
        #     Format:
        #     `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/models/{model_id}`
        class TuneModelRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata associated with a create operation.
        # @!attribute [rw] model
        #   @return [::String]
        #     The resource name of the model that this create applies to.
        #     Format:
        #     `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/models/{model_id}`
        class CreateModelMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata associated with a tune operation.
        # @!attribute [rw] model
        #   @return [::String]
        #     The resource name of the model that this tune applies to.
        #     Format:
        #     `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/models/{model_id}`
        class TuneModelMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response associated with a tune operation.
        class TuneModelResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
