# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Retail
      module V2
        # Metadata that describes the training and serving parameters of a
        # {::Google::Cloud::Retail::V2::Model Model}. A
        # {::Google::Cloud::Retail::V2::Model Model} can be associated with a
        # {::Google::Cloud::Retail::V2::ServingConfig ServingConfig} and then queried
        # through the Predict API.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The fully qualified resource name of the model.
        #
        #     Format:
        #     `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/models/{model_id}`
        #     catalog_id has char limit of 50.
        #     recommendation_model_id has char limit of 40.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. The display name of the model.
        #
        #     Should be human readable, used to display Recommendation Models in the
        #     Retail Cloud Console Dashboard. UTF-8 encoded string with limit of 1024
        #     characters.
        # @!attribute [rw] training_state
        #   @return [::Google::Cloud::Retail::V2::Model::TrainingState]
        #     Optional. The training state that the model is in (e.g.
        #     `TRAINING` or `PAUSED`).
        #
        #     Since part of the cost of running the service
        #     is frequency of training - this can be used to determine when to train
        #     model in order to control cost. If not specified: the default value for
        #     `CreateModel` method is `TRAINING`. The default value for
        #     `UpdateModel` method is to keep the state the same as before.
        # @!attribute [r] serving_state
        #   @return [::Google::Cloud::Retail::V2::Model::ServingState]
        #     Output only. The serving state of the model: `ACTIVE`, `NOT_ACTIVE`.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp the Recommendation Model was created at.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp the Recommendation Model was last updated. E.g.
        #     if a Recommendation Model was paused - this would be the time the pause was
        #     initiated.
        # @!attribute [rw] type
        #   @return [::String]
        #     Required. The type of model e.g. `home-page`.
        #
        #     Currently supported values: `recommended-for-you`, `others-you-may-like`,
        #     `frequently-bought-together`, `page-optimization`, `similar-items`,
        #     `buy-it-again`, `on-sale-items`, and `recently-viewed`(readonly value).
        #
        #     This field together with
        #     {::Google::Cloud::Retail::V2::Model#optimization_objective optimization_objective}
        #     describe model metadata to use to control model training and serving.
        #     See https://cloud.google.com/retail/docs/models
        #     for more details on what the model metadata control and which combination
        #     of parameters are valid. For invalid combinations of parameters (e.g. type
        #     = `frequently-bought-together` and optimization_objective = `ctr`), you
        #     receive an error 400 if you try to create/update a recommendation with
        #     this set of knobs.
        # @!attribute [rw] optimization_objective
        #   @return [::String]
        #     Optional. The optimization objective e.g. `cvr`.
        #
        #     Currently supported
        #     values: `ctr`, `cvr`, `revenue-per-order`.
        #
        #      If not specified, we choose default based on model type.
        #     Default depends on type of recommendation:
        #
        #     `recommended-for-you` => `ctr`
        #
        #     `others-you-may-like` => `ctr`
        #
        #     `frequently-bought-together` => `revenue_per_order`
        #
        #     This field together with
        #     {::Google::Cloud::Retail::V2::Model#type optimization_objective}
        #     describe model metadata to use to control model training and serving.
        #     See https://cloud.google.com/retail/docs/models
        #     for more details on what the model metadata control and which combination
        #     of parameters are valid. For invalid combinations of parameters (e.g. type
        #     = `frequently-bought-together` and optimization_objective = `ctr`), you
        #     receive an error 400 if you try to create/update a recommendation with
        #     this set of knobs.
        # @!attribute [rw] periodic_tuning_state
        #   @return [::Google::Cloud::Retail::V2::Model::PeriodicTuningState]
        #     Optional. The state of periodic tuning.
        #
        #     The period we use is 3 months - to do a
        #     one-off tune earlier use the `TuneModel` method. Default value
        #     is `PERIODIC_TUNING_ENABLED`.
        # @!attribute [r] last_tune_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp when the latest successful tune finished.
        # @!attribute [r] tuning_operation
        #   @return [::String]
        #     Output only. The tune operation associated with the model.
        #
        #     Can be used to determine if there is an ongoing tune for this
        #     recommendation. Empty field implies no tune is goig on.
        # @!attribute [r] data_state
        #   @return [::Google::Cloud::Retail::V2::Model::DataState]
        #     Output only. The state of data requirements for this model: `DATA_OK` and
        #     `DATA_ERROR`.
        #
        #     Recommendation model cannot be trained if the data is in
        #     `DATA_ERROR` state. Recommendation model can have `DATA_ERROR` state even
        #     if serving state is `ACTIVE`: models were trained successfully before, but
        #     cannot be refreshed because model no longer has sufficient
        #     data for training.
        # @!attribute [rw] filtering_option
        #   @return [::Google::Cloud::Retail::V2::RecommendationsFilteringOption]
        #     Optional. If `RECOMMENDATIONS_FILTERING_ENABLED`, recommendation filtering
        #     by attributes is enabled for the model.
        # @!attribute [r] serving_config_lists
        #   @return [::Array<::Google::Cloud::Retail::V2::Model::ServingConfigList>]
        #     Output only. The list of valid serving configs associated with the
        #     PageOptimizationConfig.
        # @!attribute [rw] model_features_config
        #   @return [::Google::Cloud::Retail::V2::Model::ModelFeaturesConfig]
        #     Optional. Additional model features config.
        class Model
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Represents an ordered combination of valid serving configs, which
          # can be used for `PAGE_OPTIMIZATION` recommendations.
          # @!attribute [rw] serving_config_ids
          #   @return [::Array<::String>]
          #     Optional. A set of valid serving configs that may be used for
          #     `PAGE_OPTIMIZATION`.
          class ServingConfigList
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Additional configs for the frequently-bought-together model type.
          # @!attribute [rw] context_products_type
          #   @return [::Google::Cloud::Retail::V2::Model::ContextProductsType]
          #     Optional. Specifies the context of the model when it is used in predict
          #     requests. Can only be set for the `frequently-bought-together` type. If
          #     it isn't specified, it defaults to
          #     {::Google::Cloud::Retail::V2::Model::ContextProductsType::MULTIPLE_CONTEXT_PRODUCTS MULTIPLE_CONTEXT_PRODUCTS}.
          class FrequentlyBoughtTogetherFeaturesConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Additional model features config.
          # @!attribute [rw] frequently_bought_together_config
          #   @return [::Google::Cloud::Retail::V2::Model::FrequentlyBoughtTogetherFeaturesConfig]
          #     Additional configs for frequently-bought-together models.
          class ModelFeaturesConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The serving state of the model.
          module ServingState
            # Unspecified serving state.
            SERVING_STATE_UNSPECIFIED = 0

            # The model is not serving.
            INACTIVE = 1

            # The model is serving and can be queried.
            ACTIVE = 2

            # The model is trained on tuned hyperparameters and can be
            # queried.
            TUNED = 3
          end

          # The training state of the model.
          module TrainingState
            # Unspecified training state.
            TRAINING_STATE_UNSPECIFIED = 0

            # The model training is paused.
            PAUSED = 1

            # The model is training.
            TRAINING = 2
          end

          # Describes whether periodic tuning is enabled for this model
          # or not. Periodic tuning is scheduled at most every three months. You can
          # start a tuning process manually by using the `TuneModel`
          # method, which starts a tuning process immediately and resets the quarterly
          # schedule. Enabling or disabling periodic tuning does not affect any
          # current tuning processes.
          module PeriodicTuningState
            # Unspecified default value, should never be explicitly set.
            PERIODIC_TUNING_STATE_UNSPECIFIED = 0

            # The model has periodic tuning disabled. Tuning
            # can be reenabled by calling the `EnableModelPeriodicTuning`
            # method or by calling the `TuneModel` method.
            PERIODIC_TUNING_DISABLED = 1

            # The model cannot be tuned with periodic tuning OR the
            # `TuneModel` method. Hide the options in customer UI and
            # reject any requests through the backend self serve API.
            ALL_TUNING_DISABLED = 3

            # The model has periodic tuning enabled. Tuning
            # can be disabled by calling the `DisableModelPeriodicTuning`
            # method.
            PERIODIC_TUNING_ENABLED = 2
          end

          # Describes whether this model have sufficient training data
          # to be continuously trained.
          module DataState
            # Unspecified default value, should never be explicitly set.
            DATA_STATE_UNSPECIFIED = 0

            # The model has sufficient training data.
            DATA_OK = 1

            # The model does not have sufficient training data. Error
            # messages can be queried via Stackdriver.
            DATA_ERROR = 2
          end

          # Use single or multiple context products for recommendations.
          module ContextProductsType
            # Unspecified default value, should never be explicitly set.
            # Defaults to
            # {::Google::Cloud::Retail::V2::Model::ContextProductsType::MULTIPLE_CONTEXT_PRODUCTS MULTIPLE_CONTEXT_PRODUCTS}.
            CONTEXT_PRODUCTS_TYPE_UNSPECIFIED = 0

            # Use only a single product as context for the recommendation. Typically
            # used on pages like add-to-cart or product details.
            SINGLE_CONTEXT_PRODUCT = 1

            # Use one or multiple products as context for the recommendation. Typically
            # used on shopping cart pages.
            MULTIPLE_CONTEXT_PRODUCTS = 2
          end
        end
      end
    end
  end
end
