# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Retail
      module V2
        # Request for UpdateGenerativeQuestionsFeatureConfig method.
        # @!attribute [rw] generative_questions_feature_config
        #   @return [::Google::Cloud::Retail::V2::GenerativeQuestionsFeatureConfig]
        #     Required. The configuration managing the feature state.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Indicates which fields in the provided
        #     {::Google::Cloud::Retail::V2::GenerativeQuestionsFeatureConfig GenerativeQuestionsFeatureConfig}
        #     to update. If not set or empty, all supported fields are updated.
        class UpdateGenerativeQuestionsFeatureConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for GetGenerativeQuestionsFeatureConfig method.
        # @!attribute [rw] catalog
        #   @return [::String]
        #     Required. Resource name of the parent catalog.
        #     Format: projects/\\{project}/locations/\\{location}/catalogs/\\{catalog}
        class GetGenerativeQuestionsFeatureConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for ListQuestions method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Resource name of the parent catalog.
        #     Format: projects/\\{project}/locations/\\{location}/catalogs/\\{catalog}
        class ListGenerativeQuestionConfigsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for ListQuestions method.
        # @!attribute [rw] generative_question_configs
        #   @return [::Array<::Google::Cloud::Retail::V2::GenerativeQuestionConfig>]
        #     All the questions for a given catalog.
        class ListGenerativeQuestionConfigsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for UpdateGenerativeQuestionConfig method.
        # @!attribute [rw] generative_question_config
        #   @return [::Google::Cloud::Retail::V2::GenerativeQuestionConfig]
        #     Required. The question to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Indicates which fields in the provided
        #     {::Google::Cloud::Retail::V2::GenerativeQuestionConfig GenerativeQuestionConfig}
        #     to update. The following are NOT supported:
        #
        #     * {::Google::Cloud::Retail::V2::GenerativeQuestionConfig#frequency GenerativeQuestionConfig.frequency}
        #
        #     If not set or empty, all supported fields are updated.
        class UpdateGenerativeQuestionConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for BatchUpdateGenerativeQuestionConfig method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Optional. Resource name of the parent catalog.
        #     Format: projects/\\{project}/locations/\\{location}/catalogs/\\{catalog}
        # @!attribute [rw] requests
        #   @return [::Array<::Google::Cloud::Retail::V2::UpdateGenerativeQuestionConfigRequest>]
        #     Required. The updates question configs.
        class BatchUpdateGenerativeQuestionConfigsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Aggregated response for UpdateGenerativeQuestionConfig method.
        # @!attribute [rw] generative_question_configs
        #   @return [::Array<::Google::Cloud::Retail::V2::GenerativeQuestionConfig>]
        #     Optional. The updates question configs.
        class BatchUpdateGenerativeQuestionConfigsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
