# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Retail
      module V2
        # Configuration for overall generative question feature state.
        # @!attribute [rw] catalog
        #   @return [::String]
        #     Required. Resource name of the affected catalog.
        #     Format: projects/\\{project}/locations/\\{location}/catalogs/\\{catalog}
        # @!attribute [rw] feature_enabled
        #   @return [::Boolean]
        #     Optional. Determines whether questions will be used at serving time.
        #     Note: This feature cannot be enabled until initial data requirements are
        #     satisfied.
        # @!attribute [rw] minimum_products
        #   @return [::Integer]
        #     Optional. Minimum number of products in the response to trigger follow-up
        #     questions. Value must be 0 or positive.
        class GenerativeQuestionsFeatureConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration for a single generated question.
        # @!attribute [rw] catalog
        #   @return [::String]
        #     Required. Resource name of the catalog.
        #     Format: projects/\\{project}/locations/\\{location}/catalogs/\\{catalog}
        # @!attribute [rw] facet
        #   @return [::String]
        #     Required. The facet to which the question is associated.
        # @!attribute [r] generated_question
        #   @return [::String]
        #     Output only. The LLM generated question.
        # @!attribute [rw] final_question
        #   @return [::String]
        #     Optional. The question that will be used at serving time.
        #     Question can have a max length of 300 bytes.
        #     When not populated, generated_question should be used.
        # @!attribute [r] example_values
        #   @return [::Array<::String>]
        #     Output only. Values that can be used to answer the question.
        # @!attribute [r] frequency
        #   @return [::Float]
        #     Output only. The ratio of how often a question was asked.
        # @!attribute [rw] allowed_in_conversation
        #   @return [::Boolean]
        #     Optional. Whether the question is asked at serving time.
        class GenerativeQuestionConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
