# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Retail
      module V2
        # The output configuration setting.
        # @!attribute [rw] gcs_destination
        #   @return [::Google::Cloud::Retail::V2::OutputConfig::GcsDestination]
        #     The Google Cloud Storage location where the output is to be written to.
        #
        #     Note: The following fields are mutually exclusive: `gcs_destination`, `bigquery_destination`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] bigquery_destination
        #   @return [::Google::Cloud::Retail::V2::OutputConfig::BigQueryDestination]
        #     The BigQuery location where the output is to be written to.
        #
        #     Note: The following fields are mutually exclusive: `bigquery_destination`, `gcs_destination`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class OutputConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The Google Cloud Storage output destination configuration.
          # @!attribute [rw] output_uri_prefix
          #   @return [::String]
          #     Required. The output uri prefix for saving output data to json files.
          #     Some mapping examples are as follows:
          #     output_uri_prefix         sample output(assuming the object is foo.json)
          #     ========================  =============================================
          #     gs://bucket/              gs://bucket/foo.json
          #     gs://bucket/folder/       gs://bucket/folder/foo.json
          #     gs://bucket/folder/item_  gs://bucket/folder/item_foo.json
          class GcsDestination
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The BigQuery output destination configuration.
          # @!attribute [rw] dataset_id
          #   @return [::String]
          #     Required. The ID of a BigQuery Dataset.
          # @!attribute [rw] table_id_prefix
          #   @return [::String]
          #     Required. The prefix of exported BigQuery tables.
          # @!attribute [rw] table_type
          #   @return [::String]
          #     Required. Describes the table type. The following values are supported:
          #
          #     * `table`: A BigQuery native table.
          #     * `view`: A virtual table defined by a SQL query.
          class BigQueryDestination
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Configuration of destination for Export related errors.
        # @!attribute [rw] gcs_prefix
        #   @return [::String]
        #     Google Cloud Storage path for import errors. This must be an empty,
        #     existing Cloud Storage bucket. Export errors will be written to a file in
        #     this bucket, one per line, as a JSON-encoded
        #     `google.rpc.Status` message.
        class ExportErrorsConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for the `ExportAnalyticsMetrics` method.
        # @!attribute [rw] catalog
        #   @return [::String]
        #     Required. Full resource name of the parent catalog.
        #     Expected format: `projects/*/locations/*/catalogs/*`
        # @!attribute [rw] output_config
        #   @return [::Google::Cloud::Retail::V2::OutputConfig]
        #     Required. The output location of the data.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filtering expression to specify restrictions on returned metrics.
        #     The expression is a sequence of terms. Each term applies a restriction to
        #     the returned metrics. Use this expression to restrict results to a
        #     specific time range.
        #
        #       Currently we expect only one types of fields:
        #
        #        * `timestamp`: This can be specified twice, once with a
        #          less than operator and once with a greater than operator. The
        #          `timestamp` restriction should result in one, contiguous, valid,
        #          `timestamp` range.
        #
        #       Some examples of valid filters expressions:
        #
        #       * Example 1: `timestamp > "2012-04-23T18:25:43.511Z"
        #                 timestamp < "2012-04-23T18:30:43.511Z"`
        #       * Example 2: `timestamp > "2012-04-23T18:25:43.511Z"`
        class ExportAnalyticsMetricsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata related to the progress of the Export operation. This is
        # returned by the google.longrunning.Operation.metadata field.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Operation create time.
        # @!attribute [rw] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Operation last update time. If the operation is done, this is also the
        #     finish time.
        class ExportMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response of the ExportAnalyticsMetricsRequest. If the long running
        # operation was successful, then this message is returned by the
        # google.longrunning.Operations.response field if the operation was successful.
        # @!attribute [rw] error_samples
        #   @return [::Array<::Google::Rpc::Status>]
        #     A sample of errors encountered while processing the request.
        # @!attribute [rw] errors_config
        #   @return [::Google::Cloud::Retail::V2::ExportErrorsConfig]
        #     This field is never set.
        # @!attribute [rw] output_result
        #   @return [::Google::Cloud::Retail::V2::OutputResult]
        #     Output result indicating where the data were exported to.
        class ExportAnalyticsMetricsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Output result that stores the information about where the exported data is
        # stored.
        # @!attribute [rw] bigquery_result
        #   @return [::Array<::Google::Cloud::Retail::V2::BigQueryOutputResult>]
        #     The BigQuery location where the result is stored.
        # @!attribute [rw] gcs_result
        #   @return [::Array<::Google::Cloud::Retail::V2::GcsOutputResult>]
        #     The Google Cloud Storage location where the result is stored.
        class OutputResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A BigQuery output result.
        # @!attribute [rw] dataset_id
        #   @return [::String]
        #     The ID of a BigQuery Dataset.
        # @!attribute [rw] table_id
        #   @return [::String]
        #     The ID of a BigQuery Table.
        class BigQueryOutputResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A Gcs output result.
        # @!attribute [rw] output_uri
        #   @return [::String]
        #     The uri of Gcs output
        class GcsOutputResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
