# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Retail
      module V2
        # Request message for
        # {::Google::Cloud::Retail::V2::ConversationalSearchService::Client#conversational_search ConversationalSearchService.ConversationalSearch}
        # method.
        # @!attribute [rw] placement
        #   @return [::String]
        #     Required. The resource name of the search engine placement, such as
        #     `projects/*/locations/global/catalogs/default_catalog/placements/default_search`
        #     or
        #     `projects/*/locations/global/catalogs/default_catalog/servingConfigs/default_serving_config`
        #     This field is used to identify the serving config name and the set
        #     of models that will be used to make the search.
        # @!attribute [rw] branch
        #   @return [::String]
        #     Required. The branch resource name, such as
        #     `projects/*/locations/global/catalogs/default_catalog/branches/0`.
        #
        #     Use "default_branch" as the branch ID or leave this field empty, to search
        #     products under the default branch.
        # @!attribute [rw] query
        #   @return [::String]
        #     Optional. Raw search query to be searched for.
        #
        #     If this field is empty, the request is considered a category browsing
        #     request.
        # @!attribute [rw] page_categories
        #   @return [::Array<::String>]
        #     Optional. The categories associated with a category page. Must be set for
        #     category navigation queries to achieve good search quality. The format
        #     should be the same as
        #     {::Google::Cloud::Retail::V2::UserEvent#page_categories UserEvent.page_categories};
        #
        #     To represent full path of category, use '>' sign to separate different
        #     hierarchies. If '>' is part of the category name, replace it with
        #     other character(s).
        #
        #     Category pages include special pages such as sales or promotions. For
        #     instance, a special sale page may have the category hierarchy:
        #     "pageCategories" : ["Sales > 2017 Black Friday Deals"].
        # @!attribute [rw] conversation_id
        #   @return [::String]
        #     Optional. This field specifies the conversation id, which maintains the
        #     state of the conversation between client side and server side. Use the
        #     value from the previous
        #     {::Google::Cloud::Retail::V2::ConversationalSearchResponse#conversation_id ConversationalSearchResponse.conversation_id}.
        #     For the initial request, this should be empty.
        # @!attribute [rw] search_params
        #   @return [::Google::Cloud::Retail::V2::ConversationalSearchRequest::SearchParams]
        #     Optional. Search parameters.
        # @!attribute [rw] visitor_id
        #   @return [::String]
        #     Required. A unique identifier for tracking visitors. For example, this
        #     could be implemented with an HTTP cookie, which should be able to uniquely
        #     identify a visitor on a single device. This unique identifier should not
        #     change if the visitor logs in or out of the website.
        #
        #     This should be the same identifier as
        #     {::Google::Cloud::Retail::V2::UserEvent#visitor_id UserEvent.visitor_id}.
        #
        #     The field must be a UTF-8 encoded string with a length limit of 128
        #     characters. Otherwise, an INVALID_ARGUMENT error is returned.
        # @!attribute [rw] user_info
        #   @return [::Google::Cloud::Retail::V2::UserInfo]
        #     Optional. User information.
        # @!attribute [rw] conversational_filtering_spec
        #   @return [::Google::Cloud::Retail::V2::ConversationalSearchRequest::ConversationalFilteringSpec]
        #     Optional. This field specifies all conversational filtering related
        #     parameters.
        # @!attribute [rw] user_labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. The user labels applied to a resource must meet the following
        #     requirements:
        #
        #     * Each resource can have multiple labels, up to a maximum of 64.
        #     * Each label must be a key-value pair.
        #     * Keys have a minimum length of 1 character and a maximum length of 63
        #       characters and cannot be empty. Values can be empty and have a maximum
        #       length of 63 characters.
        #     * Keys and values can contain only lowercase letters, numeric characters,
        #       underscores, and dashes. All characters must use UTF-8 encoding, and
        #       international characters are allowed.
        #     * The key portion of a label must be unique. However, you can use the same
        #       key with multiple resources.
        #     * Keys must start with a lowercase letter or international character.
        #
        #     See [Google Cloud
        #     Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
        #     for more details.
        # @!attribute [rw] safety_settings
        #   @return [::Array<::Google::Cloud::Retail::V2::SafetySetting>]
        #     Optional. The safety settings to be applied to the generated content.
        class ConversationalSearchRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Search parameters.
          # @!attribute [rw] filter
          #   @return [::String]
          #     Optional. The filter string to restrict search results.
          #
          #     The syntax of the filter string is the same as
          #     {::Google::Cloud::Retail::V2::SearchRequest#filter SearchRequest.filter}.
          # @!attribute [rw] canonical_filter
          #   @return [::String]
          #     Optional. The canonical filter string to restrict search results.
          #
          #     The syntax of the canonical filter string is the same as
          #     {::Google::Cloud::Retail::V2::SearchRequest#canonical_filter SearchRequest.canonical_filter}.
          # @!attribute [rw] sort_by
          #   @return [::String]
          #     Optional. The sort string to specify the sorting of search results.
          #
          #     The syntax of the sort string is the same as
          #     [SearchRequest.sort][].
          # @!attribute [rw] boost_spec
          #   @return [::Google::Cloud::Retail::V2::SearchRequest::BoostSpec]
          #     Optional. The boost spec to specify the boosting of search results.
          #
          #     The syntax of the boost spec is the same as
          #     {::Google::Cloud::Retail::V2::SearchRequest#boost_spec SearchRequest.boost_spec}.
          class SearchParams
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # This field specifies the current user answer during the conversational
          # filtering search. This can be either user selected from suggested answers
          # or user input plain text.
          # @!attribute [rw] text_answer
          #   @return [::String]
          #     This field specifies the incremental input text from the user during
          #     the conversational search.
          #
          #     Note: The following fields are mutually exclusive: `text_answer`, `selected_answer`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] selected_answer
          #   @return [::Google::Cloud::Retail::V2::ConversationalSearchRequest::UserAnswer::SelectedAnswer]
          #     Optional. This field specifies the selected answer during the
          #     conversational search. This should be a subset of
          #     [ConversationalSearchResponse.followup_question.suggested_answers][].
          #
          #     Note: The following fields are mutually exclusive: `selected_answer`, `text_answer`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class UserAnswer
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # This field specifies the selected answers during the conversational
            # search.
            # @!attribute [rw] product_attribute_value
            #   @return [::Google::Cloud::Retail::V2::ProductAttributeValue]
            #     Optional. This field specifies the selected answer which is a attribute
            #     key-value.
            class SelectedAnswer
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # This field specifies all conversational filtering related parameters
          # addition to conversational retail search.
          # @!attribute [rw] enable_conversational_filtering
          #   @deprecated This field is deprecated and may be removed in the next major version update.
          #   @return [::Boolean]
          #     Optional. This field is deprecated. Please use
          #     {::Google::Cloud::Retail::V2::ConversationalSearchRequest::ConversationalFilteringSpec#conversational_filtering_mode ConversationalFilteringSpec.conversational_filtering_mode}
          #     instead.
          # @!attribute [rw] user_answer
          #   @return [::Google::Cloud::Retail::V2::ConversationalSearchRequest::UserAnswer]
          #     Optional. This field specifies the current user answer during the
          #     conversational filtering search. It can be either user selected from
          #     suggested answers or user input plain text.
          # @!attribute [rw] conversational_filtering_mode
          #   @return [::Google::Cloud::Retail::V2::ConversationalSearchRequest::ConversationalFilteringSpec::Mode]
          #     Optional. Mode to control Conversational Filtering.
          #     Defaults to
          #     {::Google::Cloud::Retail::V2::ConversationalSearchRequest::ConversationalFilteringSpec::Mode::DISABLED Mode.DISABLED}
          #     if it's unset.
          class ConversationalFilteringSpec
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Enum to control Conversational Filtering mode.
            # A single conversation session including multiple turns supports modes for
            # Conversational Search OR Conversational Filtering without
            # Conversational Search, but not both.
            module Mode
              # Default value.
              MODE_UNSPECIFIED = 0

              # Disables Conversational Filtering when using Conversational Search.
              DISABLED = 1

              # Enables Conversational Filtering when using Conversational Search.
              ENABLED = 2

              # Enables Conversational Filtering without Conversational Search.
              CONVERSATIONAL_FILTER_ONLY = 3
            end
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class UserLabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Response message for
        # {::Google::Cloud::Retail::V2::ConversationalSearchService::Client#conversational_search ConversationalSearchService.ConversationalSearch}
        # method.
        # @!attribute [rw] user_query_types
        #   @return [::Array<::String>]
        #     The types Retail classifies the search query as.
        #
        #     Supported values are:
        #
        #     - "ORDER_SUPPORT"
        #     - "SIMPLE_PRODUCT_SEARCH"
        #     - "INTENT_REFINEMENT"
        #     - "PRODUCT_DETAILS"
        #     - "PRODUCT_COMPARISON"
        #     - "DEALS_AND_COUPONS"
        #     - "STORE_RELEVANT"
        #     - "BLOCKLISTED"
        #     - "BEST_PRODUCT"
        #     - "RETAIL_SUPPORT"
        #     - "DISABLED"
        # @!attribute [rw] conversational_text_response
        #   @return [::String]
        #     The conversational answer-based text response generated by the Server.
        # @!attribute [rw] followup_question
        #   @return [::Google::Cloud::Retail::V2::ConversationalSearchResponse::FollowupQuestion]
        #     The conversational followup question generated for Intent refinement.
        # @!attribute [rw] conversation_id
        #   @return [::String]
        #     Conversation UUID. This field will be stored in client side storage to
        #     maintain the conversation session with server and will be used for next
        #     search request's
        #     {::Google::Cloud::Retail::V2::ConversationalSearchRequest#conversation_id ConversationalSearchRequest.conversation_id}
        #     to restore conversation state in server.
        # @!attribute [rw] refined_search
        #   @return [::Array<::Google::Cloud::Retail::V2::ConversationalSearchResponse::RefinedSearch>]
        #     The proposed refined search queries. They can be used to fetch the relevant
        #     search results. When using CONVERSATIONAL_FILTER_ONLY mode, the
        #     refined_query from search response will be populated here.
        # @!attribute [rw] conversational_filtering_result
        #   @return [::Google::Cloud::Retail::V2::ConversationalSearchResponse::ConversationalFilteringResult]
        #     This field specifies all related information that is needed on client
        #     side for UI rendering of conversational filtering search.
        # @!attribute [r] state
        #   @return [::Google::Cloud::Retail::V2::ConversationalSearchResponse::State]
        #     Output only. The state of the response generation.
        class ConversationalSearchResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The conversational followup question generated for Intent refinement.
          # @!attribute [rw] followup_question
          #   @return [::String]
          #     The conversational followup question generated for Intent refinement.
          # @!attribute [rw] suggested_answers
          #   @return [::Array<::Google::Cloud::Retail::V2::ConversationalSearchResponse::FollowupQuestion::SuggestedAnswer>]
          #     The answer options provided to client for the follow-up question.
          class FollowupQuestion
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Suggested answers to the follow-up question.
            # If it's numerical attribute, only ProductAttributeInterval will be set.
            # If it's textual attribute, only productAttributeValue will be set.
            # @!attribute [rw] product_attribute_value
            #   @return [::Google::Cloud::Retail::V2::ProductAttributeValue]
            #     Product attribute value, including an attribute key and an
            #     attribute value. Other types can be added here in the future.
            class SuggestedAnswer
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # The proposed refined search for intent-refinement/bundled shopping
          # conversation. When using CONVERSATIONAL_FILTER_ONLY mode, the
          # refined_query from search response will be populated here.
          # @!attribute [rw] query
          #   @return [::String]
          #     The query to be used for search.
          class RefinedSearch
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # This field specifies all related information that is needed on client
          # side for UI rendering of conversational filtering search.
          # @!attribute [rw] followup_question
          #   @return [::Google::Cloud::Retail::V2::ConversationalSearchResponse::FollowupQuestion]
          #     The conversational filtering question.
          # @!attribute [rw] additional_filter
          #   @return [::Google::Cloud::Retail::V2::ConversationalSearchResponse::ConversationalFilteringResult::AdditionalFilter]
          #     This is the incremental additional filters implied from the current
          #     user answer. User should add the suggested addition filters to the
          #     previous [ConversationalSearchRequest.search_params.filter][] and
          #     {::Google::Cloud::Retail::V2::SearchRequest#filter SearchRequest.filter},  and
          #     use the merged filter in the follow up requests.
          class ConversationalFilteringResult
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Additional filter that client side need to apply.
            # @!attribute [rw] product_attribute_value
            #   @return [::Google::Cloud::Retail::V2::ProductAttributeValue]
            #     Product attribute value, including an attribute key and an
            #     attribute value. Other types can be added here in the future.
            class AdditionalFilter
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # The state of the response generation.
          module State
            # Unknown.
            STATE_UNSPECIFIED = 0

            # Response generation is being streamed.
            STREAMING = 1

            # Response generation has succeeded.
            SUCCEEDED = 2
          end
        end
      end
    end
  end
end
