# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Retail
      module V2
        # Autocomplete parameters.
        # @!attribute [rw] catalog
        #   @return [::String]
        #     Required. Catalog for which the completion is performed.
        #
        #     Full resource name of catalog, such as
        #     `projects/*/locations/global/catalogs/default_catalog`.
        # @!attribute [rw] query
        #   @return [::String]
        #     Required. The query used to generate suggestions.
        #
        #     The maximum number of allowed characters is 255.
        # @!attribute [rw] visitor_id
        #   @return [::String]
        #     Recommended field. A unique identifier for tracking visitors. For example,
        #     this could be implemented with an HTTP cookie, which should be able to
        #     uniquely identify a visitor on a single device. This unique identifier
        #     should not change if the visitor logs in or out of the website.
        #
        #     The field must be a UTF-8 encoded string with a length limit of 128
        #     characters. Otherwise, an INVALID_ARGUMENT error is returned.
        # @!attribute [rw] language_codes
        #   @return [::Array<::String>]
        #     Note that this field applies for `user-data` dataset only. For requests
        #     with `cloud-retail` dataset, setting this field has no effect.
        #
        #     The language filters applied to the output suggestions. If set, it should
        #     contain the language of the query. If not set, suggestions are returned
        #     without considering language restrictions. This is the BCP-47 language
        #     code, such as "en-US" or "sr-Latn". For more information, see [Tags for
        #     Identifying Languages](https://tools.ietf.org/html/bcp47). The maximum
        #     number of language codes is 3.
        # @!attribute [rw] device_type
        #   @return [::String]
        #     The device type context for completion suggestions. We recommend that you
        #     leave this field empty.
        #
        #     It can apply different suggestions on different device types, e.g.
        #     `DESKTOP`, `MOBILE`. If it is empty, the suggestions are across all device
        #     types.
        #
        #     Supported formats:
        #
        #     * `UNKNOWN_DEVICE_TYPE`
        #
        #     * `DESKTOP`
        #
        #     * `MOBILE`
        #
        #     * A customized string starts with `OTHER_`, e.g. `OTHER_IPHONE`.
        # @!attribute [rw] dataset
        #   @return [::String]
        #     Determines which dataset to use for fetching completion. "user-data" will
        #     use the dataset imported through
        #     {::Google::Cloud::Retail::V2::CompletionService::Client#import_completion_data CompletionService.ImportCompletionData}.
        #     `cloud-retail` will use the dataset generated by Cloud Retail based on user
        #     events. If left empty, completions will be fetched from the `user-data`
        #     dataset.
        #
        #     Current supported values:
        #
        #     * user-data
        #
        #     * cloud-retail:
        #       This option requires enabling auto-learning function first. See
        #       [guidelines](https://cloud.google.com/retail/docs/completion-overview#generated-completion-dataset).
        # @!attribute [rw] max_suggestions
        #   @return [::Integer]
        #     Completion max suggestions. If left unset or set to 0, then will fallback
        #     to the configured value
        #     {::Google::Cloud::Retail::V2::CompletionConfig#max_suggestions CompletionConfig.max_suggestions}.
        #
        #     The maximum allowed max suggestions is 20. If it is set higher, it will be
        #     capped by 20.
        # @!attribute [rw] enable_attribute_suggestions
        #   @return [::Boolean]
        #     If true, attribute suggestions are enabled and provided in the response.
        #
        #     This field is only available for the `cloud-retail` dataset.
        # @!attribute [rw] entity
        #   @return [::String]
        #     The entity for customers who run multiple entities, domains, sites, or
        #     regions, for example, `Google US`, `Google Ads`, `Waymo`,
        #     `google.com`, `youtube.com`, etc.
        #     If this is set, it must be an exact match with
        #     {::Google::Cloud::Retail::V2::UserEvent#entity UserEvent.entity} to get
        #     per-entity autocomplete results. This field will be applied to
        #     `completion_results` only. It has no effect on the `attribute_results`.
        #     Also, this entity should be limited to 256 characters, if too long, it will
        #     be truncated to 256 characters in both generation and serving time, and may
        #     lead to mis-match. To ensure it works, please set the entity with string
        #     within 256 characters.
        class CompleteQueryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response of the autocomplete query.
        # @!attribute [rw] completion_results
        #   @return [::Array<::Google::Cloud::Retail::V2::CompleteQueryResponse::CompletionResult>]
        #     Results of the matching suggestions. The result list is ordered and the
        #     first result is top suggestion.
        # @!attribute [rw] attribution_token
        #   @return [::String]
        #     A unique complete token. This should be included in the
        #     {::Google::Cloud::Retail::V2::UserEvent#completion_detail UserEvent.completion_detail}
        #     for search events resulting from this completion, which enables accurate
        #     attribution of complete model performance.
        # @!attribute [rw] recent_search_results
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Array<::Google::Cloud::Retail::V2::CompleteQueryResponse::RecentSearchResult>]
        #     Deprecated. Matched recent searches of this user. The maximum number of
        #     recent searches is 10. This field is a restricted feature. If you want to
        #     enable it, contact Retail Search support.
        #
        #     This feature is only available when
        #     {::Google::Cloud::Retail::V2::CompleteQueryRequest#visitor_id CompleteQueryRequest.visitor_id}
        #     field is set and {::Google::Cloud::Retail::V2::UserEvent UserEvent} is imported.
        #     The recent searches satisfy the follow rules:
        #
        #      * They are ordered from latest to oldest.
        #
        #      * They are matched with
        #      {::Google::Cloud::Retail::V2::CompleteQueryRequest#query CompleteQueryRequest.query}
        #      case insensitively.
        #
        #      * They are transformed to lower case.
        #
        #      * They are UTF-8 safe.
        #
        #     Recent searches are deduplicated. More recent searches will be reserved
        #     when duplication happens.
        # @!attribute [rw] attribute_results
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Retail::V2::CompleteQueryResponse::AttributeResult}]
        #     A map of matched attribute suggestions. This field is only available for
        #     `cloud-retail` dataset.
        #
        #     Current supported keys:
        #
        #     * `brands`
        #
        #     * `categories`
        class CompleteQueryResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Resource that represents completion results.
          # @!attribute [rw] suggestion
          #   @return [::String]
          #     The suggestion for the query.
          # @!attribute [rw] attributes
          #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Retail::V2::CustomAttribute}]
          #     Custom attributes for the suggestion term.
          #
          #     * For `user-data`, the attributes are additional custom attributes
          #     ingested through BigQuery.
          #
          #     * For `cloud-retail`, the attributes are product attributes generated
          #     by Cloud Retail. It requires
          #     {::Google::Cloud::Retail::V2::UserEvent#product_details UserEvent.product_details}
          #     is imported properly.
          class CompletionResult
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::Google::Cloud::Retail::V2::CustomAttribute]
            class AttributesEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Deprecated: Recent search of this user.
          # @deprecated This message is deprecated and may be removed in the next major version update.
          # @!attribute [rw] recent_search
          #   @return [::String]
          #     The recent search query.
          class RecentSearchResult
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Resource that represents attribute results.
          # @!attribute [rw] suggestions
          #   @return [::Array<::String>]
          #     The list of suggestions for the attribute.
          class AttributeResult
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::Retail::V2::CompleteQueryResponse::AttributeResult]
          class AttributeResultsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
