# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Retail
      module V2
        # Metadata that is used to define a condition that triggers an action.
        # A valid condition must specify at least one of 'query_terms' or
        # 'products_filter'. If multiple fields are specified, the condition is met if
        # all the fields are satisfied e.g. if a set of query terms and product_filter
        # are set, then only items matching the product_filter for requests with a
        # query matching the query terms wil get boosted.
        # @!attribute [rw] query_terms
        #   @return [::Array<::Google::Cloud::Retail::V2::Condition::QueryTerm>]
        #     A list (up to 10 entries) of terms to match the query on. If not
        #     specified, match all queries.
        #     If many query terms are specified, the condition
        #     is matched if any of the terms is a match (i.e. using the OR operator).
        # @!attribute [rw] active_time_range
        #   @return [::Array<::Google::Cloud::Retail::V2::Condition::TimeRange>]
        #     Range of time(s) specifying when Condition is active.
        #     Condition true if any time range matches.
        # @!attribute [rw] page_categories
        #   @return [::Array<::String>]
        #     Used to support browse uses cases.
        #     A list (up to 10 entries) of categories or departments.
        #     The format should be the same as
        #     {::Google::Cloud::Retail::V2::UserEvent#page_categories UserEvent.page_categories};
        class Condition
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Query terms that we want to match on.
          # @!attribute [rw] value
          #   @return [::String]
          #     The value of the term to match on.
          #     Value cannot be empty.
          #     Value can have at most 3 terms if specified as a partial match. Each
          #     space separated string is considered as one term.
          #     For example, "a b c" is 3 terms and allowed, but " a b c d" is 4 terms
          #     and not allowed for a partial match.
          # @!attribute [rw] full_match
          #   @return [::Boolean]
          #     Whether this is supposed to be a full or partial match.
          class QueryTerm
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Used for time-dependent conditions.
          # Example: Want to have rule applied for week long sale.
          # @!attribute [rw] start_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Start of time range. Range is inclusive.
          # @!attribute [rw] end_time
          #   @return [::Google::Protobuf::Timestamp]
          #     End of time range. Range is inclusive.
          class TimeRange
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # A rule is a condition-action pair
        #
        # * A condition defines when a rule is to be triggered.
        # * An action specifies what occurs on that trigger.
        # Currently rules only work for {::Google::Cloud::Retail::V2::Control controls} with
        # {::Google::Cloud::Retail::V2::SolutionType::SOLUTION_TYPE_SEARCH SOLUTION_TYPE_SEARCH}.
        # @!attribute [rw] boost_action
        #   @return [::Google::Cloud::Retail::V2::Rule::BoostAction]
        #     A boost action.
        #
        #     Note: The following fields are mutually exclusive: `boost_action`, `redirect_action`, `oneway_synonyms_action`, `do_not_associate_action`, `replacement_action`, `ignore_action`, `filter_action`, `twoway_synonyms_action`, `force_return_facet_action`, `remove_facet_action`, `pin_action`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] redirect_action
        #   @return [::Google::Cloud::Retail::V2::Rule::RedirectAction]
        #     Redirects a shopper to a specific page.
        #
        #     Note: The following fields are mutually exclusive: `redirect_action`, `boost_action`, `oneway_synonyms_action`, `do_not_associate_action`, `replacement_action`, `ignore_action`, `filter_action`, `twoway_synonyms_action`, `force_return_facet_action`, `remove_facet_action`, `pin_action`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] oneway_synonyms_action
        #   @return [::Google::Cloud::Retail::V2::Rule::OnewaySynonymsAction]
        #     Treats specific term as a synonym with a group of terms.
        #     Group of terms will not be treated as synonyms with the specific term.
        #
        #     Note: The following fields are mutually exclusive: `oneway_synonyms_action`, `boost_action`, `redirect_action`, `do_not_associate_action`, `replacement_action`, `ignore_action`, `filter_action`, `twoway_synonyms_action`, `force_return_facet_action`, `remove_facet_action`, `pin_action`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] do_not_associate_action
        #   @return [::Google::Cloud::Retail::V2::Rule::DoNotAssociateAction]
        #     Prevents term from being associated with other terms.
        #
        #     Note: The following fields are mutually exclusive: `do_not_associate_action`, `boost_action`, `redirect_action`, `oneway_synonyms_action`, `replacement_action`, `ignore_action`, `filter_action`, `twoway_synonyms_action`, `force_return_facet_action`, `remove_facet_action`, `pin_action`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] replacement_action
        #   @return [::Google::Cloud::Retail::V2::Rule::ReplacementAction]
        #     Replaces specific terms in the query.
        #
        #     Note: The following fields are mutually exclusive: `replacement_action`, `boost_action`, `redirect_action`, `oneway_synonyms_action`, `do_not_associate_action`, `ignore_action`, `filter_action`, `twoway_synonyms_action`, `force_return_facet_action`, `remove_facet_action`, `pin_action`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] ignore_action
        #   @return [::Google::Cloud::Retail::V2::Rule::IgnoreAction]
        #     Ignores specific terms from query during search.
        #
        #     Note: The following fields are mutually exclusive: `ignore_action`, `boost_action`, `redirect_action`, `oneway_synonyms_action`, `do_not_associate_action`, `replacement_action`, `filter_action`, `twoway_synonyms_action`, `force_return_facet_action`, `remove_facet_action`, `pin_action`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] filter_action
        #   @return [::Google::Cloud::Retail::V2::Rule::FilterAction]
        #     Filters results.
        #
        #     Note: The following fields are mutually exclusive: `filter_action`, `boost_action`, `redirect_action`, `oneway_synonyms_action`, `do_not_associate_action`, `replacement_action`, `ignore_action`, `twoway_synonyms_action`, `force_return_facet_action`, `remove_facet_action`, `pin_action`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] twoway_synonyms_action
        #   @return [::Google::Cloud::Retail::V2::Rule::TwowaySynonymsAction]
        #     Treats a set of terms as synonyms of one another.
        #
        #     Note: The following fields are mutually exclusive: `twoway_synonyms_action`, `boost_action`, `redirect_action`, `oneway_synonyms_action`, `do_not_associate_action`, `replacement_action`, `ignore_action`, `filter_action`, `force_return_facet_action`, `remove_facet_action`, `pin_action`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] force_return_facet_action
        #   @return [::Google::Cloud::Retail::V2::Rule::ForceReturnFacetAction]
        #     Force returns an attribute as a facet in the request.
        #
        #     Note: The following fields are mutually exclusive: `force_return_facet_action`, `boost_action`, `redirect_action`, `oneway_synonyms_action`, `do_not_associate_action`, `replacement_action`, `ignore_action`, `filter_action`, `twoway_synonyms_action`, `remove_facet_action`, `pin_action`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] remove_facet_action
        #   @return [::Google::Cloud::Retail::V2::Rule::RemoveFacetAction]
        #     Remove an attribute as a facet in the request (if present).
        #
        #     Note: The following fields are mutually exclusive: `remove_facet_action`, `boost_action`, `redirect_action`, `oneway_synonyms_action`, `do_not_associate_action`, `replacement_action`, `ignore_action`, `filter_action`, `twoway_synonyms_action`, `force_return_facet_action`, `pin_action`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] pin_action
        #   @return [::Google::Cloud::Retail::V2::Rule::PinAction]
        #     Pins one or more specified products to a specific position in the
        #     results.
        #
        #     Note: The following fields are mutually exclusive: `pin_action`, `boost_action`, `redirect_action`, `oneway_synonyms_action`, `do_not_associate_action`, `replacement_action`, `ignore_action`, `filter_action`, `twoway_synonyms_action`, `force_return_facet_action`, `remove_facet_action`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] condition
        #   @return [::Google::Cloud::Retail::V2::Condition]
        #     Required. The condition that triggers the rule.
        #     If the condition is empty, the rule will always apply.
        class Rule
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A boost action to apply to results matching condition specified above.
          # @!attribute [rw] boost
          #   @return [::Float]
          #     Strength of the condition boost, which must be in [-1, 1]. Negative
          #     boost means demotion. Default is 0.0.
          #
          #     Setting to 1.0 gives the item a big promotion. However, it does not
          #     necessarily mean that the boosted item will be the top result at all
          #     times, nor that other items will be excluded. Results could still be
          #     shown even when none of them matches the condition. And results that
          #     are significantly more relevant to the search query can still trump
          #     your heavily favored but irrelevant items.
          #
          #     Setting to -1.0 gives the item a big demotion. However, results that
          #     are deeply relevant might still be shown. The item will have an
          #     upstream battle to get a fairly high ranking, but it is not blocked out
          #     completely.
          #
          #     Setting to 0.0 means no boost applied. The boosting condition is
          #     ignored.
          # @!attribute [rw] products_filter
          #   @return [::String]
          #     The filter can have a max size of 5000 characters.
          #     An expression which specifies which products to apply an action to.
          #     The syntax and supported fields are the same as a filter expression. See
          #     {::Google::Cloud::Retail::V2::SearchRequest#filter SearchRequest.filter} for
          #     detail syntax and limitations.
          #
          #     Examples:
          #
          #     * To boost products with product ID "product_1" or "product_2", and
          #     color
          #       "Red" or "Blue":<br>
          #       *(id: ANY("product_1", "product_2"))<br>*
          #       *AND<br>*
          #       *(colorFamilies: ANY("Red", "Blue"))<br>*
          class BoostAction
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # * Rule Condition:
          #     - No
          #     {::Google::Cloud::Retail::V2::Condition#query_terms Condition.query_terms}
          #     provided is a global match.
          #     - 1 or more
          #     {::Google::Cloud::Retail::V2::Condition#query_terms Condition.query_terms}
          #     provided are combined with OR operator.
          #
          # * Action Input: The request query and filter that are applied to the
          # retrieved products, in addition to any filters already provided with the
          # SearchRequest. The AND operator is used to combine the query's existing
          # filters with the filter rule(s). NOTE: May result in 0 results when
          # filters conflict.
          #
          # * Action Result: Filters the returned objects to be ONLY those that passed
          # the filter.
          # @!attribute [rw] filter
          #   @return [::String]
          #     A filter to apply on the matching condition results. Supported features:
          #
          #     * {::Google::Cloud::Retail::V2::Rule::FilterAction#filter filter} must be set.
          #     * Filter syntax is identical to
          #     {::Google::Cloud::Retail::V2::SearchRequest#filter SearchRequest.filter}. For
          #     more
          #       information, see [Filter](/retail/docs/filter-and-order#filter).
          #     * To filter products with product ID "product_1" or "product_2", and
          #     color
          #       "Red" or "Blue":<br>
          #       *(id: ANY("product_1", "product_2"))<br>*
          #       *AND<br>*
          #       *(colorFamilies: ANY("Red", "Blue"))<br>*
          class FilterAction
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Redirects a shopper to a specific page.
          #
          # * Rule Condition:
          #   Must specify
          #   {::Google::Cloud::Retail::V2::Condition#query_terms Condition.query_terms}.
          # * Action Input: Request Query
          # * Action Result: Redirects shopper to provided uri.
          # @!attribute [rw] redirect_uri
          #   @return [::String]
          #     URL must have length equal or less than 2000 characters.
          class RedirectAction
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Creates a set of terms that will be treated as synonyms of each other.
          # Example: synonyms of "sneakers" and "shoes":
          #
          #  * "sneakers" will use a synonym of "shoes".
          #  * "shoes" will use a synonym of "sneakers".
          # @!attribute [rw] synonyms
          #   @return [::Array<::String>]
          #     Defines a set of synonyms.
          #     Can specify up to 100 synonyms.
          #     Must specify at least 2 synonyms.
          class TwowaySynonymsAction
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Maps a set of terms to a set of synonyms.
          # Set of synonyms will be treated as synonyms of each query term only.
          # `query_terms` will not be treated as synonyms of each other.
          # Example: "sneakers" will use a synonym of "shoes".
          # "shoes" will not use a synonym of "sneakers".
          # @!attribute [rw] query_terms
          #   @return [::Array<::String>]
          #     Terms from the search query.
          #     Will treat synonyms as their synonyms.
          #     Not themselves synonyms of the synonyms.
          #     Can specify up to 100 terms.
          # @!attribute [rw] synonyms
          #   @return [::Array<::String>]
          #     Defines a set of synonyms.
          #     Cannot contain duplicates.
          #     Can specify up to 100 synonyms.
          # @!attribute [rw] oneway_terms
          #   @return [::Array<::String>]
          #     Will be [deprecated = true] post migration;
          class OnewaySynonymsAction
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Prevents `query_term` from being associated with specified terms during
          # search.
          # Example: Don't associate "gShoe" and "cheap".
          # @!attribute [rw] query_terms
          #   @return [::Array<::String>]
          #     Terms from the search query.
          #     Will not consider do_not_associate_terms for search if in search query.
          #     Can specify up to 100 terms.
          # @!attribute [rw] do_not_associate_terms
          #   @return [::Array<::String>]
          #     Cannot contain duplicates or the query term.
          #     Can specify up to 100 terms.
          # @!attribute [rw] terms
          #   @return [::Array<::String>]
          #     Will be [deprecated = true] post migration;
          class DoNotAssociateAction
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Replaces a term in the query. Multiple replacement candidates can be
          # specified. All `query_terms` will be replaced with the replacement term.
          # Example: Replace "gShoe" with "google shoe".
          # @!attribute [rw] query_terms
          #   @return [::Array<::String>]
          #     Terms from the search query.
          #     Will be replaced by replacement term.
          #     Can specify up to 100 terms.
          # @!attribute [rw] replacement_term
          #   @return [::String]
          #     Term that will be used for replacement.
          # @!attribute [rw] term
          #   @return [::String]
          #     Will be [deprecated = true] post migration;
          class ReplacementAction
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Prevents a term in the query from being used in search.
          # Example: Don't search for "shoddy".
          # @!attribute [rw] ignore_terms
          #   @return [::Array<::String>]
          #     Terms to ignore in the search query.
          class IgnoreAction
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Force returns an attribute/facet in the request around a certain position
          # or above.
          #
          # * Rule Condition:
          #   Must specify non-empty
          #   {::Google::Cloud::Retail::V2::Condition#query_terms Condition.query_terms}
          #   (for search only) or
          #   {::Google::Cloud::Retail::V2::Condition#page_categories Condition.page_categories}
          #   (for browse only), but can't specify both.
          #
          # * Action Inputs: attribute name, position
          #
          # * Action Result: Will force return a facet key around a certain position
          # or above if the condition is satisfied.
          #
          # Example: Suppose the query is "shoes", the
          # {::Google::Cloud::Retail::V2::Condition#query_terms Condition.query_terms} is
          # "shoes", the
          # {::Google::Cloud::Retail::V2::Rule::ForceReturnFacetAction::FacetPositionAdjustment#attribute_name ForceReturnFacetAction.FacetPositionAdjustment.attribute_name}
          # is "size" and the
          # {::Google::Cloud::Retail::V2::Rule::ForceReturnFacetAction::FacetPositionAdjustment#position ForceReturnFacetAction.FacetPositionAdjustment.position}
          # is 8.
          #
          # Two cases: a) The facet key "size" is not already in the top 8 slots, then
          # the facet "size" will appear at a position close to 8. b) The facet key
          # "size" in among the top 8 positions in the request, then it will stay at
          # its current rank.
          # @!attribute [rw] facet_position_adjustments
          #   @return [::Array<::Google::Cloud::Retail::V2::Rule::ForceReturnFacetAction::FacetPositionAdjustment>]
          #     Each instance corresponds to a force return attribute for the given
          #     condition. There can't be more 15 instances here.
          class ForceReturnFacetAction
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Each facet position adjustment consists of a single attribute name (i.e.
            # facet key) along with a specified position.
            # @!attribute [rw] attribute_name
            #   @return [::String]
            #     The attribute name to force return as a facet. Each attribute name
            #     should be a valid attribute name, be non-empty and contain at most 80
            #     characters long.
            # @!attribute [rw] position
            #   @return [::Integer]
            #     This is the position in the request as explained above. It should be
            #     strictly positive be at most 100.
            class FacetPositionAdjustment
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Removes an attribute/facet in the request if is present.
          #
          # * Rule Condition:
          #   Must specify non-empty
          #   {::Google::Cloud::Retail::V2::Condition#query_terms Condition.query_terms}
          #   (for search only) or
          #   {::Google::Cloud::Retail::V2::Condition#page_categories Condition.page_categories}
          #   (for browse only), but can't specify both.
          #
          # * Action Input: attribute name
          #
          # * Action Result: Will remove the attribute (as a facet) from the request
          # if it is present.
          #
          # Example: Suppose the query is "shoes", the
          # {::Google::Cloud::Retail::V2::Condition#query_terms Condition.query_terms} is
          # "shoes" and the attribute name "size", then facet key "size" will be
          # removed from the request (if it is present).
          # @!attribute [rw] attribute_names
          #   @return [::Array<::String>]
          #     The attribute names (i.e. facet keys) to remove from the dynamic facets
          #     (if present in the request). There can't be more 3 attribute names.
          #     Each attribute name should be a valid attribute name, be non-empty and
          #     contain at most 80 characters.
          class RemoveFacetAction
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Pins one or more specified products to a specific position in the
          # results.
          #
          # * Rule Condition:
          #   Must specify non-empty
          #   {::Google::Cloud::Retail::V2::Condition#query_terms Condition.query_terms}
          #   (for search only) or
          #   {::Google::Cloud::Retail::V2::Condition#page_categories Condition.page_categories}
          #   (for browse only), but can't specify both.
          #
          # * Action Input: mapping of `[pin_position, product_id]` pairs (pin position
          # uses 1-based indexing).
          #
          # * Action Result: Will pin products with matching ids to the position
          # specified in the final result order.
          #
          # Example: Suppose the query is `shoes`, the
          # {::Google::Cloud::Retail::V2::Condition#query_terms Condition.query_terms} is
          # `shoes` and the pin_map has `{1, "pid1"}`, then product with `pid1` will be
          # pinned to the top position in the final results.
          #
          # If multiple PinActions are matched to a single request the actions will
          # be processed from most to least recently updated.
          #
          # Pins to positions larger than the max allowed page size of 120 are not
          # allowed.
          # @!attribute [rw] pin_map
          #   @return [::Google::Protobuf::Map{::Integer => ::String}]
          #     Required. A map of positions to product_ids.
          #
          #     Partial matches per action are allowed, if a certain position in the map
          #     is already filled that `[position, product_id]` pair will be ignored
          #     but the rest may still be applied. This case will only occur if multiple
          #     pin actions are matched to a single request, as the map guarantees that
          #     pin positions are unique within the same action.
          #
          #     Duplicate product_ids are not permitted within a single pin map.
          #
          #     The max size of this map is 120, equivalent to the max [request page
          #     size](https://cloud.google.com/retail/docs/reference/rest/v2/projects.locations.catalogs.placements/search#request-body).
          class PinAction
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # @!attribute [rw] key
            #   @return [::Integer]
            # @!attribute [rw] value
            #   @return [::String]
            class PinMapEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end
        end

        # An intended audience of the {::Google::Cloud::Retail::V2::Product Product} for
        # whom it's sold.
        # @!attribute [rw] genders
        #   @return [::Array<::String>]
        #     The genders of the audience. Strongly encouraged to use the standard
        #     values: "male", "female", "unisex".
        #
        #     At most 5 values are allowed. Each value must be a UTF-8 encoded string
        #     with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error
        #     is returned.
        #
        #     Google Merchant Center property
        #     [gender](https://support.google.com/merchants/answer/6324479). Schema.org
        #     property
        #     [Product.audience.suggestedGender](https://schema.org/suggestedGender).
        # @!attribute [rw] age_groups
        #   @return [::Array<::String>]
        #     The age groups of the audience. Strongly encouraged to use the standard
        #     values: "newborn" (up to 3 months old), "infant" (3–12 months old),
        #     "toddler" (1–5 years old), "kids" (5–13 years old), "adult" (typically
        #     teens or older).
        #
        #     At most 5 values are allowed. Each value must be a UTF-8 encoded string
        #     with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error
        #     is returned.
        #
        #     Google Merchant Center property
        #     [age_group](https://support.google.com/merchants/answer/6324463).
        #     Schema.org property
        #     [Product.audience.suggestedMinAge](https://schema.org/suggestedMinAge) and
        #     [Product.audience.suggestedMaxAge](https://schema.org/suggestedMaxAge).
        class Audience
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The color information of a {::Google::Cloud::Retail::V2::Product Product}.
        # @!attribute [rw] color_families
        #   @return [::Array<::String>]
        #     The standard color families. Strongly recommended to use the following
        #     standard color groups: "Red", "Pink", "Orange", "Yellow", "Purple",
        #     "Green", "Cyan", "Blue", "Brown", "White", "Gray", "Black" and "Mixed".
        #     Normally it is expected to have only 1 color family. May consider using
        #     single "Mixed" instead of multiple values.
        #
        #     A maximum of 5 values are allowed. Each value must be a UTF-8 encoded
        #     string with a length limit of 128 characters. Otherwise, an
        #     INVALID_ARGUMENT error is returned.
        #
        #     Google Merchant Center property
        #     [color](https://support.google.com/merchants/answer/6324487). Schema.org
        #     property [Product.color](https://schema.org/color).
        #
        #     The colorFamilies field as a system attribute is not a required field but
        #     strongly recommended to be specified. Google Search models treat this field
        #     as more important than a custom product attribute when specified.
        # @!attribute [rw] colors
        #   @return [::Array<::String>]
        #     The color display names, which may be different from standard color family
        #     names, such as the color aliases used in the website frontend. Normally
        #     it is expected to have only 1 color. May consider using single "Mixed"
        #     instead of multiple values.
        #
        #     A maximum of 75 colors are allowed. Each value must be a UTF-8 encoded
        #     string with a length limit of 128 characters. Otherwise, an
        #     INVALID_ARGUMENT error is returned.
        #
        #     Google Merchant Center property
        #     [color](https://support.google.com/merchants/answer/6324487). Schema.org
        #     property [Product.color](https://schema.org/color).
        class ColorInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A custom attribute that is not explicitly modeled in
        # {::Google::Cloud::Retail::V2::Product Product}.
        # @!attribute [rw] text
        #   @return [::Array<::String>]
        #     The textual values of this custom attribute. For example, `["yellow",
        #     "green"]` when the key is "color".
        #
        #     Empty string is not allowed. Otherwise, an INVALID_ARGUMENT error is
        #     returned.
        #
        #     Exactly one of {::Google::Cloud::Retail::V2::CustomAttribute#text text} or
        #     {::Google::Cloud::Retail::V2::CustomAttribute#numbers numbers} should be set.
        #     Otherwise, an INVALID_ARGUMENT error is returned.
        # @!attribute [rw] numbers
        #   @return [::Array<::Float>]
        #     The numerical values of this custom attribute. For example, `[2.3, 15.4]`
        #     when the key is "lengths_cm".
        #
        #     Exactly one of {::Google::Cloud::Retail::V2::CustomAttribute#text text} or
        #     {::Google::Cloud::Retail::V2::CustomAttribute#numbers numbers} should be set.
        #     Otherwise, an INVALID_ARGUMENT error is returned.
        # @!attribute [rw] searchable
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Boolean]
        #     This field is normally ignored unless
        #     {::Google::Cloud::Retail::V2::AttributesConfig#attribute_config_level AttributesConfig.attribute_config_level}
        #     of the {::Google::Cloud::Retail::V2::Catalog Catalog} is set to the deprecated
        #     'PRODUCT_LEVEL_ATTRIBUTE_CONFIG' mode. For information about product-level
        #     attribute configuration, see [Configuration
        #     modes](https://cloud.google.com/retail/docs/attribute-config#config-modes).
        #     If true, custom attribute values are searchable by text queries in
        #     {::Google::Cloud::Retail::V2::SearchService::Client#search SearchService.Search}.
        #
        #     This field is ignored in a {::Google::Cloud::Retail::V2::UserEvent UserEvent}.
        #
        #     Only set if type {::Google::Cloud::Retail::V2::CustomAttribute#text text} is
        #     set. Otherwise, a INVALID_ARGUMENT error is returned.
        # @!attribute [rw] indexable
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Boolean]
        #     This field is normally ignored unless
        #     {::Google::Cloud::Retail::V2::AttributesConfig#attribute_config_level AttributesConfig.attribute_config_level}
        #     of the {::Google::Cloud::Retail::V2::Catalog Catalog} is set to the deprecated
        #     'PRODUCT_LEVEL_ATTRIBUTE_CONFIG' mode. For information about product-level
        #     attribute configuration, see [Configuration
        #     modes](https://cloud.google.com/retail/docs/attribute-config#config-modes).
        #     If true, custom attribute values are indexed, so that they can be filtered,
        #     faceted or boosted in
        #     {::Google::Cloud::Retail::V2::SearchService::Client#search SearchService.Search}.
        #
        #     This field is ignored in a {::Google::Cloud::Retail::V2::UserEvent UserEvent}.
        #
        #     See {::Google::Cloud::Retail::V2::SearchRequest#filter SearchRequest.filter},
        #     {::Google::Cloud::Retail::V2::SearchRequest#facet_specs SearchRequest.facet_specs}
        #     and
        #     {::Google::Cloud::Retail::V2::SearchRequest#boost_spec SearchRequest.boost_spec}
        #     for more details.
        class CustomAttribute
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Fulfillment information, such as the store IDs for in-store pickup or region
        # IDs for different shipping methods.
        # @!attribute [rw] type
        #   @return [::String]
        #     The fulfillment type, including commonly used types (such as pickup in
        #     store and same day delivery), and custom types. Customers have to map
        #     custom types to their display names before rendering UI.
        #
        #     Supported values:
        #
        #     * "pickup-in-store"
        #     * "ship-to-store"
        #     * "same-day-delivery"
        #     * "next-day-delivery"
        #     * "custom-type-1"
        #     * "custom-type-2"
        #     * "custom-type-3"
        #     * "custom-type-4"
        #     * "custom-type-5"
        #
        #     If this field is set to an invalid value other than these, an
        #     INVALID_ARGUMENT error is returned.
        # @!attribute [rw] place_ids
        #   @return [::Array<::String>]
        #     The IDs for this {::Google::Cloud::Retail::V2::FulfillmentInfo#type type}, such
        #     as the store IDs for
        #     {::Google::Cloud::Retail::V2::FulfillmentInfo#type FulfillmentInfo.type.pickup-in-store}
        #     or the region IDs for
        #     {::Google::Cloud::Retail::V2::FulfillmentInfo#type FulfillmentInfo.type.same-day-delivery}.
        #
        #     A maximum of 3000 values are allowed. Each value must be a string with a
        #     length limit of 30 characters, matching the pattern `[a-zA-Z0-9_-]+`, such
        #     as "store1" or "REGION-2". Otherwise, an INVALID_ARGUMENT error is
        #     returned.
        class FulfillmentInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # {::Google::Cloud::Retail::V2::Product Product} image. Recommendations AI and
        # Retail Search use product images to improve prediction and search results.
        # Product images can be returned in results, and are shown in prediction or
        # search previews in the console. Please try to provide correct product images
        # and avoid using images with size too small.
        # @!attribute [rw] uri
        #   @return [::String]
        #     Required. URI of the image.
        #
        #     This field must be a valid UTF-8 encoded URI with a length limit of 5,000
        #     characters. Otherwise, an INVALID_ARGUMENT error is returned.
        #
        #     Google Merchant Center property
        #     [image_link](https://support.google.com/merchants/answer/6324350).
        #     Schema.org property [Product.image](https://schema.org/image).
        # @!attribute [rw] height
        #   @return [::Integer]
        #     Height of the image in number of pixels.
        #
        #     This field must be nonnegative. Otherwise, an INVALID_ARGUMENT error is
        #     returned.
        # @!attribute [rw] width
        #   @return [::Integer]
        #     Width of the image in number of pixels.
        #
        #     This field must be nonnegative. Otherwise, an INVALID_ARGUMENT error is
        #     returned.
        class Image
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A floating point interval.
        # @!attribute [rw] minimum
        #   @return [::Float]
        #     Inclusive lower bound.
        #
        #     Note: The following fields are mutually exclusive: `minimum`, `exclusive_minimum`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] exclusive_minimum
        #   @return [::Float]
        #     Exclusive lower bound.
        #
        #     Note: The following fields are mutually exclusive: `exclusive_minimum`, `minimum`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] maximum
        #   @return [::Float]
        #     Inclusive upper bound.
        #
        #     Note: The following fields are mutually exclusive: `maximum`, `exclusive_maximum`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] exclusive_maximum
        #   @return [::Float]
        #     Exclusive upper bound.
        #
        #     Note: The following fields are mutually exclusive: `exclusive_maximum`, `maximum`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class Interval
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The price information of a {::Google::Cloud::Retail::V2::Product Product}.
        # @!attribute [rw] currency_code
        #   @return [::String]
        #     The 3-letter currency code defined in [ISO
        #     4217](https://www.iso.org/iso-4217-currency-codes.html).
        #
        #     If this field is an unrecognizable currency code, an INVALID_ARGUMENT
        #     error is returned.
        #
        #     The {::Google::Cloud::Retail::V2::Product::Type::VARIANT Product.Type.VARIANT}
        #     {::Google::Cloud::Retail::V2::Product Product}s with the same
        #     {::Google::Cloud::Retail::V2::Product#primary_product_id Product.primary_product_id}
        #     must share the same
        #     {::Google::Cloud::Retail::V2::PriceInfo#currency_code currency_code}. Otherwise,
        #     a FAILED_PRECONDITION error is returned.
        # @!attribute [rw] price
        #   @return [::Float]
        #     Price of the product.
        #
        #     Google Merchant Center property
        #     [price](https://support.google.com/merchants/answer/6324371). Schema.org
        #     property [Offer.price](https://schema.org/price).
        # @!attribute [rw] original_price
        #   @return [::Float]
        #     Price of the product without any discount. If zero, by default set to be
        #     the {::Google::Cloud::Retail::V2::PriceInfo#price price}. If set,
        #     {::Google::Cloud::Retail::V2::PriceInfo#original_price original_price} should be
        #     greater than or equal to {::Google::Cloud::Retail::V2::PriceInfo#price price},
        #     otherwise an INVALID_ARGUMENT error is thrown.
        # @!attribute [rw] cost
        #   @return [::Float]
        #     The costs associated with the sale of a particular product. Used for gross
        #     profit reporting.
        #
        #     * Profit = {::Google::Cloud::Retail::V2::PriceInfo#price price} -
        #     {::Google::Cloud::Retail::V2::PriceInfo#cost cost}
        #
        #     Google Merchant Center property
        #     [cost_of_goods_sold](https://support.google.com/merchants/answer/9017895).
        # @!attribute [rw] price_effective_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The timestamp when the {::Google::Cloud::Retail::V2::PriceInfo#price price}
        #     starts to be effective. This can be set as a future timestamp, and the
        #     {::Google::Cloud::Retail::V2::PriceInfo#price price} is only used for search
        #     after
        #     {::Google::Cloud::Retail::V2::PriceInfo#price_effective_time price_effective_time}.
        #     If so, the
        #     {::Google::Cloud::Retail::V2::PriceInfo#original_price original_price} must be
        #     set and {::Google::Cloud::Retail::V2::PriceInfo#original_price original_price}
        #     is used before
        #     {::Google::Cloud::Retail::V2::PriceInfo#price_effective_time price_effective_time}.
        #
        #     Do not set if {::Google::Cloud::Retail::V2::PriceInfo#price price} is always
        #     effective because it will cause additional latency during search.
        # @!attribute [rw] price_expire_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The timestamp when the {::Google::Cloud::Retail::V2::PriceInfo#price price}
        #     stops to be effective. The {::Google::Cloud::Retail::V2::PriceInfo#price price}
        #     is used for search before
        #     {::Google::Cloud::Retail::V2::PriceInfo#price_expire_time price_expire_time}. If
        #     this field is set, the
        #     {::Google::Cloud::Retail::V2::PriceInfo#original_price original_price} must be
        #     set and {::Google::Cloud::Retail::V2::PriceInfo#original_price original_price}
        #     is used after
        #     {::Google::Cloud::Retail::V2::PriceInfo#price_expire_time price_expire_time}.
        #
        #     Do not set if {::Google::Cloud::Retail::V2::PriceInfo#price price} is always
        #     effective because it will cause additional latency during search.
        # @!attribute [r] price_range
        #   @return [::Google::Cloud::Retail::V2::PriceInfo::PriceRange]
        #     Output only. The price range of all the child
        #     {::Google::Cloud::Retail::V2::Product::Type::VARIANT Product.Type.VARIANT}
        #     {::Google::Cloud::Retail::V2::Product Product}s grouped together on the
        #     {::Google::Cloud::Retail::V2::Product::Type::PRIMARY Product.Type.PRIMARY}
        #     {::Google::Cloud::Retail::V2::Product Product}. Only populated for
        #     {::Google::Cloud::Retail::V2::Product::Type::PRIMARY Product.Type.PRIMARY}
        #     {::Google::Cloud::Retail::V2::Product Product}s.
        #
        #     Note: This field is OUTPUT_ONLY for
        #     {::Google::Cloud::Retail::V2::ProductService::Client#get_product ProductService.GetProduct}.
        #     Do not set this field in API requests.
        class PriceInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The price range of all
          # {::Google::Cloud::Retail::V2::Product::Type::VARIANT variant}
          # {::Google::Cloud::Retail::V2::Product Product} having the same
          # {::Google::Cloud::Retail::V2::Product#primary_product_id Product.primary_product_id}.
          # @!attribute [rw] price
          #   @return [::Google::Cloud::Retail::V2::Interval]
          #     The inclusive
          #     {::Google::Cloud::Retail::V2::PriceInfo#price Product.pricing_info.price}
          #     interval of all {::Google::Cloud::Retail::V2::Product::Type::VARIANT variant}
          #     {::Google::Cloud::Retail::V2::Product Product} having the same
          #     {::Google::Cloud::Retail::V2::Product#primary_product_id Product.primary_product_id}.
          # @!attribute [rw] original_price
          #   @return [::Google::Cloud::Retail::V2::Interval]
          #     The inclusive
          #     {::Google::Cloud::Retail::V2::PriceInfo#original_price Product.pricing_info.original_price}
          #     internal of all {::Google::Cloud::Retail::V2::Product::Type::VARIANT variant}
          #     {::Google::Cloud::Retail::V2::Product Product} having the same
          #     {::Google::Cloud::Retail::V2::Product#primary_product_id Product.primary_product_id}.
          class PriceRange
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The rating of a {::Google::Cloud::Retail::V2::Product Product}.
        # @!attribute [rw] rating_count
        #   @return [::Integer]
        #     The total number of ratings. This value is independent of the value of
        #     {::Google::Cloud::Retail::V2::Rating#rating_histogram rating_histogram}.
        #
        #     This value must be nonnegative. Otherwise, an INVALID_ARGUMENT error is
        #     returned.
        # @!attribute [rw] average_rating
        #   @return [::Float]
        #     The average rating of the {::Google::Cloud::Retail::V2::Product Product}.
        #
        #     The rating is scaled at 1-5. Otherwise, an INVALID_ARGUMENT error is
        #     returned.
        # @!attribute [rw] rating_histogram
        #   @return [::Array<::Integer>]
        #     List of rating counts per rating value (index = rating - 1). The list is
        #     empty if there is no rating. If the list is non-empty, its size is
        #     always 5. Otherwise, an INVALID_ARGUMENT error is returned.
        #
        #     For example, [41, 14, 13, 47, 303]. It means that the
        #     {::Google::Cloud::Retail::V2::Product Product} got 41 ratings with 1 star, 14
        #     ratings with 2 star, and so on.
        class Rating
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Information of an end user.
        # @!attribute [rw] user_id
        #   @return [::String]
        #     Highly recommended for logged-in users. Unique identifier for logged-in
        #     user, such as a user name. Don't set for anonymous users.
        #
        #     Always use a hashed value for this ID.
        #
        #     Don't set the field to the same fixed ID for different users. This mixes
        #     the event history of those users together, which results in degraded
        #     model quality.
        #
        #     The field must be a UTF-8 encoded string with a length limit of 128
        #     characters. Otherwise, an INVALID_ARGUMENT error is returned.
        # @!attribute [rw] ip_address
        #   @return [::String]
        #     The end user's IP address. This field is used to extract location
        #     information for personalization.
        #
        #     This field must be either an IPv4 address (e.g. "104.133.9.80") or an IPv6
        #     address (e.g. "2001:0db8:85a3:0000:0000:8a2e:0370:7334"). Otherwise, an
        #     INVALID_ARGUMENT error is returned.
        #
        #     This should not be set when:
        #
        #     * setting
        #     {::Google::Cloud::Retail::V2::SearchRequest#user_info SearchRequest.user_info}.
        #     * using the JavaScript tag in
        #     {::Google::Cloud::Retail::V2::UserEventService::Client#collect_user_event UserEventService.CollectUserEvent}
        #     or if
        #     {::Google::Cloud::Retail::V2::UserInfo#direct_user_request direct_user_request}
        #     is set.
        # @!attribute [rw] user_agent
        #   @return [::String]
        #     User agent as included in the HTTP header.
        #     The field must be a UTF-8 encoded string with a length limit of 1,000
        #     characters. Otherwise, an INVALID_ARGUMENT error is returned.
        #
        #     This should not be set when using the client side event reporting with
        #     GTM or JavaScript tag in
        #     {::Google::Cloud::Retail::V2::UserEventService::Client#collect_user_event UserEventService.CollectUserEvent}
        #     or if
        #     {::Google::Cloud::Retail::V2::UserInfo#direct_user_request direct_user_request}
        #     is set.
        # @!attribute [rw] direct_user_request
        #   @return [::Boolean]
        #     True if the request is made directly from the end user, in which case the
        #     {::Google::Cloud::Retail::V2::UserInfo#ip_address ip_address} and
        #     {::Google::Cloud::Retail::V2::UserInfo#user_agent user_agent} can be populated
        #     from the HTTP request. This flag should be set only if the API request is
        #     made directly from the end user such as a mobile app (and not if a gateway
        #     or a server is processing and pushing the user events).
        #
        #     This should not be set when using the JavaScript tag in
        #     {::Google::Cloud::Retail::V2::UserEventService::Client#collect_user_event UserEventService.CollectUserEvent}.
        class UserInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The inventory information at a place (e.g. a store) identified
        # by a place ID.
        # @!attribute [rw] place_id
        #   @return [::String]
        #     Optional. The place ID for the current set of inventory information.
        # @!attribute [rw] price_info
        #   @return [::Google::Cloud::Retail::V2::PriceInfo]
        #     Optional. Product price and cost information.
        #
        #     Google Merchant Center property
        #     [price](https://support.google.com/merchants/answer/6324371).
        # @!attribute [rw] attributes
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Retail::V2::CustomAttribute}]
        #     Optional. Additional local inventory attributes, for example, store name,
        #     promotion tags, etc.
        #
        #     This field needs to pass all below criteria, otherwise an INVALID_ARGUMENT
        #     error is returned:
        #
        #     * At most 30 attributes are allowed.
        #     * The key must be a UTF-8 encoded string with a length limit of 32
        #       characters.
        #     * The key must match the pattern: `[a-zA-Z0-9][a-zA-Z0-9_]*`. For example,
        #       key0LikeThis or KEY_1_LIKE_THIS.
        #     * The attribute values must be of the same type (text or number).
        #     * Only 1 value is allowed for each attribute.
        #     * For text values, the length limit is 256 UTF-8 characters.
        #     * The attribute does not support search. The `searchable` field should be
        #       unset or set to false.
        #     * The max summed total bytes of custom attribute keys and values per
        #       product is 5MiB.
        # @!attribute [rw] fulfillment_types
        #   @return [::Array<::String>]
        #     Optional. Supported fulfillment types. Valid fulfillment type values
        #     include commonly used types (such as pickup in store and same day
        #     delivery), and custom types. Customers have to map custom types to their
        #     display names before rendering UI.
        #
        #     Supported values:
        #
        #     * "pickup-in-store"
        #     * "ship-to-store"
        #     * "same-day-delivery"
        #     * "next-day-delivery"
        #     * "custom-type-1"
        #     * "custom-type-2"
        #     * "custom-type-3"
        #     * "custom-type-4"
        #     * "custom-type-5"
        #
        #     If this field is set to an invalid value other than these, an
        #     INVALID_ARGUMENT error is returned.
        #
        #     All the elements must be distinct. Otherwise, an INVALID_ARGUMENT error is
        #     returned.
        class LocalInventory
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::Retail::V2::CustomAttribute]
          class AttributesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Metadata for pinning to be returned in the response.
        # This is used for distinguishing between applied vs dropped pins.
        # @!attribute [rw] all_matched_pins
        #   @return [::Google::Protobuf::Map{::Integer => ::Google::Cloud::Retail::V2::PinControlMetadata::ProductPins}]
        #     Map of all matched pins, keyed by pin position.
        # @!attribute [rw] dropped_pins
        #   @return [::Google::Protobuf::Map{::Integer => ::Google::Cloud::Retail::V2::PinControlMetadata::ProductPins}]
        #     Map of pins that were dropped due to overlap with other matching pins,
        #     keyed by pin position.
        class PinControlMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # List of product ids which have associated pins.
          # @!attribute [rw] product_id
          #   @return [::Array<::String>]
          #     List of product ids which have associated pins.
          class ProductPins
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::Integer]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::Retail::V2::PinControlMetadata::ProductPins]
          class AllMatchedPinsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::Integer]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::Retail::V2::PinControlMetadata::ProductPins]
          class DroppedPinsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # A list of string values.
        # @!attribute [rw] values
        #   @return [::Array<::String>]
        #     String values.
        class StringList
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A message with a list of double values.
        # @!attribute [rw] values
        #   @return [::Array<::Float>]
        #     The list of double values.
        class DoubleList
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # At which level we offer configuration for attributes.
        module AttributeConfigLevel
          # Value used when unset. In this case, server behavior defaults to
          # {::Google::Cloud::Retail::V2::AttributeConfigLevel::CATALOG_LEVEL_ATTRIBUTE_CONFIG CATALOG_LEVEL_ATTRIBUTE_CONFIG}.
          ATTRIBUTE_CONFIG_LEVEL_UNSPECIFIED = 0

          # At this level, we honor the attribute configurations set in
          # {::Google::Cloud::Retail::V2::Product#attributes Product.attributes}.
          PRODUCT_LEVEL_ATTRIBUTE_CONFIG = 1

          # At this level, we honor the attribute configurations set in
          # `CatalogConfig.attribute_configs`.
          CATALOG_LEVEL_ATTRIBUTE_CONFIG = 2
        end

        # The type of solution.
        module SolutionType
          # Default value.
          SOLUTION_TYPE_UNSPECIFIED = 0

          # Used for Recommendations AI.
          SOLUTION_TYPE_RECOMMENDATION = 1

          # Used for Retail Search.
          SOLUTION_TYPE_SEARCH = 2
        end

        # If filtering for recommendations is enabled.
        module RecommendationsFilteringOption
          # Value used when unset.
          # In this case, server behavior defaults to
          # {::Google::Cloud::Retail::V2::RecommendationsFilteringOption::RECOMMENDATIONS_FILTERING_DISABLED RECOMMENDATIONS_FILTERING_DISABLED}.
          RECOMMENDATIONS_FILTERING_OPTION_UNSPECIFIED = 0

          # Recommendation filtering is disabled.
          RECOMMENDATIONS_FILTERING_DISABLED = 1

          # Recommendation filtering is enabled.
          RECOMMENDATIONS_FILTERING_ENABLED = 3
        end

        # The use case of Cloud Retail Search.
        module SearchSolutionUseCase
          # The value when it's unspecified. In this case, server behavior defaults to
          # {::Google::Cloud::Retail::V2::SearchSolutionUseCase::SEARCH_SOLUTION_USE_CASE_SEARCH SEARCH_SOLUTION_USE_CASE_SEARCH}.
          SEARCH_SOLUTION_USE_CASE_UNSPECIFIED = 0

          # Search use case. Expects the traffic has a non-empty
          # {::Google::Cloud::Retail::V2::SearchRequest#query query}.
          SEARCH_SOLUTION_USE_CASE_SEARCH = 1

          # Browse use case. Expects the traffic has an empty
          # {::Google::Cloud::Retail::V2::SearchRequest#query query}.
          SEARCH_SOLUTION_USE_CASE_BROWSE = 2
        end
      end
    end
  end
end
