# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Retail
      module V2
        # Configures what level the product should be uploaded with regards to
        # how users will be send events and how predictions will be made.
        # @!attribute [rw] ingestion_product_type
        #   @return [::String]
        #     The type of {::Google::Cloud::Retail::V2::Product Product}s allowed to be
        #     ingested into the catalog. Acceptable values are:
        #
        #     * `primary` (default): You can ingest
        #     {::Google::Cloud::Retail::V2::Product Product}s of all types. When
        #       ingesting a {::Google::Cloud::Retail::V2::Product Product}, its type will
        #       default to
        #       {::Google::Cloud::Retail::V2::Product::Type::PRIMARY Product.Type.PRIMARY} if
        #       unset.
        #     * `variant` (incompatible with Retail Search): You can only
        #       ingest
        #       {::Google::Cloud::Retail::V2::Product::Type::VARIANT Product.Type.VARIANT}
        #       {::Google::Cloud::Retail::V2::Product Product}s. This means
        #       {::Google::Cloud::Retail::V2::Product#primary_product_id Product.primary_product_id}
        #       cannot be empty.
        #
        #     If this field is set to an invalid value other than these, an
        #     INVALID_ARGUMENT error is returned.
        #
        #     If this field is `variant` and
        #     {::Google::Cloud::Retail::V2::ProductLevelConfig#merchant_center_product_id_field merchant_center_product_id_field}
        #     is `itemGroupId`, an INVALID_ARGUMENT error is returned.
        #
        #     See [Product
        #     levels](https://cloud.google.com/retail/docs/catalog#product-levels)
        #     for more details.
        # @!attribute [rw] merchant_center_product_id_field
        #   @return [::String]
        #     Which field of [Merchant Center
        #     Product](/bigquery-transfer/docs/merchant-center-products-schema) should be
        #     imported as {::Google::Cloud::Retail::V2::Product#id Product.id}. Acceptable
        #     values are:
        #
        #     * `offerId` (default): Import `offerId` as the product ID.
        #     * `itemGroupId`: Import `itemGroupId` as the product ID. Notice that Retail
        #       API will choose one item from the ones with the same `itemGroupId`, and
        #       use it to represent the item group.
        #
        #     If this field is set to an invalid value other than these, an
        #     INVALID_ARGUMENT error is returned.
        #
        #     If this field is `itemGroupId` and
        #     {::Google::Cloud::Retail::V2::ProductLevelConfig#ingestion_product_type ingestion_product_type}
        #     is `variant`, an INVALID_ARGUMENT error is returned.
        #
        #     See [Product
        #     levels](https://cloud.google.com/retail/docs/catalog#product-levels)
        #     for more details.
        class ProductLevelConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Catalog level attribute config for an attribute. For example, if customers
        # want to enable/disable facet for a specific attribute.
        # @!attribute [rw] key
        #   @return [::String]
        #     Required. Attribute name.
        #     For example: `color`, `brands`, `attributes.custom_attribute`, such as
        #     `attributes.xyz`.
        #     To be indexable, the attribute name can contain only alpha-numeric
        #     characters and underscores. For example, an attribute named
        #     `attributes.abc_xyz` can be indexed, but an attribute named
        #     `attributes.abc-xyz` cannot be indexed.
        #
        #     If the attribute key starts with `attributes.`, then the attribute is a
        #     custom attribute. Attributes such as `brands`, `patterns`, and `title` are
        #     built-in and called system attributes.
        # @!attribute [r] in_use
        #   @return [::Boolean]
        #     Output only. Indicates whether this attribute has been used by any
        #     products. `True` if at least one {::Google::Cloud::Retail::V2::Product Product}
        #     is using this attribute in
        #     {::Google::Cloud::Retail::V2::Product#attributes Product.attributes}. Otherwise,
        #     this field is `False`.
        #
        #     {::Google::Cloud::Retail::V2::CatalogAttribute CatalogAttribute} can be
        #     pre-loaded by using
        #     {::Google::Cloud::Retail::V2::CatalogService::Client#add_catalog_attribute CatalogService.AddCatalogAttribute}
        #     or
        #     {::Google::Cloud::Retail::V2::CatalogService::Client#update_attributes_config CatalogService.UpdateAttributesConfig}
        #     APIs. This field is `False` for pre-loaded
        #     {::Google::Cloud::Retail::V2::CatalogAttribute CatalogAttribute}s.
        #
        #     Only pre-loaded [catalog
        #     attributes][google.cloud.retail.v2.CatalogAttribute] that are neither in
        #     use by products nor predefined can be deleted. [Catalog
        #     attributes][google.cloud.retail.v2.CatalogAttribute] that are
        #     either in use by products or are predefined attributes cannot be deleted;
        #     however, their configuration properties will reset to default values upon
        #     removal request.
        #
        #     After catalog changes, it takes about 10 minutes for this field to update.
        # @!attribute [r] type
        #   @return [::Google::Cloud::Retail::V2::CatalogAttribute::AttributeType]
        #     Output only. The type of this attribute. This is derived from the attribute
        #     in {::Google::Cloud::Retail::V2::Product#attributes Product.attributes}.
        # @!attribute [rw] indexable_option
        #   @return [::Google::Cloud::Retail::V2::CatalogAttribute::IndexableOption]
        #     When
        #     {::Google::Cloud::Retail::V2::AttributesConfig#attribute_config_level AttributesConfig.attribute_config_level}
        #     is CATALOG_LEVEL_ATTRIBUTE_CONFIG, if INDEXABLE_ENABLED attribute values
        #     are indexed so that it can be filtered, faceted, or boosted in
        #     {::Google::Cloud::Retail::V2::SearchService::Client#search SearchService.Search}.
        #
        #     Must be specified when
        #     {::Google::Cloud::Retail::V2::AttributesConfig#attribute_config_level AttributesConfig.attribute_config_level}
        #     is CATALOG_LEVEL_ATTRIBUTE_CONFIG, otherwise throws INVALID_FORMAT error.
        # @!attribute [rw] dynamic_facetable_option
        #   @return [::Google::Cloud::Retail::V2::CatalogAttribute::DynamicFacetableOption]
        #     If DYNAMIC_FACETABLE_ENABLED, attribute values are available for dynamic
        #     facet. Could only be DYNAMIC_FACETABLE_DISABLED if
        #     {::Google::Cloud::Retail::V2::CatalogAttribute#indexable_option CatalogAttribute.indexable_option}
        #     is INDEXABLE_DISABLED. Otherwise, an INVALID_ARGUMENT error is returned.
        #
        #     Must be specified, otherwise throws INVALID_FORMAT error.
        # @!attribute [rw] searchable_option
        #   @return [::Google::Cloud::Retail::V2::CatalogAttribute::SearchableOption]
        #     When
        #     {::Google::Cloud::Retail::V2::AttributesConfig#attribute_config_level AttributesConfig.attribute_config_level}
        #     is CATALOG_LEVEL_ATTRIBUTE_CONFIG, if SEARCHABLE_ENABLED, attribute values
        #     are searchable by text queries in
        #     {::Google::Cloud::Retail::V2::SearchService::Client#search SearchService.Search}.
        #
        #     If SEARCHABLE_ENABLED but attribute type is numerical, attribute values
        #     will not be searchable by text queries in
        #     {::Google::Cloud::Retail::V2::SearchService::Client#search SearchService.Search}, as
        #     there are no text values associated to numerical attributes.
        #
        #     Must be specified, when
        #     {::Google::Cloud::Retail::V2::AttributesConfig#attribute_config_level AttributesConfig.attribute_config_level}
        #     is CATALOG_LEVEL_ATTRIBUTE_CONFIG, otherwise throws INVALID_FORMAT error.
        # @!attribute [rw] exact_searchable_option
        #   @return [::Google::Cloud::Retail::V2::CatalogAttribute::ExactSearchableOption]
        #     If EXACT_SEARCHABLE_ENABLED, attribute values will be exact searchable.
        #     This property only applies to textual custom attributes and requires
        #     indexable set to enabled to enable exact-searchable. If unset, the server
        #     behavior defaults to
        #     {::Google::Cloud::Retail::V2::CatalogAttribute::ExactSearchableOption::EXACT_SEARCHABLE_DISABLED EXACT_SEARCHABLE_DISABLED}.
        # @!attribute [rw] retrievable_option
        #   @return [::Google::Cloud::Retail::V2::CatalogAttribute::RetrievableOption]
        #     If RETRIEVABLE_ENABLED, attribute values are retrievable in the search
        #     results. If unset, the server behavior defaults to
        #     {::Google::Cloud::Retail::V2::CatalogAttribute::RetrievableOption::RETRIEVABLE_DISABLED RETRIEVABLE_DISABLED}.
        # @!attribute [rw] facet_config
        #   @return [::Google::Cloud::Retail::V2::CatalogAttribute::FacetConfig]
        #     Contains facet options.
        class CatalogAttribute
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Possible options for the facet that corresponds to the current attribute
          # config.
          # @!attribute [rw] facet_intervals
          #   @return [::Array<::Google::Cloud::Retail::V2::Interval>]
          #     If you don't set the facet
          #     {::Google::Cloud::Retail::V2::SearchRequest::FacetSpec::FacetKey#intervals SearchRequest.FacetSpec.FacetKey.intervals}
          #     in the request to a numerical attribute, then we use the computed
          #     intervals with rounded bounds obtained from all its product numerical
          #     attribute values. The computed intervals might not be ideal for some
          #     attributes. Therefore, we give you the option to overwrite them with the
          #     facet_intervals field. The maximum of facet intervals per
          #     {::Google::Cloud::Retail::V2::CatalogAttribute CatalogAttribute} is 40. Each
          #     interval must have a lower bound or an upper bound. If both bounds are
          #     provided, then the lower bound must be smaller or equal than the upper
          #     bound.
          # @!attribute [rw] ignored_facet_values
          #   @return [::Array<::Google::Cloud::Retail::V2::CatalogAttribute::FacetConfig::IgnoredFacetValues>]
          #     Each instance represents a list of attribute values to ignore as facet
          #     values for a specific time range. The maximum number of instances per
          #     {::Google::Cloud::Retail::V2::CatalogAttribute CatalogAttribute} is 25.
          # @!attribute [rw] merged_facet_values
          #   @return [::Array<::Google::Cloud::Retail::V2::CatalogAttribute::FacetConfig::MergedFacetValue>]
          #     Each instance replaces a list of facet values by a merged facet
          #     value. If a facet value is not in any list, then it will stay the same.
          #     To avoid conflicts, only paths of length 1 are accepted. In other words,
          #     if "dark_blue" merged into "BLUE", then the latter can't merge into
          #     "blues" because this would create a path of length 2. The maximum number
          #     of instances of MergedFacetValue per
          #     {::Google::Cloud::Retail::V2::CatalogAttribute CatalogAttribute} is 100. This
          #     feature is available only for textual custom attributes.
          # @!attribute [rw] merged_facet
          #   @return [::Google::Cloud::Retail::V2::CatalogAttribute::FacetConfig::MergedFacet]
          #     Use this field only if you want to merge a facet key into another facet
          #     key.
          # @!attribute [rw] rerank_config
          #   @return [::Google::Cloud::Retail::V2::CatalogAttribute::FacetConfig::RerankConfig]
          #     Set this field only if you want to rerank based on facet values engaged
          #     by the user for the current key. This option is only possible for custom
          #     facetable textual keys.
          class FacetConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # {::Google::Cloud::Retail::V2::SearchResponse::Facet#values Facet values} to
            # ignore on {::Google::Cloud::Retail::V2::SearchResponse::Facet facets} during
            # the specified time range for the given
            # {::Google::Cloud::Retail::V2::SearchResponse::Facet#key SearchResponse.Facet.key}
            # attribute.
            # @!attribute [rw] values
            #   @return [::Array<::String>]
            #     List of facet values to ignore for the following time range. The facet
            #     values are the same as the attribute values. There is a limit of 10
            #     values per instance of IgnoredFacetValues. Each value can have at most
            #     128 characters.
            # @!attribute [rw] start_time
            #   @return [::Google::Protobuf::Timestamp]
            #     Time range for the current list of facet values to ignore.
            #     If multiple time ranges are specified for an facet value for the
            #     current attribute, consider all of them. If both are empty, ignore
            #     always. If start time and end time are set, then start time
            #     must be before end time.
            #     If start time is not empty and end time is empty, then will ignore
            #     these facet values after the start time.
            # @!attribute [rw] end_time
            #   @return [::Google::Protobuf::Timestamp]
            #     If start time is empty and end time is not empty, then ignore these
            #     facet values before end time.
            class IgnoredFacetValues
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Replaces a set of textual facet values by the same (possibly different)
            # merged facet value. Each facet value should appear at most once as a
            # value per {::Google::Cloud::Retail::V2::CatalogAttribute CatalogAttribute}.
            # This feature is available only for textual custom attributes.
            # @!attribute [rw] values
            #   @return [::Array<::String>]
            #     All the facet values that are replaces by the same
            #     {::Google::Cloud::Retail::V2::CatalogAttribute::FacetConfig::MergedFacetValue#merged_value merged_value}
            #     that follows. The maximum number of values per MergedFacetValue is 25.
            #     Each value can have up to 128 characters.
            # @!attribute [rw] merged_value
            #   @return [::String]
            #     All the previous values are replaced by this merged facet value.
            #     This merged_value must be non-empty and can have up to 128 characters.
            class MergedFacetValue
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The current facet key (i.e. attribute config) maps into the
            # {::Google::Cloud::Retail::V2::CatalogAttribute::FacetConfig::MergedFacet#merged_facet_key merged_facet_key}.
            # A facet key can have at most one child. The current facet key and the
            # merged facet key need both to be textual custom attributes or both
            # numerical custom attributes (same type).
            # @!attribute [rw] merged_facet_key
            #   @return [::String]
            #     The merged facet key should be a valid facet key that is different than
            #     the facet key of the current catalog attribute. We refer this is
            #     merged facet key as the child of the current catalog attribute. This
            #     merged facet key can't be a parent of another facet key (i.e. no
            #     directed path of length 2). This merged facet key needs to be either a
            #     textual custom attribute or a numerical custom attribute.
            class MergedFacet
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Options to rerank based on facet values engaged by the user for the
            # current key. That key needs to be a custom textual key and facetable.
            # To use this control, you also need to pass all the facet keys engaged by
            # the user in the request using the field [SearchRequest.FacetSpec]. In
            # particular, if you don't pass the facet keys engaged that you want to
            # rerank on, this control won't be effective. Moreover, to obtain better
            # results, the facet values that you want to rerank on should be close to
            # English (ideally made of words, underscores, and spaces).
            # @!attribute [rw] rerank_facet
            #   @return [::Boolean]
            #     If set to true, then we also rerank the dynamic facets based on the
            #     facet values engaged by the user for the current attribute key during
            #     serving.
            # @!attribute [rw] facet_values
            #   @return [::Array<::String>]
            #     If empty, rerank on all facet values for the current key. Otherwise,
            #     will rerank on the facet values from this list only.
            class RerankConfig
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # The type of an attribute.
          module AttributeType
            # The type of the attribute is unknown.
            #
            # Used when type cannot be derived from attribute that is not
            # {::Google::Cloud::Retail::V2::CatalogAttribute#in_use in_use}.
            UNKNOWN = 0

            # Textual attribute.
            TEXTUAL = 1

            # Numerical attribute.
            NUMERICAL = 2
          end

          # The status of the indexable option of a catalog attribute.
          module IndexableOption
            # Value used when unset.
            INDEXABLE_OPTION_UNSPECIFIED = 0

            # Indexable option enabled for an attribute.
            INDEXABLE_ENABLED = 1

            # Indexable option disabled for an attribute.
            INDEXABLE_DISABLED = 2
          end

          # The status of the dynamic facetable option of a catalog attribute.
          module DynamicFacetableOption
            # Value used when unset.
            DYNAMIC_FACETABLE_OPTION_UNSPECIFIED = 0

            # Dynamic facetable option enabled for an attribute.
            DYNAMIC_FACETABLE_ENABLED = 1

            # Dynamic facetable option disabled for an attribute.
            DYNAMIC_FACETABLE_DISABLED = 2
          end

          # The status of the searchable option of a catalog attribute.
          module SearchableOption
            # Value used when unset.
            SEARCHABLE_OPTION_UNSPECIFIED = 0

            # Searchable option enabled for an attribute.
            SEARCHABLE_ENABLED = 1

            # Searchable option disabled for an attribute.
            SEARCHABLE_DISABLED = 2
          end

          # The status of the exact-searchable option of a catalog attribute.
          module ExactSearchableOption
            # Value used when unset.
            EXACT_SEARCHABLE_OPTION_UNSPECIFIED = 0

            # Exact searchable option enabled for an attribute.
            EXACT_SEARCHABLE_ENABLED = 1

            # Exact searchable option disabled for an attribute.
            EXACT_SEARCHABLE_DISABLED = 2
          end

          # The status of the retrievable option of a catalog attribute.
          module RetrievableOption
            # Value used when unset.
            RETRIEVABLE_OPTION_UNSPECIFIED = 0

            # Retrievable option enabled for an attribute.
            RETRIEVABLE_ENABLED = 1

            # Retrievable option disabled for an attribute.
            RETRIEVABLE_DISABLED = 2
          end
        end

        # Catalog level attribute config.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Immutable. The fully qualified resource name of the attribute
        #     config. Format: `projects/*/locations/*/catalogs/*/attributesConfig`
        # @!attribute [rw] catalog_attributes
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Retail::V2::CatalogAttribute}]
        #     Enable attribute(s) config at catalog level.
        #     For example, indexable, dynamic_facetable, or searchable for each
        #     attribute.
        #
        #     The key is catalog attribute's name.
        #     For example: `color`, `brands`, `attributes.custom_attribute`, such as
        #     `attributes.xyz`.
        #
        #     The maximum number of catalog attributes allowed in a request is 1000.
        # @!attribute [r] attribute_config_level
        #   @return [::Google::Cloud::Retail::V2::AttributeConfigLevel]
        #     Output only. The
        #     {::Google::Cloud::Retail::V2::AttributeConfigLevel AttributeConfigLevel} used
        #     for this catalog.
        class AttributesConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::Retail::V2::CatalogAttribute]
          class CatalogAttributesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Catalog level autocomplete config for customers to customize autocomplete
        # feature's settings.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Immutable. Fully qualified name
        #     `projects/*/locations/*/catalogs/*/completionConfig`
        # @!attribute [rw] matching_order
        #   @return [::String]
        #     Specifies the matching order for autocomplete suggestions, e.g., a query
        #     consisting of 'sh' with 'out-of-order' specified would suggest "women's
        #     shoes", whereas a query of 'red s' with 'exact-prefix' specified would
        #     suggest "red shoes". Currently supported values:
        #
        #     * 'out-of-order'
        #     * 'exact-prefix'
        #
        #     Default value: 'exact-prefix'.
        # @!attribute [rw] max_suggestions
        #   @return [::Integer]
        #     The maximum number of autocomplete suggestions returned per term. Default
        #     value is 20. If left unset or set to 0, then will fallback to default
        #     value.
        #
        #     Value range is 1 to 20.
        # @!attribute [rw] min_prefix_length
        #   @return [::Integer]
        #     The minimum number of characters needed to be typed in order to get
        #     suggestions. Default value is 2. If left unset or set to 0, then will
        #     fallback to default value.
        #
        #     Value range is 1 to 20.
        # @!attribute [rw] auto_learning
        #   @return [::Boolean]
        #     If set to true, the auto learning function is enabled. Auto learning uses
        #     user data to generate suggestions using ML techniques. Default value is
        #     false. Only after enabling auto learning can users use `cloud-retail`
        #     data in
        #     {::Google::Cloud::Retail::V2::CompleteQueryRequest CompleteQueryRequest}.
        # @!attribute [r] suggestions_input_config
        #   @return [::Google::Cloud::Retail::V2::CompletionDataInputConfig]
        #     Output only. The source data for the latest import of the autocomplete
        #     suggestion phrases.
        # @!attribute [r] last_suggestions_import_operation
        #   @return [::String]
        #     Output only. Name of the LRO corresponding to the latest suggestion terms
        #     list import.
        #
        #     Can use GetOperation API
        #     method to retrieve the latest state of the Long Running Operation.
        # @!attribute [r] denylist_input_config
        #   @return [::Google::Cloud::Retail::V2::CompletionDataInputConfig]
        #     Output only. The source data for the latest import of the autocomplete
        #     denylist phrases.
        # @!attribute [r] last_denylist_import_operation
        #   @return [::String]
        #     Output only. Name of the LRO corresponding to the latest denylist import.
        #
        #     Can use GetOperation API to
        #     retrieve the latest state of the Long Running Operation.
        # @!attribute [r] allowlist_input_config
        #   @return [::Google::Cloud::Retail::V2::CompletionDataInputConfig]
        #     Output only. The source data for the latest import of the autocomplete
        #     allowlist phrases.
        # @!attribute [r] last_allowlist_import_operation
        #   @return [::String]
        #     Output only. Name of the LRO corresponding to the latest allowlist import.
        #
        #     Can use GetOperation API to
        #     retrieve the latest state of the Long Running Operation.
        class CompletionConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The catalog configuration.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Immutable. The fully qualified resource name of the catalog.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. Immutable. The catalog display name.
        #
        #     This field must be a UTF-8 encoded string with a length limit of 128
        #     characters. Otherwise, an INVALID_ARGUMENT error is returned.
        # @!attribute [rw] product_level_config
        #   @return [::Google::Cloud::Retail::V2::ProductLevelConfig]
        #     Required. The product level configuration.
        class Catalog
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
