# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/retail/v2/product_service_pb"
require "google/cloud/location"

module Google
  module Cloud
    module Retail
      module V2
        module ProductService
          ##
          # Client for the ProductService service.
          #
          # Service for ingesting {::Google::Cloud::Retail::V2::Product Product} information
          # of the customer's website.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "retail.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :product_service_stub

            ##
            # Configure the ProductService Client class.
            #
            # See {::Google::Cloud::Retail::V2::ProductService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all ProductService clients
            #   ::Google::Cloud::Retail::V2::ProductService::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "Retail", "V2"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.timeout = 30.0
                default_config.retry_policy = {
                  initial_delay: 0.1, max_delay: 30.0, multiplier: 1.3, retry_codes: [14, 4]
                }

                default_config.rpcs.import_products.timeout = 300.0
                default_config.rpcs.import_products.retry_policy = {
                  initial_delay: 0.1, max_delay: 300.0, multiplier: 1.3, retry_codes: [14, 4]
                }

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the ProductService Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::Retail::V2::ProductService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @product_service_stub.universe_domain
            end

            ##
            # Create a new ProductService client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::Retail::V2::ProductService::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::Retail::V2::ProductService::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the ProductService client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/retail/v2/product_service_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @product_service_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::Retail::V2::ProductService::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @product_service_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @location_client = Google::Cloud::Location::Locations::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @product_service_stub.endpoint
                config.universe_domain = @product_service_stub.universe_domain
                config.logger = @product_service_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Cloud::Retail::V2::ProductService::Operations]
            #
            attr_reader :operations_client

            ##
            # Get the associated client for mix-in of the Locations.
            #
            # @return [Google::Cloud::Location::Locations::Client]
            #
            attr_reader :location_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @product_service_stub.logger
            end

            # Service calls

            ##
            # Creates a {::Google::Cloud::Retail::V2::Product Product}.
            #
            # @overload create_product(request, options = nil)
            #   Pass arguments to `create_product` via a request object, either of type
            #   {::Google::Cloud::Retail::V2::CreateProductRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Retail::V2::CreateProductRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_product(parent: nil, product: nil, product_id: nil)
            #   Pass arguments to `create_product` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent catalog resource name, such as
            #     `projects/*/locations/global/catalogs/default_catalog/branches/default_branch`.
            #   @param product [::Google::Cloud::Retail::V2::Product, ::Hash]
            #     Required. The {::Google::Cloud::Retail::V2::Product Product} to create.
            #   @param product_id [::String]
            #     Required. The ID to use for the {::Google::Cloud::Retail::V2::Product Product},
            #     which will become the final component of the
            #     {::Google::Cloud::Retail::V2::Product#name Product.name}.
            #
            #     If the caller does not have permission to create the
            #     {::Google::Cloud::Retail::V2::Product Product}, regardless of whether or not it
            #     exists, a PERMISSION_DENIED error is returned.
            #
            #     This field must be unique among all
            #     {::Google::Cloud::Retail::V2::Product Product}s with the same
            #     {::Google::Cloud::Retail::V2::CreateProductRequest#parent parent}. Otherwise, an
            #     ALREADY_EXISTS error is returned.
            #
            #     This field must be a UTF-8 encoded string with a length limit of 128
            #     characters. Otherwise, an INVALID_ARGUMENT error is returned.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Retail::V2::Product]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Retail::V2::Product]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/retail/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Retail::V2::ProductService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Retail::V2::CreateProductRequest.new
            #
            #   # Call the create_product method.
            #   result = client.create_product request
            #
            #   # The returned object is of type Google::Cloud::Retail::V2::Product.
            #   p result
            #
            def create_product request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Retail::V2::CreateProductRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_product.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Retail::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_product.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_product.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @product_service_stub.call_rpc :create_product, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a {::Google::Cloud::Retail::V2::Product Product}.
            #
            # @overload get_product(request, options = nil)
            #   Pass arguments to `get_product` via a request object, either of type
            #   {::Google::Cloud::Retail::V2::GetProductRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Retail::V2::GetProductRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_product(name: nil)
            #   Pass arguments to `get_product` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Full resource name of {::Google::Cloud::Retail::V2::Product Product},
            #     such as
            #     `projects/*/locations/global/catalogs/default_catalog/branches/default_branch/products/some_product_id`.
            #
            #     If the caller does not have permission to access the
            #     {::Google::Cloud::Retail::V2::Product Product}, regardless of whether or not it
            #     exists, a PERMISSION_DENIED error is returned.
            #
            #     If the requested {::Google::Cloud::Retail::V2::Product Product} does not exist,
            #     a NOT_FOUND error is returned.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Retail::V2::Product]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Retail::V2::Product]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/retail/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Retail::V2::ProductService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Retail::V2::GetProductRequest.new
            #
            #   # Call the get_product method.
            #   result = client.get_product request
            #
            #   # The returned object is of type Google::Cloud::Retail::V2::Product.
            #   p result
            #
            def get_product request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Retail::V2::GetProductRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_product.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Retail::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_product.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_product.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @product_service_stub.call_rpc :get_product, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a list of {::Google::Cloud::Retail::V2::Product Product}s.
            #
            # @overload list_products(request, options = nil)
            #   Pass arguments to `list_products` via a request object, either of type
            #   {::Google::Cloud::Retail::V2::ListProductsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Retail::V2::ListProductsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_products(parent: nil, page_size: nil, page_token: nil, filter: nil, read_mask: nil)
            #   Pass arguments to `list_products` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent branch resource name, such as
            #     `projects/*/locations/global/catalogs/default_catalog/branches/0`. Use
            #     `default_branch` as the branch ID, to list products under the default
            #     branch.
            #
            #     If the caller does not have permission to list
            #     {::Google::Cloud::Retail::V2::Product Product}s under this branch, regardless of
            #     whether or not this branch exists, a PERMISSION_DENIED error is returned.
            #   @param page_size [::Integer]
            #     Maximum number of {::Google::Cloud::Retail::V2::Product Product}s to return. If
            #     unspecified, defaults to 100. The maximum allowed value is 1000. Values
            #     above 1000 will be coerced to 1000.
            #
            #     If this field is negative, an INVALID_ARGUMENT error is returned.
            #   @param page_token [::String]
            #     A page token
            #     {::Google::Cloud::Retail::V2::ListProductsResponse#next_page_token ListProductsResponse.next_page_token},
            #     received from a previous
            #     {::Google::Cloud::Retail::V2::ProductService::Client#list_products ProductService.ListProducts}
            #     call. Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to
            #     {::Google::Cloud::Retail::V2::ProductService::Client#list_products ProductService.ListProducts}
            #     must match the call that provided the page token. Otherwise, an
            #     INVALID_ARGUMENT error is returned.
            #   @param filter [::String]
            #     A filter to apply on the list results. Supported features:
            #
            #     * List all the products under the parent branch if
            #     {::Google::Cloud::Retail::V2::ListProductsRequest#filter filter} is unset.
            #     * List {::Google::Cloud::Retail::V2::Product::Type::VARIANT Product.Type.VARIANT}
            #     {::Google::Cloud::Retail::V2::Product Product}s sharing the same
            #       {::Google::Cloud::Retail::V2::Product::Type::PRIMARY Product.Type.PRIMARY}
            #       {::Google::Cloud::Retail::V2::Product Product}. For example:
            #         `primary_product_id = "some_product_id"`
            #     * List {::Google::Cloud::Retail::V2::Product Product}s bundled in a
            #     {::Google::Cloud::Retail::V2::Product::Type::COLLECTION Product.Type.COLLECTION}
            #     {::Google::Cloud::Retail::V2::Product Product}.
            #       For example:
            #         `collection_product_id = "some_product_id"`
            #     * List {::Google::Cloud::Retail::V2::Product Product}s with a partibular type.
            #     For example:
            #         `type = "PRIMARY"`
            #         `type = "VARIANT"`
            #         `type = "COLLECTION"`
            #
            #     If the field is unrecognizable, an INVALID_ARGUMENT error is returned.
            #
            #     If the specified
            #     {::Google::Cloud::Retail::V2::Product::Type::PRIMARY Product.Type.PRIMARY}
            #     {::Google::Cloud::Retail::V2::Product Product} or
            #     {::Google::Cloud::Retail::V2::Product::Type::COLLECTION Product.Type.COLLECTION}
            #     {::Google::Cloud::Retail::V2::Product Product} does not exist, a NOT_FOUND error
            #     is returned.
            #   @param read_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     The fields of {::Google::Cloud::Retail::V2::Product Product} to return in the
            #     responses. If not set or empty, the following fields are returned:
            #
            #     * {::Google::Cloud::Retail::V2::Product#name Product.name}
            #     * {::Google::Cloud::Retail::V2::Product#id Product.id}
            #     * {::Google::Cloud::Retail::V2::Product#title Product.title}
            #     * {::Google::Cloud::Retail::V2::Product#uri Product.uri}
            #     * {::Google::Cloud::Retail::V2::Product#images Product.images}
            #     * {::Google::Cloud::Retail::V2::Product#price_info Product.price_info}
            #     * {::Google::Cloud::Retail::V2::Product#brands Product.brands}
            #
            #     If "*" is provided, all fields are returned.
            #     {::Google::Cloud::Retail::V2::Product#name Product.name} is always returned no
            #     matter what mask is set.
            #
            #     If an unsupported or unknown field is provided, an INVALID_ARGUMENT error
            #     is returned.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Retail::V2::Product>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Retail::V2::Product>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/retail/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Retail::V2::ProductService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Retail::V2::ListProductsRequest.new
            #
            #   # Call the list_products method.
            #   result = client.list_products request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Retail::V2::Product.
            #     p item
            #   end
            #
            def list_products request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Retail::V2::ListProductsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_products.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Retail::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_products.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_products.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @product_service_stub.call_rpc :list_products, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @product_service_stub, :list_products, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a {::Google::Cloud::Retail::V2::Product Product}.
            #
            # @overload update_product(request, options = nil)
            #   Pass arguments to `update_product` via a request object, either of type
            #   {::Google::Cloud::Retail::V2::UpdateProductRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Retail::V2::UpdateProductRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_product(product: nil, update_mask: nil, allow_missing: nil)
            #   Pass arguments to `update_product` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param product [::Google::Cloud::Retail::V2::Product, ::Hash]
            #     Required. The product to update/create.
            #
            #     If the caller does not have permission to update the
            #     {::Google::Cloud::Retail::V2::Product Product}, regardless of whether or not it
            #     exists, a PERMISSION_DENIED error is returned.
            #
            #     If the {::Google::Cloud::Retail::V2::Product Product} to update does not exist
            #     and
            #     {::Google::Cloud::Retail::V2::UpdateProductRequest#allow_missing allow_missing}
            #     is not set, a NOT_FOUND error is returned.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Indicates which fields in the provided
            #     {::Google::Cloud::Retail::V2::Product Product} to update. The immutable and
            #     output only fields are NOT supported. If not set, all supported fields (the
            #     fields that are neither immutable nor output only) are updated.
            #
            #     If an unsupported or unknown field is provided, an INVALID_ARGUMENT error
            #     is returned.
            #
            #     The attribute key can be updated by setting the mask path as
            #     "attributes.$\\{key_name}". If a key name is present in the mask but not in
            #     the patching product from the request, this key will be deleted after the
            #     update.
            #   @param allow_missing [::Boolean]
            #     If set to true, and the {::Google::Cloud::Retail::V2::Product Product} is not
            #     found, a new {::Google::Cloud::Retail::V2::Product Product} will be created. In
            #     this situation, `update_mask` is ignored.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Retail::V2::Product]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Retail::V2::Product]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/retail/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Retail::V2::ProductService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Retail::V2::UpdateProductRequest.new
            #
            #   # Call the update_product method.
            #   result = client.update_product request
            #
            #   # The returned object is of type Google::Cloud::Retail::V2::Product.
            #   p result
            #
            def update_product request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Retail::V2::UpdateProductRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_product.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Retail::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.product&.name
                header_params["product.name"] = request.product.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_product.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_product.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @product_service_stub.call_rpc :update_product, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a {::Google::Cloud::Retail::V2::Product Product}.
            #
            # @overload delete_product(request, options = nil)
            #   Pass arguments to `delete_product` via a request object, either of type
            #   {::Google::Cloud::Retail::V2::DeleteProductRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Retail::V2::DeleteProductRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_product(name: nil)
            #   Pass arguments to `delete_product` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Full resource name of {::Google::Cloud::Retail::V2::Product Product},
            #     such as
            #     `projects/*/locations/global/catalogs/default_catalog/branches/default_branch/products/some_product_id`.
            #
            #     If the caller does not have permission to delete the
            #     {::Google::Cloud::Retail::V2::Product Product}, regardless of whether or not it
            #     exists, a PERMISSION_DENIED error is returned.
            #
            #     If the {::Google::Cloud::Retail::V2::Product Product} to delete does not exist,
            #     a NOT_FOUND error is returned.
            #
            #     The {::Google::Cloud::Retail::V2::Product Product} to delete can neither be a
            #     {::Google::Cloud::Retail::V2::Product::Type::COLLECTION Product.Type.COLLECTION}
            #     {::Google::Cloud::Retail::V2::Product Product} member nor a
            #     {::Google::Cloud::Retail::V2::Product::Type::PRIMARY Product.Type.PRIMARY}
            #     {::Google::Cloud::Retail::V2::Product Product} with more than one
            #     {::Google::Cloud::Retail::V2::Product::Type::VARIANT variants}. Otherwise, an
            #     INVALID_ARGUMENT error is returned.
            #
            #     All inventory information for the named
            #     {::Google::Cloud::Retail::V2::Product Product} will be deleted.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/retail/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Retail::V2::ProductService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Retail::V2::DeleteProductRequest.new
            #
            #   # Call the delete_product method.
            #   result = client.delete_product request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_product request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Retail::V2::DeleteProductRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_product.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Retail::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_product.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_product.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @product_service_stub.call_rpc :delete_product, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Permanently deletes all selected {::Google::Cloud::Retail::V2::Product Product}s
            # under a branch.
            #
            # This process is asynchronous. If the request is valid, the removal will be
            # enqueued and processed offline. Depending on the number of
            # {::Google::Cloud::Retail::V2::Product Product}s, this operation could take hours
            # to complete. Before the operation completes, some
            # {::Google::Cloud::Retail::V2::Product Product}s may still be returned by
            # {::Google::Cloud::Retail::V2::ProductService::Client#get_product ProductService.GetProduct}
            # or
            # {::Google::Cloud::Retail::V2::ProductService::Client#list_products ProductService.ListProducts}.
            #
            # Depending on the number of {::Google::Cloud::Retail::V2::Product Product}s, this
            # operation could take hours to complete. To get a sample of
            # {::Google::Cloud::Retail::V2::Product Product}s that would be deleted, set
            # {::Google::Cloud::Retail::V2::PurgeProductsRequest#force PurgeProductsRequest.force}
            # to false.
            #
            # @overload purge_products(request, options = nil)
            #   Pass arguments to `purge_products` via a request object, either of type
            #   {::Google::Cloud::Retail::V2::PurgeProductsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Retail::V2::PurgeProductsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload purge_products(parent: nil, filter: nil, force: nil)
            #   Pass arguments to `purge_products` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the branch under which the products are
            #     created. The format is
            #     `projects/${projectId}/locations/global/catalogs/${catalogId}/branches/${branchId}`
            #   @param filter [::String]
            #     Required. The filter string to specify the products to be deleted with a
            #     length limit of 5,000 characters.
            #
            #     Empty string filter is not allowed. "*" implies delete all items in a
            #     branch.
            #
            #     The eligible fields for filtering are:
            #
            #     * `availability`: Double quoted
            #     {::Google::Cloud::Retail::V2::Product#availability Product.availability} string.
            #     * `create_time` : in ISO 8601 "zulu" format.
            #
            #     Supported syntax:
            #
            #     * Comparators (">", "<", ">=", "<=", "=").
            #       Examples:
            #       * create_time <= "2015-02-13T17:05:46Z"
            #       * availability = "IN_STOCK"
            #
            #     * Conjunctions ("AND")
            #       Examples:
            #       * create_time <= "2015-02-13T17:05:46Z" AND availability = "PREORDER"
            #
            #     * Disjunctions ("OR")
            #       Examples:
            #       * create_time <= "2015-02-13T17:05:46Z" OR availability = "IN_STOCK"
            #
            #     * Can support nested queries.
            #       Examples:
            #       * (create_time <= "2015-02-13T17:05:46Z" AND availability = "PREORDER")
            #       OR (create_time >= "2015-02-14T13:03:32Z" AND availability = "IN_STOCK")
            #
            #     * Filter Limits:
            #       * Filter should not contain more than 6 conditions.
            #       * Max nesting depth should not exceed 2 levels.
            #
            #     Examples queries:
            #     * Delete back order products created before a timestamp.
            #       create_time <= "2015-02-13T17:05:46Z" OR availability = "BACKORDER"
            #   @param force [::Boolean]
            #     Actually perform the purge.
            #     If `force` is set to false, the method will return the expected purge count
            #     without deleting any products.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/retail/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Retail::V2::ProductService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Retail::V2::PurgeProductsRequest.new
            #
            #   # Call the purge_products method.
            #   result = client.purge_products request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def purge_products request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Retail::V2::PurgeProductsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.purge_products.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Retail::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.purge_products.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.purge_products.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @product_service_stub.call_rpc :purge_products, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Bulk import of multiple {::Google::Cloud::Retail::V2::Product Product}s.
            #
            # Request processing may be synchronous.
            # Non-existing items are created.
            #
            # Note that it is possible for a subset of the
            # {::Google::Cloud::Retail::V2::Product Product}s to be successfully updated.
            #
            # @overload import_products(request, options = nil)
            #   Pass arguments to `import_products` via a request object, either of type
            #   {::Google::Cloud::Retail::V2::ImportProductsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Retail::V2::ImportProductsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload import_products(parent: nil, request_id: nil, input_config: nil, errors_config: nil, update_mask: nil, reconciliation_mode: nil, notification_pubsub_topic: nil)
            #   Pass arguments to `import_products` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required.
            #     `projects/1234/locations/global/catalogs/default_catalog/branches/default_branch`
            #
            #     If no updateMask is specified, requires products.create permission.
            #     If updateMask is specified, requires products.update permission.
            #   @param request_id [::String]
            #     Deprecated. This field has no effect.
            #   @param input_config [::Google::Cloud::Retail::V2::ProductInputConfig, ::Hash]
            #     Required. The desired input location of the data.
            #   @param errors_config [::Google::Cloud::Retail::V2::ImportErrorsConfig, ::Hash]
            #     The desired location of errors incurred during the Import.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Indicates which fields in the provided imported `products` to update. If
            #     not set, all fields are updated. If provided, only the existing product
            #     fields are updated. Missing products will not be created.
            #   @param reconciliation_mode [::Google::Cloud::Retail::V2::ImportProductsRequest::ReconciliationMode]
            #     The mode of reconciliation between existing products and the products to be
            #     imported. Defaults to
            #     {::Google::Cloud::Retail::V2::ImportProductsRequest::ReconciliationMode::INCREMENTAL ReconciliationMode.INCREMENTAL}.
            #   @param notification_pubsub_topic [::String]
            #     Full Pub/Sub topic name for receiving notification. If this field is set,
            #     when the import is finished, a notification is sent to
            #     specified Pub/Sub topic. The message data is JSON string of a
            #     {::Google::Longrunning::Operation Operation}.
            #
            #     Format of the Pub/Sub topic is `projects/{project}/topics/{topic}`. It has
            #     to be within the same project as
            #     {::Google::Cloud::Retail::V2::ImportProductsRequest#parent ImportProductsRequest.parent}.
            #     Make sure that both
            #     `cloud-retail-customer-data-access@system.gserviceaccount.com` and
            #     `service-<project number>@gcp-sa-retail.iam.gserviceaccount.com`
            #     have the `pubsub.topics.publish` IAM permission on the topic.
            #
            #     Only supported when
            #     {::Google::Cloud::Retail::V2::ImportProductsRequest#reconciliation_mode ImportProductsRequest.reconciliation_mode}
            #     is set to `FULL`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/retail/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Retail::V2::ProductService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Retail::V2::ImportProductsRequest.new
            #
            #   # Call the import_products method.
            #   result = client.import_products request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def import_products request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Retail::V2::ImportProductsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.import_products.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Retail::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.import_products.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.import_products.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @product_service_stub.call_rpc :import_products, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates inventory information for a
            # {::Google::Cloud::Retail::V2::Product Product} while respecting the last update
            # timestamps of each inventory field.
            #
            # This process is asynchronous and does not require the
            # {::Google::Cloud::Retail::V2::Product Product} to exist before updating
            # fulfillment information. If the request is valid, the update is enqueued
            # and processed downstream. As a consequence, when a response is returned,
            # updates are not immediately manifested in the
            # {::Google::Cloud::Retail::V2::Product Product} queried by
            # {::Google::Cloud::Retail::V2::ProductService::Client#get_product ProductService.GetProduct}
            # or
            # {::Google::Cloud::Retail::V2::ProductService::Client#list_products ProductService.ListProducts}.
            #
            # When inventory is updated with
            # {::Google::Cloud::Retail::V2::ProductService::Client#create_product ProductService.CreateProduct}
            # and
            # {::Google::Cloud::Retail::V2::ProductService::Client#update_product ProductService.UpdateProduct},
            # the specified inventory field value(s) overwrite any existing value(s)
            # while ignoring the last update time for this field. Furthermore, the last
            # update times for the specified inventory fields are overwritten by the
            # times of the
            # {::Google::Cloud::Retail::V2::ProductService::Client#create_product ProductService.CreateProduct}
            # or
            # {::Google::Cloud::Retail::V2::ProductService::Client#update_product ProductService.UpdateProduct}
            # request.
            #
            # If no inventory fields are set in
            # {::Google::Cloud::Retail::V2::CreateProductRequest#product CreateProductRequest.product},
            # then any pre-existing inventory information for this product is used.
            #
            # If no inventory fields are set in
            # {::Google::Cloud::Retail::V2::SetInventoryRequest#set_mask SetInventoryRequest.set_mask},
            # then any existing inventory information is preserved.
            #
            # Pre-existing inventory information can only be updated with
            # {::Google::Cloud::Retail::V2::ProductService::Client#set_inventory ProductService.SetInventory},
            # {::Google::Cloud::Retail::V2::ProductService::Client#add_fulfillment_places ProductService.AddFulfillmentPlaces},
            # and
            # {::Google::Cloud::Retail::V2::ProductService::Client#remove_fulfillment_places ProductService.RemoveFulfillmentPlaces}.
            #
            # The returned {::Google::Longrunning::Operation Operation}s is obsolete after
            # one day, and the GetOperation
            # API returns `NOT_FOUND` afterwards.
            #
            # If conflicting updates are issued, the
            # {::Google::Longrunning::Operation Operation}s associated with the stale
            # updates are not marked as {::Google::Longrunning::Operation#done done} until
            # they are obsolete.
            #
            # @overload set_inventory(request, options = nil)
            #   Pass arguments to `set_inventory` via a request object, either of type
            #   {::Google::Cloud::Retail::V2::SetInventoryRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Retail::V2::SetInventoryRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload set_inventory(inventory: nil, set_mask: nil, set_time: nil, allow_missing: nil)
            #   Pass arguments to `set_inventory` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param inventory [::Google::Cloud::Retail::V2::Product, ::Hash]
            #     Required. The inventory information to update. The allowable fields to
            #     update are:
            #
            #     * {::Google::Cloud::Retail::V2::Product#price_info Product.price_info}
            #     * {::Google::Cloud::Retail::V2::Product#availability Product.availability}
            #     * {::Google::Cloud::Retail::V2::Product#available_quantity Product.available_quantity}
            #     * {::Google::Cloud::Retail::V2::Product#fulfillment_info Product.fulfillment_info}
            #     The updated inventory fields must be specified in
            #     {::Google::Cloud::Retail::V2::SetInventoryRequest#set_mask SetInventoryRequest.set_mask}.
            #
            #     If
            #     {::Google::Cloud::Retail::V2::Product#name SetInventoryRequest.inventory.name}
            #     is empty or invalid, an INVALID_ARGUMENT error is returned.
            #
            #     If the caller does not have permission to update the
            #     {::Google::Cloud::Retail::V2::Product Product} named in
            #     {::Google::Cloud::Retail::V2::Product#name Product.name}, regardless of whether
            #     or not it exists, a PERMISSION_DENIED error is returned.
            #
            #     If the {::Google::Cloud::Retail::V2::Product Product} to update does not have
            #     existing inventory information, the provided inventory information will be
            #     inserted.
            #
            #     If the {::Google::Cloud::Retail::V2::Product Product} to update has existing
            #     inventory information, the provided inventory information will be merged
            #     while respecting the last update time for each inventory field, using the
            #     provided or default value for
            #     {::Google::Cloud::Retail::V2::SetInventoryRequest#set_time SetInventoryRequest.set_time}.
            #
            #     The caller can replace place IDs for a subset of fulfillment types in the
            #     following ways:
            #
            #     * Adds "fulfillment_info" in
            #     {::Google::Cloud::Retail::V2::SetInventoryRequest#set_mask SetInventoryRequest.set_mask}
            #     * Specifies only the desired fulfillment types and corresponding place IDs
            #     to update in
            #     {::Google::Cloud::Retail::V2::Product#fulfillment_info SetInventoryRequest.inventory.fulfillment_info}
            #
            #     The caller can clear all place IDs from a subset of fulfillment types in
            #     the following ways:
            #
            #     * Adds "fulfillment_info" in
            #     {::Google::Cloud::Retail::V2::SetInventoryRequest#set_mask SetInventoryRequest.set_mask}
            #     * Specifies only the desired fulfillment types to clear in
            #     {::Google::Cloud::Retail::V2::Product#fulfillment_info SetInventoryRequest.inventory.fulfillment_info}
            #     * Checks that only the desired fulfillment info types have empty
            #     {::Google::Cloud::Retail::V2::FulfillmentInfo#place_ids SetInventoryRequest.inventory.fulfillment_info.place_ids}
            #
            #     The last update time is recorded for the following inventory fields:
            #     * {::Google::Cloud::Retail::V2::Product#price_info Product.price_info}
            #     * {::Google::Cloud::Retail::V2::Product#availability Product.availability}
            #     * {::Google::Cloud::Retail::V2::Product#available_quantity Product.available_quantity}
            #     * {::Google::Cloud::Retail::V2::Product#fulfillment_info Product.fulfillment_info}
            #
            #     If a full overwrite of inventory information while ignoring timestamps is
            #     needed,
            #     {::Google::Cloud::Retail::V2::ProductService::Client#update_product ProductService.UpdateProduct}
            #     should be invoked instead.
            #   @param set_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Indicates which inventory fields in the provided
            #     {::Google::Cloud::Retail::V2::Product Product} to update.
            #
            #     At least one field must be provided.
            #
            #     If an unsupported or unknown field is provided, an INVALID_ARGUMENT error
            #     is returned and the entire update will be ignored.
            #   @param set_time [::Google::Protobuf::Timestamp, ::Hash]
            #     The time when the request is issued, used to prevent
            #     out-of-order updates on inventory fields with the last update time
            #     recorded. If not provided, the internal system time will be used.
            #   @param allow_missing [::Boolean]
            #     If set to true, and the {::Google::Cloud::Retail::V2::Product Product} with name
            #     {::Google::Cloud::Retail::V2::Product#name Product.name} is not found, the
            #     inventory update will still be processed and retained for at most 1 day
            #     until the {::Google::Cloud::Retail::V2::Product Product} is created. If set to
            #     false, a NOT_FOUND error is returned if the
            #     {::Google::Cloud::Retail::V2::Product Product} is not found.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/retail/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Retail::V2::ProductService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Retail::V2::SetInventoryRequest.new
            #
            #   # Call the set_inventory method.
            #   result = client.set_inventory request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def set_inventory request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Retail::V2::SetInventoryRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.set_inventory.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Retail::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.inventory&.name
                header_params["inventory.name"] = request.inventory.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.set_inventory.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.set_inventory.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @product_service_stub.call_rpc :set_inventory, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # We recommend that you use the
            # {::Google::Cloud::Retail::V2::ProductService::Client#add_local_inventories ProductService.AddLocalInventories}
            # method instead of the
            # {::Google::Cloud::Retail::V2::ProductService::Client#add_fulfillment_places ProductService.AddFulfillmentPlaces}
            # method.
            # {::Google::Cloud::Retail::V2::ProductService::Client#add_local_inventories ProductService.AddLocalInventories}
            # achieves the same results but provides more fine-grained control over
            # ingesting local inventory data.
            #
            # Incrementally adds place IDs to
            # {::Google::Cloud::Retail::V2::FulfillmentInfo#place_ids Product.fulfillment_info.place_ids}.
            #
            # This process is asynchronous and does not require the
            # {::Google::Cloud::Retail::V2::Product Product} to exist before updating
            # fulfillment information. If the request is valid, the update will be
            # enqueued and processed downstream. As a consequence, when a response is
            # returned, the added place IDs are not immediately manifested in the
            # {::Google::Cloud::Retail::V2::Product Product} queried by
            # {::Google::Cloud::Retail::V2::ProductService::Client#get_product ProductService.GetProduct}
            # or
            # {::Google::Cloud::Retail::V2::ProductService::Client#list_products ProductService.ListProducts}.
            #
            # The returned {::Google::Longrunning::Operation Operation}s will be obsolete
            # after 1 day, and GetOperation
            # API will return NOT_FOUND afterwards.
            #
            # If conflicting updates are issued, the
            # {::Google::Longrunning::Operation Operation}s associated with the stale
            # updates will not be marked as {::Google::Longrunning::Operation#done done}
            # until being obsolete.
            #
            # @overload add_fulfillment_places(request, options = nil)
            #   Pass arguments to `add_fulfillment_places` via a request object, either of type
            #   {::Google::Cloud::Retail::V2::AddFulfillmentPlacesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Retail::V2::AddFulfillmentPlacesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload add_fulfillment_places(product: nil, type: nil, place_ids: nil, add_time: nil, allow_missing: nil)
            #   Pass arguments to `add_fulfillment_places` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param product [::String]
            #     Required. Full resource name of {::Google::Cloud::Retail::V2::Product Product},
            #     such as
            #     `projects/*/locations/global/catalogs/default_catalog/branches/default_branch/products/some_product_id`.
            #
            #     If the caller does not have permission to access the
            #     {::Google::Cloud::Retail::V2::Product Product}, regardless of whether or not it
            #     exists, a PERMISSION_DENIED error is returned.
            #   @param type [::String]
            #     Required. The fulfillment type, including commonly used types (such as
            #     pickup in store and same day delivery), and custom types.
            #
            #     Supported values:
            #
            #     * "pickup-in-store"
            #     * "ship-to-store"
            #     * "same-day-delivery"
            #     * "next-day-delivery"
            #     * "custom-type-1"
            #     * "custom-type-2"
            #     * "custom-type-3"
            #     * "custom-type-4"
            #     * "custom-type-5"
            #
            #     If this field is set to an invalid value other than these, an
            #     INVALID_ARGUMENT error is returned.
            #
            #     This field directly corresponds to
            #     {::Google::Cloud::Retail::V2::FulfillmentInfo#type Product.fulfillment_info.type}.
            #   @param place_ids [::Array<::String>]
            #     Required. The IDs for this
            #     {::Google::Cloud::Retail::V2::AddFulfillmentPlacesRequest#type type}, such as
            #     the store IDs for "pickup-in-store" or the region IDs for
            #     "same-day-delivery" to be added for this
            #     {::Google::Cloud::Retail::V2::AddFulfillmentPlacesRequest#type type}. Duplicate
            #     IDs will be automatically ignored.
            #
            #     At least 1 value is required, and a maximum of 2000 values are allowed.
            #     Each value must be a string with a length limit of 10 characters, matching
            #     the pattern `[a-zA-Z0-9_-]+`, such as "store1" or "REGION-2". Otherwise, an
            #     INVALID_ARGUMENT error is returned.
            #
            #     If the total number of place IDs exceeds 2000 for this
            #     {::Google::Cloud::Retail::V2::AddFulfillmentPlacesRequest#type type} after
            #     adding, then the update will be rejected.
            #   @param add_time [::Google::Protobuf::Timestamp, ::Hash]
            #     The time when the fulfillment updates are issued, used to prevent
            #     out-of-order updates on fulfillment information. If not provided, the
            #     internal system time will be used.
            #   @param allow_missing [::Boolean]
            #     If set to true, and the {::Google::Cloud::Retail::V2::Product Product} is not
            #     found, the fulfillment information will still be processed and retained for
            #     at most 1 day and processed once the
            #     {::Google::Cloud::Retail::V2::Product Product} is created. If set to false, a
            #     NOT_FOUND error is returned if the
            #     {::Google::Cloud::Retail::V2::Product Product} is not found.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/retail/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Retail::V2::ProductService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Retail::V2::AddFulfillmentPlacesRequest.new
            #
            #   # Call the add_fulfillment_places method.
            #   result = client.add_fulfillment_places request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def add_fulfillment_places request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Retail::V2::AddFulfillmentPlacesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.add_fulfillment_places.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Retail::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.product
                header_params["product"] = request.product
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.add_fulfillment_places.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.add_fulfillment_places.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @product_service_stub.call_rpc :add_fulfillment_places, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # We recommend that you use the
            # {::Google::Cloud::Retail::V2::ProductService::Client#remove_local_inventories ProductService.RemoveLocalInventories}
            # method instead of the
            # {::Google::Cloud::Retail::V2::ProductService::Client#remove_fulfillment_places ProductService.RemoveFulfillmentPlaces}
            # method.
            # {::Google::Cloud::Retail::V2::ProductService::Client#remove_local_inventories ProductService.RemoveLocalInventories}
            # achieves the same results but provides more fine-grained control over
            # ingesting local inventory data.
            #
            # Incrementally removes place IDs from a
            # {::Google::Cloud::Retail::V2::FulfillmentInfo#place_ids Product.fulfillment_info.place_ids}.
            #
            # This process is asynchronous and does not require the
            # {::Google::Cloud::Retail::V2::Product Product} to exist before updating
            # fulfillment information. If the request is valid, the update will be
            # enqueued and processed downstream. As a consequence, when a response is
            # returned, the removed place IDs are not immediately manifested in the
            # {::Google::Cloud::Retail::V2::Product Product} queried by
            # {::Google::Cloud::Retail::V2::ProductService::Client#get_product ProductService.GetProduct}
            # or
            # {::Google::Cloud::Retail::V2::ProductService::Client#list_products ProductService.ListProducts}.
            #
            # The returned {::Google::Longrunning::Operation Operation}s will be obsolete
            # after 1 day, and GetOperation
            # API will return NOT_FOUND afterwards.
            #
            # If conflicting updates are issued, the
            # {::Google::Longrunning::Operation Operation}s associated with the stale
            # updates will not be marked as {::Google::Longrunning::Operation#done done}
            # until being obsolete.
            #
            # @overload remove_fulfillment_places(request, options = nil)
            #   Pass arguments to `remove_fulfillment_places` via a request object, either of type
            #   {::Google::Cloud::Retail::V2::RemoveFulfillmentPlacesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Retail::V2::RemoveFulfillmentPlacesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload remove_fulfillment_places(product: nil, type: nil, place_ids: nil, remove_time: nil, allow_missing: nil)
            #   Pass arguments to `remove_fulfillment_places` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param product [::String]
            #     Required. Full resource name of {::Google::Cloud::Retail::V2::Product Product},
            #     such as
            #     `projects/*/locations/global/catalogs/default_catalog/branches/default_branch/products/some_product_id`.
            #
            #     If the caller does not have permission to access the
            #     {::Google::Cloud::Retail::V2::Product Product}, regardless of whether or not it
            #     exists, a PERMISSION_DENIED error is returned.
            #   @param type [::String]
            #     Required. The fulfillment type, including commonly used types (such as
            #     pickup in store and same day delivery), and custom types.
            #
            #     Supported values:
            #
            #     * "pickup-in-store"
            #     * "ship-to-store"
            #     * "same-day-delivery"
            #     * "next-day-delivery"
            #     * "custom-type-1"
            #     * "custom-type-2"
            #     * "custom-type-3"
            #     * "custom-type-4"
            #     * "custom-type-5"
            #
            #     If this field is set to an invalid value other than these, an
            #     INVALID_ARGUMENT error is returned.
            #
            #     This field directly corresponds to
            #     {::Google::Cloud::Retail::V2::FulfillmentInfo#type Product.fulfillment_info.type}.
            #   @param place_ids [::Array<::String>]
            #     Required. The IDs for this
            #     {::Google::Cloud::Retail::V2::RemoveFulfillmentPlacesRequest#type type}, such as
            #     the store IDs for "pickup-in-store" or the region IDs for
            #     "same-day-delivery", to be removed for this
            #     {::Google::Cloud::Retail::V2::RemoveFulfillmentPlacesRequest#type type}.
            #
            #     At least 1 value is required, and a maximum of 2000 values are allowed.
            #     Each value must be a string with a length limit of 10 characters, matching
            #     the pattern `[a-zA-Z0-9_-]+`, such as "store1" or "REGION-2". Otherwise, an
            #     INVALID_ARGUMENT error is returned.
            #   @param remove_time [::Google::Protobuf::Timestamp, ::Hash]
            #     The time when the fulfillment updates are issued, used to prevent
            #     out-of-order updates on fulfillment information. If not provided, the
            #     internal system time will be used.
            #   @param allow_missing [::Boolean]
            #     If set to true, and the {::Google::Cloud::Retail::V2::Product Product} is not
            #     found, the fulfillment information will still be processed and retained for
            #     at most 1 day and processed once the
            #     {::Google::Cloud::Retail::V2::Product Product} is created. If set to false, a
            #     NOT_FOUND error is returned if the
            #     {::Google::Cloud::Retail::V2::Product Product} is not found.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/retail/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Retail::V2::ProductService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Retail::V2::RemoveFulfillmentPlacesRequest.new
            #
            #   # Call the remove_fulfillment_places method.
            #   result = client.remove_fulfillment_places request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def remove_fulfillment_places request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Retail::V2::RemoveFulfillmentPlacesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.remove_fulfillment_places.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Retail::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.product
                header_params["product"] = request.product
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.remove_fulfillment_places.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.remove_fulfillment_places.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @product_service_stub.call_rpc :remove_fulfillment_places, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates local inventory information for a
            # {::Google::Cloud::Retail::V2::Product Product} at a list of places, while
            # respecting the last update timestamps of each inventory field.
            #
            # This process is asynchronous and does not require the
            # {::Google::Cloud::Retail::V2::Product Product} to exist before updating
            # inventory information. If the request is valid, the update will be enqueued
            # and processed downstream. As a consequence, when a response is returned,
            # updates are not immediately manifested in the
            # {::Google::Cloud::Retail::V2::Product Product} queried by
            # {::Google::Cloud::Retail::V2::ProductService::Client#get_product ProductService.GetProduct}
            # or
            # {::Google::Cloud::Retail::V2::ProductService::Client#list_products ProductService.ListProducts}.
            #
            # Local inventory information can only be modified using this method.
            # {::Google::Cloud::Retail::V2::ProductService::Client#create_product ProductService.CreateProduct}
            # and
            # {::Google::Cloud::Retail::V2::ProductService::Client#update_product ProductService.UpdateProduct}
            # has no effect on local inventories.
            #
            # The returned {::Google::Longrunning::Operation Operation}s will be obsolete
            # after 1 day, and GetOperation
            # API will return NOT_FOUND afterwards.
            #
            # If conflicting updates are issued, the
            # {::Google::Longrunning::Operation Operation}s associated with the stale
            # updates will not be marked as {::Google::Longrunning::Operation#done done}
            # until being obsolete.
            #
            # @overload add_local_inventories(request, options = nil)
            #   Pass arguments to `add_local_inventories` via a request object, either of type
            #   {::Google::Cloud::Retail::V2::AddLocalInventoriesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Retail::V2::AddLocalInventoriesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload add_local_inventories(product: nil, local_inventories: nil, add_mask: nil, add_time: nil, allow_missing: nil)
            #   Pass arguments to `add_local_inventories` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param product [::String]
            #     Required. Full resource name of {::Google::Cloud::Retail::V2::Product Product},
            #     such as
            #     `projects/*/locations/global/catalogs/default_catalog/branches/default_branch/products/some_product_id`.
            #
            #     If the caller does not have permission to access the
            #     {::Google::Cloud::Retail::V2::Product Product}, regardless of whether or not it
            #     exists, a PERMISSION_DENIED error is returned.
            #   @param local_inventories [::Array<::Google::Cloud::Retail::V2::LocalInventory, ::Hash>]
            #     Required. A list of inventory information at difference places. Each place
            #     is identified by its place ID. At most 3000 inventories are allowed per
            #     request.
            #   @param add_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Indicates which inventory fields in the provided list of
            #     {::Google::Cloud::Retail::V2::LocalInventory LocalInventory} to update. The
            #     field is updated to the provided value.
            #
            #     If a field is set while the place does not have a previous local inventory,
            #     the local inventory at that store is created.
            #
            #     If a field is set while the value of that field is not provided, the
            #     original field value, if it exists, is deleted.
            #
            #     If the mask is not set or set with empty paths, all inventory fields will
            #     be updated.
            #
            #     If an unsupported or unknown field is provided, an INVALID_ARGUMENT error
            #     is returned and the entire update will be ignored.
            #   @param add_time [::Google::Protobuf::Timestamp, ::Hash]
            #     The time when the inventory updates are issued. Used to prevent
            #     out-of-order updates on local inventory fields. If not provided, the
            #     internal system time will be used.
            #   @param allow_missing [::Boolean]
            #     If set to true, and the {::Google::Cloud::Retail::V2::Product Product} is not
            #     found, the local inventory will still be processed and retained for at most
            #     1 day and processed once the {::Google::Cloud::Retail::V2::Product Product} is
            #     created. If set to false, a NOT_FOUND error is returned if the
            #     {::Google::Cloud::Retail::V2::Product Product} is not found.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/retail/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Retail::V2::ProductService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Retail::V2::AddLocalInventoriesRequest.new
            #
            #   # Call the add_local_inventories method.
            #   result = client.add_local_inventories request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def add_local_inventories request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Retail::V2::AddLocalInventoriesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.add_local_inventories.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Retail::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.product
                header_params["product"] = request.product
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.add_local_inventories.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.add_local_inventories.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @product_service_stub.call_rpc :add_local_inventories, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Remove local inventory information for a
            # {::Google::Cloud::Retail::V2::Product Product} at a list of places at a removal
            # timestamp.
            #
            # This process is asynchronous. If the request is valid, the removal will be
            # enqueued and processed downstream. As a consequence, when a response is
            # returned, removals are not immediately manifested in the
            # {::Google::Cloud::Retail::V2::Product Product} queried by
            # {::Google::Cloud::Retail::V2::ProductService::Client#get_product ProductService.GetProduct}
            # or
            # {::Google::Cloud::Retail::V2::ProductService::Client#list_products ProductService.ListProducts}.
            #
            # Local inventory information can only be removed using this method.
            # {::Google::Cloud::Retail::V2::ProductService::Client#create_product ProductService.CreateProduct}
            # and
            # {::Google::Cloud::Retail::V2::ProductService::Client#update_product ProductService.UpdateProduct}
            # has no effect on local inventories.
            #
            # The returned {::Google::Longrunning::Operation Operation}s will be obsolete
            # after 1 day, and GetOperation
            # API will return NOT_FOUND afterwards.
            #
            # If conflicting updates are issued, the
            # {::Google::Longrunning::Operation Operation}s associated with the stale
            # updates will not be marked as {::Google::Longrunning::Operation#done done}
            # until being obsolete.
            #
            # @overload remove_local_inventories(request, options = nil)
            #   Pass arguments to `remove_local_inventories` via a request object, either of type
            #   {::Google::Cloud::Retail::V2::RemoveLocalInventoriesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Retail::V2::RemoveLocalInventoriesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload remove_local_inventories(product: nil, place_ids: nil, remove_time: nil, allow_missing: nil)
            #   Pass arguments to `remove_local_inventories` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param product [::String]
            #     Required. Full resource name of {::Google::Cloud::Retail::V2::Product Product},
            #     such as
            #     `projects/*/locations/global/catalogs/default_catalog/branches/default_branch/products/some_product_id`.
            #
            #     If the caller does not have permission to access the
            #     {::Google::Cloud::Retail::V2::Product Product}, regardless of whether or not it
            #     exists, a PERMISSION_DENIED error is returned.
            #   @param place_ids [::Array<::String>]
            #     Required. A list of place IDs to have their inventory deleted.
            #     At most 3000 place IDs are allowed per request.
            #   @param remove_time [::Google::Protobuf::Timestamp, ::Hash]
            #     The time when the inventory deletions are issued. Used to prevent
            #     out-of-order updates and deletions on local inventory fields. If not
            #     provided, the internal system time will be used.
            #   @param allow_missing [::Boolean]
            #     If set to true, and the {::Google::Cloud::Retail::V2::Product Product} is not
            #     found, the local inventory removal request will still be processed and
            #     retained for at most 1 day and processed once the
            #     {::Google::Cloud::Retail::V2::Product Product} is created. If set to false, a
            #     NOT_FOUND error is returned if the
            #     {::Google::Cloud::Retail::V2::Product Product} is not found.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/retail/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Retail::V2::ProductService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Retail::V2::RemoveLocalInventoriesRequest.new
            #
            #   # Call the remove_local_inventories method.
            #   result = client.remove_local_inventories request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def remove_local_inventories request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Retail::V2::RemoveLocalInventoriesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.remove_local_inventories.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Retail::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.product
                header_params["product"] = request.product
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.remove_local_inventories.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.remove_local_inventories.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @product_service_stub.call_rpc :remove_local_inventories, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the ProductService API.
            #
            # This class represents the configuration for ProductService,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::Retail::V2::ProductService::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # create_product to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::Retail::V2::ProductService::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_product.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::Retail::V2::ProductService::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_product.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::Retail::V2::ProductService::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "retail.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the ProductService API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `create_product`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_product
                ##
                # RPC-specific configuration for `get_product`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_product
                ##
                # RPC-specific configuration for `list_products`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_products
                ##
                # RPC-specific configuration for `update_product`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_product
                ##
                # RPC-specific configuration for `delete_product`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_product
                ##
                # RPC-specific configuration for `purge_products`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :purge_products
                ##
                # RPC-specific configuration for `import_products`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :import_products
                ##
                # RPC-specific configuration for `set_inventory`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :set_inventory
                ##
                # RPC-specific configuration for `add_fulfillment_places`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :add_fulfillment_places
                ##
                # RPC-specific configuration for `remove_fulfillment_places`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :remove_fulfillment_places
                ##
                # RPC-specific configuration for `add_local_inventories`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :add_local_inventories
                ##
                # RPC-specific configuration for `remove_local_inventories`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :remove_local_inventories

                # @private
                def initialize parent_rpcs = nil
                  create_product_config = parent_rpcs.create_product if parent_rpcs.respond_to? :create_product
                  @create_product = ::Gapic::Config::Method.new create_product_config
                  get_product_config = parent_rpcs.get_product if parent_rpcs.respond_to? :get_product
                  @get_product = ::Gapic::Config::Method.new get_product_config
                  list_products_config = parent_rpcs.list_products if parent_rpcs.respond_to? :list_products
                  @list_products = ::Gapic::Config::Method.new list_products_config
                  update_product_config = parent_rpcs.update_product if parent_rpcs.respond_to? :update_product
                  @update_product = ::Gapic::Config::Method.new update_product_config
                  delete_product_config = parent_rpcs.delete_product if parent_rpcs.respond_to? :delete_product
                  @delete_product = ::Gapic::Config::Method.new delete_product_config
                  purge_products_config = parent_rpcs.purge_products if parent_rpcs.respond_to? :purge_products
                  @purge_products = ::Gapic::Config::Method.new purge_products_config
                  import_products_config = parent_rpcs.import_products if parent_rpcs.respond_to? :import_products
                  @import_products = ::Gapic::Config::Method.new import_products_config
                  set_inventory_config = parent_rpcs.set_inventory if parent_rpcs.respond_to? :set_inventory
                  @set_inventory = ::Gapic::Config::Method.new set_inventory_config
                  add_fulfillment_places_config = parent_rpcs.add_fulfillment_places if parent_rpcs.respond_to? :add_fulfillment_places
                  @add_fulfillment_places = ::Gapic::Config::Method.new add_fulfillment_places_config
                  remove_fulfillment_places_config = parent_rpcs.remove_fulfillment_places if parent_rpcs.respond_to? :remove_fulfillment_places
                  @remove_fulfillment_places = ::Gapic::Config::Method.new remove_fulfillment_places_config
                  add_local_inventories_config = parent_rpcs.add_local_inventories if parent_rpcs.respond_to? :add_local_inventories
                  @add_local_inventories = ::Gapic::Config::Method.new add_local_inventories_config
                  remove_local_inventories_config = parent_rpcs.remove_local_inventories if parent_rpcs.respond_to? :remove_local_inventories
                  @remove_local_inventories = ::Gapic::Config::Method.new remove_local_inventories_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
