# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/cloud/retail/v2/model_service.proto for package 'Google.Cloud.Retail.V2'
# Original file comments:
# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/cloud/retail/v2/model_service_pb'

module Google
  module Cloud
    module Retail
      module V2
        module ModelService
          # Service for performing CRUD operations on models.
          # Recommendation models contain all the metadata necessary to generate a set of
          # models for the `Predict()` API. A model is queried
          # indirectly via a ServingConfig, which associates a model with a
          # given Placement (e.g. Frequently Bought Together on Home Page).
          #
          # This service allows you to do the following:
          #
          # * Initiate training of a model.
          # * Pause training of an existing model.
          # * List all the available models along with their metadata.
          # * Control their tuning schedule.
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'google.cloud.retail.v2.ModelService'

            # Creates a new model.
            rpc :CreateModel, ::Google::Cloud::Retail::V2::CreateModelRequest, ::Google::Longrunning::Operation
            # Gets a model.
            rpc :GetModel, ::Google::Cloud::Retail::V2::GetModelRequest, ::Google::Cloud::Retail::V2::Model
            # Pauses the training of an existing model.
            rpc :PauseModel, ::Google::Cloud::Retail::V2::PauseModelRequest, ::Google::Cloud::Retail::V2::Model
            # Resumes the training of an existing model.
            rpc :ResumeModel, ::Google::Cloud::Retail::V2::ResumeModelRequest, ::Google::Cloud::Retail::V2::Model
            # Deletes an existing model.
            rpc :DeleteModel, ::Google::Cloud::Retail::V2::DeleteModelRequest, ::Google::Protobuf::Empty
            # Lists all the models linked to this event store.
            rpc :ListModels, ::Google::Cloud::Retail::V2::ListModelsRequest, ::Google::Cloud::Retail::V2::ListModelsResponse
            # Update of model metadata. Only fields that
            # currently can be updated are: `filtering_option` and
            # `periodic_tuning_state`.
            # If other values are provided, this API method ignores them.
            rpc :UpdateModel, ::Google::Cloud::Retail::V2::UpdateModelRequest, ::Google::Cloud::Retail::V2::Model
            # Tunes an existing model.
            rpc :TuneModel, ::Google::Cloud::Retail::V2::TuneModelRequest, ::Google::Longrunning::Operation
          end

          Stub = Service.rpc_stub_class
        end
      end
    end
  end
end
