# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "gapic/common"
require "gapic/config"
require "gapic/config/method"

require "google/cloud/retail/v2/version"

require "google/cloud/retail/v2/model_service/credentials"
require "google/cloud/retail/v2/model_service/paths"
require "google/cloud/retail/v2/model_service/operations"
require "google/cloud/retail/v2/model_service/client"
require "google/cloud/retail/v2/model_service/rest"

module Google
  module Cloud
    module Retail
      module V2
        ##
        # Service for performing CRUD operations on models.
        # Recommendation models contain all the metadata necessary to generate a set of
        # models for the `Predict()` API. A model is queried
        # indirectly via a ServingConfig, which associates a model with a
        # given Placement (e.g. Frequently Bought Together on Home Page).
        #
        # This service allows you to do the following:
        #
        # * Initiate training of a model.
        # * Pause training of an existing model.
        # * List all the available models along with their metadata.
        # * Control their tuning schedule.
        #
        # @example Load this service and instantiate a gRPC client
        #
        #     require "google/cloud/retail/v2/model_service"
        #     client = ::Google::Cloud::Retail::V2::ModelService::Client.new
        #
        # @example Load this service and instantiate a REST client
        #
        #     require "google/cloud/retail/v2/model_service/rest"
        #     client = ::Google::Cloud::Retail::V2::ModelService::Rest::Client.new
        #
        module ModelService
        end
      end
    end
  end
end

helper_path = ::File.join __dir__, "model_service", "helpers.rb"
require "google/cloud/retail/v2/model_service/helpers" if ::File.file? helper_path
