# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/retail/v2/conversational_search_service_pb"
require "google/cloud/retail/v2/conversational_search_service/rest/service_stub"
require "google/cloud/location/rest"

module Google
  module Cloud
    module Retail
      module V2
        module ConversationalSearchService
          module Rest
            ##
            # REST client for the ConversationalSearchService service.
            #
            # Service for retail conversational search.
            #
            # This feature is only available for users who have Retail Conversational
            # Search enabled. Enable Retail Conversational Search on Cloud Console
            # before using this feature.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "retail.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :conversational_search_service_stub

              ##
              # Configure the ConversationalSearchService Client class.
              #
              # See {::Google::Cloud::Retail::V2::ConversationalSearchService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all ConversationalSearchService clients
              #   ::Google::Cloud::Retail::V2::ConversationalSearchService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "Retail", "V2"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the ConversationalSearchService Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::Retail::V2::ConversationalSearchService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @conversational_search_service_stub.universe_domain
              end

              ##
              # Create a new ConversationalSearchService REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::Retail::V2::ConversationalSearchService::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::Retail::V2::ConversationalSearchService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the ConversationalSearchService client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @conversational_search_service_stub = ::Google::Cloud::Retail::V2::ConversationalSearchService::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @conversational_search_service_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @conversational_search_service_stub.endpoint
                  config.universe_domain = @conversational_search_service_stub.universe_domain
                  config.logger = @conversational_search_service_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Rest::Client]
              #
              attr_reader :location_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @conversational_search_service_stub.logger
              end

              # Service calls

              ##
              # Performs a conversational search.
              #
              # This feature is only available for users who have Conversational Search
              # enabled.
              #
              # @overload conversational_search(request, options = nil)
              #   Pass arguments to `conversational_search` via a request object, either of type
              #   {::Google::Cloud::Retail::V2::ConversationalSearchRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Retail::V2::ConversationalSearchRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload conversational_search(placement: nil, branch: nil, query: nil, page_categories: nil, conversation_id: nil, search_params: nil, visitor_id: nil, user_info: nil, conversational_filtering_spec: nil, user_labels: nil, safety_settings: nil)
              #   Pass arguments to `conversational_search` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param placement [::String]
              #     Required. The resource name of the search engine placement, such as
              #     `projects/*/locations/global/catalogs/default_catalog/placements/default_search`
              #     or
              #     `projects/*/locations/global/catalogs/default_catalog/servingConfigs/default_serving_config`
              #     This field is used to identify the serving config name and the set
              #     of models that will be used to make the search.
              #   @param branch [::String]
              #     Required. The branch resource name, such as
              #     `projects/*/locations/global/catalogs/default_catalog/branches/0`.
              #
              #     Use "default_branch" as the branch ID or leave this field empty, to search
              #     products under the default branch.
              #   @param query [::String]
              #     Optional. Raw search query to be searched for.
              #
              #     If this field is empty, the request is considered a category browsing
              #     request.
              #   @param page_categories [::Array<::String>]
              #     Optional. The categories associated with a category page. Must be set for
              #     category navigation queries to achieve good search quality. The format
              #     should be the same as
              #     {::Google::Cloud::Retail::V2::UserEvent#page_categories UserEvent.page_categories};
              #
              #     To represent full path of category, use '>' sign to separate different
              #     hierarchies. If '>' is part of the category name, replace it with
              #     other character(s).
              #
              #     Category pages include special pages such as sales or promotions. For
              #     instance, a special sale page may have the category hierarchy:
              #     "pageCategories" : ["Sales > 2017 Black Friday Deals"].
              #   @param conversation_id [::String]
              #     Optional. This field specifies the conversation id, which maintains the
              #     state of the conversation between client side and server side. Use the
              #     value from the previous
              #     {::Google::Cloud::Retail::V2::ConversationalSearchResponse#conversation_id ConversationalSearchResponse.conversation_id}.
              #     For the initial request, this should be empty.
              #   @param search_params [::Google::Cloud::Retail::V2::ConversationalSearchRequest::SearchParams, ::Hash]
              #     Optional. Search parameters.
              #   @param visitor_id [::String]
              #     Required. A unique identifier for tracking visitors. For example, this
              #     could be implemented with an HTTP cookie, which should be able to uniquely
              #     identify a visitor on a single device. This unique identifier should not
              #     change if the visitor logs in or out of the website.
              #
              #     This should be the same identifier as
              #     {::Google::Cloud::Retail::V2::UserEvent#visitor_id UserEvent.visitor_id}.
              #
              #     The field must be a UTF-8 encoded string with a length limit of 128
              #     characters. Otherwise, an INVALID_ARGUMENT error is returned.
              #   @param user_info [::Google::Cloud::Retail::V2::UserInfo, ::Hash]
              #     Optional. User information.
              #   @param conversational_filtering_spec [::Google::Cloud::Retail::V2::ConversationalSearchRequest::ConversationalFilteringSpec, ::Hash]
              #     Optional. This field specifies all conversational filtering related
              #     parameters.
              #   @param user_labels [::Hash{::String => ::String}]
              #     Optional. The user labels applied to a resource must meet the following
              #     requirements:
              #
              #     * Each resource can have multiple labels, up to a maximum of 64.
              #     * Each label must be a key-value pair.
              #     * Keys have a minimum length of 1 character and a maximum length of 63
              #       characters and cannot be empty. Values can be empty and have a maximum
              #       length of 63 characters.
              #     * Keys and values can contain only lowercase letters, numeric characters,
              #       underscores, and dashes. All characters must use UTF-8 encoding, and
              #       international characters are allowed.
              #     * The key portion of a label must be unique. However, you can use the same
              #       key with multiple resources.
              #     * Keys must start with a lowercase letter or international character.
              #
              #     See [Google Cloud
              #     Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
              #     for more details.
              #   @param safety_settings [::Array<::Google::Cloud::Retail::V2::SafetySetting, ::Hash>]
              #     Optional. The safety settings to be applied to the generated content.
              # @return [::Enumerable<::Google::Cloud::Retail::V2::ConversationalSearchResponse>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/retail/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Retail::V2::ConversationalSearchService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Retail::V2::ConversationalSearchRequest.new
              #
              #   # Call the conversational_search method to start streaming.
              #   output = client.conversational_search request
              #
              #   # The returned object is a streamed enumerable yielding elements of type
              #   # ::Google::Cloud::Retail::V2::ConversationalSearchResponse
              #   output.each do |current_response|
              #     p current_response
              #   end
              #
              def conversational_search request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Retail::V2::ConversationalSearchRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.conversational_search.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Retail::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.conversational_search.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.conversational_search.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                ::Gapic::Rest::ServerStream.new(
                  ::Google::Cloud::Retail::V2::ConversationalSearchResponse,
                  ::Gapic::Rest::ThreadedEnumerator.new do |in_q, out_q|
                    @conversational_search_service_stub.conversational_search request, options do |chunk|
                      in_q.deq
                      out_q.enq chunk
                    end
                  end
                )
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the ConversationalSearchService REST API.
              #
              # This class represents the configuration for ConversationalSearchService REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::Retail::V2::ConversationalSearchService::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # conversational_search to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::Retail::V2::ConversationalSearchService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.conversational_search.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::Retail::V2::ConversationalSearchService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.conversational_search.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "retail.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the ConversationalSearchService API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `conversational_search`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :conversational_search

                  # @private
                  def initialize parent_rpcs = nil
                    conversational_search_config = parent_rpcs.conversational_search if parent_rpcs.respond_to? :conversational_search
                    @conversational_search = ::Gapic::Config::Method.new conversational_search_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
