# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Retail
      module V2
        module CatalogService
          # Path helper methods for the CatalogService API.
          module Paths
            ##
            # Create a fully-qualified AttributesConfig resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/catalogs/{catalog}/attributesConfig`
            #
            # @param project [String]
            # @param location [String]
            # @param catalog [String]
            #
            # @return [::String]
            def attributes_config_path project:, location:, catalog:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/catalogs/#{catalog}/attributesConfig"
            end

            ##
            # Create a fully-qualified Branch resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/catalogs/{catalog}/branches/{branch}`
            #
            # @param project [String]
            # @param location [String]
            # @param catalog [String]
            # @param branch [String]
            #
            # @return [::String]
            def branch_path project:, location:, catalog:, branch:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "catalog cannot contain /" if catalog.to_s.include? "/"

              "projects/#{project}/locations/#{location}/catalogs/#{catalog}/branches/#{branch}"
            end

            ##
            # Create a fully-qualified Catalog resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/catalogs/{catalog}`
            #
            # @param project [String]
            # @param location [String]
            # @param catalog [String]
            #
            # @return [::String]
            def catalog_path project:, location:, catalog:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/catalogs/#{catalog}"
            end

            ##
            # Create a fully-qualified CompletionConfig resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/catalogs/{catalog}/completionConfig`
            #
            # @param project [String]
            # @param location [String]
            # @param catalog [String]
            #
            # @return [::String]
            def completion_config_path project:, location:, catalog:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/catalogs/#{catalog}/completionConfig"
            end

            ##
            # Create a fully-qualified Location resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}`
            #
            # @param project [String]
            # @param location [String]
            #
            # @return [::String]
            def location_path project:, location:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/locations/#{location}"
            end

            extend self
          end
        end
      end
    end
  end
end
