# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "google/cloud/resource_manager"
require "gapic/common"
require "gapic/grpc"
require "gapic/rest"

class Google::Cloud::ResourceManager::ClientConstructionMinitest < Minitest::Test
  class DummyStub
    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_folders_grpc
    skip unless Google::Cloud::ResourceManager.folders_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::ResourceManager.folders transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::ResourceManager::V3::Folders::Client, client
    end
  end

  def test_folders_rest
    skip unless Google::Cloud::ResourceManager.folders_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::ResourceManager.folders transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::ResourceManager::V3::Folders::Rest::Client, client
    end
  end

  def test_organizations_grpc
    skip unless Google::Cloud::ResourceManager.organizations_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::ResourceManager.organizations transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::ResourceManager::V3::Organizations::Client, client
    end
  end

  def test_organizations_rest
    skip unless Google::Cloud::ResourceManager.organizations_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::ResourceManager.organizations transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::ResourceManager::V3::Organizations::Rest::Client, client
    end
  end

  def test_projects_grpc
    skip unless Google::Cloud::ResourceManager.projects_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::ResourceManager.projects transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::ResourceManager::V3::Projects::Client, client
    end
  end

  def test_projects_rest
    skip unless Google::Cloud::ResourceManager.projects_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::ResourceManager.projects transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::ResourceManager::V3::Projects::Rest::Client, client
    end
  end

  def test_tag_bindings_grpc
    skip unless Google::Cloud::ResourceManager.tag_bindings_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::ResourceManager.tag_bindings transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::ResourceManager::V3::TagBindings::Client, client
    end
  end

  def test_tag_bindings_rest
    skip unless Google::Cloud::ResourceManager.tag_bindings_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::ResourceManager.tag_bindings transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::ResourceManager::V3::TagBindings::Rest::Client, client
    end
  end

  def test_tag_holds_grpc
    skip unless Google::Cloud::ResourceManager.tag_holds_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::ResourceManager.tag_holds transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::ResourceManager::V3::TagHolds::Client, client
    end
  end

  def test_tag_holds_rest
    skip unless Google::Cloud::ResourceManager.tag_holds_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::ResourceManager.tag_holds transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::ResourceManager::V3::TagHolds::Rest::Client, client
    end
  end

  def test_tag_keys_grpc
    skip unless Google::Cloud::ResourceManager.tag_keys_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::ResourceManager.tag_keys transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::ResourceManager::V3::TagKeys::Client, client
    end
  end

  def test_tag_keys_rest
    skip unless Google::Cloud::ResourceManager.tag_keys_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::ResourceManager.tag_keys transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::ResourceManager::V3::TagKeys::Rest::Client, client
    end
  end

  def test_tag_values_grpc
    skip unless Google::Cloud::ResourceManager.tag_values_available? transport: :grpc
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::ResourceManager.tag_values transport: :grpc do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::ResourceManager::V3::TagValues::Client, client
    end
  end

  def test_tag_values_rest
    skip unless Google::Cloud::ResourceManager.tag_values_available? transport: :rest
    Gapic::Rest::ClientStub.stub :new, DummyStub.new do
      client = Google::Cloud::ResourceManager.tag_values transport: :rest do |config|
        config.credentials = :dummy_credentials
      end
      assert_kind_of Google::Cloud::ResourceManager::V3::TagValues::Rest::Client, client
    end
  end
end
