# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module ResourceManager
      module V3
        # A TagHold represents the use of a TagValue that is not captured by
        # TagBindings. If a TagValue has any TagHolds, deletion will be blocked.
        # This resource is intended to be created in the same cloud location as the
        # `holder`.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The resource name of a TagHold. This is a String of the form:
        #     `tagValues/{tag-value-id}/tagHolds/{tag-hold-id}`
        #     (e.g. `tagValues/123/tagHolds/456`). This resource name is generated by
        #     the server.
        # @!attribute [rw] holder
        #   @return [::String]
        #     Required. The name of the resource where the TagValue is being used. Must
        #     be less than 200 characters. E.g.
        #     `//compute.googleapis.com/compute/projects/myproject/regions/us-east-1/instanceGroupManagers/instance-group`
        # @!attribute [rw] origin
        #   @return [::String]
        #     Optional. An optional string representing the origin of this request. This
        #     field should include human-understandable information to distinguish
        #     origins from each other. Must be less than 200 characters. E.g.
        #     `migs-35678234`
        # @!attribute [rw] help_link
        #   @return [::String]
        #     Optional. A URL where an end user can learn more about removing this hold.
        #     E.g.
        #     `https://cloud.google.com/resource-manager/docs/tags/tags-creating-and-managing`
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time this TagHold was created.
        class TagHold
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message to create a TagHold.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the TagHold's parent TagValue. Must be of
        #     the form: `tagValues/{tag-value-id}`.
        # @!attribute [rw] tag_hold
        #   @return [::Google::Cloud::ResourceManager::V3::TagHold]
        #     Required. The TagHold to be created.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. Set to true to perform the validations necessary for creating the
        #     resource, but not actually perform the action.
        class CreateTagHoldRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Runtime operation information for creating a TagHold.
        # (-- The metadata is currently empty, but may include information in the
        # future. --)
        class CreateTagHoldMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message to delete a TagHold.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the TagHold to delete. Must be of the form:
        #     `tagValues/{tag-value-id}/tagHolds/{tag-hold-id}`.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. Set to true to perform the validations necessary for deleting the
        #     resource, but not actually perform the action.
        class DeleteTagHoldRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Runtime operation information for deleting a TagHold.
        # (-- The metadata is currently empty, but may include information in the
        # future. --)
        class DeleteTagHoldMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for listing the TagHolds under a TagValue.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the parent TagValue. Must be of the form:
        #     `tagValues/{tag-value-id}`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of TagHolds to return in the response. The
        #     server allows a maximum of 300 TagHolds to return. If unspecified, the
        #     server will use 100 as the default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A pagination token returned from a previous call to
        #     `ListTagHolds` that indicates where this listing should continue from.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Criteria used to select a subset of TagHolds parented by the
        #     TagValue to return. This field follows the syntax defined by aip.dev/160;
        #     the `holder` and `origin` fields are supported for filtering. Currently
        #     only `AND` syntax is supported. Some example queries are:
        #
        #       * `holder =
        #         //compute.googleapis.com/compute/projects/myproject/regions/us-east-1/instanceGroupManagers/instance-group`
        #       * `origin = 35678234`
        #       * `holder =
        #         //compute.googleapis.com/compute/projects/myproject/regions/us-east-1/instanceGroupManagers/instance-group
        #         AND origin = 35678234`
        class ListTagHoldsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The ListTagHolds response.
        # @!attribute [rw] tag_holds
        #   @return [::Array<::Google::Cloud::ResourceManager::V3::TagHold>]
        #     A possibly paginated list of TagHolds.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Pagination token.
        #
        #     If the result set is too large to fit in a single response, this token
        #     is returned. It encodes the position of the current result cursor.
        #     Feeding this value into a new list request with the `page_token` parameter
        #     gives the next page of the results.
        #
        #     When `next_page_token` is not filled in, there is no next page and
        #     the list returned is the last page in the result set.
        #
        #     Pagination tokens have a limited lifetime.
        class ListTagHoldsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
