# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module ResourceManager
      module V3
        # A project is a high-level Google Cloud entity. It is a
        # container for ACLs, APIs, App Engine Apps, VMs, and other
        # Google Cloud Platform resources.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The unique resource name of the project. It is an int64
        #     generated number prefixed by "projects/".
        #
        #     Example: `projects/415104041262`
        # @!attribute [rw] parent
        #   @return [::String]
        #     Optional. A reference to a parent Resource. eg., `organizations/123` or
        #     `folders/876`.
        # @!attribute [rw] project_id
        #   @return [::String]
        #     Immutable. The unique, user-assigned id of the project.
        #     It must be 6 to 30 lowercase ASCII letters, digits, or hyphens.
        #     It must start with a letter.
        #     Trailing hyphens are prohibited.
        #
        #     Example: `tokyo-rain-123`
        # @!attribute [r] state
        #   @return [::Google::Cloud::ResourceManager::V3::Project::State]
        #     Output only. The project lifecycle state.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Optional. A user-assigned display name of the project.
        #     When present it must be between 4 to 30 characters.
        #     Allowed characters are: lowercase and uppercase letters, numbers,
        #     hyphen, single-quote, double-quote, space, and exclamation point.
        #
        #     Example: `My Project`
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Creation time.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The most recent time this resource was modified.
        # @!attribute [r] delete_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time at which this resource was requested for deletion.
        # @!attribute [r] etag
        #   @return [::String]
        #     Output only. A checksum computed by the server based on the current value
        #     of the Project resource. This may be sent on update and delete requests to
        #     ensure the client has an up-to-date value before proceeding.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. The labels associated with this project.
        #
        #     Label keys must be between 1 and 63 characters long and must conform
        #     to the following regular expression: \[a-z\](\[-a-z0-9\]*\[a-z0-9\])?.
        #
        #     Label values must be between 0 and 63 characters long and must conform
        #     to the regular expression (\[a-z\](\[-a-z0-9\]*\[a-z0-9\])?)?.
        #
        #     No more than 64 labels can be associated with a given resource.
        #
        #     Clients should store labels in a representation such as JSON that does not
        #     depend on specific characters being disallowed.
        #
        #     Example: `"myBusinessDimension" : "businessValue"`
        class Project
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Project lifecycle states.
          module State
            # Unspecified state.  This is only used/useful for distinguishing
            # unset values.
            STATE_UNSPECIFIED = 0

            # The normal and active state.
            ACTIVE = 1

            # The project has been marked for deletion by the user
            # (by invoking
            # {::Google::Cloud::ResourceManager::V3::Projects::Client#delete_project DeleteProject})
            # or by the system (Google Cloud Platform).
            # This can generally be reversed by invoking [UndeleteProject]
            # [google.cloud.resourcemanager.v3.Projects.UndeleteProject].
            DELETE_REQUESTED = 2
          end
        end

        # The request sent to the
        # {::Google::Cloud::ResourceManager::V3::Projects::Client#get_project GetProject}
        # method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the project (for example, `projects/415104041262`).
        class GetProjectRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request sent to the
        # {::Google::Cloud::ResourceManager::V3::Projects::Client#list_projects ListProjects}
        # method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the parent resource whose projects are being listed.
        #     Only children of this parent resource are listed; descendants are not
        #     listed.
        #
        #     If the parent is a folder, use the value `folders/{folder_id}`. If the
        #     parent is an organization, use the value `organizations/{org_id}`.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A pagination token returned from a previous call to
        #     [ListProjects] [google.cloud.resourcemanager.v3.Projects.ListProjects] that
        #     indicates from where listing should continue.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of projects to return in the response.
        #     The server can return fewer projects than requested.
        #     If unspecified, server picks an appropriate default.
        # @!attribute [rw] show_deleted
        #   @return [::Boolean]
        #     Optional. Indicate that projects in the `DELETE_REQUESTED` state should
        #     also be returned. Normally only `ACTIVE` projects are returned.
        class ListProjectsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A page of the response received from the
        # {::Google::Cloud::ResourceManager::V3::Projects::Client#list_projects ListProjects}
        # method.
        #
        # A paginated response where more pages are available has
        # `next_page_token` set. This token can be used in a subsequent request to
        # retrieve the next request page.
        #
        # NOTE: A response may contain fewer elements than the request `page_size` and
        # still have a `next_page_token`.
        # @!attribute [rw] projects
        #   @return [::Array<::Google::Cloud::ResourceManager::V3::Project>]
        #     The list of Projects under the parent. This list can be paginated.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Pagination token.
        #
        #     If the result set is too large to fit in a single response, this token
        #     is returned. It encodes the position of the current result cursor.
        #     Feeding this value into a new list request with the `page_token` parameter
        #     gives the next page of the results.
        #
        #     When `next_page_token` is not filled in, there is no next page and
        #     the list returned is the last page in the result set.
        #
        #     Pagination tokens have a limited lifetime.
        class ListProjectsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request sent to the
        # {::Google::Cloud::ResourceManager::V3::Projects::Client#search_projects SearchProjects}
        # method.
        # @!attribute [rw] query
        #   @return [::String]
        #     Optional. A query string for searching for projects that the caller has
        #     `resourcemanager.projects.get` permission to. If multiple fields are
        #     included in the query, then it will return results that match any of the
        #     fields. Some eligible fields are:
        #
        #     - **`displayName`, `name`**: Filters by displayName.
        #     - **`parent`**: Project's parent (for example: `folders/123`,
        #     `organizations/*`). Prefer `parent` field over `parent.type` and
        #     `parent.id`.
        #     - **`parent.type`**: Parent's type: `folder` or `organization`.
        #     - **`parent.id`**: Parent's id number (for example: `123`).
        #     - **`id`, `projectId`**: Filters by projectId.
        #     - **`state`, `lifecycleState`**: Filters by state.
        #     - **`labels`**: Filters by label name or value.
        #     - **`labels.<key>` (where `<key>` is the name of a label)**: Filters by label
        #     name.
        #
        #     Search expressions are case insensitive.
        #
        #     Some examples queries:
        #
        #
        #     - **`name:how*`**: The project's name starts with "how".
        #     - **`name:Howl`**: The project's name is `Howl` or `howl`.
        #     - **`name:HOWL`**: Equivalent to above.
        #     - **`NAME:howl`**: Equivalent to above.
        #     - **`labels.color:*`**: The project has the label `color`.
        #     - **`labels.color:red`**:  The project's label `color` has the value `red`.
        #     - **`labels.color:red labels.size:big`**: The project's label `color` has
        #     the value `red` or its label `size` has the value `big`.
        #
        #     If no query is specified, the call will return projects for which the user
        #     has the `resourcemanager.projects.get` permission.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A pagination token returned from a previous call to
        #     [ListProjects] [google.cloud.resourcemanager.v3.Projects.ListProjects] that
        #     indicates from where listing should continue.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of projects to return in the response.
        #     The server can return fewer projects than requested.
        #     If unspecified, server picks an appropriate default.
        class SearchProjectsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A page of the response received from the
        # {::Google::Cloud::ResourceManager::V3::Projects::Client#search_projects SearchProjects}
        # method.
        #
        # A paginated response where more pages are available has
        # `next_page_token` set. This token can be used in a subsequent request to
        # retrieve the next request page.
        # @!attribute [rw] projects
        #   @return [::Array<::Google::Cloud::ResourceManager::V3::Project>]
        #     The list of Projects that matched the list filter query. This list can
        #     be paginated.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Pagination token.
        #
        #     If the result set is too large to fit in a single response, this token
        #     is returned. It encodes the position of the current result cursor.
        #     Feeding this value into a new list request with the `page_token` parameter
        #     gives the next page of the results.
        #
        #     When `next_page_token` is not filled in, there is no next page and
        #     the list returned is the last page in the result set.
        #
        #     Pagination tokens have a limited lifetime.
        class SearchProjectsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request sent to the
        # {::Google::Cloud::ResourceManager::V3::Projects::Client#create_project CreateProject}
        # method.
        # @!attribute [rw] project
        #   @return [::Google::Cloud::ResourceManager::V3::Project]
        #     Required. The Project to create.
        #
        #     Project ID is required. If the requested ID is unavailable, the request
        #     fails.
        #
        #     If the `parent` field is set, the `resourcemanager.projects.create`
        #     permission is checked on the parent resource. If no parent is set and
        #     the authorization credentials belong to an Organization, the parent
        #     will be set to that Organization.
        class CreateProjectRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A status object which is used as the `metadata` field for the Operation
        # returned by CreateProject. It provides insight for when significant phases of
        # Project creation have completed.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Creation time of the project creation workflow.
        # @!attribute [rw] gettable
        #   @return [::Boolean]
        #     True if the project can be retrieved using `GetProject`. No other
        #     operations on the project are guaranteed to work until the project creation
        #     is complete.
        # @!attribute [rw] ready
        #   @return [::Boolean]
        #     True if the project creation process is complete.
        class CreateProjectMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request sent to the
        # {::Google::Cloud::ResourceManager::V3::Projects::Client#update_project UpdateProject}
        # method.
        #
        # Only the `display_name` and `labels` fields can be change. Use the
        # {::Google::Cloud::ResourceManager::V3::Projects::Client#move_project MoveProject} method to
        # change the `parent` field.
        # @!attribute [rw] project
        #   @return [::Google::Cloud::ResourceManager::V3::Project]
        #     Required. The new definition of the project.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. An update mask to selectively update fields.
        class UpdateProjectRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A status object which is used as the `metadata` field for the Operation
        # returned by UpdateProject.
        class UpdateProjectMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request sent to
        # {::Google::Cloud::ResourceManager::V3::Projects::Client#move_project MoveProject}
        # method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the project to move.
        # @!attribute [rw] destination_parent
        #   @return [::String]
        #     Required. The new parent to move the Project under.
        class MoveProjectRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A status object which is used as the `metadata` field for the Operation
        # returned by MoveProject.
        class MoveProjectMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # {::Google::Cloud::ResourceManager::V3::Projects::Client#delete_project DeleteProject}
        # method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the Project (for example, `projects/415104041262`).
        class DeleteProjectRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A status object which is used as the `metadata` field for the Operation
        # returned by `DeleteProject`.
        class DeleteProjectMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request sent to the [UndeleteProject]
        # [google.cloud.resourcemanager.v3.Projects.UndeleteProject]
        # method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the project (for example, `projects/415104041262`).
        #
        #     Required.
        class UndeleteProjectRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A status object which is used as the `metadata` field for the Operation
        # returned by `UndeleteProject`.
        class UndeleteProjectMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
