# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/cloud/resourcemanager/v3/tag_values.proto for package 'Google.Cloud.ResourceManager.V3'
# Original file comments:
# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/cloud/resourcemanager/v3/tag_values_pb'

module Google
  module Cloud
    module ResourceManager
      module V3
        module TagValues
          # Allow users to create and manage tag values.
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'google.cloud.resourcemanager.v3.TagValues'

            # Lists all TagValues for a specific TagKey.
            rpc :ListTagValues, ::Google::Cloud::ResourceManager::V3::ListTagValuesRequest, ::Google::Cloud::ResourceManager::V3::ListTagValuesResponse
            # Retrieves a TagValue. This method will return `PERMISSION_DENIED` if the
            # value does not exist or the user does not have permission to view it.
            rpc :GetTagValue, ::Google::Cloud::ResourceManager::V3::GetTagValueRequest, ::Google::Cloud::ResourceManager::V3::TagValue
            # Retrieves a TagValue by its namespaced name.
            # This method will return `PERMISSION_DENIED` if the value does not exist
            # or the user does not have permission to view it.
            rpc :GetNamespacedTagValue, ::Google::Cloud::ResourceManager::V3::GetNamespacedTagValueRequest, ::Google::Cloud::ResourceManager::V3::TagValue
            # Creates a TagValue as a child of the specified TagKey. If a another
            # request with the same parameters is sent while the original request is in
            # process the second request will receive an error. A maximum of 1000
            # TagValues can exist under a TagKey at any given time.
            rpc :CreateTagValue, ::Google::Cloud::ResourceManager::V3::CreateTagValueRequest, ::Google::Longrunning::Operation
            # Updates the attributes of the TagValue resource.
            rpc :UpdateTagValue, ::Google::Cloud::ResourceManager::V3::UpdateTagValueRequest, ::Google::Longrunning::Operation
            # Deletes a TagValue. The TagValue cannot have any bindings when it is
            # deleted.
            rpc :DeleteTagValue, ::Google::Cloud::ResourceManager::V3::DeleteTagValueRequest, ::Google::Longrunning::Operation
            # Gets the access control policy for a TagValue. The returned policy may be
            # empty if no such policy or resource exists. The `resource` field should
            # be the TagValue's resource name. For example: `tagValues/1234`.
            # The caller must have the
            # `cloudresourcemanager.googleapis.com/tagValues.getIamPolicy` permission on
            # the identified TagValue to get the access control policy.
            rpc :GetIamPolicy, ::Google::Iam::V1::GetIamPolicyRequest, ::Google::Iam::V1::Policy
            # Sets the access control policy on a TagValue, replacing any existing
            # policy. The `resource` field should be the TagValue's resource name.
            # For example: `tagValues/1234`.
            # The caller must have `resourcemanager.tagValues.setIamPolicy` permission
            # on the identified tagValue.
            rpc :SetIamPolicy, ::Google::Iam::V1::SetIamPolicyRequest, ::Google::Iam::V1::Policy
            # Returns permissions that a caller has on the specified TagValue.
            # The `resource` field should be the TagValue's resource name. For example:
            # `tagValues/1234`.
            #
            # There are no permissions required for making this API call.
            rpc :TestIamPermissions, ::Google::Iam::V1::TestIamPermissionsRequest, ::Google::Iam::V1::TestIamPermissionsResponse
          end

          Stub = Service.rpc_stub_class
        end
      end
    end
  end
end
