# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/cloud/resourcemanager/v3/tag_keys.proto for package 'Google.Cloud.ResourceManager.V3'
# Original file comments:
# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/cloud/resourcemanager/v3/tag_keys_pb'

module Google
  module Cloud
    module ResourceManager
      module V3
        module TagKeys
          # Allow users to create and manage tag keys.
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'google.cloud.resourcemanager.v3.TagKeys'

            # Lists all TagKeys for a parent resource.
            rpc :ListTagKeys, ::Google::Cloud::ResourceManager::V3::ListTagKeysRequest, ::Google::Cloud::ResourceManager::V3::ListTagKeysResponse
            # Retrieves a TagKey. This method will return `PERMISSION_DENIED` if the
            # key does not exist or the user does not have permission to view it.
            rpc :GetTagKey, ::Google::Cloud::ResourceManager::V3::GetTagKeyRequest, ::Google::Cloud::ResourceManager::V3::TagKey
            # Retrieves a TagKey by its namespaced name.
            # This method will return `PERMISSION_DENIED` if the key does not exist
            # or the user does not have permission to view it.
            rpc :GetNamespacedTagKey, ::Google::Cloud::ResourceManager::V3::GetNamespacedTagKeyRequest, ::Google::Cloud::ResourceManager::V3::TagKey
            # Creates a new TagKey. If another request with the same parameters is
            # sent while the original request is in process, the second request
            # will receive an error. A maximum of 1000 TagKeys can exist under a parent
            # at any given time.
            rpc :CreateTagKey, ::Google::Cloud::ResourceManager::V3::CreateTagKeyRequest, ::Google::Longrunning::Operation
            # Updates the attributes of the TagKey resource.
            rpc :UpdateTagKey, ::Google::Cloud::ResourceManager::V3::UpdateTagKeyRequest, ::Google::Longrunning::Operation
            # Deletes a TagKey. The TagKey cannot be deleted if it has any child
            # TagValues.
            rpc :DeleteTagKey, ::Google::Cloud::ResourceManager::V3::DeleteTagKeyRequest, ::Google::Longrunning::Operation
            # Gets the access control policy for a TagKey. The returned policy may be
            # empty if no such policy or resource exists. The `resource` field should
            # be the TagKey's resource name. For example, "tagKeys/1234".
            # The caller must have
            # `cloudresourcemanager.googleapis.com/tagKeys.getIamPolicy` permission on
            # the specified TagKey.
            rpc :GetIamPolicy, ::Google::Iam::V1::GetIamPolicyRequest, ::Google::Iam::V1::Policy
            # Sets the access control policy on a TagKey, replacing any existing
            # policy. The `resource` field should be the TagKey's resource name.
            # For example, "tagKeys/1234".
            # The caller must have `resourcemanager.tagKeys.setIamPolicy` permission
            # on the identified tagValue.
            rpc :SetIamPolicy, ::Google::Iam::V1::SetIamPolicyRequest, ::Google::Iam::V1::Policy
            # Returns permissions that a caller has on the specified TagKey.
            # The `resource` field should be the TagKey's resource name.
            # For example, "tagKeys/1234".
            #
            # There are no permissions required for making this API call.
            rpc :TestIamPermissions, ::Google::Iam::V1::TestIamPermissionsRequest, ::Google::Iam::V1::TestIamPermissionsResponse
          end

          Stub = Service.rpc_stub_class
        end
      end
    end
  end
end
