# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/resourcemanager/v3/tag_keys_pb"
require "google/cloud/resource_manager/v3/tag_keys/rest/service_stub"

module Google
  module Cloud
    module ResourceManager
      module V3
        module TagKeys
          module Rest
            ##
            # REST client for the TagKeys service.
            #
            # Allow users to create and manage tag keys.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "cloudresourcemanager.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :tag_keys_stub

              ##
              # Configure the TagKeys Client class.
              #
              # See {::Google::Cloud::ResourceManager::V3::TagKeys::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all TagKeys clients
              #   ::Google::Cloud::ResourceManager::V3::TagKeys::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "ResourceManager", "V3"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.rpcs.list_tag_keys.timeout = 60.0
                  default_config.rpcs.list_tag_keys.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_tag_key.timeout = 60.0
                  default_config.rpcs.get_tag_key.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.create_tag_key.timeout = 60.0

                  default_config.rpcs.update_tag_key.timeout = 60.0

                  default_config.rpcs.delete_tag_key.timeout = 60.0

                  default_config.rpcs.get_iam_policy.timeout = 60.0
                  default_config.rpcs.get_iam_policy.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.set_iam_policy.timeout = 60.0

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the TagKeys Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::ResourceManager::V3::TagKeys::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @tag_keys_stub.universe_domain
              end

              ##
              # Create a new TagKeys REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::ResourceManager::V3::TagKeys::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::ResourceManager::V3::TagKeys::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the TagKeys client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = ::Google::Cloud::ResourceManager::V3::TagKeys::Rest::Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @tag_keys_stub = ::Google::Cloud::ResourceManager::V3::TagKeys::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @tag_keys_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::ResourceManager::V3::TagKeys::Rest::Operations]
              #
              attr_reader :operations_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @tag_keys_stub.logger
              end

              # Service calls

              ##
              # Lists all TagKeys for a parent resource.
              #
              # @overload list_tag_keys(request, options = nil)
              #   Pass arguments to `list_tag_keys` via a request object, either of type
              #   {::Google::Cloud::ResourceManager::V3::ListTagKeysRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ResourceManager::V3::ListTagKeysRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_tag_keys(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_tag_keys` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the TagKey's parent.
              #     Must be of the form `organizations/{org_id}` or `projects/{project_id}` or
              #     `projects/{project_number}`
              #   @param page_size [::Integer]
              #     Optional. The maximum number of TagKeys to return in the response. The
              #     server allows a maximum of 300 TagKeys to return. If unspecified, the
              #     server will use 100 as the default.
              #   @param page_token [::String]
              #     Optional. A pagination token returned from a previous call to `ListTagKey`
              #     that indicates where this listing should continue from.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ResourceManager::V3::TagKey>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ResourceManager::V3::TagKey>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/resource_manager/v3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ResourceManager::V3::TagKeys::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ResourceManager::V3::ListTagKeysRequest.new
              #
              #   # Call the list_tag_keys method.
              #   result = client.list_tag_keys request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::ResourceManager::V3::TagKey.
              #     p item
              #   end
              #
              def list_tag_keys request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ResourceManager::V3::ListTagKeysRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_tag_keys.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ResourceManager::V3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_tag_keys.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_tag_keys.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @tag_keys_stub.list_tag_keys request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @tag_keys_stub, :list_tag_keys, "tag_keys", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Retrieves a TagKey. This method will return `PERMISSION_DENIED` if the
              # key does not exist or the user does not have permission to view it.
              #
              # @overload get_tag_key(request, options = nil)
              #   Pass arguments to `get_tag_key` via a request object, either of type
              #   {::Google::Cloud::ResourceManager::V3::GetTagKeyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ResourceManager::V3::GetTagKeyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_tag_key(name: nil)
              #   Pass arguments to `get_tag_key` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. A resource name in the format `tagKeys/{id}`, such as
              #     `tagKeys/123`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ResourceManager::V3::TagKey]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ResourceManager::V3::TagKey]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/resource_manager/v3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ResourceManager::V3::TagKeys::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ResourceManager::V3::GetTagKeyRequest.new
              #
              #   # Call the get_tag_key method.
              #   result = client.get_tag_key request
              #
              #   # The returned object is of type Google::Cloud::ResourceManager::V3::TagKey.
              #   p result
              #
              def get_tag_key request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ResourceManager::V3::GetTagKeyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_tag_key.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ResourceManager::V3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_tag_key.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_tag_key.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @tag_keys_stub.get_tag_key request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Retrieves a TagKey by its namespaced name.
              # This method will return `PERMISSION_DENIED` if the key does not exist
              # or the user does not have permission to view it.
              #
              # @overload get_namespaced_tag_key(request, options = nil)
              #   Pass arguments to `get_namespaced_tag_key` via a request object, either of type
              #   {::Google::Cloud::ResourceManager::V3::GetNamespacedTagKeyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ResourceManager::V3::GetNamespacedTagKeyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_namespaced_tag_key(name: nil)
              #   Pass arguments to `get_namespaced_tag_key` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. A namespaced tag key name in the format
              #     `{parentId}/{tagKeyShort}`, such as `42/foo` for a key with short name
              #     "foo" under the organization with ID 42 or `r2-d2/bar` for a key with short
              #     name "bar" under the project `r2-d2`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ResourceManager::V3::TagKey]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ResourceManager::V3::TagKey]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/resource_manager/v3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ResourceManager::V3::TagKeys::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ResourceManager::V3::GetNamespacedTagKeyRequest.new
              #
              #   # Call the get_namespaced_tag_key method.
              #   result = client.get_namespaced_tag_key request
              #
              #   # The returned object is of type Google::Cloud::ResourceManager::V3::TagKey.
              #   p result
              #
              def get_namespaced_tag_key request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ResourceManager::V3::GetNamespacedTagKeyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_namespaced_tag_key.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ResourceManager::V3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_namespaced_tag_key.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_namespaced_tag_key.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @tag_keys_stub.get_namespaced_tag_key request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new TagKey. If another request with the same parameters is
              # sent while the original request is in process, the second request
              # will receive an error. A maximum of 1000 TagKeys can exist under a parent
              # at any given time.
              #
              # @overload create_tag_key(request, options = nil)
              #   Pass arguments to `create_tag_key` via a request object, either of type
              #   {::Google::Cloud::ResourceManager::V3::CreateTagKeyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ResourceManager::V3::CreateTagKeyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_tag_key(tag_key: nil, validate_only: nil)
              #   Pass arguments to `create_tag_key` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param tag_key [::Google::Cloud::ResourceManager::V3::TagKey, ::Hash]
              #     Required. The TagKey to be created. Only fields `short_name`,
              #     `description`, and `parent` are considered during the creation request.
              #   @param validate_only [::Boolean]
              #     Optional. Set to true to perform validations necessary for creating the
              #     resource, but not actually perform the action.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/resource_manager/v3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ResourceManager::V3::TagKeys::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ResourceManager::V3::CreateTagKeyRequest.new
              #
              #   # Call the create_tag_key method.
              #   result = client.create_tag_key request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_tag_key request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ResourceManager::V3::CreateTagKeyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_tag_key.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ResourceManager::V3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_tag_key.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_tag_key.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @tag_keys_stub.create_tag_key request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the attributes of the TagKey resource.
              #
              # @overload update_tag_key(request, options = nil)
              #   Pass arguments to `update_tag_key` via a request object, either of type
              #   {::Google::Cloud::ResourceManager::V3::UpdateTagKeyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ResourceManager::V3::UpdateTagKeyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_tag_key(tag_key: nil, update_mask: nil, validate_only: nil)
              #   Pass arguments to `update_tag_key` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param tag_key [::Google::Cloud::ResourceManager::V3::TagKey, ::Hash]
              #     Required. The new definition of the TagKey. Only the `description` and
              #     `etag` fields can be updated by this request. If the `etag` field is not
              #     empty, it must match the `etag` field of the existing tag key. Otherwise,
              #     `ABORTED` will be returned.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Fields to be updated. The mask may only contain `description` or
              #     `etag`. If omitted entirely, both `description` and `etag` are assumed to
              #     be significant.
              #   @param validate_only [::Boolean]
              #     Set as true to perform validations necessary for updating the resource, but
              #     not actually perform the action.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/resource_manager/v3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ResourceManager::V3::TagKeys::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ResourceManager::V3::UpdateTagKeyRequest.new
              #
              #   # Call the update_tag_key method.
              #   result = client.update_tag_key request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_tag_key request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ResourceManager::V3::UpdateTagKeyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_tag_key.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ResourceManager::V3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_tag_key.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_tag_key.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @tag_keys_stub.update_tag_key request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a TagKey. The TagKey cannot be deleted if it has any child
              # TagValues.
              #
              # @overload delete_tag_key(request, options = nil)
              #   Pass arguments to `delete_tag_key` via a request object, either of type
              #   {::Google::Cloud::ResourceManager::V3::DeleteTagKeyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ResourceManager::V3::DeleteTagKeyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_tag_key(name: nil, validate_only: nil, etag: nil)
              #   Pass arguments to `delete_tag_key` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of a TagKey to be deleted in the format
              #     `tagKeys/123`. The TagKey cannot be a parent of any existing TagValues or
              #     it will not be deleted successfully.
              #   @param validate_only [::Boolean]
              #     Optional. Set as true to perform validations necessary for deletion, but
              #     not actually perform the action.
              #   @param etag [::String]
              #     Optional. The etag known to the client for the expected state of the
              #     TagKey. This is to be used for optimistic concurrency.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/resource_manager/v3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ResourceManager::V3::TagKeys::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ResourceManager::V3::DeleteTagKeyRequest.new
              #
              #   # Call the delete_tag_key method.
              #   result = client.delete_tag_key request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_tag_key request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ResourceManager::V3::DeleteTagKeyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_tag_key.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ResourceManager::V3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_tag_key.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_tag_key.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @tag_keys_stub.delete_tag_key request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the access control policy for a TagKey. The returned policy may be
              # empty if no such policy or resource exists. The `resource` field should
              # be the TagKey's resource name. For example, "tagKeys/1234".
              # The caller must have
              # `cloudresourcemanager.googleapis.com/tagKeys.getIamPolicy` permission on
              # the specified TagKey.
              #
              # @overload get_iam_policy(request, options = nil)
              #   Pass arguments to `get_iam_policy` via a request object, either of type
              #   {::Google::Iam::V1::GetIamPolicyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Iam::V1::GetIamPolicyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_iam_policy(resource: nil, options: nil)
              #   Pass arguments to `get_iam_policy` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param resource [::String]
              #     REQUIRED: The resource for which the policy is being requested.
              #     See the operation documentation for the appropriate value for this field.
              #   @param options [::Google::Iam::V1::GetPolicyOptions, ::Hash]
              #     OPTIONAL: A `GetPolicyOptions` object for specifying options to
              #     `GetIamPolicy`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Iam::V1::Policy]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Iam::V1::Policy]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/resource_manager/v3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ResourceManager::V3::TagKeys::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Iam::V1::GetIamPolicyRequest.new
              #
              #   # Call the get_iam_policy method.
              #   result = client.get_iam_policy request
              #
              #   # The returned object is of type Google::Iam::V1::Policy.
              #   p result
              #
              def get_iam_policy request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::GetIamPolicyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_iam_policy.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ResourceManager::V3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_iam_policy.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_iam_policy.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @tag_keys_stub.get_iam_policy request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Sets the access control policy on a TagKey, replacing any existing
              # policy. The `resource` field should be the TagKey's resource name.
              # For example, "tagKeys/1234".
              # The caller must have `resourcemanager.tagKeys.setIamPolicy` permission
              # on the identified tagValue.
              #
              # @overload set_iam_policy(request, options = nil)
              #   Pass arguments to `set_iam_policy` via a request object, either of type
              #   {::Google::Iam::V1::SetIamPolicyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Iam::V1::SetIamPolicyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload set_iam_policy(resource: nil, policy: nil, update_mask: nil)
              #   Pass arguments to `set_iam_policy` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param resource [::String]
              #     REQUIRED: The resource for which the policy is being specified.
              #     See the operation documentation for the appropriate value for this field.
              #   @param policy [::Google::Iam::V1::Policy, ::Hash]
              #     REQUIRED: The complete policy to be applied to the `resource`. The size of
              #     the policy is limited to a few 10s of KB. An empty policy is a
              #     valid policy but certain Cloud Platform services (such as Projects)
              #     might reject them.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     OPTIONAL: A FieldMask specifying which fields of the policy to modify. Only
              #     the fields in the mask will be modified. If no mask is provided, the
              #     following default mask is used:
              #
              #     `paths: "bindings, etag"`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Iam::V1::Policy]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Iam::V1::Policy]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/resource_manager/v3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ResourceManager::V3::TagKeys::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Iam::V1::SetIamPolicyRequest.new
              #
              #   # Call the set_iam_policy method.
              #   result = client.set_iam_policy request
              #
              #   # The returned object is of type Google::Iam::V1::Policy.
              #   p result
              #
              def set_iam_policy request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::SetIamPolicyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.set_iam_policy.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ResourceManager::V3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.set_iam_policy.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.set_iam_policy.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @tag_keys_stub.set_iam_policy request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns permissions that a caller has on the specified TagKey.
              # The `resource` field should be the TagKey's resource name.
              # For example, "tagKeys/1234".
              #
              # There are no permissions required for making this API call.
              #
              # @overload test_iam_permissions(request, options = nil)
              #   Pass arguments to `test_iam_permissions` via a request object, either of type
              #   {::Google::Iam::V1::TestIamPermissionsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Iam::V1::TestIamPermissionsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload test_iam_permissions(resource: nil, permissions: nil)
              #   Pass arguments to `test_iam_permissions` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param resource [::String]
              #     REQUIRED: The resource for which the policy detail is being requested.
              #     See the operation documentation for the appropriate value for this field.
              #   @param permissions [::Array<::String>]
              #     The set of permissions to check for the `resource`. Permissions with
              #     wildcards (such as '*' or 'storage.*') are not allowed. For more
              #     information see
              #     [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Iam::V1::TestIamPermissionsResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Iam::V1::TestIamPermissionsResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/resource_manager/v3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ResourceManager::V3::TagKeys::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Iam::V1::TestIamPermissionsRequest.new
              #
              #   # Call the test_iam_permissions method.
              #   result = client.test_iam_permissions request
              #
              #   # The returned object is of type Google::Iam::V1::TestIamPermissionsResponse.
              #   p result
              #
              def test_iam_permissions request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::TestIamPermissionsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.test_iam_permissions.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ResourceManager::V3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.test_iam_permissions.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.test_iam_permissions.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @tag_keys_stub.test_iam_permissions request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the TagKeys REST API.
              #
              # This class represents the configuration for TagKeys REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::ResourceManager::V3::TagKeys::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # list_tag_keys to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::ResourceManager::V3::TagKeys::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_tag_keys.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::ResourceManager::V3::TagKeys::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_tag_keys.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "cloudresourcemanager.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the TagKeys API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `list_tag_keys`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_tag_keys
                  ##
                  # RPC-specific configuration for `get_tag_key`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_tag_key
                  ##
                  # RPC-specific configuration for `get_namespaced_tag_key`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_namespaced_tag_key
                  ##
                  # RPC-specific configuration for `create_tag_key`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_tag_key
                  ##
                  # RPC-specific configuration for `update_tag_key`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_tag_key
                  ##
                  # RPC-specific configuration for `delete_tag_key`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_tag_key
                  ##
                  # RPC-specific configuration for `get_iam_policy`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_iam_policy
                  ##
                  # RPC-specific configuration for `set_iam_policy`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :set_iam_policy
                  ##
                  # RPC-specific configuration for `test_iam_permissions`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :test_iam_permissions

                  # @private
                  def initialize parent_rpcs = nil
                    list_tag_keys_config = parent_rpcs.list_tag_keys if parent_rpcs.respond_to? :list_tag_keys
                    @list_tag_keys = ::Gapic::Config::Method.new list_tag_keys_config
                    get_tag_key_config = parent_rpcs.get_tag_key if parent_rpcs.respond_to? :get_tag_key
                    @get_tag_key = ::Gapic::Config::Method.new get_tag_key_config
                    get_namespaced_tag_key_config = parent_rpcs.get_namespaced_tag_key if parent_rpcs.respond_to? :get_namespaced_tag_key
                    @get_namespaced_tag_key = ::Gapic::Config::Method.new get_namespaced_tag_key_config
                    create_tag_key_config = parent_rpcs.create_tag_key if parent_rpcs.respond_to? :create_tag_key
                    @create_tag_key = ::Gapic::Config::Method.new create_tag_key_config
                    update_tag_key_config = parent_rpcs.update_tag_key if parent_rpcs.respond_to? :update_tag_key
                    @update_tag_key = ::Gapic::Config::Method.new update_tag_key_config
                    delete_tag_key_config = parent_rpcs.delete_tag_key if parent_rpcs.respond_to? :delete_tag_key
                    @delete_tag_key = ::Gapic::Config::Method.new delete_tag_key_config
                    get_iam_policy_config = parent_rpcs.get_iam_policy if parent_rpcs.respond_to? :get_iam_policy
                    @get_iam_policy = ::Gapic::Config::Method.new get_iam_policy_config
                    set_iam_policy_config = parent_rpcs.set_iam_policy if parent_rpcs.respond_to? :set_iam_policy
                    @set_iam_policy = ::Gapic::Config::Method.new set_iam_policy_config
                    test_iam_permissions_config = parent_rpcs.test_iam_permissions if parent_rpcs.respond_to? :test_iam_permissions
                    @test_iam_permissions = ::Gapic::Config::Method.new test_iam_permissions_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
