# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/resourcemanager/v3/projects_pb"

module Google
  module Cloud
    module ResourceManager
      module V3
        module Projects
          ##
          # Client for the Projects service.
          #
          # Manages Google Cloud Projects.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "cloudresourcemanager.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :projects_stub

            ##
            # Configure the Projects Client class.
            #
            # See {::Google::Cloud::ResourceManager::V3::Projects::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all Projects clients
            #   ::Google::Cloud::ResourceManager::V3::Projects::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "ResourceManager", "V3"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.rpcs.get_project.timeout = 60.0
                default_config.rpcs.get_project.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_projects.timeout = 60.0
                default_config.rpcs.list_projects.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.search_projects.timeout = 60.0

                default_config.rpcs.create_project.timeout = 60.0

                default_config.rpcs.update_project.timeout = 60.0

                default_config.rpcs.move_project.timeout = 60.0

                default_config.rpcs.delete_project.timeout = 60.0

                default_config.rpcs.undelete_project.timeout = 60.0

                default_config.rpcs.get_iam_policy.timeout = 60.0
                default_config.rpcs.get_iam_policy.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.set_iam_policy.timeout = 60.0

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the Projects Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::ResourceManager::V3::Projects::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @projects_stub.universe_domain
            end

            ##
            # Create a new Projects client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::ResourceManager::V3::Projects::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::ResourceManager::V3::Projects::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Projects client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/resourcemanager/v3/projects_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @projects_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::ResourceManager::V3::Projects::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @projects_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Cloud::ResourceManager::V3::Projects::Operations]
            #
            attr_reader :operations_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @projects_stub.logger
            end

            # Service calls

            ##
            # Retrieves the project identified by the specified `name` (for example,
            # `projects/415104041262`).
            #
            # The caller must have `resourcemanager.projects.get` permission
            # for this project.
            #
            # @overload get_project(request, options = nil)
            #   Pass arguments to `get_project` via a request object, either of type
            #   {::Google::Cloud::ResourceManager::V3::GetProjectRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ResourceManager::V3::GetProjectRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_project(name: nil)
            #   Pass arguments to `get_project` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the project (for example, `projects/415104041262`).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::ResourceManager::V3::Project]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::ResourceManager::V3::Project]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/resource_manager/v3"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ResourceManager::V3::Projects::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ResourceManager::V3::GetProjectRequest.new
            #
            #   # Call the get_project method.
            #   result = client.get_project request
            #
            #   # The returned object is of type Google::Cloud::ResourceManager::V3::Project.
            #   p result
            #
            def get_project request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ResourceManager::V3::GetProjectRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_project.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ResourceManager::V3::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_project.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_project.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @projects_stub.call_rpc :get_project, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists projects that are direct children of the specified folder or
            # organization resource. `list()` provides a strongly consistent view of the
            # projects underneath the specified parent resource. `list()` returns
            # projects sorted based upon the (ascending) lexical ordering of their
            # `display_name`. The caller must have `resourcemanager.projects.list`
            # permission on the identified parent.
            #
            # @overload list_projects(request, options = nil)
            #   Pass arguments to `list_projects` via a request object, either of type
            #   {::Google::Cloud::ResourceManager::V3::ListProjectsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ResourceManager::V3::ListProjectsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_projects(parent: nil, page_token: nil, page_size: nil, show_deleted: nil)
            #   Pass arguments to `list_projects` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The name of the parent resource whose projects are being listed.
            #     Only children of this parent resource are listed; descendants are not
            #     listed.
            #
            #     If the parent is a folder, use the value `folders/{folder_id}`. If the
            #     parent is an organization, use the value `organizations/{org_id}`.
            #   @param page_token [::String]
            #     Optional. A pagination token returned from a previous call to
            #     [ListProjects] [google.cloud.resourcemanager.v3.Projects.ListProjects] that
            #     indicates from where listing should continue.
            #   @param page_size [::Integer]
            #     Optional. The maximum number of projects to return in the response.
            #     The server can return fewer projects than requested.
            #     If unspecified, server picks an appropriate default.
            #   @param show_deleted [::Boolean]
            #     Optional. Indicate that projects in the `DELETE_REQUESTED` state should
            #     also be returned. Normally only `ACTIVE` projects are returned.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::ResourceManager::V3::Project>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::ResourceManager::V3::Project>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/resource_manager/v3"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ResourceManager::V3::Projects::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ResourceManager::V3::ListProjectsRequest.new
            #
            #   # Call the list_projects method.
            #   result = client.list_projects request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::ResourceManager::V3::Project.
            #     p item
            #   end
            #
            def list_projects request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ResourceManager::V3::ListProjectsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_projects.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ResourceManager::V3::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              options.apply_defaults timeout:      @config.rpcs.list_projects.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_projects.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @projects_stub.call_rpc :list_projects, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @projects_stub, :list_projects, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Search for projects that the caller has both `resourcemanager.projects.get`
            # permission on, and also satisfy the specified query.
            #
            # This method returns projects in an unspecified order.
            #
            # This method is eventually consistent with project mutations; this means
            # that a newly created project may not appear in the results or recent
            # updates to an existing project may not be reflected in the results. To
            # retrieve the latest state of a project, use the
            # {::Google::Cloud::ResourceManager::V3::Projects::Client#get_project GetProject} method.
            #
            # @overload search_projects(request, options = nil)
            #   Pass arguments to `search_projects` via a request object, either of type
            #   {::Google::Cloud::ResourceManager::V3::SearchProjectsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ResourceManager::V3::SearchProjectsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload search_projects(query: nil, page_token: nil, page_size: nil)
            #   Pass arguments to `search_projects` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param query [::String]
            #     Optional. A query string for searching for projects that the caller has
            #     `resourcemanager.projects.get` permission to. If multiple fields are
            #     included in the query, then it will return results that match any of the
            #     fields. Some eligible fields are:
            #
            #     - **`displayName`, `name`**: Filters by displayName.
            #     - **`parent`**: Project's parent (for example: `folders/123`,
            #     `organizations/*`). Prefer `parent` field over `parent.type` and
            #     `parent.id`.
            #     - **`parent.type`**: Parent's type: `folder` or `organization`.
            #     - **`parent.id`**: Parent's id number (for example: `123`).
            #     - **`id`, `projectId`**: Filters by projectId.
            #     - **`state`, `lifecycleState`**: Filters by state.
            #     - **`labels`**: Filters by label name or value.
            #     - **`labels.<key>` (where `<key>` is the name of a label)**: Filters by label
            #     name.
            #
            #     Search expressions are case insensitive.
            #
            #     Some examples queries:
            #
            #
            #     - **`name:how*`**: The project's name starts with "how".
            #     - **`name:Howl`**: The project's name is `Howl` or `howl`.
            #     - **`name:HOWL`**: Equivalent to above.
            #     - **`NAME:howl`**: Equivalent to above.
            #     - **`labels.color:*`**: The project has the label `color`.
            #     - **`labels.color:red`**:  The project's label `color` has the value `red`.
            #     - **`labels.color:red labels.size:big`**: The project's label `color` has
            #     the value `red` or its label `size` has the value `big`.
            #
            #     If no query is specified, the call will return projects for which the user
            #     has the `resourcemanager.projects.get` permission.
            #   @param page_token [::String]
            #     Optional. A pagination token returned from a previous call to
            #     [ListProjects] [google.cloud.resourcemanager.v3.Projects.ListProjects] that
            #     indicates from where listing should continue.
            #   @param page_size [::Integer]
            #     Optional. The maximum number of projects to return in the response.
            #     The server can return fewer projects than requested.
            #     If unspecified, server picks an appropriate default.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::ResourceManager::V3::Project>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::ResourceManager::V3::Project>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/resource_manager/v3"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ResourceManager::V3::Projects::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ResourceManager::V3::SearchProjectsRequest.new
            #
            #   # Call the search_projects method.
            #   result = client.search_projects request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::ResourceManager::V3::Project.
            #     p item
            #   end
            #
            def search_projects request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ResourceManager::V3::SearchProjectsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.search_projects.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ResourceManager::V3::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              options.apply_defaults timeout:      @config.rpcs.search_projects.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.search_projects.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @projects_stub.call_rpc :search_projects, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @projects_stub, :search_projects, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Request that a new project be created. The result is an `Operation` which
            # can be used to track the creation process. This process usually takes a few
            # seconds, but can sometimes take much longer. The tracking `Operation` is
            # automatically deleted after a few hours, so there is no need to call
            # `DeleteOperation`.
            #
            # @overload create_project(request, options = nil)
            #   Pass arguments to `create_project` via a request object, either of type
            #   {::Google::Cloud::ResourceManager::V3::CreateProjectRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ResourceManager::V3::CreateProjectRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_project(project: nil)
            #   Pass arguments to `create_project` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param project [::Google::Cloud::ResourceManager::V3::Project, ::Hash]
            #     Required. The Project to create.
            #
            #     Project ID is required. If the requested ID is unavailable, the request
            #     fails.
            #
            #     If the `parent` field is set, the `resourcemanager.projects.create`
            #     permission is checked on the parent resource. If no parent is set and
            #     the authorization credentials belong to an Organization, the parent
            #     will be set to that Organization.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/resource_manager/v3"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ResourceManager::V3::Projects::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ResourceManager::V3::CreateProjectRequest.new
            #
            #   # Call the create_project method.
            #   result = client.create_project request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_project request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ResourceManager::V3::CreateProjectRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_project.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ResourceManager::V3::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              options.apply_defaults timeout:      @config.rpcs.create_project.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_project.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @projects_stub.call_rpc :create_project, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the `display_name` and labels of the project identified by the
            # specified `name` (for example, `projects/415104041262`). Deleting all
            # labels requires an update mask for labels field.
            #
            # The caller must have `resourcemanager.projects.update` permission for this
            # project.
            #
            # @overload update_project(request, options = nil)
            #   Pass arguments to `update_project` via a request object, either of type
            #   {::Google::Cloud::ResourceManager::V3::UpdateProjectRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ResourceManager::V3::UpdateProjectRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_project(project: nil, update_mask: nil)
            #   Pass arguments to `update_project` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param project [::Google::Cloud::ResourceManager::V3::Project, ::Hash]
            #     Required. The new definition of the project.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Optional. An update mask to selectively update fields.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/resource_manager/v3"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ResourceManager::V3::Projects::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ResourceManager::V3::UpdateProjectRequest.new
            #
            #   # Call the update_project method.
            #   result = client.update_project request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_project request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ResourceManager::V3::UpdateProjectRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_project.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ResourceManager::V3::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.project&.name
                header_params["project.name"] = request.project.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_project.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_project.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @projects_stub.call_rpc :update_project, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Move a project to another place in your resource hierarchy, under a new
            # resource parent.
            #
            # Returns an operation which can be used to track the process of the project
            # move workflow.
            # Upon success, the `Operation.response` field will be populated with the
            # moved project.
            #
            # The caller must have `resourcemanager.projects.move` permission on the
            # project, on the project's current and proposed new parent.
            #
            # If project has no current parent, or it currently does not have an
            # associated organization resource, you will also need the
            # `resourcemanager.projects.setIamPolicy` permission in the project.
            #
            # @overload move_project(request, options = nil)
            #   Pass arguments to `move_project` via a request object, either of type
            #   {::Google::Cloud::ResourceManager::V3::MoveProjectRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ResourceManager::V3::MoveProjectRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload move_project(name: nil, destination_parent: nil)
            #   Pass arguments to `move_project` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the project to move.
            #   @param destination_parent [::String]
            #     Required. The new parent to move the Project under.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/resource_manager/v3"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ResourceManager::V3::Projects::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ResourceManager::V3::MoveProjectRequest.new
            #
            #   # Call the move_project method.
            #   result = client.move_project request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def move_project request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ResourceManager::V3::MoveProjectRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.move_project.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ResourceManager::V3::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.move_project.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.move_project.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @projects_stub.call_rpc :move_project, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Marks the project identified by the specified
            # `name` (for example, `projects/415104041262`) for deletion.
            #
            # This method will only affect the project if it has a lifecycle state of
            # {::Google::Cloud::ResourceManager::V3::Project::State::ACTIVE ACTIVE}.
            #
            # This method changes the Project's lifecycle state from
            # {::Google::Cloud::ResourceManager::V3::Project::State::ACTIVE ACTIVE}
            # to
            # {::Google::Cloud::ResourceManager::V3::Project::State::DELETE_REQUESTED DELETE_REQUESTED}.
            # The deletion starts at an unspecified time,
            # at which point the Project is no longer accessible.
            #
            # Until the deletion completes, you can check the lifecycle state
            # checked by retrieving the project with [GetProject]
            # [google.cloud.resourcemanager.v3.Projects.GetProject],
            # and the project remains visible to [ListProjects]
            # [google.cloud.resourcemanager.v3.Projects.ListProjects].
            # However, you cannot update the project.
            #
            # After the deletion completes, the project is not retrievable by
            # the  [GetProject]
            # [google.cloud.resourcemanager.v3.Projects.GetProject],
            # [ListProjects]
            # [google.cloud.resourcemanager.v3.Projects.ListProjects], and
            # {::Google::Cloud::ResourceManager::V3::Projects::Client#search_projects SearchProjects}
            # methods.
            #
            # This method behaves idempotently, such that deleting a `DELETE_REQUESTED`
            # project will not cause an error, but also won't do anything.
            #
            # The caller must have `resourcemanager.projects.delete` permissions for this
            # project.
            #
            # @overload delete_project(request, options = nil)
            #   Pass arguments to `delete_project` via a request object, either of type
            #   {::Google::Cloud::ResourceManager::V3::DeleteProjectRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ResourceManager::V3::DeleteProjectRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_project(name: nil)
            #   Pass arguments to `delete_project` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the Project (for example, `projects/415104041262`).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/resource_manager/v3"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ResourceManager::V3::Projects::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ResourceManager::V3::DeleteProjectRequest.new
            #
            #   # Call the delete_project method.
            #   result = client.delete_project request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_project request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ResourceManager::V3::DeleteProjectRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_project.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ResourceManager::V3::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_project.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_project.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @projects_stub.call_rpc :delete_project, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Restores the project identified by the specified
            # `name` (for example, `projects/415104041262`).
            # You can only use this method for a project that has a lifecycle state of
            # [DELETE_REQUESTED]
            # [Projects.State.DELETE_REQUESTED].
            # After deletion starts, the project cannot be restored.
            #
            # The caller must have `resourcemanager.projects.undelete` permission for
            # this project.
            #
            # @overload undelete_project(request, options = nil)
            #   Pass arguments to `undelete_project` via a request object, either of type
            #   {::Google::Cloud::ResourceManager::V3::UndeleteProjectRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::ResourceManager::V3::UndeleteProjectRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload undelete_project(name: nil)
            #   Pass arguments to `undelete_project` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the project (for example, `projects/415104041262`).
            #
            #     Required.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/resource_manager/v3"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ResourceManager::V3::Projects::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::ResourceManager::V3::UndeleteProjectRequest.new
            #
            #   # Call the undelete_project method.
            #   result = client.undelete_project request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def undelete_project request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ResourceManager::V3::UndeleteProjectRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.undelete_project.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ResourceManager::V3::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.undelete_project.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.undelete_project.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @projects_stub.call_rpc :undelete_project, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns the IAM access control policy for the specified project, in the
            # format `projects/{ProjectIdOrNumber}` e.g. projects/123.
            # Permission is denied if the policy or the resource do not exist.
            #
            # @overload get_iam_policy(request, options = nil)
            #   Pass arguments to `get_iam_policy` via a request object, either of type
            #   {::Google::Iam::V1::GetIamPolicyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Iam::V1::GetIamPolicyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_iam_policy(resource: nil, options: nil)
            #   Pass arguments to `get_iam_policy` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param resource [::String]
            #     REQUIRED: The resource for which the policy is being requested.
            #     See the operation documentation for the appropriate value for this field.
            #   @param options [::Google::Iam::V1::GetPolicyOptions, ::Hash]
            #     OPTIONAL: A `GetPolicyOptions` object for specifying options to
            #     `GetIamPolicy`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Iam::V1::Policy]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Iam::V1::Policy]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/resource_manager/v3"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ResourceManager::V3::Projects::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Iam::V1::GetIamPolicyRequest.new
            #
            #   # Call the get_iam_policy method.
            #   result = client.get_iam_policy request
            #
            #   # The returned object is of type Google::Iam::V1::Policy.
            #   p result
            #
            def get_iam_policy request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::GetIamPolicyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_iam_policy.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ResourceManager::V3::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.resource
                header_params["resource"] = request.resource
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_iam_policy.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_iam_policy.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @projects_stub.call_rpc :get_iam_policy, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Sets the IAM access control policy for the specified project, in the
            # format `projects/{ProjectIdOrNumber}` e.g. projects/123.
            #
            # CAUTION: This method will replace the existing policy, and cannot be used
            # to append additional IAM settings.
            #
            # Note: Removing service accounts from policies or changing their roles can
            # render services completely inoperable. It is important to understand how
            # the service account is being used before removing or updating its roles.
            #
            # The following constraints apply when using `setIamPolicy()`:
            #
            # + Project does not support `allUsers` and `allAuthenticatedUsers` as
            # `members` in a `Binding` of a `Policy`.
            #
            # + The owner role can be granted to a `user`, `serviceAccount`, or a group
            # that is part of an organization. For example,
            # group@myownpersonaldomain.com could be added as an owner to a project in
            # the myownpersonaldomain.com organization, but not the examplepetstore.com
            # organization.
            #
            # + Service accounts can be made owners of a project directly
            # without any restrictions. However, to be added as an owner, a user must be
            # invited using the Cloud Platform console and must accept the invitation.
            #
            # + A user cannot be granted the owner role using `setIamPolicy()`. The user
            # must be granted the owner role using the Cloud Platform Console and must
            # explicitly accept the invitation.
            #
            # + Invitations to grant the owner role cannot be sent using
            # `setIamPolicy()`;
            # they must be sent only using the Cloud Platform Console.
            #
            # + If the project is not part of an organization, there must be at least
            # one owner who has accepted the Terms of Service (ToS) agreement in the
            # policy. Calling `setIamPolicy()` to remove the last ToS-accepted owner
            # from the policy will fail. This restriction also applies to legacy
            # projects that no longer have owners who have accepted the ToS. Edits to
            # IAM policies will be rejected until the lack of a ToS-accepting owner is
            # rectified. If the project is part of an organization, you can remove all
            # owners, potentially making the organization inaccessible.
            #
            # @overload set_iam_policy(request, options = nil)
            #   Pass arguments to `set_iam_policy` via a request object, either of type
            #   {::Google::Iam::V1::SetIamPolicyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Iam::V1::SetIamPolicyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload set_iam_policy(resource: nil, policy: nil, update_mask: nil)
            #   Pass arguments to `set_iam_policy` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param resource [::String]
            #     REQUIRED: The resource for which the policy is being specified.
            #     See the operation documentation for the appropriate value for this field.
            #   @param policy [::Google::Iam::V1::Policy, ::Hash]
            #     REQUIRED: The complete policy to be applied to the `resource`. The size of
            #     the policy is limited to a few 10s of KB. An empty policy is a
            #     valid policy but certain Cloud Platform services (such as Projects)
            #     might reject them.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     OPTIONAL: A FieldMask specifying which fields of the policy to modify. Only
            #     the fields in the mask will be modified. If no mask is provided, the
            #     following default mask is used:
            #
            #     `paths: "bindings, etag"`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Iam::V1::Policy]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Iam::V1::Policy]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/resource_manager/v3"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ResourceManager::V3::Projects::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Iam::V1::SetIamPolicyRequest.new
            #
            #   # Call the set_iam_policy method.
            #   result = client.set_iam_policy request
            #
            #   # The returned object is of type Google::Iam::V1::Policy.
            #   p result
            #
            def set_iam_policy request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::SetIamPolicyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.set_iam_policy.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ResourceManager::V3::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.resource
                header_params["resource"] = request.resource
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.set_iam_policy.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.set_iam_policy.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @projects_stub.call_rpc :set_iam_policy, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns permissions that a caller has on the specified project, in the
            # format `projects/{ProjectIdOrNumber}` e.g. projects/123..
            #
            # @overload test_iam_permissions(request, options = nil)
            #   Pass arguments to `test_iam_permissions` via a request object, either of type
            #   {::Google::Iam::V1::TestIamPermissionsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Iam::V1::TestIamPermissionsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload test_iam_permissions(resource: nil, permissions: nil)
            #   Pass arguments to `test_iam_permissions` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param resource [::String]
            #     REQUIRED: The resource for which the policy detail is being requested.
            #     See the operation documentation for the appropriate value for this field.
            #   @param permissions [::Array<::String>]
            #     The set of permissions to check for the `resource`. Permissions with
            #     wildcards (such as '*' or 'storage.*') are not allowed. For more
            #     information see
            #     [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Iam::V1::TestIamPermissionsResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Iam::V1::TestIamPermissionsResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/resource_manager/v3"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::ResourceManager::V3::Projects::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Iam::V1::TestIamPermissionsRequest.new
            #
            #   # Call the test_iam_permissions method.
            #   result = client.test_iam_permissions request
            #
            #   # The returned object is of type Google::Iam::V1::TestIamPermissionsResponse.
            #   p result
            #
            def test_iam_permissions request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::TestIamPermissionsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.test_iam_permissions.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::ResourceManager::V3::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.resource
                header_params["resource"] = request.resource
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.test_iam_permissions.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.test_iam_permissions.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @projects_stub.call_rpc :test_iam_permissions, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the Projects API.
            #
            # This class represents the configuration for Projects,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::ResourceManager::V3::Projects::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # get_project to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::ResourceManager::V3::Projects::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.get_project.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::ResourceManager::V3::Projects::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.get_project.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::ResourceManager::V3::Projects::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "cloudresourcemanager.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the Projects API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `get_project`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_project
                ##
                # RPC-specific configuration for `list_projects`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_projects
                ##
                # RPC-specific configuration for `search_projects`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :search_projects
                ##
                # RPC-specific configuration for `create_project`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_project
                ##
                # RPC-specific configuration for `update_project`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_project
                ##
                # RPC-specific configuration for `move_project`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :move_project
                ##
                # RPC-specific configuration for `delete_project`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_project
                ##
                # RPC-specific configuration for `undelete_project`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :undelete_project
                ##
                # RPC-specific configuration for `get_iam_policy`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_iam_policy
                ##
                # RPC-specific configuration for `set_iam_policy`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :set_iam_policy
                ##
                # RPC-specific configuration for `test_iam_permissions`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :test_iam_permissions

                # @private
                def initialize parent_rpcs = nil
                  get_project_config = parent_rpcs.get_project if parent_rpcs.respond_to? :get_project
                  @get_project = ::Gapic::Config::Method.new get_project_config
                  list_projects_config = parent_rpcs.list_projects if parent_rpcs.respond_to? :list_projects
                  @list_projects = ::Gapic::Config::Method.new list_projects_config
                  search_projects_config = parent_rpcs.search_projects if parent_rpcs.respond_to? :search_projects
                  @search_projects = ::Gapic::Config::Method.new search_projects_config
                  create_project_config = parent_rpcs.create_project if parent_rpcs.respond_to? :create_project
                  @create_project = ::Gapic::Config::Method.new create_project_config
                  update_project_config = parent_rpcs.update_project if parent_rpcs.respond_to? :update_project
                  @update_project = ::Gapic::Config::Method.new update_project_config
                  move_project_config = parent_rpcs.move_project if parent_rpcs.respond_to? :move_project
                  @move_project = ::Gapic::Config::Method.new move_project_config
                  delete_project_config = parent_rpcs.delete_project if parent_rpcs.respond_to? :delete_project
                  @delete_project = ::Gapic::Config::Method.new delete_project_config
                  undelete_project_config = parent_rpcs.undelete_project if parent_rpcs.respond_to? :undelete_project
                  @undelete_project = ::Gapic::Config::Method.new undelete_project_config
                  get_iam_policy_config = parent_rpcs.get_iam_policy if parent_rpcs.respond_to? :get_iam_policy
                  @get_iam_policy = ::Gapic::Config::Method.new get_iam_policy_config
                  set_iam_policy_config = parent_rpcs.set_iam_policy if parent_rpcs.respond_to? :set_iam_policy
                  @set_iam_policy = ::Gapic::Config::Method.new set_iam_policy_config
                  test_iam_permissions_config = parent_rpcs.test_iam_permissions if parent_rpcs.respond_to? :test_iam_permissions
                  @test_iam_permissions = ::Gapic::Config::Method.new test_iam_permissions_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
