# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/resourcemanager/v3/folders_pb"
require "google/cloud/resource_manager/v3/folders/rest/service_stub"

module Google
  module Cloud
    module ResourceManager
      module V3
        module Folders
          module Rest
            ##
            # REST client for the Folders service.
            #
            # Manages Cloud Platform folder resources.
            # Folders can be used to organize the resources under an
            # organization and to control the policies applied to groups of resources.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "cloudresourcemanager.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :folders_stub

              ##
              # Configure the Folders Client class.
              #
              # See {::Google::Cloud::ResourceManager::V3::Folders::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all Folders clients
              #   ::Google::Cloud::ResourceManager::V3::Folders::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "ResourceManager", "V3"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.rpcs.get_folder.timeout = 60.0
                  default_config.rpcs.get_folder.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.list_folders.timeout = 60.0
                  default_config.rpcs.list_folders.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.search_folders.timeout = 60.0

                  default_config.rpcs.create_folder.timeout = 60.0

                  default_config.rpcs.update_folder.timeout = 60.0

                  default_config.rpcs.move_folder.timeout = 60.0

                  default_config.rpcs.delete_folder.timeout = 60.0

                  default_config.rpcs.undelete_folder.timeout = 60.0

                  default_config.rpcs.get_iam_policy.timeout = 60.0
                  default_config.rpcs.get_iam_policy.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.set_iam_policy.timeout = 60.0

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the Folders Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::ResourceManager::V3::Folders::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @folders_stub.universe_domain
              end

              ##
              # Create a new Folders REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::ResourceManager::V3::Folders::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::ResourceManager::V3::Folders::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Folders client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = ::Google::Cloud::ResourceManager::V3::Folders::Rest::Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @folders_stub = ::Google::Cloud::ResourceManager::V3::Folders::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @folders_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::ResourceManager::V3::Folders::Rest::Operations]
              #
              attr_reader :operations_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @folders_stub.logger
              end

              # Service calls

              ##
              # Retrieves a folder identified by the supplied resource name.
              # Valid folder resource names have the format `folders/{folder_id}`
              # (for example, `folders/1234`).
              # The caller must have `resourcemanager.folders.get` permission on the
              # identified folder.
              #
              # @overload get_folder(request, options = nil)
              #   Pass arguments to `get_folder` via a request object, either of type
              #   {::Google::Cloud::ResourceManager::V3::GetFolderRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ResourceManager::V3::GetFolderRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_folder(name: nil)
              #   Pass arguments to `get_folder` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the folder to retrieve.
              #     Must be of the form `folders/{folder_id}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::ResourceManager::V3::Folder]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::ResourceManager::V3::Folder]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/resource_manager/v3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ResourceManager::V3::Folders::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ResourceManager::V3::GetFolderRequest.new
              #
              #   # Call the get_folder method.
              #   result = client.get_folder request
              #
              #   # The returned object is of type Google::Cloud::ResourceManager::V3::Folder.
              #   p result
              #
              def get_folder request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ResourceManager::V3::GetFolderRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_folder.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ResourceManager::V3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_folder.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_folder.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @folders_stub.get_folder request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists the folders that are direct descendants of supplied parent resource.
              # `list()` provides a strongly consistent view of the folders underneath
              # the specified parent resource.
              # `list()` returns folders sorted based upon the (ascending) lexical ordering
              # of their display_name.
              # The caller must have `resourcemanager.folders.list` permission on the
              # identified parent.
              #
              # @overload list_folders(request, options = nil)
              #   Pass arguments to `list_folders` via a request object, either of type
              #   {::Google::Cloud::ResourceManager::V3::ListFoldersRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ResourceManager::V3::ListFoldersRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_folders(parent: nil, page_size: nil, page_token: nil, show_deleted: nil)
              #   Pass arguments to `list_folders` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The name of the parent resource whose folders are being listed.
              #     Only children of this parent resource are listed; descendants are not
              #     listed.
              #
              #     If the parent is a folder, use the value `folders/{folder_id}`. If the
              #     parent is an organization, use the value `organizations/{org_id}`.
              #
              #     Access to this method is controlled by checking the
              #     `resourcemanager.folders.list` permission on the `parent`.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of folders to return in the response. The
              #     server can return fewer folders than requested. If unspecified, server
              #     picks an appropriate default.
              #   @param page_token [::String]
              #     Optional. A pagination token returned from a previous call to `ListFolders`
              #     that indicates where this listing should continue from.
              #   @param show_deleted [::Boolean]
              #     Optional. Controls whether folders in the
              #     {::Google::Cloud::ResourceManager::V3::Folder::State::DELETE_REQUESTED DELETE_REQUESTED}
              #     state should be returned. Defaults to false.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ResourceManager::V3::Folder>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ResourceManager::V3::Folder>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/resource_manager/v3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ResourceManager::V3::Folders::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ResourceManager::V3::ListFoldersRequest.new
              #
              #   # Call the list_folders method.
              #   result = client.list_folders request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::ResourceManager::V3::Folder.
              #     p item
              #   end
              #
              def list_folders request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ResourceManager::V3::ListFoldersRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_folders.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ResourceManager::V3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_folders.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_folders.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @folders_stub.list_folders request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @folders_stub, :list_folders, "folders", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Search for folders that match specific filter criteria.
              # `search()` provides an eventually consistent view of the folders a user has
              # access to which meet the specified filter criteria.
              #
              # This will only return folders on which the caller has the
              # permission `resourcemanager.folders.get`.
              #
              # @overload search_folders(request, options = nil)
              #   Pass arguments to `search_folders` via a request object, either of type
              #   {::Google::Cloud::ResourceManager::V3::SearchFoldersRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ResourceManager::V3::SearchFoldersRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload search_folders(page_size: nil, page_token: nil, query: nil)
              #   Pass arguments to `search_folders` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param page_size [::Integer]
              #     Optional. The maximum number of folders to return in the response. The
              #     server can return fewer folders than requested. If unspecified, server
              #     picks an appropriate default.
              #   @param page_token [::String]
              #     Optional. A pagination token returned from a previous call to
              #     `SearchFolders` that indicates from where search should continue.
              #   @param query [::String]
              #     Optional. Search criteria used to select the folders to return.
              #     If no search criteria is specified then all accessible folders will be
              #     returned.
              #
              #     Query expressions can be used to restrict results based upon displayName,
              #     state and parent, where the operators `=` (`:`) `NOT`, `AND` and `OR`
              #     can be used along with the suffix wildcard symbol `*`.
              #
              #     The `displayName` field in a query expression should use escaped quotes
              #     for values that include whitespace to prevent unexpected behavior.
              #
              #     ```
              #     | Field                   | Description                            |
              #     |-------------------------|----------------------------------------|
              #     | displayName             | Filters by displayName.                |
              #     | parent                  | Filters by parent (for example: folders/123). |
              #     | state, lifecycleState   | Filters by state.                      |
              #     ```
              #
              #     Some example queries are:
              #
              #     * Query `displayName=Test*` returns Folder resources whose display name
              #     starts with "Test".
              #     * Query `state=ACTIVE` returns Folder resources with
              #     `state` set to `ACTIVE`.
              #     * Query `parent=folders/123` returns Folder resources that have
              #     `folders/123` as a parent resource.
              #     * Query `parent=folders/123 AND state=ACTIVE` returns active
              #     Folder resources that have `folders/123` as a parent resource.
              #     * Query `displayName=\\"Test String\\"` returns Folder resources with
              #     display names that include both "Test" and "String".
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ResourceManager::V3::Folder>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::ResourceManager::V3::Folder>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/resource_manager/v3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ResourceManager::V3::Folders::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ResourceManager::V3::SearchFoldersRequest.new
              #
              #   # Call the search_folders method.
              #   result = client.search_folders request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::ResourceManager::V3::Folder.
              #     p item
              #   end
              #
              def search_folders request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ResourceManager::V3::SearchFoldersRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.search_folders.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ResourceManager::V3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.search_folders.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.search_folders.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @folders_stub.search_folders request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @folders_stub, :search_folders, "folders", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a folder in the resource hierarchy.
              # Returns an `Operation` which can be used to track the progress of the
              # folder creation workflow.
              # Upon success, the `Operation.response` field will be populated with the
              # created Folder.
              #
              # In order to succeed, the addition of this new folder must not violate
              # the folder naming, height, or fanout constraints.
              #
              # + The folder's `display_name` must be distinct from all other folders that
              # share its parent.
              # + The addition of the folder must not cause the active folder hierarchy
              # to exceed a height of 10. Note, the full active + deleted folder hierarchy
              # is allowed to reach a height of 20; this provides additional headroom when
              # moving folders that contain deleted folders.
              # + The addition of the folder must not cause the total number of folders
              # under its parent to exceed 300.
              #
              # If the operation fails due to a folder constraint violation, some errors
              # may be returned by the `CreateFolder` request, with status code
              # `FAILED_PRECONDITION` and an error description. Other folder constraint
              # violations will be communicated in the `Operation`, with the specific
              # `PreconditionFailure` returned in the details list in the `Operation.error`
              # field.
              #
              # The caller must have `resourcemanager.folders.create` permission on the
              # identified parent.
              #
              # @overload create_folder(request, options = nil)
              #   Pass arguments to `create_folder` via a request object, either of type
              #   {::Google::Cloud::ResourceManager::V3::CreateFolderRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ResourceManager::V3::CreateFolderRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_folder(folder: nil)
              #   Pass arguments to `create_folder` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param folder [::Google::Cloud::ResourceManager::V3::Folder, ::Hash]
              #     Required. The folder being created, only the display name and parent will
              #     be consulted. All other fields will be ignored.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/resource_manager/v3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ResourceManager::V3::Folders::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ResourceManager::V3::CreateFolderRequest.new
              #
              #   # Call the create_folder method.
              #   result = client.create_folder request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_folder request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ResourceManager::V3::CreateFolderRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_folder.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ResourceManager::V3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_folder.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_folder.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @folders_stub.create_folder request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a folder, changing its `display_name`.
              # Changes to the folder `display_name` will be rejected if they violate
              # either the `display_name` formatting rules or the naming constraints
              # described in the
              # {::Google::Cloud::ResourceManager::V3::Folders::Rest::Client#create_folder CreateFolder}
              # documentation.
              #
              # The folder's `display_name` must start and end with a letter or digit,
              # may contain letters, digits, spaces, hyphens and underscores and can be
              # between 3 and 30 characters. This is captured by the regular expression:
              # `[\p{L}\p{N}][\p{L}\p{N}_- ]{1,28}[\p{L}\p{N}]`.
              # The caller must have `resourcemanager.folders.update` permission on the
              # identified folder.
              #
              # If the update fails due to the unique name constraint then a
              # `PreconditionFailure` explaining this violation will be returned
              # in the Status.details field.
              #
              # @overload update_folder(request, options = nil)
              #   Pass arguments to `update_folder` via a request object, either of type
              #   {::Google::Cloud::ResourceManager::V3::UpdateFolderRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ResourceManager::V3::UpdateFolderRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_folder(folder: nil, update_mask: nil)
              #   Pass arguments to `update_folder` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param folder [::Google::Cloud::ResourceManager::V3::Folder, ::Hash]
              #     Required. The new definition of the Folder. It must include the `name`
              #     field, which cannot be changed.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. Fields to be updated.
              #     Only the `display_name` can be updated.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/resource_manager/v3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ResourceManager::V3::Folders::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ResourceManager::V3::UpdateFolderRequest.new
              #
              #   # Call the update_folder method.
              #   result = client.update_folder request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_folder request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ResourceManager::V3::UpdateFolderRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_folder.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ResourceManager::V3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_folder.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_folder.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @folders_stub.update_folder request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Moves a folder under a new resource parent.
              # Returns an `Operation` which can be used to track the progress of the
              # folder move workflow.
              # Upon success, the `Operation.response` field will be populated with the
              # moved folder.
              # Upon failure, a `FolderOperationError` categorizing the failure cause will
              # be returned - if the failure occurs synchronously then the
              # `FolderOperationError` will be returned in the `Status.details` field.
              # If it occurs asynchronously, then the FolderOperation will be returned
              # in the `Operation.error` field.
              # In addition, the `Operation.metadata` field will be populated with a
              # `FolderOperation` message as an aid to stateless clients.
              # Folder moves will be rejected if they violate either the naming, height,
              # or fanout constraints described in the
              # {::Google::Cloud::ResourceManager::V3::Folders::Rest::Client#create_folder CreateFolder}
              # documentation. The caller must have `resourcemanager.folders.move`
              # permission on the folder's current and proposed new parent.
              #
              # @overload move_folder(request, options = nil)
              #   Pass arguments to `move_folder` via a request object, either of type
              #   {::Google::Cloud::ResourceManager::V3::MoveFolderRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ResourceManager::V3::MoveFolderRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload move_folder(name: nil, destination_parent: nil)
              #   Pass arguments to `move_folder` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the Folder to move.
              #     Must be of the form folders/\\{folder_id}
              #   @param destination_parent [::String]
              #     Required. The resource name of the folder or organization which should be
              #     the folder's new parent. Must be of the form `folders/{folder_id}` or
              #     `organizations/{org_id}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/resource_manager/v3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ResourceManager::V3::Folders::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ResourceManager::V3::MoveFolderRequest.new
              #
              #   # Call the move_folder method.
              #   result = client.move_folder request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def move_folder request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ResourceManager::V3::MoveFolderRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.move_folder.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ResourceManager::V3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.move_folder.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.move_folder.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @folders_stub.move_folder request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Requests deletion of a folder. The folder is moved into the
              # {::Google::Cloud::ResourceManager::V3::Folder::State::DELETE_REQUESTED DELETE_REQUESTED}
              # state immediately, and is deleted approximately 30 days later. This method
              # may only be called on an empty folder, where a folder is empty if it
              # doesn't contain any folders or projects in the
              # {::Google::Cloud::ResourceManager::V3::Folder::State::ACTIVE ACTIVE} state. If
              # called on a folder in
              # {::Google::Cloud::ResourceManager::V3::Folder::State::DELETE_REQUESTED DELETE_REQUESTED}
              # state the operation will result in a no-op success.
              # The caller must have `resourcemanager.folders.delete` permission on the
              # identified folder.
              #
              # @overload delete_folder(request, options = nil)
              #   Pass arguments to `delete_folder` via a request object, either of type
              #   {::Google::Cloud::ResourceManager::V3::DeleteFolderRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ResourceManager::V3::DeleteFolderRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_folder(name: nil)
              #   Pass arguments to `delete_folder` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the folder to be deleted.
              #     Must be of the form `folders/{folder_id}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/resource_manager/v3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ResourceManager::V3::Folders::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ResourceManager::V3::DeleteFolderRequest.new
              #
              #   # Call the delete_folder method.
              #   result = client.delete_folder request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_folder request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ResourceManager::V3::DeleteFolderRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_folder.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ResourceManager::V3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_folder.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_folder.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @folders_stub.delete_folder request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Cancels the deletion request for a folder. This method may be called on a
              # folder in any state. If the folder is in the
              # {::Google::Cloud::ResourceManager::V3::Folder::State::ACTIVE ACTIVE} state the
              # result will be a no-op success. In order to succeed, the folder's parent
              # must be in the
              # {::Google::Cloud::ResourceManager::V3::Folder::State::ACTIVE ACTIVE} state. In
              # addition, reintroducing the folder into the tree must not violate folder
              # naming, height, and fanout constraints described in the
              # {::Google::Cloud::ResourceManager::V3::Folders::Rest::Client#create_folder CreateFolder}
              # documentation. The caller must have `resourcemanager.folders.undelete`
              # permission on the identified folder.
              #
              # @overload undelete_folder(request, options = nil)
              #   Pass arguments to `undelete_folder` via a request object, either of type
              #   {::Google::Cloud::ResourceManager::V3::UndeleteFolderRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::ResourceManager::V3::UndeleteFolderRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload undelete_folder(name: nil)
              #   Pass arguments to `undelete_folder` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the folder to undelete.
              #     Must be of the form `folders/{folder_id}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/resource_manager/v3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ResourceManager::V3::Folders::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::ResourceManager::V3::UndeleteFolderRequest.new
              #
              #   # Call the undelete_folder method.
              #   result = client.undelete_folder request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def undelete_folder request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::ResourceManager::V3::UndeleteFolderRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.undelete_folder.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ResourceManager::V3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.undelete_folder.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.undelete_folder.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @folders_stub.undelete_folder request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the access control policy for a folder. The returned policy may be
              # empty if no such policy or resource exists. The `resource` field should
              # be the folder's resource name, for example: "folders/1234".
              # The caller must have `resourcemanager.folders.getIamPolicy` permission
              # on the identified folder.
              #
              # @overload get_iam_policy(request, options = nil)
              #   Pass arguments to `get_iam_policy` via a request object, either of type
              #   {::Google::Iam::V1::GetIamPolicyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Iam::V1::GetIamPolicyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_iam_policy(resource: nil, options: nil)
              #   Pass arguments to `get_iam_policy` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param resource [::String]
              #     REQUIRED: The resource for which the policy is being requested.
              #     See the operation documentation for the appropriate value for this field.
              #   @param options [::Google::Iam::V1::GetPolicyOptions, ::Hash]
              #     OPTIONAL: A `GetPolicyOptions` object for specifying options to
              #     `GetIamPolicy`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Iam::V1::Policy]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Iam::V1::Policy]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/resource_manager/v3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ResourceManager::V3::Folders::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Iam::V1::GetIamPolicyRequest.new
              #
              #   # Call the get_iam_policy method.
              #   result = client.get_iam_policy request
              #
              #   # The returned object is of type Google::Iam::V1::Policy.
              #   p result
              #
              def get_iam_policy request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::GetIamPolicyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_iam_policy.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ResourceManager::V3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_iam_policy.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_iam_policy.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @folders_stub.get_iam_policy request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Sets the access control policy on a folder, replacing any existing policy.
              # The `resource` field should be the folder's resource name, for example:
              # "folders/1234".
              # The caller must have `resourcemanager.folders.setIamPolicy` permission
              # on the identified folder.
              #
              # @overload set_iam_policy(request, options = nil)
              #   Pass arguments to `set_iam_policy` via a request object, either of type
              #   {::Google::Iam::V1::SetIamPolicyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Iam::V1::SetIamPolicyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload set_iam_policy(resource: nil, policy: nil, update_mask: nil)
              #   Pass arguments to `set_iam_policy` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param resource [::String]
              #     REQUIRED: The resource for which the policy is being specified.
              #     See the operation documentation for the appropriate value for this field.
              #   @param policy [::Google::Iam::V1::Policy, ::Hash]
              #     REQUIRED: The complete policy to be applied to the `resource`. The size of
              #     the policy is limited to a few 10s of KB. An empty policy is a
              #     valid policy but certain Cloud Platform services (such as Projects)
              #     might reject them.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     OPTIONAL: A FieldMask specifying which fields of the policy to modify. Only
              #     the fields in the mask will be modified. If no mask is provided, the
              #     following default mask is used:
              #
              #     `paths: "bindings, etag"`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Iam::V1::Policy]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Iam::V1::Policy]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/resource_manager/v3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ResourceManager::V3::Folders::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Iam::V1::SetIamPolicyRequest.new
              #
              #   # Call the set_iam_policy method.
              #   result = client.set_iam_policy request
              #
              #   # The returned object is of type Google::Iam::V1::Policy.
              #   p result
              #
              def set_iam_policy request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::SetIamPolicyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.set_iam_policy.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ResourceManager::V3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.set_iam_policy.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.set_iam_policy.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @folders_stub.set_iam_policy request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns permissions that a caller has on the specified folder.
              # The `resource` field should be the folder's resource name,
              # for example: "folders/1234".
              #
              # There are no permissions required for making this API call.
              #
              # @overload test_iam_permissions(request, options = nil)
              #   Pass arguments to `test_iam_permissions` via a request object, either of type
              #   {::Google::Iam::V1::TestIamPermissionsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Iam::V1::TestIamPermissionsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload test_iam_permissions(resource: nil, permissions: nil)
              #   Pass arguments to `test_iam_permissions` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param resource [::String]
              #     REQUIRED: The resource for which the policy detail is being requested.
              #     See the operation documentation for the appropriate value for this field.
              #   @param permissions [::Array<::String>]
              #     The set of permissions to check for the `resource`. Permissions with
              #     wildcards (such as '*' or 'storage.*') are not allowed. For more
              #     information see
              #     [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Iam::V1::TestIamPermissionsResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Iam::V1::TestIamPermissionsResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/resource_manager/v3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::ResourceManager::V3::Folders::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Iam::V1::TestIamPermissionsRequest.new
              #
              #   # Call the test_iam_permissions method.
              #   result = client.test_iam_permissions request
              #
              #   # The returned object is of type Google::Iam::V1::TestIamPermissionsResponse.
              #   p result
              #
              def test_iam_permissions request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::TestIamPermissionsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.test_iam_permissions.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::ResourceManager::V3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.test_iam_permissions.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.test_iam_permissions.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @folders_stub.test_iam_permissions request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the Folders REST API.
              #
              # This class represents the configuration for Folders REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::ResourceManager::V3::Folders::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # get_folder to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::ResourceManager::V3::Folders::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.get_folder.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::ResourceManager::V3::Folders::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.get_folder.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "cloudresourcemanager.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the Folders API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `get_folder`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_folder
                  ##
                  # RPC-specific configuration for `list_folders`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_folders
                  ##
                  # RPC-specific configuration for `search_folders`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :search_folders
                  ##
                  # RPC-specific configuration for `create_folder`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_folder
                  ##
                  # RPC-specific configuration for `update_folder`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_folder
                  ##
                  # RPC-specific configuration for `move_folder`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :move_folder
                  ##
                  # RPC-specific configuration for `delete_folder`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_folder
                  ##
                  # RPC-specific configuration for `undelete_folder`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :undelete_folder
                  ##
                  # RPC-specific configuration for `get_iam_policy`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_iam_policy
                  ##
                  # RPC-specific configuration for `set_iam_policy`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :set_iam_policy
                  ##
                  # RPC-specific configuration for `test_iam_permissions`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :test_iam_permissions

                  # @private
                  def initialize parent_rpcs = nil
                    get_folder_config = parent_rpcs.get_folder if parent_rpcs.respond_to? :get_folder
                    @get_folder = ::Gapic::Config::Method.new get_folder_config
                    list_folders_config = parent_rpcs.list_folders if parent_rpcs.respond_to? :list_folders
                    @list_folders = ::Gapic::Config::Method.new list_folders_config
                    search_folders_config = parent_rpcs.search_folders if parent_rpcs.respond_to? :search_folders
                    @search_folders = ::Gapic::Config::Method.new search_folders_config
                    create_folder_config = parent_rpcs.create_folder if parent_rpcs.respond_to? :create_folder
                    @create_folder = ::Gapic::Config::Method.new create_folder_config
                    update_folder_config = parent_rpcs.update_folder if parent_rpcs.respond_to? :update_folder
                    @update_folder = ::Gapic::Config::Method.new update_folder_config
                    move_folder_config = parent_rpcs.move_folder if parent_rpcs.respond_to? :move_folder
                    @move_folder = ::Gapic::Config::Method.new move_folder_config
                    delete_folder_config = parent_rpcs.delete_folder if parent_rpcs.respond_to? :delete_folder
                    @delete_folder = ::Gapic::Config::Method.new delete_folder_config
                    undelete_folder_config = parent_rpcs.undelete_folder if parent_rpcs.respond_to? :undelete_folder
                    @undelete_folder = ::Gapic::Config::Method.new undelete_folder_config
                    get_iam_policy_config = parent_rpcs.get_iam_policy if parent_rpcs.respond_to? :get_iam_policy
                    @get_iam_policy = ::Gapic::Config::Method.new get_iam_policy_config
                    set_iam_policy_config = parent_rpcs.set_iam_policy if parent_rpcs.respond_to? :set_iam_policy
                    @set_iam_policy = ::Gapic::Config::Method.new set_iam_policy_config
                    test_iam_permissions_config = parent_rpcs.test_iam_permissions if parent_rpcs.respond_to? :test_iam_permissions
                    @test_iam_permissions = ::Gapic::Config::Method.new test_iam_permissions_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
