# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/redis/v1/cloud_redis_pb"
require "google/cloud/location"

module Google
  module Cloud
    module Redis
      module V1
        module CloudRedis
          ##
          # Client for the CloudRedis service.
          #
          # Configures and manages Cloud Memorystore for Redis instances
          #
          # Google Cloud Memorystore for Redis v1
          #
          # The `redis.googleapis.com` service implements the Google Cloud Memorystore
          # for Redis API and defines the following resource model for managing Redis
          # instances:
          # * The service works with a collection of cloud projects, named: `/projects/*`
          # * Each project has a collection of available locations, named: `/locations/*`
          # * Each location has a collection of Redis instances, named: `/instances/*`
          # * As such, Redis instances are resources of the form:
          #   `/projects/{project_id}/locations/{location_id}/instances/{instance_id}`
          #
          # Note that location_id must be referring to a GCP `region`; for example:
          # * `projects/redpepper-1290/locations/us-central1/instances/my-redis`
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "redis.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :cloud_redis_stub

            ##
            # Configure the CloudRedis Client class.
            #
            # See {::Google::Cloud::Redis::V1::CloudRedis::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all CloudRedis clients
            #   ::Google::Cloud::Redis::V1::CloudRedis::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "Redis", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.rpcs.list_instances.timeout = 600.0

                default_config.rpcs.get_instance.timeout = 600.0

                default_config.rpcs.get_instance_auth_string.timeout = 600.0

                default_config.rpcs.create_instance.timeout = 600.0

                default_config.rpcs.update_instance.timeout = 600.0

                default_config.rpcs.upgrade_instance.timeout = 600.0

                default_config.rpcs.import_instance.timeout = 600.0

                default_config.rpcs.export_instance.timeout = 600.0

                default_config.rpcs.failover_instance.timeout = 600.0

                default_config.rpcs.delete_instance.timeout = 600.0

                default_config.rpcs.reschedule_maintenance.timeout = 600.0

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the CloudRedis Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::Redis::V1::CloudRedis::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @cloud_redis_stub.universe_domain
            end

            ##
            # Create a new CloudRedis client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::Redis::V1::CloudRedis::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::Redis::V1::CloudRedis::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the CloudRedis client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/redis/v1/cloud_redis_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @cloud_redis_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::Redis::V1::CloudRedis::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @cloud_redis_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @location_client = Google::Cloud::Location::Locations::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @cloud_redis_stub.endpoint
                config.universe_domain = @cloud_redis_stub.universe_domain
                config.logger = @cloud_redis_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Cloud::Redis::V1::CloudRedis::Operations]
            #
            attr_reader :operations_client

            ##
            # Get the associated client for mix-in of the Locations.
            #
            # @return [Google::Cloud::Location::Locations::Client]
            #
            attr_reader :location_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @cloud_redis_stub.logger
            end

            # Service calls

            ##
            # Lists all Redis instances owned by a project in either the specified
            # location (region) or all locations.
            #
            # The location should have the following format:
            #
            # * `projects/{project_id}/locations/{location_id}`
            #
            # If `location_id` is specified as `-` (wildcard), then all regions
            # available to the project are queried, and the results are aggregated.
            #
            # @overload list_instances(request, options = nil)
            #   Pass arguments to `list_instances` via a request object, either of type
            #   {::Google::Cloud::Redis::V1::ListInstancesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Redis::V1::ListInstancesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_instances(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_instances` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the instance location using the form:
            #         `projects/{project_id}/locations/{location_id}`
            #     where `location_id` refers to a GCP region.
            #   @param page_size [::Integer]
            #     The maximum number of items to return.
            #
            #     If not specified, a default value of 1000 will be used by the service.
            #     Regardless of the page_size value, the response may include a partial list
            #     and a caller should only rely on response's
            #     {::Google::Cloud::Redis::V1::ListInstancesResponse#next_page_token `next_page_token`}
            #     to determine if there are more instances left to be queried.
            #   @param page_token [::String]
            #     The `next_page_token` value returned from a previous
            #     {::Google::Cloud::Redis::V1::CloudRedis::Client#list_instances ListInstances} request, if
            #     any.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Redis::V1::Instance>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Redis::V1::Instance>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/redis/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Redis::V1::CloudRedis::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Redis::V1::ListInstancesRequest.new
            #
            #   # Call the list_instances method.
            #   result = client.list_instances request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Redis::V1::Instance.
            #     p item
            #   end
            #
            def list_instances request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Redis::V1::ListInstancesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_instances.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Redis::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_instances.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_instances.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cloud_redis_stub.call_rpc :list_instances, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @cloud_redis_stub, :list_instances, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets the details of a specific Redis instance.
            #
            # @overload get_instance(request, options = nil)
            #   Pass arguments to `get_instance` via a request object, either of type
            #   {::Google::Cloud::Redis::V1::GetInstanceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Redis::V1::GetInstanceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_instance(name: nil)
            #   Pass arguments to `get_instance` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Redis instance resource name using the form:
            #         `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
            #     where `location_id` refers to a GCP region.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Redis::V1::Instance]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Redis::V1::Instance]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/redis/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Redis::V1::CloudRedis::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Redis::V1::GetInstanceRequest.new
            #
            #   # Call the get_instance method.
            #   result = client.get_instance request
            #
            #   # The returned object is of type Google::Cloud::Redis::V1::Instance.
            #   p result
            #
            def get_instance request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Redis::V1::GetInstanceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_instance.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Redis::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_instance.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_instance.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cloud_redis_stub.call_rpc :get_instance, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets the AUTH string for a Redis instance. If AUTH is not enabled for the
            # instance the response will be empty. This information is not included in
            # the details returned to GetInstance.
            #
            # @overload get_instance_auth_string(request, options = nil)
            #   Pass arguments to `get_instance_auth_string` via a request object, either of type
            #   {::Google::Cloud::Redis::V1::GetInstanceAuthStringRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Redis::V1::GetInstanceAuthStringRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_instance_auth_string(name: nil)
            #   Pass arguments to `get_instance_auth_string` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Redis instance resource name using the form:
            #         `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
            #     where `location_id` refers to a GCP region.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Redis::V1::InstanceAuthString]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Redis::V1::InstanceAuthString]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/redis/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Redis::V1::CloudRedis::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Redis::V1::GetInstanceAuthStringRequest.new
            #
            #   # Call the get_instance_auth_string method.
            #   result = client.get_instance_auth_string request
            #
            #   # The returned object is of type Google::Cloud::Redis::V1::InstanceAuthString.
            #   p result
            #
            def get_instance_auth_string request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Redis::V1::GetInstanceAuthStringRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_instance_auth_string.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Redis::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_instance_auth_string.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_instance_auth_string.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cloud_redis_stub.call_rpc :get_instance_auth_string, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a Redis instance based on the specified tier and memory size.
            #
            # By default, the instance is accessible from the project's
            # [default network](https://cloud.google.com/vpc/docs/vpc).
            #
            # The creation is executed asynchronously and callers may check the returned
            # operation to track its progress. Once the operation is completed the Redis
            # instance will be fully functional. Completed longrunning.Operation will
            # contain the new instance object in the response field.
            #
            # The returned operation is automatically deleted after a few hours, so there
            # is no need to call DeleteOperation.
            #
            # @overload create_instance(request, options = nil)
            #   Pass arguments to `create_instance` via a request object, either of type
            #   {::Google::Cloud::Redis::V1::CreateInstanceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Redis::V1::CreateInstanceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_instance(parent: nil, instance_id: nil, instance: nil)
            #   Pass arguments to `create_instance` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the instance location using the form:
            #         `projects/{project_id}/locations/{location_id}`
            #     where `location_id` refers to a GCP region.
            #   @param instance_id [::String]
            #     Required. The logical name of the Redis instance in the customer project
            #     with the following restrictions:
            #
            #     * Must contain only lowercase letters, numbers, and hyphens.
            #     * Must start with a letter.
            #     * Must be between 1-40 characters.
            #     * Must end with a number or a letter.
            #     * Must be unique within the customer project / location
            #   @param instance [::Google::Cloud::Redis::V1::Instance, ::Hash]
            #     Required. A Redis [Instance] resource
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/redis/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Redis::V1::CloudRedis::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Redis::V1::CreateInstanceRequest.new
            #
            #   # Call the create_instance method.
            #   result = client.create_instance request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_instance request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Redis::V1::CreateInstanceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_instance.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Redis::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_instance.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_instance.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cloud_redis_stub.call_rpc :create_instance, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the metadata and configuration of a specific Redis instance.
            #
            # Completed longrunning.Operation will contain the new instance object
            # in the response field. The returned operation is automatically deleted
            # after a few hours, so there is no need to call DeleteOperation.
            #
            # @overload update_instance(request, options = nil)
            #   Pass arguments to `update_instance` via a request object, either of type
            #   {::Google::Cloud::Redis::V1::UpdateInstanceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Redis::V1::UpdateInstanceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_instance(update_mask: nil, instance: nil)
            #   Pass arguments to `update_instance` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. Mask of fields to update. At least one path must be supplied in
            #     this field. The elements of the repeated paths field may only include these
            #     fields from {::Google::Cloud::Redis::V1::Instance Instance}:
            #
            #      *   `displayName`
            #      *   `labels`
            #      *   `memorySizeGb`
            #      *   `redisConfig`
            #      *   `replica_count`
            #   @param instance [::Google::Cloud::Redis::V1::Instance, ::Hash]
            #     Required. Update description.
            #     Only fields specified in update_mask are updated.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/redis/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Redis::V1::CloudRedis::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Redis::V1::UpdateInstanceRequest.new
            #
            #   # Call the update_instance method.
            #   result = client.update_instance request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_instance request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Redis::V1::UpdateInstanceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_instance.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Redis::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.instance&.name
                header_params["instance.name"] = request.instance.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_instance.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_instance.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cloud_redis_stub.call_rpc :update_instance, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Upgrades Redis instance to the newer Redis version specified in the
            # request.
            #
            # @overload upgrade_instance(request, options = nil)
            #   Pass arguments to `upgrade_instance` via a request object, either of type
            #   {::Google::Cloud::Redis::V1::UpgradeInstanceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Redis::V1::UpgradeInstanceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload upgrade_instance(name: nil, redis_version: nil)
            #   Pass arguments to `upgrade_instance` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Redis instance resource name using the form:
            #         `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
            #     where `location_id` refers to a GCP region.
            #   @param redis_version [::String]
            #     Required. Specifies the target version of Redis software to upgrade to.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/redis/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Redis::V1::CloudRedis::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Redis::V1::UpgradeInstanceRequest.new
            #
            #   # Call the upgrade_instance method.
            #   result = client.upgrade_instance request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def upgrade_instance request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Redis::V1::UpgradeInstanceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.upgrade_instance.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Redis::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.upgrade_instance.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.upgrade_instance.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cloud_redis_stub.call_rpc :upgrade_instance, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Import a Redis RDB snapshot file from Cloud Storage into a Redis instance.
            #
            # Redis may stop serving during this operation. Instance state will be
            # IMPORTING for entire operation. When complete, the instance will contain
            # only data from the imported file.
            #
            # The returned operation is automatically deleted after a few hours, so
            # there is no need to call DeleteOperation.
            #
            # @overload import_instance(request, options = nil)
            #   Pass arguments to `import_instance` via a request object, either of type
            #   {::Google::Cloud::Redis::V1::ImportInstanceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Redis::V1::ImportInstanceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload import_instance(name: nil, input_config: nil)
            #   Pass arguments to `import_instance` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Redis instance resource name using the form:
            #         `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
            #     where `location_id` refers to a GCP region.
            #   @param input_config [::Google::Cloud::Redis::V1::InputConfig, ::Hash]
            #     Required. Specify data to be imported.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/redis/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Redis::V1::CloudRedis::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Redis::V1::ImportInstanceRequest.new
            #
            #   # Call the import_instance method.
            #   result = client.import_instance request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def import_instance request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Redis::V1::ImportInstanceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.import_instance.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Redis::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.import_instance.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.import_instance.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cloud_redis_stub.call_rpc :import_instance, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Export Redis instance data into a Redis RDB format file in Cloud Storage.
            #
            # Redis will continue serving during this operation.
            #
            # The returned operation is automatically deleted after a few hours, so
            # there is no need to call DeleteOperation.
            #
            # @overload export_instance(request, options = nil)
            #   Pass arguments to `export_instance` via a request object, either of type
            #   {::Google::Cloud::Redis::V1::ExportInstanceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Redis::V1::ExportInstanceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload export_instance(name: nil, output_config: nil)
            #   Pass arguments to `export_instance` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Redis instance resource name using the form:
            #         `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
            #     where `location_id` refers to a GCP region.
            #   @param output_config [::Google::Cloud::Redis::V1::OutputConfig, ::Hash]
            #     Required. Specify data to be exported.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/redis/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Redis::V1::CloudRedis::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Redis::V1::ExportInstanceRequest.new
            #
            #   # Call the export_instance method.
            #   result = client.export_instance request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def export_instance request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Redis::V1::ExportInstanceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.export_instance.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Redis::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.export_instance.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.export_instance.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cloud_redis_stub.call_rpc :export_instance, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Initiates a failover of the primary node to current replica node for a
            # specific STANDARD tier Cloud Memorystore for Redis instance.
            #
            # @overload failover_instance(request, options = nil)
            #   Pass arguments to `failover_instance` via a request object, either of type
            #   {::Google::Cloud::Redis::V1::FailoverInstanceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Redis::V1::FailoverInstanceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload failover_instance(name: nil, data_protection_mode: nil)
            #   Pass arguments to `failover_instance` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Redis instance resource name using the form:
            #         `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
            #     where `location_id` refers to a GCP region.
            #   @param data_protection_mode [::Google::Cloud::Redis::V1::FailoverInstanceRequest::DataProtectionMode]
            #     Optional. Available data protection modes that the user can choose. If it's
            #     unspecified, data protection mode will be LIMITED_DATA_LOSS by default.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/redis/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Redis::V1::CloudRedis::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Redis::V1::FailoverInstanceRequest.new
            #
            #   # Call the failover_instance method.
            #   result = client.failover_instance request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def failover_instance request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Redis::V1::FailoverInstanceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.failover_instance.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Redis::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.failover_instance.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.failover_instance.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cloud_redis_stub.call_rpc :failover_instance, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a specific Redis instance.  Instance stops serving and data is
            # deleted.
            #
            # @overload delete_instance(request, options = nil)
            #   Pass arguments to `delete_instance` via a request object, either of type
            #   {::Google::Cloud::Redis::V1::DeleteInstanceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Redis::V1::DeleteInstanceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_instance(name: nil)
            #   Pass arguments to `delete_instance` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Redis instance resource name using the form:
            #         `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
            #     where `location_id` refers to a GCP region.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/redis/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Redis::V1::CloudRedis::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Redis::V1::DeleteInstanceRequest.new
            #
            #   # Call the delete_instance method.
            #   result = client.delete_instance request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_instance request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Redis::V1::DeleteInstanceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_instance.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Redis::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_instance.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_instance.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cloud_redis_stub.call_rpc :delete_instance, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Reschedule maintenance for a given instance in a given project and
            # location.
            #
            # @overload reschedule_maintenance(request, options = nil)
            #   Pass arguments to `reschedule_maintenance` via a request object, either of type
            #   {::Google::Cloud::Redis::V1::RescheduleMaintenanceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Redis::V1::RescheduleMaintenanceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload reschedule_maintenance(name: nil, reschedule_type: nil, schedule_time: nil)
            #   Pass arguments to `reschedule_maintenance` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Redis instance resource name using the form:
            #         `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
            #     where `location_id` refers to a GCP region.
            #   @param reschedule_type [::Google::Cloud::Redis::V1::RescheduleMaintenanceRequest::RescheduleType]
            #     Required. If reschedule type is SPECIFIC_TIME, must set up schedule_time as
            #     well.
            #   @param schedule_time [::Google::Protobuf::Timestamp, ::Hash]
            #     Optional. Timestamp when the maintenance shall be rescheduled to if
            #     reschedule_type=SPECIFIC_TIME, in RFC 3339 format, for
            #     example `2012-11-15T16:19:00.094Z`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/redis/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Redis::V1::CloudRedis::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Redis::V1::RescheduleMaintenanceRequest.new
            #
            #   # Call the reschedule_maintenance method.
            #   result = client.reschedule_maintenance request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def reschedule_maintenance request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Redis::V1::RescheduleMaintenanceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.reschedule_maintenance.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Redis::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.reschedule_maintenance.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.reschedule_maintenance.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cloud_redis_stub.call_rpc :reschedule_maintenance, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the CloudRedis API.
            #
            # This class represents the configuration for CloudRedis,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::Redis::V1::CloudRedis::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # list_instances to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::Redis::V1::CloudRedis::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_instances.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::Redis::V1::CloudRedis::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_instances.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::Redis::V1::CloudRedis::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "redis.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the CloudRedis API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `list_instances`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_instances
                ##
                # RPC-specific configuration for `get_instance`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_instance
                ##
                # RPC-specific configuration for `get_instance_auth_string`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_instance_auth_string
                ##
                # RPC-specific configuration for `create_instance`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_instance
                ##
                # RPC-specific configuration for `update_instance`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_instance
                ##
                # RPC-specific configuration for `upgrade_instance`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :upgrade_instance
                ##
                # RPC-specific configuration for `import_instance`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :import_instance
                ##
                # RPC-specific configuration for `export_instance`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :export_instance
                ##
                # RPC-specific configuration for `failover_instance`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :failover_instance
                ##
                # RPC-specific configuration for `delete_instance`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_instance
                ##
                # RPC-specific configuration for `reschedule_maintenance`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :reschedule_maintenance

                # @private
                def initialize parent_rpcs = nil
                  list_instances_config = parent_rpcs.list_instances if parent_rpcs.respond_to? :list_instances
                  @list_instances = ::Gapic::Config::Method.new list_instances_config
                  get_instance_config = parent_rpcs.get_instance if parent_rpcs.respond_to? :get_instance
                  @get_instance = ::Gapic::Config::Method.new get_instance_config
                  get_instance_auth_string_config = parent_rpcs.get_instance_auth_string if parent_rpcs.respond_to? :get_instance_auth_string
                  @get_instance_auth_string = ::Gapic::Config::Method.new get_instance_auth_string_config
                  create_instance_config = parent_rpcs.create_instance if parent_rpcs.respond_to? :create_instance
                  @create_instance = ::Gapic::Config::Method.new create_instance_config
                  update_instance_config = parent_rpcs.update_instance if parent_rpcs.respond_to? :update_instance
                  @update_instance = ::Gapic::Config::Method.new update_instance_config
                  upgrade_instance_config = parent_rpcs.upgrade_instance if parent_rpcs.respond_to? :upgrade_instance
                  @upgrade_instance = ::Gapic::Config::Method.new upgrade_instance_config
                  import_instance_config = parent_rpcs.import_instance if parent_rpcs.respond_to? :import_instance
                  @import_instance = ::Gapic::Config::Method.new import_instance_config
                  export_instance_config = parent_rpcs.export_instance if parent_rpcs.respond_to? :export_instance
                  @export_instance = ::Gapic::Config::Method.new export_instance_config
                  failover_instance_config = parent_rpcs.failover_instance if parent_rpcs.respond_to? :failover_instance
                  @failover_instance = ::Gapic::Config::Method.new failover_instance_config
                  delete_instance_config = parent_rpcs.delete_instance if parent_rpcs.respond_to? :delete_instance
                  @delete_instance = ::Gapic::Config::Method.new delete_instance_config
                  reschedule_maintenance_config = parent_rpcs.reschedule_maintenance if parent_rpcs.respond_to? :reschedule_maintenance
                  @reschedule_maintenance = ::Gapic::Config::Method.new reschedule_maintenance_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
