# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/cloud/redis/cluster/v1beta1/cloud_redis_cluster.proto for package 'Google.Cloud.Redis.Cluster.V1beta1'
# Original file comments:
# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/cloud/redis/cluster/v1beta1/cloud_redis_cluster_pb'

module Google
  module Cloud
    module Redis
      module Cluster
        module V1beta1
          module CloudRedisCluster
            # Configures and manages Cloud Memorystore for Redis clusters
            #
            # Google Cloud Memorystore for Redis Cluster
            #
            # The `redis.googleapis.com` service implements the Google Cloud Memorystore
            # for Redis API and defines the following resource model for managing Redis
            # clusters:
            # * The service works with a collection of cloud projects, named: `/projects/*`
            # * Each project has a collection of available locations, named: `/locations/*`
            # * Each location has a collection of Redis clusters, named: `/clusters/*`
            # * As such, Redis clusters are resources of the form:
            #   `/projects/{project_id}/locations/{location_id}/clusters/{instance_id}`
            #
            # Note that location_id must be a GCP `region`; for example:
            # * `projects/redpepper-1290/locations/us-central1/clusters/my-redis`
            class Service

              include ::GRPC::GenericService

              self.marshal_class_method = :encode
              self.unmarshal_class_method = :decode
              self.service_name = 'google.cloud.redis.cluster.v1beta1.CloudRedisCluster'

              # Lists all Redis clusters owned by a project in either the specified
              # location (region) or all locations.
              #
              # The location should have the following format:
              #
              # * `projects/{project_id}/locations/{location_id}`
              #
              # If `location_id` is specified as `-` (wildcard), then all regions
              # available to the project are queried, and the results are aggregated.
              rpc :ListClusters, ::Google::Cloud::Redis::Cluster::V1beta1::ListClustersRequest, ::Google::Cloud::Redis::Cluster::V1beta1::ListClustersResponse
              # Gets the details of a specific Redis cluster.
              rpc :GetCluster, ::Google::Cloud::Redis::Cluster::V1beta1::GetClusterRequest, ::Google::Cloud::Redis::Cluster::V1beta1::Cluster
              # Updates the metadata and configuration of a specific Redis cluster.
              #
              # Completed longrunning.Operation will contain the new cluster object
              # in the response field. The returned operation is automatically deleted
              # after a few hours, so there is no need to call DeleteOperation.
              rpc :UpdateCluster, ::Google::Cloud::Redis::Cluster::V1beta1::UpdateClusterRequest, ::Google::Longrunning::Operation
              # Deletes a specific Redis cluster. Cluster stops serving and data is
              # deleted.
              rpc :DeleteCluster, ::Google::Cloud::Redis::Cluster::V1beta1::DeleteClusterRequest, ::Google::Longrunning::Operation
              # Creates a Redis cluster based on the specified properties.
              # The creation is executed asynchronously and callers may check the returned
              # operation to track its progress. Once the operation is completed the Redis
              # cluster will be fully functional. The completed longrunning.Operation will
              # contain the new cluster object in the response field.
              #
              # The returned operation is automatically deleted after a few hours, so there
              # is no need to call DeleteOperation.
              rpc :CreateCluster, ::Google::Cloud::Redis::Cluster::V1beta1::CreateClusterRequest, ::Google::Longrunning::Operation
              # Gets the details of certificate authority information for Redis cluster.
              rpc :GetClusterCertificateAuthority, ::Google::Cloud::Redis::Cluster::V1beta1::GetClusterCertificateAuthorityRequest, ::Google::Cloud::Redis::Cluster::V1beta1::CertificateAuthority
              # Reschedules upcoming maintenance event.
              rpc :RescheduleClusterMaintenance, ::Google::Cloud::Redis::Cluster::V1beta1::RescheduleClusterMaintenanceRequest, ::Google::Longrunning::Operation
              # Lists all backup collections owned by a consumer project in either the
              # specified location (region) or all locations.
              #
              # If `location_id` is specified as `-` (wildcard), then all regions
              # available to the project are queried, and the results are aggregated.
              rpc :ListBackupCollections, ::Google::Cloud::Redis::Cluster::V1beta1::ListBackupCollectionsRequest, ::Google::Cloud::Redis::Cluster::V1beta1::ListBackupCollectionsResponse
              # Get a backup collection.
              rpc :GetBackupCollection, ::Google::Cloud::Redis::Cluster::V1beta1::GetBackupCollectionRequest, ::Google::Cloud::Redis::Cluster::V1beta1::BackupCollection
              # Lists all backups owned by a backup collection.
              rpc :ListBackups, ::Google::Cloud::Redis::Cluster::V1beta1::ListBackupsRequest, ::Google::Cloud::Redis::Cluster::V1beta1::ListBackupsResponse
              # Gets the details of a specific backup.
              rpc :GetBackup, ::Google::Cloud::Redis::Cluster::V1beta1::GetBackupRequest, ::Google::Cloud::Redis::Cluster::V1beta1::Backup
              # Deletes a specific backup.
              rpc :DeleteBackup, ::Google::Cloud::Redis::Cluster::V1beta1::DeleteBackupRequest, ::Google::Longrunning::Operation
              # Exports a specific backup to a customer target Cloud Storage URI.
              rpc :ExportBackup, ::Google::Cloud::Redis::Cluster::V1beta1::ExportBackupRequest, ::Google::Longrunning::Operation
              # Backup Redis Cluster.
              # If this is the first time a backup is being created, a backup collection
              # will be created at the backend, and this backup belongs to this collection.
              # Both collection and backup will have a resource name. Backup will be
              # executed for each shard. A replica (primary if nonHA) will be selected to
              # perform the execution. Backup call will be rejected if there is an ongoing
              # backup or update operation. Be aware that during preview, if the cluster's
              # internal software version is too old, critical update will be performed
              # before actual backup. Once the internal software version is updated to the
              # minimum version required by the backup feature, subsequent backups will not
              # require critical update. After preview, there will be no critical update
              # needed for backup.
              rpc :BackupCluster, ::Google::Cloud::Redis::Cluster::V1beta1::BackupClusterRequest, ::Google::Longrunning::Operation
            end

            Stub = Service.rpc_stub_class
          end
        end
      end
    end
  end
end
