# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/redis/cluster/v1beta1/cloud_redis_cluster_pb"
require "google/cloud/location"

module Google
  module Cloud
    module Redis
      module Cluster
        module V1beta1
          module CloudRedisCluster
            ##
            # Client for the CloudRedisCluster service.
            #
            # Configures and manages Cloud Memorystore for Redis clusters
            #
            # Google Cloud Memorystore for Redis Cluster
            #
            # The `redis.googleapis.com` service implements the Google Cloud Memorystore
            # for Redis API and defines the following resource model for managing Redis
            # clusters:
            # * The service works with a collection of cloud projects, named: `/projects/*`
            # * Each project has a collection of available locations, named: `/locations/*`
            # * Each location has a collection of Redis clusters, named: `/clusters/*`
            # * As such, Redis clusters are resources of the form:
            #   `/projects/{project_id}/locations/{location_id}/clusters/{instance_id}`
            #
            # Note that location_id must be a GCP `region`; for example:
            # * `projects/redpepper-1290/locations/us-central1/clusters/my-redis`
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "redis.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :cloud_redis_cluster_stub

              ##
              # Configure the CloudRedisCluster Client class.
              #
              # See {::Google::Cloud::Redis::Cluster::V1beta1::CloudRedisCluster::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all CloudRedisCluster clients
              #   ::Google::Cloud::Redis::Cluster::V1beta1::CloudRedisCluster::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "Redis", "Cluster", "V1beta1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.rpcs.list_clusters.timeout = 600.0

                  default_config.rpcs.get_cluster.timeout = 600.0

                  default_config.rpcs.update_cluster.timeout = 600.0

                  default_config.rpcs.delete_cluster.timeout = 600.0

                  default_config.rpcs.create_cluster.timeout = 600.0

                  default_config.rpcs.get_cluster_certificate_authority.timeout = 600.0

                  default_config.rpcs.reschedule_cluster_maintenance.timeout = 600.0

                  default_config.rpcs.list_backup_collections.timeout = 600.0

                  default_config.rpcs.get_backup_collection.timeout = 600.0

                  default_config.rpcs.list_backups.timeout = 600.0

                  default_config.rpcs.get_backup.timeout = 600.0

                  default_config.rpcs.delete_backup.timeout = 600.0

                  default_config.rpcs.export_backup.timeout = 600.0

                  default_config.rpcs.backup_cluster.timeout = 600.0

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the CloudRedisCluster Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::Redis::Cluster::V1beta1::CloudRedisCluster::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @cloud_redis_cluster_stub.universe_domain
              end

              ##
              # Create a new CloudRedisCluster client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::Redis::Cluster::V1beta1::CloudRedisCluster::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::Redis::Cluster::V1beta1::CloudRedisCluster::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the CloudRedisCluster client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # These require statements are intentionally placed here to initialize
                # the gRPC module only when it's required.
                # See https://github.com/googleapis/toolkit/issues/446
                require "gapic/grpc"
                require "google/cloud/redis/cluster/v1beta1/cloud_redis_cluster_services_pb"

                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end
                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @cloud_redis_cluster_stub = ::Gapic::ServiceStub.new(
                  ::Google::Cloud::Redis::Cluster::V1beta1::CloudRedisCluster::Stub,
                  credentials: credentials,
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  channel_args: @config.channel_args,
                  interceptors: @config.interceptors,
                  channel_pool_config: @config.channel_pool,
                  logger: @config.logger
                )

                @cloud_redis_cluster_stub.stub_logger&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @cloud_redis_cluster_stub.endpoint
                  config.universe_domain = @cloud_redis_cluster_stub.universe_domain
                  config.logger = @cloud_redis_cluster_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::Redis::Cluster::V1beta1::CloudRedisCluster::Operations]
              #
              attr_reader :operations_client

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Client]
              #
              attr_reader :location_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @cloud_redis_cluster_stub.logger
              end

              # Service calls

              ##
              # Lists all Redis clusters owned by a project in either the specified
              # location (region) or all locations.
              #
              # The location should have the following format:
              #
              # * `projects/{project_id}/locations/{location_id}`
              #
              # If `location_id` is specified as `-` (wildcard), then all regions
              # available to the project are queried, and the results are aggregated.
              #
              # @overload list_clusters(request, options = nil)
              #   Pass arguments to `list_clusters` via a request object, either of type
              #   {::Google::Cloud::Redis::Cluster::V1beta1::ListClustersRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Redis::Cluster::V1beta1::ListClustersRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload list_clusters(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_clusters` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the cluster location using the form:
              #         `projects/{project_id}/locations/{location_id}`
              #     where `location_id` refers to a GCP region.
              #   @param page_size [::Integer]
              #     The maximum number of items to return.
              #
              #     If not specified, a default value of 1000 will be used by the service.
              #     Regardless of the page_size value, the response may include a partial list
              #     and a caller should only rely on response's
              #     {::Google::Cloud::Redis::Cluster::V1beta1::ListClustersResponse#next_page_token `next_page_token`}
              #     to determine if there are more clusters left to be queried.
              #   @param page_token [::String]
              #     The `next_page_token` value returned from a previous
              #     [ListClusters][CloudRedis.ListClusters] request, if any.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Redis::Cluster::V1beta1::Cluster>]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::PagedEnumerable<::Google::Cloud::Redis::Cluster::V1beta1::Cluster>]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/redis/cluster/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Redis::Cluster::V1beta1::CloudRedisCluster::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Redis::Cluster::V1beta1::ListClustersRequest.new
              #
              #   # Call the list_clusters method.
              #   result = client.list_clusters request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Redis::Cluster::V1beta1::Cluster.
              #     p item
              #   end
              #
              def list_clusters request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Redis::Cluster::V1beta1::ListClustersRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.list_clusters.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Redis::Cluster::V1beta1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.list_clusters.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.list_clusters.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_redis_cluster_stub.call_rpc :list_clusters, request, options: options do |response, operation|
                  response = ::Gapic::PagedEnumerable.new @cloud_redis_cluster_stub, :list_clusters, request, response, operation, options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the details of a specific Redis cluster.
              #
              # @overload get_cluster(request, options = nil)
              #   Pass arguments to `get_cluster` via a request object, either of type
              #   {::Google::Cloud::Redis::Cluster::V1beta1::GetClusterRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Redis::Cluster::V1beta1::GetClusterRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_cluster(name: nil)
              #   Pass arguments to `get_cluster` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Redis cluster resource name using the form:
              #         `projects/{project_id}/locations/{location_id}/clusters/{cluster_id}`
              #     where `location_id` refers to a GCP region.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Redis::Cluster::V1beta1::Cluster]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Redis::Cluster::V1beta1::Cluster]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/redis/cluster/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Redis::Cluster::V1beta1::CloudRedisCluster::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Redis::Cluster::V1beta1::GetClusterRequest.new
              #
              #   # Call the get_cluster method.
              #   result = client.get_cluster request
              #
              #   # The returned object is of type Google::Cloud::Redis::Cluster::V1beta1::Cluster.
              #   p result
              #
              def get_cluster request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Redis::Cluster::V1beta1::GetClusterRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_cluster.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Redis::Cluster::V1beta1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_cluster.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_cluster.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_redis_cluster_stub.call_rpc :get_cluster, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the metadata and configuration of a specific Redis cluster.
              #
              # Completed longrunning.Operation will contain the new cluster object
              # in the response field. The returned operation is automatically deleted
              # after a few hours, so there is no need to call DeleteOperation.
              #
              # @overload update_cluster(request, options = nil)
              #   Pass arguments to `update_cluster` via a request object, either of type
              #   {::Google::Cloud::Redis::Cluster::V1beta1::UpdateClusterRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Redis::Cluster::V1beta1::UpdateClusterRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload update_cluster(update_mask: nil, cluster: nil, request_id: nil)
              #   Pass arguments to `update_cluster` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. Mask of fields to update. At least one path must be supplied in
              #     this field. The elements of the repeated paths field may only include these
              #     fields from {::Google::Cloud::Redis::Cluster::V1beta1::Cluster Cluster}:
              #
              #      *   `size_gb`
              #      *   `replica_count`
              #   @param cluster [::Google::Cloud::Redis::Cluster::V1beta1::Cluster, ::Hash]
              #     Required. Update description.
              #     Only fields specified in update_mask are updated.
              #   @param request_id [::String]
              #     Idempotent request UUID.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/redis/cluster/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Redis::Cluster::V1beta1::CloudRedisCluster::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Redis::Cluster::V1beta1::UpdateClusterRequest.new
              #
              #   # Call the update_cluster method.
              #   result = client.update_cluster request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_cluster request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Redis::Cluster::V1beta1::UpdateClusterRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.update_cluster.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Redis::Cluster::V1beta1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.cluster&.name
                  header_params["cluster.name"] = request.cluster.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.update_cluster.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.update_cluster.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_redis_cluster_stub.call_rpc :update_cluster, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a specific Redis cluster. Cluster stops serving and data is
              # deleted.
              #
              # @overload delete_cluster(request, options = nil)
              #   Pass arguments to `delete_cluster` via a request object, either of type
              #   {::Google::Cloud::Redis::Cluster::V1beta1::DeleteClusterRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Redis::Cluster::V1beta1::DeleteClusterRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload delete_cluster(name: nil, request_id: nil)
              #   Pass arguments to `delete_cluster` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Redis cluster resource name using the form:
              #         `projects/{project_id}/locations/{location_id}/clusters/{cluster_id}`
              #     where `location_id` refers to a GCP region.
              #   @param request_id [::String]
              #     Idempotent request UUID.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/redis/cluster/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Redis::Cluster::V1beta1::CloudRedisCluster::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Redis::Cluster::V1beta1::DeleteClusterRequest.new
              #
              #   # Call the delete_cluster method.
              #   result = client.delete_cluster request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_cluster request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Redis::Cluster::V1beta1::DeleteClusterRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.delete_cluster.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Redis::Cluster::V1beta1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.delete_cluster.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.delete_cluster.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_redis_cluster_stub.call_rpc :delete_cluster, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a Redis cluster based on the specified properties.
              # The creation is executed asynchronously and callers may check the returned
              # operation to track its progress. Once the operation is completed the Redis
              # cluster will be fully functional. The completed longrunning.Operation will
              # contain the new cluster object in the response field.
              #
              # The returned operation is automatically deleted after a few hours, so there
              # is no need to call DeleteOperation.
              #
              # @overload create_cluster(request, options = nil)
              #   Pass arguments to `create_cluster` via a request object, either of type
              #   {::Google::Cloud::Redis::Cluster::V1beta1::CreateClusterRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Redis::Cluster::V1beta1::CreateClusterRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload create_cluster(parent: nil, cluster_id: nil, cluster: nil, request_id: nil)
              #   Pass arguments to `create_cluster` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the cluster location using the form:
              #         `projects/{project_id}/locations/{location_id}`
              #     where `location_id` refers to a GCP region.
              #   @param cluster_id [::String]
              #     Required. The logical name of the Redis cluster in the customer project
              #     with the following restrictions:
              #
              #     * Must contain only lowercase letters, numbers, and hyphens.
              #     * Must start with a letter.
              #     * Must be between 1-63 characters.
              #     * Must end with a number or a letter.
              #     * Must be unique within the customer project / location
              #   @param cluster [::Google::Cloud::Redis::Cluster::V1beta1::Cluster, ::Hash]
              #     Required. The cluster that is to be created.
              #   @param request_id [::String]
              #     Idempotent request UUID.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/redis/cluster/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Redis::Cluster::V1beta1::CloudRedisCluster::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Redis::Cluster::V1beta1::CreateClusterRequest.new
              #
              #   # Call the create_cluster method.
              #   result = client.create_cluster request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_cluster request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Redis::Cluster::V1beta1::CreateClusterRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.create_cluster.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Redis::Cluster::V1beta1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.create_cluster.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.create_cluster.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_redis_cluster_stub.call_rpc :create_cluster, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the details of certificate authority information for Redis cluster.
              #
              # @overload get_cluster_certificate_authority(request, options = nil)
              #   Pass arguments to `get_cluster_certificate_authority` via a request object, either of type
              #   {::Google::Cloud::Redis::Cluster::V1beta1::GetClusterCertificateAuthorityRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Redis::Cluster::V1beta1::GetClusterCertificateAuthorityRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_cluster_certificate_authority(name: nil)
              #   Pass arguments to `get_cluster_certificate_authority` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Redis cluster certificate authority resource name using the form:
              #         `projects/{project_id}/locations/{location_id}/clusters/{cluster_id}/certificateAuthority`
              #     where `location_id` refers to a GCP region.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Redis::Cluster::V1beta1::CertificateAuthority]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Redis::Cluster::V1beta1::CertificateAuthority]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/redis/cluster/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Redis::Cluster::V1beta1::CloudRedisCluster::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Redis::Cluster::V1beta1::GetClusterCertificateAuthorityRequest.new
              #
              #   # Call the get_cluster_certificate_authority method.
              #   result = client.get_cluster_certificate_authority request
              #
              #   # The returned object is of type Google::Cloud::Redis::Cluster::V1beta1::CertificateAuthority.
              #   p result
              #
              def get_cluster_certificate_authority request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Redis::Cluster::V1beta1::GetClusterCertificateAuthorityRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_cluster_certificate_authority.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Redis::Cluster::V1beta1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_cluster_certificate_authority.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_cluster_certificate_authority.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_redis_cluster_stub.call_rpc :get_cluster_certificate_authority, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Reschedules upcoming maintenance event.
              #
              # @overload reschedule_cluster_maintenance(request, options = nil)
              #   Pass arguments to `reschedule_cluster_maintenance` via a request object, either of type
              #   {::Google::Cloud::Redis::Cluster::V1beta1::RescheduleClusterMaintenanceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Redis::Cluster::V1beta1::RescheduleClusterMaintenanceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload reschedule_cluster_maintenance(name: nil, reschedule_type: nil, schedule_time: nil)
              #   Pass arguments to `reschedule_cluster_maintenance` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Redis Cluster instance resource name using the form:
              #         `projects/{project_id}/locations/{location_id}/clusters/{cluster_id}`
              #     where `location_id` refers to a GCP region.
              #   @param reschedule_type [::Google::Cloud::Redis::Cluster::V1beta1::RescheduleClusterMaintenanceRequest::RescheduleType]
              #     Required. If reschedule type is SPECIFIC_TIME, must set up schedule_time as
              #     well.
              #   @param schedule_time [::Google::Protobuf::Timestamp, ::Hash]
              #     Optional. Timestamp when the maintenance shall be rescheduled to if
              #     reschedule_type=SPECIFIC_TIME, in RFC 3339 format, for
              #     example `2012-11-15T16:19:00.094Z`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/redis/cluster/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Redis::Cluster::V1beta1::CloudRedisCluster::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Redis::Cluster::V1beta1::RescheduleClusterMaintenanceRequest.new
              #
              #   # Call the reschedule_cluster_maintenance method.
              #   result = client.reschedule_cluster_maintenance request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def reschedule_cluster_maintenance request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Redis::Cluster::V1beta1::RescheduleClusterMaintenanceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.reschedule_cluster_maintenance.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Redis::Cluster::V1beta1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.reschedule_cluster_maintenance.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.reschedule_cluster_maintenance.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_redis_cluster_stub.call_rpc :reschedule_cluster_maintenance, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all backup collections owned by a consumer project in either the
              # specified location (region) or all locations.
              #
              # If `location_id` is specified as `-` (wildcard), then all regions
              # available to the project are queried, and the results are aggregated.
              #
              # @overload list_backup_collections(request, options = nil)
              #   Pass arguments to `list_backup_collections` via a request object, either of type
              #   {::Google::Cloud::Redis::Cluster::V1beta1::ListBackupCollectionsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Redis::Cluster::V1beta1::ListBackupCollectionsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload list_backup_collections(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_backup_collections` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the backupCollection location using the
              #     form:
              #         `projects/{project_id}/locations/{location_id}`
              #     where `location_id` refers to a GCP region.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of items to return.
              #
              #     If not specified, a default value of 1000 will be used by the service.
              #     Regardless of the page_size value, the response may include a partial list
              #     and a caller should only rely on response's
              #     {::Google::Cloud::Redis::Cluster::V1beta1::ListBackupCollectionsResponse#next_page_token `next_page_token`}
              #     to determine if there are more clusters left to be queried.
              #   @param page_token [::String]
              #     Optional. The `next_page_token` value returned from a previous
              #     [ListBackupCollections] request, if any.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Redis::Cluster::V1beta1::BackupCollection>]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::PagedEnumerable<::Google::Cloud::Redis::Cluster::V1beta1::BackupCollection>]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/redis/cluster/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Redis::Cluster::V1beta1::CloudRedisCluster::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Redis::Cluster::V1beta1::ListBackupCollectionsRequest.new
              #
              #   # Call the list_backup_collections method.
              #   result = client.list_backup_collections request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Redis::Cluster::V1beta1::BackupCollection.
              #     p item
              #   end
              #
              def list_backup_collections request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Redis::Cluster::V1beta1::ListBackupCollectionsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.list_backup_collections.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Redis::Cluster::V1beta1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.list_backup_collections.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.list_backup_collections.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_redis_cluster_stub.call_rpc :list_backup_collections, request, options: options do |response, operation|
                  response = ::Gapic::PagedEnumerable.new @cloud_redis_cluster_stub, :list_backup_collections, request, response, operation, options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Get a backup collection.
              #
              # @overload get_backup_collection(request, options = nil)
              #   Pass arguments to `get_backup_collection` via a request object, either of type
              #   {::Google::Cloud::Redis::Cluster::V1beta1::GetBackupCollectionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Redis::Cluster::V1beta1::GetBackupCollectionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_backup_collection(name: nil)
              #   Pass arguments to `get_backup_collection` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Redis backupCollection resource name using the form:
              #         `projects/{project_id}/locations/{location_id}/backupCollections/{backup_collection_id}`
              #     where `location_id` refers to a GCP region.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Redis::Cluster::V1beta1::BackupCollection]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Redis::Cluster::V1beta1::BackupCollection]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/redis/cluster/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Redis::Cluster::V1beta1::CloudRedisCluster::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Redis::Cluster::V1beta1::GetBackupCollectionRequest.new
              #
              #   # Call the get_backup_collection method.
              #   result = client.get_backup_collection request
              #
              #   # The returned object is of type Google::Cloud::Redis::Cluster::V1beta1::BackupCollection.
              #   p result
              #
              def get_backup_collection request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Redis::Cluster::V1beta1::GetBackupCollectionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_backup_collection.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Redis::Cluster::V1beta1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_backup_collection.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_backup_collection.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_redis_cluster_stub.call_rpc :get_backup_collection, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all backups owned by a backup collection.
              #
              # @overload list_backups(request, options = nil)
              #   Pass arguments to `list_backups` via a request object, either of type
              #   {::Google::Cloud::Redis::Cluster::V1beta1::ListBackupsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Redis::Cluster::V1beta1::ListBackupsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload list_backups(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_backups` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the backupCollection using the form:
              #     `projects/{project_id}/locations/{location_id}/backupCollections/{backup_collection_id}`
              #   @param page_size [::Integer]
              #     Optional. The maximum number of items to return.
              #
              #     If not specified, a default value of 1000 will be used by the service.
              #     Regardless of the page_size value, the response may include a partial list
              #     and a caller should only rely on response's
              #     {::Google::Cloud::Redis::Cluster::V1beta1::ListBackupsResponse#next_page_token `next_page_token`}
              #     to determine if there are more clusters left to be queried.
              #   @param page_token [::String]
              #     Optional. The `next_page_token` value returned from a previous
              #     [ListBackupCollections] request, if any.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Redis::Cluster::V1beta1::Backup>]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::PagedEnumerable<::Google::Cloud::Redis::Cluster::V1beta1::Backup>]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/redis/cluster/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Redis::Cluster::V1beta1::CloudRedisCluster::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Redis::Cluster::V1beta1::ListBackupsRequest.new
              #
              #   # Call the list_backups method.
              #   result = client.list_backups request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Redis::Cluster::V1beta1::Backup.
              #     p item
              #   end
              #
              def list_backups request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Redis::Cluster::V1beta1::ListBackupsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.list_backups.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Redis::Cluster::V1beta1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.list_backups.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.list_backups.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_redis_cluster_stub.call_rpc :list_backups, request, options: options do |response, operation|
                  response = ::Gapic::PagedEnumerable.new @cloud_redis_cluster_stub, :list_backups, request, response, operation, options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the details of a specific backup.
              #
              # @overload get_backup(request, options = nil)
              #   Pass arguments to `get_backup` via a request object, either of type
              #   {::Google::Cloud::Redis::Cluster::V1beta1::GetBackupRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Redis::Cluster::V1beta1::GetBackupRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_backup(name: nil)
              #   Pass arguments to `get_backup` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Redis backup resource name using the form:
              #     `projects/{project_id}/locations/{location_id}/backupCollections/{backup_collection_id}/backups/{backup_id}`
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Redis::Cluster::V1beta1::Backup]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Redis::Cluster::V1beta1::Backup]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/redis/cluster/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Redis::Cluster::V1beta1::CloudRedisCluster::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Redis::Cluster::V1beta1::GetBackupRequest.new
              #
              #   # Call the get_backup method.
              #   result = client.get_backup request
              #
              #   # The returned object is of type Google::Cloud::Redis::Cluster::V1beta1::Backup.
              #   p result
              #
              def get_backup request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Redis::Cluster::V1beta1::GetBackupRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_backup.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Redis::Cluster::V1beta1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_backup.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_backup.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_redis_cluster_stub.call_rpc :get_backup, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a specific backup.
              #
              # @overload delete_backup(request, options = nil)
              #   Pass arguments to `delete_backup` via a request object, either of type
              #   {::Google::Cloud::Redis::Cluster::V1beta1::DeleteBackupRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Redis::Cluster::V1beta1::DeleteBackupRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload delete_backup(name: nil, request_id: nil)
              #   Pass arguments to `delete_backup` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Redis backup resource name using the form:
              #     `projects/{project_id}/locations/{location_id}/backupCollections/{backup_collection_id}/backups/{backup_id}`
              #   @param request_id [::String]
              #     Optional. Idempotent request UUID.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/redis/cluster/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Redis::Cluster::V1beta1::CloudRedisCluster::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Redis::Cluster::V1beta1::DeleteBackupRequest.new
              #
              #   # Call the delete_backup method.
              #   result = client.delete_backup request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_backup request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Redis::Cluster::V1beta1::DeleteBackupRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.delete_backup.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Redis::Cluster::V1beta1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.delete_backup.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.delete_backup.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_redis_cluster_stub.call_rpc :delete_backup, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Exports a specific backup to a customer target Cloud Storage URI.
              #
              # @overload export_backup(request, options = nil)
              #   Pass arguments to `export_backup` via a request object, either of type
              #   {::Google::Cloud::Redis::Cluster::V1beta1::ExportBackupRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Redis::Cluster::V1beta1::ExportBackupRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload export_backup(gcs_bucket: nil, name: nil)
              #   Pass arguments to `export_backup` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param gcs_bucket [::String]
              #     Google Cloud Storage bucket, like "my-bucket".
              #   @param name [::String]
              #     Required. Redis backup resource name using the form:
              #     `projects/{project_id}/locations/{location_id}/backupCollections/{backup_collection_id}/backups/{backup_id}`
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/redis/cluster/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Redis::Cluster::V1beta1::CloudRedisCluster::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Redis::Cluster::V1beta1::ExportBackupRequest.new
              #
              #   # Call the export_backup method.
              #   result = client.export_backup request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def export_backup request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Redis::Cluster::V1beta1::ExportBackupRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.export_backup.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Redis::Cluster::V1beta1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.export_backup.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.export_backup.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_redis_cluster_stub.call_rpc :export_backup, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Backup Redis Cluster.
              # If this is the first time a backup is being created, a backup collection
              # will be created at the backend, and this backup belongs to this collection.
              # Both collection and backup will have a resource name. Backup will be
              # executed for each shard. A replica (primary if nonHA) will be selected to
              # perform the execution. Backup call will be rejected if there is an ongoing
              # backup or update operation. Be aware that during preview, if the cluster's
              # internal software version is too old, critical update will be performed
              # before actual backup. Once the internal software version is updated to the
              # minimum version required by the backup feature, subsequent backups will not
              # require critical update. After preview, there will be no critical update
              # needed for backup.
              #
              # @overload backup_cluster(request, options = nil)
              #   Pass arguments to `backup_cluster` via a request object, either of type
              #   {::Google::Cloud::Redis::Cluster::V1beta1::BackupClusterRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Redis::Cluster::V1beta1::BackupClusterRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload backup_cluster(name: nil, ttl: nil, backup_id: nil)
              #   Pass arguments to `backup_cluster` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Redis cluster resource name using the form:
              #      `projects/{project_id}/locations/{location_id}/clusters/{cluster_id}`
              #     where `location_id` refers to a GCP region.
              #   @param ttl [::Google::Protobuf::Duration, ::Hash]
              #     Optional. TTL for the backup to expire. Value range is 1 day to 100 years.
              #     If not specified, the default value is 100 years.
              #   @param backup_id [::String]
              #     Optional. The id of the backup to be created. If not specified, the
              #     default value ([YYYYMMDDHHMMSS]_[Shortened Cluster UID] is used.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/redis/cluster/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Redis::Cluster::V1beta1::CloudRedisCluster::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Redis::Cluster::V1beta1::BackupClusterRequest.new
              #
              #   # Call the backup_cluster method.
              #   result = client.backup_cluster request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def backup_cluster request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Redis::Cluster::V1beta1::BackupClusterRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.backup_cluster.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Redis::Cluster::V1beta1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.backup_cluster.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.backup_cluster.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_redis_cluster_stub.call_rpc :backup_cluster, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the CloudRedisCluster API.
              #
              # This class represents the configuration for CloudRedisCluster,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::Redis::Cluster::V1beta1::CloudRedisCluster::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # list_clusters to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::Redis::Cluster::V1beta1::CloudRedisCluster::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_clusters.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::Redis::Cluster::V1beta1::CloudRedisCluster::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_clusters.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
              #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
              #    *  (`nil`) indicating no credentials
              #
              #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
              #     is deprecated. Providing an unvalidated credential configuration to
              #     Google APIs can compromise the security of your systems and data.
              #
              #   @example
              #
              #     # The recommended way to provide credentials is to use the `make_creds` method
              #     # on the appropriate credentials class for your environment.
              #
              #     require "googleauth"
              #
              #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
              #       json_key_io: ::File.open("/path/to/keyfile.json")
              #     )
              #
              #     client = ::Google::Cloud::Redis::Cluster::V1beta1::CloudRedisCluster::Client.new do |config|
              #       config.credentials = credentials
              #     end
              #
              #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] channel_args
              #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
              #   `GRPC::Core::Channel` object is provided as the credential.
              #   @return [::Hash]
              # @!attribute [rw] interceptors
              #   An array of interceptors that are run before calls are executed.
              #   @return [::Array<::GRPC::ClientInterceptor>]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional gRPC headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "redis.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
                config_attr :interceptors,  nil, ::Array, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration for the channel pool
                # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
                #
                def channel_pool
                  @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
                end

                ##
                # Configuration RPC class for the CloudRedisCluster API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `list_clusters`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_clusters
                  ##
                  # RPC-specific configuration for `get_cluster`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_cluster
                  ##
                  # RPC-specific configuration for `update_cluster`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_cluster
                  ##
                  # RPC-specific configuration for `delete_cluster`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_cluster
                  ##
                  # RPC-specific configuration for `create_cluster`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_cluster
                  ##
                  # RPC-specific configuration for `get_cluster_certificate_authority`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_cluster_certificate_authority
                  ##
                  # RPC-specific configuration for `reschedule_cluster_maintenance`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :reschedule_cluster_maintenance
                  ##
                  # RPC-specific configuration for `list_backup_collections`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_backup_collections
                  ##
                  # RPC-specific configuration for `get_backup_collection`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_backup_collection
                  ##
                  # RPC-specific configuration for `list_backups`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_backups
                  ##
                  # RPC-specific configuration for `get_backup`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_backup
                  ##
                  # RPC-specific configuration for `delete_backup`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_backup
                  ##
                  # RPC-specific configuration for `export_backup`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :export_backup
                  ##
                  # RPC-specific configuration for `backup_cluster`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :backup_cluster

                  # @private
                  def initialize parent_rpcs = nil
                    list_clusters_config = parent_rpcs.list_clusters if parent_rpcs.respond_to? :list_clusters
                    @list_clusters = ::Gapic::Config::Method.new list_clusters_config
                    get_cluster_config = parent_rpcs.get_cluster if parent_rpcs.respond_to? :get_cluster
                    @get_cluster = ::Gapic::Config::Method.new get_cluster_config
                    update_cluster_config = parent_rpcs.update_cluster if parent_rpcs.respond_to? :update_cluster
                    @update_cluster = ::Gapic::Config::Method.new update_cluster_config
                    delete_cluster_config = parent_rpcs.delete_cluster if parent_rpcs.respond_to? :delete_cluster
                    @delete_cluster = ::Gapic::Config::Method.new delete_cluster_config
                    create_cluster_config = parent_rpcs.create_cluster if parent_rpcs.respond_to? :create_cluster
                    @create_cluster = ::Gapic::Config::Method.new create_cluster_config
                    get_cluster_certificate_authority_config = parent_rpcs.get_cluster_certificate_authority if parent_rpcs.respond_to? :get_cluster_certificate_authority
                    @get_cluster_certificate_authority = ::Gapic::Config::Method.new get_cluster_certificate_authority_config
                    reschedule_cluster_maintenance_config = parent_rpcs.reschedule_cluster_maintenance if parent_rpcs.respond_to? :reschedule_cluster_maintenance
                    @reschedule_cluster_maintenance = ::Gapic::Config::Method.new reschedule_cluster_maintenance_config
                    list_backup_collections_config = parent_rpcs.list_backup_collections if parent_rpcs.respond_to? :list_backup_collections
                    @list_backup_collections = ::Gapic::Config::Method.new list_backup_collections_config
                    get_backup_collection_config = parent_rpcs.get_backup_collection if parent_rpcs.respond_to? :get_backup_collection
                    @get_backup_collection = ::Gapic::Config::Method.new get_backup_collection_config
                    list_backups_config = parent_rpcs.list_backups if parent_rpcs.respond_to? :list_backups
                    @list_backups = ::Gapic::Config::Method.new list_backups_config
                    get_backup_config = parent_rpcs.get_backup if parent_rpcs.respond_to? :get_backup
                    @get_backup = ::Gapic::Config::Method.new get_backup_config
                    delete_backup_config = parent_rpcs.delete_backup if parent_rpcs.respond_to? :delete_backup
                    @delete_backup = ::Gapic::Config::Method.new delete_backup_config
                    export_backup_config = parent_rpcs.export_backup if parent_rpcs.respond_to? :export_backup
                    @export_backup = ::Gapic::Config::Method.new export_backup_config
                    backup_cluster_config = parent_rpcs.backup_cluster if parent_rpcs.respond_to? :backup_cluster
                    @backup_cluster = ::Gapic::Config::Method.new backup_cluster_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
