# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/recommender/v1/recommender_service_pb"
require "google/cloud/recommender/v1/recommender"

class ::Google::Cloud::Recommender::V1::Recommender::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_insights
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Recommender::V1::ListInsightsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_insights_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_insights, name
      assert_kind_of ::Google::Cloud::Recommender::V1::ListInsightsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_insights_client_stub do
      # Create client
      client = ::Google::Cloud::Recommender::V1::Recommender::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_insights({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_insights parent: parent, page_size: page_size, page_token: page_token, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_insights ::Google::Cloud::Recommender::V1::ListInsightsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_insights({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_insights(::Google::Cloud::Recommender::V1::ListInsightsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_insights_client_stub.call_rpc_count
    end
  end

  def test_get_insight
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Recommender::V1::Insight.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_insight_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_insight, name
      assert_kind_of ::Google::Cloud::Recommender::V1::GetInsightRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_insight_client_stub do
      # Create client
      client = ::Google::Cloud::Recommender::V1::Recommender::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_insight({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_insight name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_insight ::Google::Cloud::Recommender::V1::GetInsightRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_insight({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_insight(::Google::Cloud::Recommender::V1::GetInsightRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_insight_client_stub.call_rpc_count
    end
  end

  def test_mark_insight_accepted
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Recommender::V1::Insight.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    state_metadata = {}
    etag = "hello world"

    mark_insight_accepted_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :mark_insight_accepted, name
      assert_kind_of ::Google::Cloud::Recommender::V1::MarkInsightAcceptedRequest, request
      assert_equal "hello world", request["name"]
      assert_equal({}, request["state_metadata"].to_h)
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, mark_insight_accepted_client_stub do
      # Create client
      client = ::Google::Cloud::Recommender::V1::Recommender::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.mark_insight_accepted({ name: name, state_metadata: state_metadata, etag: etag }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.mark_insight_accepted name: name, state_metadata: state_metadata, etag: etag do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.mark_insight_accepted ::Google::Cloud::Recommender::V1::MarkInsightAcceptedRequest.new(name: name, state_metadata: state_metadata, etag: etag) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.mark_insight_accepted({ name: name, state_metadata: state_metadata, etag: etag }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.mark_insight_accepted(::Google::Cloud::Recommender::V1::MarkInsightAcceptedRequest.new(name: name, state_metadata: state_metadata, etag: etag), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, mark_insight_accepted_client_stub.call_rpc_count
    end
  end

  def test_list_recommendations
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Recommender::V1::ListRecommendationsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_recommendations_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_recommendations, name
      assert_kind_of ::Google::Cloud::Recommender::V1::ListRecommendationsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_recommendations_client_stub do
      # Create client
      client = ::Google::Cloud::Recommender::V1::Recommender::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_recommendations({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_recommendations parent: parent, page_size: page_size, page_token: page_token, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_recommendations ::Google::Cloud::Recommender::V1::ListRecommendationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_recommendations({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_recommendations(::Google::Cloud::Recommender::V1::ListRecommendationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_recommendations_client_stub.call_rpc_count
    end
  end

  def test_get_recommendation
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Recommender::V1::Recommendation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_recommendation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_recommendation, name
      assert_kind_of ::Google::Cloud::Recommender::V1::GetRecommendationRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_recommendation_client_stub do
      # Create client
      client = ::Google::Cloud::Recommender::V1::Recommender::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_recommendation({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_recommendation name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_recommendation ::Google::Cloud::Recommender::V1::GetRecommendationRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_recommendation({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_recommendation(::Google::Cloud::Recommender::V1::GetRecommendationRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_recommendation_client_stub.call_rpc_count
    end
  end

  def test_mark_recommendation_dismissed
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Recommender::V1::Recommendation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"

    mark_recommendation_dismissed_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :mark_recommendation_dismissed, name
      assert_kind_of ::Google::Cloud::Recommender::V1::MarkRecommendationDismissedRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, mark_recommendation_dismissed_client_stub do
      # Create client
      client = ::Google::Cloud::Recommender::V1::Recommender::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.mark_recommendation_dismissed({ name: name, etag: etag }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.mark_recommendation_dismissed name: name, etag: etag do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.mark_recommendation_dismissed ::Google::Cloud::Recommender::V1::MarkRecommendationDismissedRequest.new(name: name, etag: etag) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.mark_recommendation_dismissed({ name: name, etag: etag }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.mark_recommendation_dismissed(::Google::Cloud::Recommender::V1::MarkRecommendationDismissedRequest.new(name: name, etag: etag), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, mark_recommendation_dismissed_client_stub.call_rpc_count
    end
  end

  def test_mark_recommendation_claimed
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Recommender::V1::Recommendation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    state_metadata = {}
    etag = "hello world"

    mark_recommendation_claimed_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :mark_recommendation_claimed, name
      assert_kind_of ::Google::Cloud::Recommender::V1::MarkRecommendationClaimedRequest, request
      assert_equal "hello world", request["name"]
      assert_equal({}, request["state_metadata"].to_h)
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, mark_recommendation_claimed_client_stub do
      # Create client
      client = ::Google::Cloud::Recommender::V1::Recommender::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.mark_recommendation_claimed({ name: name, state_metadata: state_metadata, etag: etag }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.mark_recommendation_claimed name: name, state_metadata: state_metadata, etag: etag do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.mark_recommendation_claimed ::Google::Cloud::Recommender::V1::MarkRecommendationClaimedRequest.new(name: name, state_metadata: state_metadata, etag: etag) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.mark_recommendation_claimed({ name: name, state_metadata: state_metadata, etag: etag }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.mark_recommendation_claimed(::Google::Cloud::Recommender::V1::MarkRecommendationClaimedRequest.new(name: name, state_metadata: state_metadata, etag: etag), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, mark_recommendation_claimed_client_stub.call_rpc_count
    end
  end

  def test_mark_recommendation_succeeded
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Recommender::V1::Recommendation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    state_metadata = {}
    etag = "hello world"

    mark_recommendation_succeeded_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :mark_recommendation_succeeded, name
      assert_kind_of ::Google::Cloud::Recommender::V1::MarkRecommendationSucceededRequest, request
      assert_equal "hello world", request["name"]
      assert_equal({}, request["state_metadata"].to_h)
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, mark_recommendation_succeeded_client_stub do
      # Create client
      client = ::Google::Cloud::Recommender::V1::Recommender::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.mark_recommendation_succeeded({ name: name, state_metadata: state_metadata, etag: etag }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.mark_recommendation_succeeded name: name, state_metadata: state_metadata, etag: etag do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.mark_recommendation_succeeded ::Google::Cloud::Recommender::V1::MarkRecommendationSucceededRequest.new(name: name, state_metadata: state_metadata, etag: etag) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.mark_recommendation_succeeded({ name: name, state_metadata: state_metadata, etag: etag }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.mark_recommendation_succeeded(::Google::Cloud::Recommender::V1::MarkRecommendationSucceededRequest.new(name: name, state_metadata: state_metadata, etag: etag), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, mark_recommendation_succeeded_client_stub.call_rpc_count
    end
  end

  def test_mark_recommendation_failed
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Recommender::V1::Recommendation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    state_metadata = {}
    etag = "hello world"

    mark_recommendation_failed_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :mark_recommendation_failed, name
      assert_kind_of ::Google::Cloud::Recommender::V1::MarkRecommendationFailedRequest, request
      assert_equal "hello world", request["name"]
      assert_equal({}, request["state_metadata"].to_h)
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, mark_recommendation_failed_client_stub do
      # Create client
      client = ::Google::Cloud::Recommender::V1::Recommender::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.mark_recommendation_failed({ name: name, state_metadata: state_metadata, etag: etag }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.mark_recommendation_failed name: name, state_metadata: state_metadata, etag: etag do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.mark_recommendation_failed ::Google::Cloud::Recommender::V1::MarkRecommendationFailedRequest.new(name: name, state_metadata: state_metadata, etag: etag) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.mark_recommendation_failed({ name: name, state_metadata: state_metadata, etag: etag }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.mark_recommendation_failed(::Google::Cloud::Recommender::V1::MarkRecommendationFailedRequest.new(name: name, state_metadata: state_metadata, etag: etag), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, mark_recommendation_failed_client_stub.call_rpc_count
    end
  end

  def test_get_recommender_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Recommender::V1::RecommenderConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_recommender_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_recommender_config, name
      assert_kind_of ::Google::Cloud::Recommender::V1::GetRecommenderConfigRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_recommender_config_client_stub do
      # Create client
      client = ::Google::Cloud::Recommender::V1::Recommender::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_recommender_config({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_recommender_config name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_recommender_config ::Google::Cloud::Recommender::V1::GetRecommenderConfigRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_recommender_config({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_recommender_config(::Google::Cloud::Recommender::V1::GetRecommenderConfigRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_recommender_config_client_stub.call_rpc_count
    end
  end

  def test_update_recommender_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Recommender::V1::RecommenderConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    recommender_config = {}
    update_mask = {}
    validate_only = true

    update_recommender_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_recommender_config, name
      assert_kind_of ::Google::Cloud::Recommender::V1::UpdateRecommenderConfigRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Recommender::V1::RecommenderConfig), request["recommender_config"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_recommender_config_client_stub do
      # Create client
      client = ::Google::Cloud::Recommender::V1::Recommender::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_recommender_config({ recommender_config: recommender_config, update_mask: update_mask, validate_only: validate_only }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_recommender_config recommender_config: recommender_config, update_mask: update_mask, validate_only: validate_only do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_recommender_config ::Google::Cloud::Recommender::V1::UpdateRecommenderConfigRequest.new(recommender_config: recommender_config, update_mask: update_mask, validate_only: validate_only) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_recommender_config({ recommender_config: recommender_config, update_mask: update_mask, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_recommender_config(::Google::Cloud::Recommender::V1::UpdateRecommenderConfigRequest.new(recommender_config: recommender_config, update_mask: update_mask, validate_only: validate_only), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_recommender_config_client_stub.call_rpc_count
    end
  end

  def test_get_insight_type_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Recommender::V1::InsightTypeConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_insight_type_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_insight_type_config, name
      assert_kind_of ::Google::Cloud::Recommender::V1::GetInsightTypeConfigRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_insight_type_config_client_stub do
      # Create client
      client = ::Google::Cloud::Recommender::V1::Recommender::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_insight_type_config({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_insight_type_config name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_insight_type_config ::Google::Cloud::Recommender::V1::GetInsightTypeConfigRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_insight_type_config({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_insight_type_config(::Google::Cloud::Recommender::V1::GetInsightTypeConfigRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_insight_type_config_client_stub.call_rpc_count
    end
  end

  def test_update_insight_type_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Recommender::V1::InsightTypeConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    insight_type_config = {}
    update_mask = {}
    validate_only = true

    update_insight_type_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_insight_type_config, name
      assert_kind_of ::Google::Cloud::Recommender::V1::UpdateInsightTypeConfigRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Recommender::V1::InsightTypeConfig), request["insight_type_config"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_insight_type_config_client_stub do
      # Create client
      client = ::Google::Cloud::Recommender::V1::Recommender::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_insight_type_config({ insight_type_config: insight_type_config, update_mask: update_mask, validate_only: validate_only }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_insight_type_config insight_type_config: insight_type_config, update_mask: update_mask, validate_only: validate_only do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_insight_type_config ::Google::Cloud::Recommender::V1::UpdateInsightTypeConfigRequest.new(insight_type_config: insight_type_config, update_mask: update_mask, validate_only: validate_only) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_insight_type_config({ insight_type_config: insight_type_config, update_mask: update_mask, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_insight_type_config(::Google::Cloud::Recommender::V1::UpdateInsightTypeConfigRequest.new(insight_type_config: insight_type_config, update_mask: update_mask, validate_only: validate_only), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_insight_type_config_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Recommender::V1::Recommender::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Recommender::V1::Recommender::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Recommender::V1::Recommender::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::Recommender::V1::Recommender::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
