# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/recommender/v1/recommender_service_pb"
require "google/cloud/recommender/v1/recommender/rest/service_stub"

module Google
  module Cloud
    module Recommender
      module V1
        module Recommender
          module Rest
            ##
            # REST client for the Recommender service.
            #
            # Provides insights and recommendations for cloud customers for various
            # categories like performance optimization, cost savings, reliability, feature
            # discovery, etc. Insights and recommendations are generated automatically
            # based on analysis of user resources, configuration and monitoring metrics.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "recommender.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :recommender_stub

              ##
              # Configure the Recommender Client class.
              #
              # See {::Google::Cloud::Recommender::V1::Recommender::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all Recommender clients
              #   ::Google::Cloud::Recommender::V1::Recommender::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "Recommender", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.rpcs.list_insights.timeout = 60.0
                  default_config.rpcs.list_insights.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.get_insight.timeout = 60.0
                  default_config.rpcs.get_insight.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.mark_insight_accepted.timeout = 60.0

                  default_config.rpcs.list_recommendations.timeout = 60.0
                  default_config.rpcs.list_recommendations.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.get_recommendation.timeout = 60.0
                  default_config.rpcs.get_recommendation.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.mark_recommendation_claimed.timeout = 60.0

                  default_config.rpcs.mark_recommendation_succeeded.timeout = 60.0

                  default_config.rpcs.mark_recommendation_failed.timeout = 60.0

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the Recommender Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::Recommender::V1::Recommender::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @recommender_stub.universe_domain
              end

              ##
              # Create a new Recommender REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::Recommender::V1::Recommender::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::Recommender::V1::Recommender::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Recommender client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @recommender_stub = ::Google::Cloud::Recommender::V1::Recommender::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @recommender_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end
              end

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @recommender_stub.logger
              end

              # Service calls

              ##
              # Lists insights for the specified Cloud Resource. Requires the
              # recommender.*.list IAM permission for the specified insight type.
              #
              # @overload list_insights(request, options = nil)
              #   Pass arguments to `list_insights` via a request object, either of type
              #   {::Google::Cloud::Recommender::V1::ListInsightsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Recommender::V1::ListInsightsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_insights(parent: nil, page_size: nil, page_token: nil, filter: nil)
              #   Pass arguments to `list_insights` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The container resource on which to execute the request.
              #     Acceptable formats:
              #
              #     * `projects/[PROJECT_NUMBER]/locations/[LOCATION]/insightTypes/[INSIGHT_TYPE_ID]`
              #
              #     * `projects/[PROJECT_ID]/locations/[LOCATION]/insightTypes/[INSIGHT_TYPE_ID]`
              #
              #     * `billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION]/insightTypes/[INSIGHT_TYPE_ID]`
              #
              #     * `folders/[FOLDER_ID]/locations/[LOCATION]/insightTypes/[INSIGHT_TYPE_ID]`
              #
              #     * `organizations/[ORGANIZATION_ID]/locations/[LOCATION]/insightTypes/[INSIGHT_TYPE_ID]`
              #
              #     LOCATION here refers to GCP Locations:
              #     https://cloud.google.com/about/locations/
              #     INSIGHT_TYPE_ID refers to supported insight types:
              #     https://cloud.google.com/recommender/docs/insights/insight-types.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of results to return from this request.
              #     Non-positive values are ignored. If not specified, the server will
              #     determine the number of results to return.
              #   @param page_token [::String]
              #     Optional. If present, retrieves the next batch of results from the
              #     preceding call to this method. `page_token` must be the value of
              #     `next_page_token` from the previous response. The values of other method
              #     parameters must be identical to those in the previous call.
              #   @param filter [::String]
              #     Optional. Filter expression to restrict the insights returned. Supported
              #     filter fields:
              #
              #     * `stateInfo.state`
              #
              #     * `insightSubtype`
              #
              #     * `severity`
              #
              #     * `targetResources`
              #
              #     Examples:
              #
              #     * `stateInfo.state = ACTIVE OR stateInfo.state = DISMISSED`
              #
              #     * `insightSubtype = PERMISSIONS_USAGE`
              #
              #     * `severity = CRITICAL OR severity = HIGH`
              #
              #     * `targetResources :
              #     //compute.googleapis.com/projects/1234/zones/us-central1-a/instances/instance-1`
              #
              #     * `stateInfo.state = ACTIVE AND (severity = CRITICAL OR severity = HIGH)`
              #
              #     The max allowed filter length is 500 characters.
              #
              #     (These expressions are based on the filter language described at
              #     https://google.aip.dev/160)
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Recommender::V1::Insight>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Recommender::V1::Insight>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/recommender/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Recommender::V1::Recommender::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Recommender::V1::ListInsightsRequest.new
              #
              #   # Call the list_insights method.
              #   result = client.list_insights request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Recommender::V1::Insight.
              #     p item
              #   end
              #
              def list_insights request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Recommender::V1::ListInsightsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_insights.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Recommender::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_insights.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_insights.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @recommender_stub.list_insights request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @recommender_stub, :list_insights, "insights", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the requested insight. Requires the recommender.*.get IAM permission
              # for the specified insight type.
              #
              # @overload get_insight(request, options = nil)
              #   Pass arguments to `get_insight` via a request object, either of type
              #   {::Google::Cloud::Recommender::V1::GetInsightRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Recommender::V1::GetInsightRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_insight(name: nil)
              #   Pass arguments to `get_insight` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the insight.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Recommender::V1::Insight]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Recommender::V1::Insight]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/recommender/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Recommender::V1::Recommender::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Recommender::V1::GetInsightRequest.new
              #
              #   # Call the get_insight method.
              #   result = client.get_insight request
              #
              #   # The returned object is of type Google::Cloud::Recommender::V1::Insight.
              #   p result
              #
              def get_insight request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Recommender::V1::GetInsightRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_insight.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Recommender::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_insight.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_insight.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @recommender_stub.get_insight request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Marks the Insight State as Accepted. Users can use this method to
              # indicate to the Recommender API that they have applied some action based
              # on the insight. This stops the insight content from being updated.
              #
              # MarkInsightAccepted can be applied to insights in ACTIVE state. Requires
              # the recommender.*.update IAM permission for the specified insight.
              #
              # @overload mark_insight_accepted(request, options = nil)
              #   Pass arguments to `mark_insight_accepted` via a request object, either of type
              #   {::Google::Cloud::Recommender::V1::MarkInsightAcceptedRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Recommender::V1::MarkInsightAcceptedRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload mark_insight_accepted(name: nil, state_metadata: nil, etag: nil)
              #   Pass arguments to `mark_insight_accepted` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the insight.
              #   @param state_metadata [::Hash{::String => ::String}]
              #     Optional. State properties user wish to include with this state.  Full
              #     replace of the current state_metadata.
              #   @param etag [::String]
              #     Required. Fingerprint of the Insight. Provides optimistic locking.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Recommender::V1::Insight]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Recommender::V1::Insight]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/recommender/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Recommender::V1::Recommender::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Recommender::V1::MarkInsightAcceptedRequest.new
              #
              #   # Call the mark_insight_accepted method.
              #   result = client.mark_insight_accepted request
              #
              #   # The returned object is of type Google::Cloud::Recommender::V1::Insight.
              #   p result
              #
              def mark_insight_accepted request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Recommender::V1::MarkInsightAcceptedRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.mark_insight_accepted.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Recommender::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.mark_insight_accepted.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.mark_insight_accepted.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @recommender_stub.mark_insight_accepted request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists recommendations for the specified Cloud Resource. Requires the
              # recommender.*.list IAM permission for the specified recommender.
              #
              # @overload list_recommendations(request, options = nil)
              #   Pass arguments to `list_recommendations` via a request object, either of type
              #   {::Google::Cloud::Recommender::V1::ListRecommendationsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Recommender::V1::ListRecommendationsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_recommendations(parent: nil, page_size: nil, page_token: nil, filter: nil)
              #   Pass arguments to `list_recommendations` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The container resource on which to execute the request.
              #     Acceptable formats:
              #
              #     * `projects/[PROJECT_NUMBER]/locations/[LOCATION]/recommenders/[RECOMMENDER_ID]`
              #
              #     * `projects/[PROJECT_ID]/locations/[LOCATION]/recommenders/[RECOMMENDER_ID]`
              #
              #     * `billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION]/recommenders/[RECOMMENDER_ID]`
              #
              #     * `folders/[FOLDER_ID]/locations/[LOCATION]/recommenders/[RECOMMENDER_ID]`
              #
              #     * `organizations/[ORGANIZATION_ID]/locations/[LOCATION]/recommenders/[RECOMMENDER_ID]`
              #
              #     LOCATION here refers to GCP Locations:
              #     https://cloud.google.com/about/locations/
              #     RECOMMENDER_ID refers to supported recommenders:
              #     https://cloud.google.com/recommender/docs/recommenders.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of results to return from this request.
              #     Non-positive values are ignored. If not specified, the server will
              #     determine the number of results to return.
              #   @param page_token [::String]
              #     Optional. If present, retrieves the next batch of results from the
              #     preceding call to this method. `page_token` must be the value of
              #     `next_page_token` from the previous response. The values of other method
              #     parameters must be identical to those in the previous call.
              #   @param filter [::String]
              #     Filter expression to restrict the recommendations returned. Supported
              #     filter fields:
              #
              #     * `state_info.state`
              #
              #     * `recommenderSubtype`
              #
              #     * `priority`
              #
              #     * `targetResources`
              #
              #     Examples:
              #
              #     * `stateInfo.state = ACTIVE OR stateInfo.state = DISMISSED`
              #
              #     * `recommenderSubtype = REMOVE_ROLE OR recommenderSubtype = REPLACE_ROLE`
              #
              #     * `priority = P1 OR priority = P2`
              #
              #     * `targetResources :
              #     //compute.googleapis.com/projects/1234/zones/us-central1-a/instances/instance-1`
              #
              #     * `stateInfo.state = ACTIVE AND (priority = P1 OR priority = P2)`
              #
              #     The max allowed filter length is 500 characters.
              #
              #     (These expressions are based on the filter language described at
              #     https://google.aip.dev/160)
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Recommender::V1::Recommendation>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Recommender::V1::Recommendation>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/recommender/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Recommender::V1::Recommender::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Recommender::V1::ListRecommendationsRequest.new
              #
              #   # Call the list_recommendations method.
              #   result = client.list_recommendations request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Recommender::V1::Recommendation.
              #     p item
              #   end
              #
              def list_recommendations request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Recommender::V1::ListRecommendationsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_recommendations.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Recommender::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_recommendations.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_recommendations.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @recommender_stub.list_recommendations request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @recommender_stub, :list_recommendations, "recommendations", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the requested recommendation. Requires the recommender.*.get
              # IAM permission for the specified recommender.
              #
              # @overload get_recommendation(request, options = nil)
              #   Pass arguments to `get_recommendation` via a request object, either of type
              #   {::Google::Cloud::Recommender::V1::GetRecommendationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Recommender::V1::GetRecommendationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_recommendation(name: nil)
              #   Pass arguments to `get_recommendation` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the recommendation.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Recommender::V1::Recommendation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Recommender::V1::Recommendation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/recommender/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Recommender::V1::Recommender::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Recommender::V1::GetRecommendationRequest.new
              #
              #   # Call the get_recommendation method.
              #   result = client.get_recommendation request
              #
              #   # The returned object is of type Google::Cloud::Recommender::V1::Recommendation.
              #   p result
              #
              def get_recommendation request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Recommender::V1::GetRecommendationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_recommendation.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Recommender::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_recommendation.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_recommendation.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @recommender_stub.get_recommendation request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Mark the Recommendation State as Dismissed. Users can use this method to
              # indicate to the Recommender API that an ACTIVE recommendation has to
              # be marked back as DISMISSED.
              #
              # MarkRecommendationDismissed can be applied to recommendations in ACTIVE
              # state.
              #
              # Requires the recommender.*.update IAM permission for the specified
              # recommender.
              #
              # @overload mark_recommendation_dismissed(request, options = nil)
              #   Pass arguments to `mark_recommendation_dismissed` via a request object, either of type
              #   {::Google::Cloud::Recommender::V1::MarkRecommendationDismissedRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Recommender::V1::MarkRecommendationDismissedRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload mark_recommendation_dismissed(name: nil, etag: nil)
              #   Pass arguments to `mark_recommendation_dismissed` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the recommendation.
              #   @param etag [::String]
              #     Fingerprint of the Recommendation. Provides optimistic locking.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Recommender::V1::Recommendation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Recommender::V1::Recommendation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/recommender/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Recommender::V1::Recommender::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Recommender::V1::MarkRecommendationDismissedRequest.new
              #
              #   # Call the mark_recommendation_dismissed method.
              #   result = client.mark_recommendation_dismissed request
              #
              #   # The returned object is of type Google::Cloud::Recommender::V1::Recommendation.
              #   p result
              #
              def mark_recommendation_dismissed request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Recommender::V1::MarkRecommendationDismissedRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.mark_recommendation_dismissed.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Recommender::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.mark_recommendation_dismissed.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.mark_recommendation_dismissed.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @recommender_stub.mark_recommendation_dismissed request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Marks the Recommendation State as Claimed. Users can use this method to
              # indicate to the Recommender API that they are starting to apply the
              # recommendation themselves. This stops the recommendation content from being
              # updated. Associated insights are frozen and placed in the ACCEPTED state.
              #
              # MarkRecommendationClaimed can be applied to recommendations in CLAIMED,
              # SUCCEEDED, FAILED, or ACTIVE state.
              #
              # Requires the recommender.*.update IAM permission for the specified
              # recommender.
              #
              # @overload mark_recommendation_claimed(request, options = nil)
              #   Pass arguments to `mark_recommendation_claimed` via a request object, either of type
              #   {::Google::Cloud::Recommender::V1::MarkRecommendationClaimedRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Recommender::V1::MarkRecommendationClaimedRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload mark_recommendation_claimed(name: nil, state_metadata: nil, etag: nil)
              #   Pass arguments to `mark_recommendation_claimed` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the recommendation.
              #   @param state_metadata [::Hash{::String => ::String}]
              #     State properties to include with this state. Overwrites any existing
              #     `state_metadata`.
              #     Keys must match the regex `/^[a-z0-9][a-z0-9_.-]{0,62}$/`.
              #     Values must match the regex `/^[a-zA-Z0-9_./-]{0,255}$/`.
              #   @param etag [::String]
              #     Required. Fingerprint of the Recommendation. Provides optimistic locking.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Recommender::V1::Recommendation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Recommender::V1::Recommendation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/recommender/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Recommender::V1::Recommender::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Recommender::V1::MarkRecommendationClaimedRequest.new
              #
              #   # Call the mark_recommendation_claimed method.
              #   result = client.mark_recommendation_claimed request
              #
              #   # The returned object is of type Google::Cloud::Recommender::V1::Recommendation.
              #   p result
              #
              def mark_recommendation_claimed request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Recommender::V1::MarkRecommendationClaimedRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.mark_recommendation_claimed.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Recommender::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.mark_recommendation_claimed.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.mark_recommendation_claimed.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @recommender_stub.mark_recommendation_claimed request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Marks the Recommendation State as Succeeded. Users can use this method to
              # indicate to the Recommender API that they have applied the recommendation
              # themselves, and the operation was successful. This stops the recommendation
              # content from being updated. Associated insights are frozen and placed in
              # the ACCEPTED state.
              #
              # MarkRecommendationSucceeded can be applied to recommendations in ACTIVE,
              # CLAIMED, SUCCEEDED, or FAILED state.
              #
              # Requires the recommender.*.update IAM permission for the specified
              # recommender.
              #
              # @overload mark_recommendation_succeeded(request, options = nil)
              #   Pass arguments to `mark_recommendation_succeeded` via a request object, either of type
              #   {::Google::Cloud::Recommender::V1::MarkRecommendationSucceededRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Recommender::V1::MarkRecommendationSucceededRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload mark_recommendation_succeeded(name: nil, state_metadata: nil, etag: nil)
              #   Pass arguments to `mark_recommendation_succeeded` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the recommendation.
              #   @param state_metadata [::Hash{::String => ::String}]
              #     State properties to include with this state. Overwrites any existing
              #     `state_metadata`.
              #     Keys must match the regex `/^[a-z0-9][a-z0-9_.-]{0,62}$/`.
              #     Values must match the regex `/^[a-zA-Z0-9_./-]{0,255}$/`.
              #   @param etag [::String]
              #     Required. Fingerprint of the Recommendation. Provides optimistic locking.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Recommender::V1::Recommendation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Recommender::V1::Recommendation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/recommender/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Recommender::V1::Recommender::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Recommender::V1::MarkRecommendationSucceededRequest.new
              #
              #   # Call the mark_recommendation_succeeded method.
              #   result = client.mark_recommendation_succeeded request
              #
              #   # The returned object is of type Google::Cloud::Recommender::V1::Recommendation.
              #   p result
              #
              def mark_recommendation_succeeded request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Recommender::V1::MarkRecommendationSucceededRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.mark_recommendation_succeeded.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Recommender::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.mark_recommendation_succeeded.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.mark_recommendation_succeeded.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @recommender_stub.mark_recommendation_succeeded request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Marks the Recommendation State as Failed. Users can use this method to
              # indicate to the Recommender API that they have applied the recommendation
              # themselves, and the operation failed. This stops the recommendation content
              # from being updated. Associated insights are frozen and placed in the
              # ACCEPTED state.
              #
              # MarkRecommendationFailed can be applied to recommendations in ACTIVE,
              # CLAIMED, SUCCEEDED, or FAILED state.
              #
              # Requires the recommender.*.update IAM permission for the specified
              # recommender.
              #
              # @overload mark_recommendation_failed(request, options = nil)
              #   Pass arguments to `mark_recommendation_failed` via a request object, either of type
              #   {::Google::Cloud::Recommender::V1::MarkRecommendationFailedRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Recommender::V1::MarkRecommendationFailedRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload mark_recommendation_failed(name: nil, state_metadata: nil, etag: nil)
              #   Pass arguments to `mark_recommendation_failed` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the recommendation.
              #   @param state_metadata [::Hash{::String => ::String}]
              #     State properties to include with this state. Overwrites any existing
              #     `state_metadata`.
              #     Keys must match the regex `/^[a-z0-9][a-z0-9_.-]{0,62}$/`.
              #     Values must match the regex `/^[a-zA-Z0-9_./-]{0,255}$/`.
              #   @param etag [::String]
              #     Required. Fingerprint of the Recommendation. Provides optimistic locking.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Recommender::V1::Recommendation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Recommender::V1::Recommendation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/recommender/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Recommender::V1::Recommender::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Recommender::V1::MarkRecommendationFailedRequest.new
              #
              #   # Call the mark_recommendation_failed method.
              #   result = client.mark_recommendation_failed request
              #
              #   # The returned object is of type Google::Cloud::Recommender::V1::Recommendation.
              #   p result
              #
              def mark_recommendation_failed request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Recommender::V1::MarkRecommendationFailedRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.mark_recommendation_failed.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Recommender::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.mark_recommendation_failed.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.mark_recommendation_failed.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @recommender_stub.mark_recommendation_failed request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the requested Recommender Config. There is only one instance of the
              # config for each Recommender.
              #
              # @overload get_recommender_config(request, options = nil)
              #   Pass arguments to `get_recommender_config` via a request object, either of type
              #   {::Google::Cloud::Recommender::V1::GetRecommenderConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Recommender::V1::GetRecommenderConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_recommender_config(name: nil)
              #   Pass arguments to `get_recommender_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the Recommendation Config to get.
              #
              #     Acceptable formats:
              #
              #     * `projects/[PROJECT_NUMBER]/locations/[LOCATION]/recommenders/[RECOMMENDER_ID]/config`
              #
              #     * `projects/[PROJECT_ID]/locations/[LOCATION]/recommenders/[RECOMMENDER_ID]/config`
              #
              #     * `organizations/[ORGANIZATION_ID]/locations/[LOCATION]/recommenders/[RECOMMENDER_ID]/config`
              #
              #     * `billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION]/recommenders/[RECOMMENDER_ID]/config`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Recommender::V1::RecommenderConfig]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Recommender::V1::RecommenderConfig]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/recommender/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Recommender::V1::Recommender::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Recommender::V1::GetRecommenderConfigRequest.new
              #
              #   # Call the get_recommender_config method.
              #   result = client.get_recommender_config request
              #
              #   # The returned object is of type Google::Cloud::Recommender::V1::RecommenderConfig.
              #   p result
              #
              def get_recommender_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Recommender::V1::GetRecommenderConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_recommender_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Recommender::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_recommender_config.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_recommender_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @recommender_stub.get_recommender_config request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a Recommender Config. This will create a new revision of the
              # config.
              #
              # @overload update_recommender_config(request, options = nil)
              #   Pass arguments to `update_recommender_config` via a request object, either of type
              #   {::Google::Cloud::Recommender::V1::UpdateRecommenderConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Recommender::V1::UpdateRecommenderConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_recommender_config(recommender_config: nil, update_mask: nil, validate_only: nil)
              #   Pass arguments to `update_recommender_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param recommender_config [::Google::Cloud::Recommender::V1::RecommenderConfig, ::Hash]
              #     Required. The RecommenderConfig to update.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     The list of fields to be updated.
              #   @param validate_only [::Boolean]
              #     If true, validate the request and preview the change, but do not actually
              #     update it.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Recommender::V1::RecommenderConfig]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Recommender::V1::RecommenderConfig]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/recommender/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Recommender::V1::Recommender::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Recommender::V1::UpdateRecommenderConfigRequest.new
              #
              #   # Call the update_recommender_config method.
              #   result = client.update_recommender_config request
              #
              #   # The returned object is of type Google::Cloud::Recommender::V1::RecommenderConfig.
              #   p result
              #
              def update_recommender_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Recommender::V1::UpdateRecommenderConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_recommender_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Recommender::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_recommender_config.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_recommender_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @recommender_stub.update_recommender_config request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the requested InsightTypeConfig. There is only one instance of the
              # config for each InsightType.
              #
              # @overload get_insight_type_config(request, options = nil)
              #   Pass arguments to `get_insight_type_config` via a request object, either of type
              #   {::Google::Cloud::Recommender::V1::GetInsightTypeConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Recommender::V1::GetInsightTypeConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_insight_type_config(name: nil)
              #   Pass arguments to `get_insight_type_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the InsightTypeConfig to get.
              #
              #     Acceptable formats:
              #
              #     * `projects/[PROJECT_NUMBER]/locations/[LOCATION]/insightTypes/[INSIGHT_TYPE_ID]/config`
              #
              #     * `projects/[PROJECT_ID]/locations/[LOCATION]/insightTypes/[INSIGHT_TYPE_ID]/config`
              #
              #     * `organizations/[ORGANIZATION_ID]/locations/[LOCATION]/insightTypes/[INSIGHT_TYPE_ID]/config`
              #
              #     * `billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION]/insightTypes/[INSIGHT_TYPE_ID]/config`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Recommender::V1::InsightTypeConfig]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Recommender::V1::InsightTypeConfig]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/recommender/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Recommender::V1::Recommender::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Recommender::V1::GetInsightTypeConfigRequest.new
              #
              #   # Call the get_insight_type_config method.
              #   result = client.get_insight_type_config request
              #
              #   # The returned object is of type Google::Cloud::Recommender::V1::InsightTypeConfig.
              #   p result
              #
              def get_insight_type_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Recommender::V1::GetInsightTypeConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_insight_type_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Recommender::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_insight_type_config.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_insight_type_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @recommender_stub.get_insight_type_config request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates an InsightTypeConfig change. This will create a new revision of the
              # config.
              #
              # @overload update_insight_type_config(request, options = nil)
              #   Pass arguments to `update_insight_type_config` via a request object, either of type
              #   {::Google::Cloud::Recommender::V1::UpdateInsightTypeConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Recommender::V1::UpdateInsightTypeConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_insight_type_config(insight_type_config: nil, update_mask: nil, validate_only: nil)
              #   Pass arguments to `update_insight_type_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param insight_type_config [::Google::Cloud::Recommender::V1::InsightTypeConfig, ::Hash]
              #     Required. The InsightTypeConfig to update.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     The list of fields to be updated.
              #   @param validate_only [::Boolean]
              #     If true, validate the request and preview the change, but do not actually
              #     update it.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Recommender::V1::InsightTypeConfig]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Recommender::V1::InsightTypeConfig]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/recommender/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Recommender::V1::Recommender::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Recommender::V1::UpdateInsightTypeConfigRequest.new
              #
              #   # Call the update_insight_type_config method.
              #   result = client.update_insight_type_config request
              #
              #   # The returned object is of type Google::Cloud::Recommender::V1::InsightTypeConfig.
              #   p result
              #
              def update_insight_type_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Recommender::V1::UpdateInsightTypeConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_insight_type_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Recommender::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_insight_type_config.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_insight_type_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @recommender_stub.update_insight_type_config request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the Recommender REST API.
              #
              # This class represents the configuration for Recommender REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::Recommender::V1::Recommender::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # list_insights to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::Recommender::V1::Recommender::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_insights.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::Recommender::V1::Recommender::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_insights.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "recommender.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the Recommender API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `list_insights`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_insights
                  ##
                  # RPC-specific configuration for `get_insight`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_insight
                  ##
                  # RPC-specific configuration for `mark_insight_accepted`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :mark_insight_accepted
                  ##
                  # RPC-specific configuration for `list_recommendations`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_recommendations
                  ##
                  # RPC-specific configuration for `get_recommendation`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_recommendation
                  ##
                  # RPC-specific configuration for `mark_recommendation_dismissed`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :mark_recommendation_dismissed
                  ##
                  # RPC-specific configuration for `mark_recommendation_claimed`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :mark_recommendation_claimed
                  ##
                  # RPC-specific configuration for `mark_recommendation_succeeded`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :mark_recommendation_succeeded
                  ##
                  # RPC-specific configuration for `mark_recommendation_failed`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :mark_recommendation_failed
                  ##
                  # RPC-specific configuration for `get_recommender_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_recommender_config
                  ##
                  # RPC-specific configuration for `update_recommender_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_recommender_config
                  ##
                  # RPC-specific configuration for `get_insight_type_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_insight_type_config
                  ##
                  # RPC-specific configuration for `update_insight_type_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_insight_type_config

                  # @private
                  def initialize parent_rpcs = nil
                    list_insights_config = parent_rpcs.list_insights if parent_rpcs.respond_to? :list_insights
                    @list_insights = ::Gapic::Config::Method.new list_insights_config
                    get_insight_config = parent_rpcs.get_insight if parent_rpcs.respond_to? :get_insight
                    @get_insight = ::Gapic::Config::Method.new get_insight_config
                    mark_insight_accepted_config = parent_rpcs.mark_insight_accepted if parent_rpcs.respond_to? :mark_insight_accepted
                    @mark_insight_accepted = ::Gapic::Config::Method.new mark_insight_accepted_config
                    list_recommendations_config = parent_rpcs.list_recommendations if parent_rpcs.respond_to? :list_recommendations
                    @list_recommendations = ::Gapic::Config::Method.new list_recommendations_config
                    get_recommendation_config = parent_rpcs.get_recommendation if parent_rpcs.respond_to? :get_recommendation
                    @get_recommendation = ::Gapic::Config::Method.new get_recommendation_config
                    mark_recommendation_dismissed_config = parent_rpcs.mark_recommendation_dismissed if parent_rpcs.respond_to? :mark_recommendation_dismissed
                    @mark_recommendation_dismissed = ::Gapic::Config::Method.new mark_recommendation_dismissed_config
                    mark_recommendation_claimed_config = parent_rpcs.mark_recommendation_claimed if parent_rpcs.respond_to? :mark_recommendation_claimed
                    @mark_recommendation_claimed = ::Gapic::Config::Method.new mark_recommendation_claimed_config
                    mark_recommendation_succeeded_config = parent_rpcs.mark_recommendation_succeeded if parent_rpcs.respond_to? :mark_recommendation_succeeded
                    @mark_recommendation_succeeded = ::Gapic::Config::Method.new mark_recommendation_succeeded_config
                    mark_recommendation_failed_config = parent_rpcs.mark_recommendation_failed if parent_rpcs.respond_to? :mark_recommendation_failed
                    @mark_recommendation_failed = ::Gapic::Config::Method.new mark_recommendation_failed_config
                    get_recommender_config_config = parent_rpcs.get_recommender_config if parent_rpcs.respond_to? :get_recommender_config
                    @get_recommender_config = ::Gapic::Config::Method.new get_recommender_config_config
                    update_recommender_config_config = parent_rpcs.update_recommender_config if parent_rpcs.respond_to? :update_recommender_config
                    @update_recommender_config = ::Gapic::Config::Method.new update_recommender_config_config
                    get_insight_type_config_config = parent_rpcs.get_insight_type_config if parent_rpcs.respond_to? :get_insight_type_config
                    @get_insight_type_config = ::Gapic::Config::Method.new get_insight_type_config_config
                    update_insight_type_config_config = parent_rpcs.update_insight_type_config if parent_rpcs.respond_to? :update_insight_type_config
                    @update_insight_type_config = ::Gapic::Config::Method.new update_insight_type_config_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
