# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module RecommendationEngine
      module V1beta1
        # Request message for CreateCatalogItem method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent catalog resource name, such as
        #     `projects/*/locations/global/catalogs/default_catalog`.
        # @!attribute [rw] catalog_item
        #   @return [::Google::Cloud::RecommendationEngine::V1beta1::CatalogItem]
        #     Required. The catalog item to create.
        class CreateCatalogItemRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetCatalogItem method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Full resource name of catalog item, such as
        #     `projects/*/locations/global/catalogs/default_catalog/catalogitems/some_catalog_item_id`.
        class GetCatalogItemRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListCatalogItems method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent catalog resource name, such as
        #     `projects/*/locations/global/catalogs/default_catalog`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Maximum number of results to return per page. If zero, the
        #     service will choose a reasonable default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The previous ListCatalogItemsResponse.next_page_token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. A filter to apply on the list results.
        class ListCatalogItemsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListCatalogItems method.
        # @!attribute [rw] catalog_items
        #   @return [::Array<::Google::Cloud::RecommendationEngine::V1beta1::CatalogItem>]
        #     The catalog items.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     If empty, the list is complete. If nonempty, the token to pass to the next
        #     request's ListCatalogItemRequest.page_token.
        class ListCatalogItemsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateCatalogItem method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Full resource name of catalog item, such as
        #     `projects/*/locations/global/catalogs/default_catalog/catalogItems/some_catalog_item_id`.
        # @!attribute [rw] catalog_item
        #   @return [::Google::Cloud::RecommendationEngine::V1beta1::CatalogItem]
        #     Required. The catalog item to update/create. The 'catalog_item_id' field
        #     has to match that in the 'name'.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Indicates which fields in the provided 'item' to update. If not
        #     set, will by default update all fields.
        class UpdateCatalogItemRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DeleteCatalogItem method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Full resource name of catalog item, such as
        #     `projects/*/locations/global/catalogs/default_catalog/catalogItems/some_catalog_item_id`.
        class DeleteCatalogItemRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
