# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/recommendationengine/v1beta1/user_event_service_pb"

module Google
  module Cloud
    module RecommendationEngine
      module V1beta1
        module UserEventService
          ##
          # Client for the UserEventService service.
          #
          # Service for ingesting end user actions on the customer website.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "recommendationengine.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :user_event_service_stub

            ##
            # Configure the UserEventService Client class.
            #
            # See {::Google::Cloud::RecommendationEngine::V1beta1::UserEventService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all UserEventService clients
            #   ::Google::Cloud::RecommendationEngine::V1beta1::UserEventService::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "RecommendationEngine", "V1beta1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.rpcs.write_user_event.timeout = 600.0
                default_config.rpcs.write_user_event.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                }

                default_config.rpcs.collect_user_event.timeout = 600.0
                default_config.rpcs.collect_user_event.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                }

                default_config.rpcs.list_user_events.timeout = 600.0
                default_config.rpcs.list_user_events.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                }

                default_config.rpcs.purge_user_events.timeout = 600.0
                default_config.rpcs.purge_user_events.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                }

                default_config.rpcs.import_user_events.timeout = 600.0
                default_config.rpcs.import_user_events.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                }

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the UserEventService Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::RecommendationEngine::V1beta1::UserEventService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @user_event_service_stub.universe_domain
            end

            ##
            # Create a new UserEventService client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::RecommendationEngine::V1beta1::UserEventService::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::RecommendationEngine::V1beta1::UserEventService::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the UserEventService client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/recommendationengine/v1beta1/user_event_service_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @user_event_service_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::RecommendationEngine::V1beta1::UserEventService::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @user_event_service_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Cloud::RecommendationEngine::V1beta1::UserEventService::Operations]
            #
            attr_reader :operations_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @user_event_service_stub.logger
            end

            # Service calls

            ##
            # Writes a single user event.
            #
            # @overload write_user_event(request, options = nil)
            #   Pass arguments to `write_user_event` via a request object, either of type
            #   {::Google::Cloud::RecommendationEngine::V1beta1::WriteUserEventRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::RecommendationEngine::V1beta1::WriteUserEventRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload write_user_event(parent: nil, user_event: nil)
            #   Pass arguments to `write_user_event` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent eventStore resource name, such as
            #     `projects/1234/locations/global/catalogs/default_catalog/eventStores/default_event_store`.
            #   @param user_event [::Google::Cloud::RecommendationEngine::V1beta1::UserEvent, ::Hash]
            #     Required. User event to write.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::RecommendationEngine::V1beta1::UserEvent]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::RecommendationEngine::V1beta1::UserEvent]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/recommendation_engine/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::RecommendationEngine::V1beta1::UserEventService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::RecommendationEngine::V1beta1::WriteUserEventRequest.new
            #
            #   # Call the write_user_event method.
            #   result = client.write_user_event request
            #
            #   # The returned object is of type Google::Cloud::RecommendationEngine::V1beta1::UserEvent.
            #   p result
            #
            def write_user_event request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::RecommendationEngine::V1beta1::WriteUserEventRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.write_user_event.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::RecommendationEngine::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.write_user_event.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.write_user_event.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @user_event_service_stub.call_rpc :write_user_event, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Writes a single user event from the browser. This uses a GET request to
            # due to browser restriction of POST-ing to a 3rd party domain.
            #
            # This method is used only by the Recommendations AI JavaScript pixel.
            # Users should not call this method directly.
            #
            # @overload collect_user_event(request, options = nil)
            #   Pass arguments to `collect_user_event` via a request object, either of type
            #   {::Google::Cloud::RecommendationEngine::V1beta1::CollectUserEventRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::RecommendationEngine::V1beta1::CollectUserEventRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload collect_user_event(parent: nil, user_event: nil, uri: nil, ets: nil)
            #   Pass arguments to `collect_user_event` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent eventStore name, such as
            #     `projects/1234/locations/global/catalogs/default_catalog/eventStores/default_event_store`.
            #   @param user_event [::String]
            #     Required. URL encoded UserEvent proto.
            #   @param uri [::String]
            #     Optional. The url including cgi-parameters but excluding the hash fragment.
            #     The URL must be truncated to 1.5K bytes to conservatively be under the 2K
            #     bytes. This is often more useful than the referer url, because many
            #     browsers only send the domain for 3rd party requests.
            #   @param ets [::Integer]
            #     Optional. The event timestamp in milliseconds. This prevents browser
            #     caching of otherwise identical get requests. The name is abbreviated to
            #     reduce the payload bytes.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Api::HttpBody]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Api::HttpBody]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/recommendation_engine/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::RecommendationEngine::V1beta1::UserEventService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::RecommendationEngine::V1beta1::CollectUserEventRequest.new
            #
            #   # Call the collect_user_event method.
            #   result = client.collect_user_event request
            #
            #   # The returned object is of type Google::Api::HttpBody.
            #   p result
            #
            def collect_user_event request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::RecommendationEngine::V1beta1::CollectUserEventRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.collect_user_event.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::RecommendationEngine::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.collect_user_event.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.collect_user_event.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @user_event_service_stub.call_rpc :collect_user_event, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a list of user events within a time range, with potential filtering.
            #
            # @overload list_user_events(request, options = nil)
            #   Pass arguments to `list_user_events` via a request object, either of type
            #   {::Google::Cloud::RecommendationEngine::V1beta1::ListUserEventsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::RecommendationEngine::V1beta1::ListUserEventsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_user_events(parent: nil, page_size: nil, page_token: nil, filter: nil)
            #   Pass arguments to `list_user_events` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent eventStore resource name, such as
            #     `projects/*/locations/*/catalogs/default_catalog/eventStores/default_event_store`.
            #   @param page_size [::Integer]
            #     Optional. Maximum number of results to return per page. If zero, the
            #     service will choose a reasonable default.
            #   @param page_token [::String]
            #     Optional. The previous ListUserEventsResponse.next_page_token.
            #   @param filter [::String]
            #     Optional. Filtering expression to specify restrictions over
            #     returned events. This is a sequence of terms, where each term applies some
            #     kind of a restriction to the returned user events. Use this expression to
            #     restrict results to a specific time range, or filter events by eventType.
            #        eg: eventTime > "2012-04-23T18:25:43.511Z" eventsMissingCatalogItems
            #        eventTime<"2012-04-23T18:25:43.511Z" eventType=search
            #
            #       We expect only 3 types of fields:
            #
            #        * eventTime: this can be specified a maximum of 2 times, once with a
            #          less than operator and once with a greater than operator. The
            #          eventTime restrict should result in one contiguous valid eventTime
            #          range.
            #
            #        * eventType: only 1 eventType restriction can be specified.
            #
            #        * eventsMissingCatalogItems: specififying this will restrict results
            #          to events for which catalog items were not found in the catalog. The
            #          default behavior is to return only those events for which catalog
            #          items were found.
            #
            #       Some examples of valid filters expressions:
            #
            #       * Example 1: eventTime > "2012-04-23T18:25:43.511Z"
            #                 eventTime < "2012-04-23T18:30:43.511Z"
            #       * Example 2: eventTime > "2012-04-23T18:25:43.511Z"
            #                 eventType = detail-page-view
            #       * Example 3: eventsMissingCatalogItems
            #                 eventType = search eventTime < "2018-04-23T18:30:43.511Z"
            #       * Example 4: eventTime > "2012-04-23T18:25:43.511Z"
            #       * Example 5: eventType = search
            #       * Example 6: eventsMissingCatalogItems
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::RecommendationEngine::V1beta1::UserEvent>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::RecommendationEngine::V1beta1::UserEvent>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/recommendation_engine/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::RecommendationEngine::V1beta1::UserEventService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::RecommendationEngine::V1beta1::ListUserEventsRequest.new
            #
            #   # Call the list_user_events method.
            #   result = client.list_user_events request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::RecommendationEngine::V1beta1::UserEvent.
            #     p item
            #   end
            #
            def list_user_events request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::RecommendationEngine::V1beta1::ListUserEventsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_user_events.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::RecommendationEngine::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_user_events.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_user_events.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @user_event_service_stub.call_rpc :list_user_events, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @user_event_service_stub, :list_user_events, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes permanently all user events specified by the filter provided.
            # Depending on the number of events specified by the filter, this operation
            # could take hours or days to complete. To test a filter, use the list
            # command first.
            #
            # @overload purge_user_events(request, options = nil)
            #   Pass arguments to `purge_user_events` via a request object, either of type
            #   {::Google::Cloud::RecommendationEngine::V1beta1::PurgeUserEventsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::RecommendationEngine::V1beta1::PurgeUserEventsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload purge_user_events(parent: nil, filter: nil, force: nil)
            #   Pass arguments to `purge_user_events` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the event_store under which the events are
            #     created. The format is
            #     `projects/${projectId}/locations/global/catalogs/${catalogId}/eventStores/${eventStoreId}`
            #   @param filter [::String]
            #     Required. The filter string to specify the events to be deleted. Empty
            #     string filter is not allowed. This filter can also be used with
            #     ListUserEvents API to list events that will be deleted. The eligible fields
            #     for filtering are:
            #     * eventType - UserEvent.eventType field of type string.
            #     * eventTime - in ISO 8601 "zulu" format.
            #     * visitorId - field of type string. Specifying this will delete all events
            #     associated with a visitor.
            #     * userId - field of type string. Specifying this will delete all events
            #     associated with a user.
            #     Example 1: Deleting all events in a time range.
            #     `eventTime > "2012-04-23T18:25:43.511Z" eventTime <
            #     "2012-04-23T18:30:43.511Z"`
            #     Example 2: Deleting specific eventType in time range.
            #     `eventTime > "2012-04-23T18:25:43.511Z" eventType = "detail-page-view"`
            #     Example 3: Deleting all events for a specific visitor
            #     `visitorId = visitor1024`
            #     The filtering fields are assumed to have an implicit AND.
            #   @param force [::Boolean]
            #     Optional. The default value is false. Override this flag to true to
            #     actually perform the purge. If the field is not set to true, a sampling of
            #     events to be deleted will be returned.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/recommendation_engine/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::RecommendationEngine::V1beta1::UserEventService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::RecommendationEngine::V1beta1::PurgeUserEventsRequest.new
            #
            #   # Call the purge_user_events method.
            #   result = client.purge_user_events request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def purge_user_events request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::RecommendationEngine::V1beta1::PurgeUserEventsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.purge_user_events.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::RecommendationEngine::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.purge_user_events.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.purge_user_events.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @user_event_service_stub.call_rpc :purge_user_events, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Bulk import of User events. Request processing might be
            # synchronous. Events that already exist are skipped.
            # Use this method for backfilling historical user events.
            #
            # Operation.response is of type ImportResponse. Note that it is
            # possible for a subset of the items to be successfully inserted.
            # Operation.metadata is of type ImportMetadata.
            #
            # @overload import_user_events(request, options = nil)
            #   Pass arguments to `import_user_events` via a request object, either of type
            #   {::Google::Cloud::RecommendationEngine::V1beta1::ImportUserEventsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::RecommendationEngine::V1beta1::ImportUserEventsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload import_user_events(parent: nil, request_id: nil, input_config: nil, errors_config: nil)
            #   Pass arguments to `import_user_events` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required.
            #     `projects/1234/locations/global/catalogs/default_catalog/eventStores/default_event_store`
            #   @param request_id [::String]
            #     Optional. Unique identifier provided by client, within the ancestor
            #     dataset scope. Ensures idempotency for expensive long running operations.
            #     Server-generated if unspecified. Up to 128 characters long. This is
            #     returned as google.longrunning.Operation.name in the response. Note that
            #     this field must not be set if the desired input config is
            #     catalog_inline_source.
            #   @param input_config [::Google::Cloud::RecommendationEngine::V1beta1::InputConfig, ::Hash]
            #     Required. The desired input location of the data.
            #   @param errors_config [::Google::Cloud::RecommendationEngine::V1beta1::ImportErrorsConfig, ::Hash]
            #     Optional. The desired location of errors incurred during the Import.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/recommendation_engine/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::RecommendationEngine::V1beta1::UserEventService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::RecommendationEngine::V1beta1::ImportUserEventsRequest.new
            #
            #   # Call the import_user_events method.
            #   result = client.import_user_events request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def import_user_events request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::RecommendationEngine::V1beta1::ImportUserEventsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.import_user_events.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::RecommendationEngine::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.import_user_events.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.import_user_events.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @user_event_service_stub.call_rpc :import_user_events, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the UserEventService API.
            #
            # This class represents the configuration for UserEventService,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::RecommendationEngine::V1beta1::UserEventService::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # write_user_event to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::RecommendationEngine::V1beta1::UserEventService::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.write_user_event.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::RecommendationEngine::V1beta1::UserEventService::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.write_user_event.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::RecommendationEngine::V1beta1::UserEventService::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "recommendationengine.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the UserEventService API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `write_user_event`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :write_user_event
                ##
                # RPC-specific configuration for `collect_user_event`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :collect_user_event
                ##
                # RPC-specific configuration for `list_user_events`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_user_events
                ##
                # RPC-specific configuration for `purge_user_events`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :purge_user_events
                ##
                # RPC-specific configuration for `import_user_events`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :import_user_events

                # @private
                def initialize parent_rpcs = nil
                  write_user_event_config = parent_rpcs.write_user_event if parent_rpcs.respond_to? :write_user_event
                  @write_user_event = ::Gapic::Config::Method.new write_user_event_config
                  collect_user_event_config = parent_rpcs.collect_user_event if parent_rpcs.respond_to? :collect_user_event
                  @collect_user_event = ::Gapic::Config::Method.new collect_user_event_config
                  list_user_events_config = parent_rpcs.list_user_events if parent_rpcs.respond_to? :list_user_events
                  @list_user_events = ::Gapic::Config::Method.new list_user_events_config
                  purge_user_events_config = parent_rpcs.purge_user_events if parent_rpcs.respond_to? :purge_user_events
                  @purge_user_events = ::Gapic::Config::Method.new purge_user_events_config
                  import_user_events_config = parent_rpcs.import_user_events if parent_rpcs.respond_to? :import_user_events
                  @import_user_events = ::Gapic::Config::Method.new import_user_events_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
